/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsImportedEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.serialization.SerializationContext;
import com.intellij.platform.workspace.jps.serialization.impl.ExternalModuleImlFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.ExternalModuleListSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.ModuleListSerializerImpl;
import com.intellij.platform.workspace.jps.serialization.impl.ModulePath;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.PathUtilRt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0015H\u0014J\b\u0010#\u001a\u00020\bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006$"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ExternalModuleListSerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl;", "externalStorageRoot", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "(Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;)V", "componentName", "", "getComponentName", "()Ljava/lang/String;", "entitySourceFilter", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "", "getEntitySourceFilter", "()Lkotlin/jvm/functions/Function1;", "isExternalStorage", "()Z", "createSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "internalSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "fileUrl", "moduleGroup", "deleteObsoleteFile", "", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "getFileName", "entity", "getSourceToSave", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$FileInDirectory;", "module", "toString", "intellij.platform.workspace.jps"})
public final class ExternalModuleListSerializer
extends ModuleListSerializerImpl {
    @NotNull
    private final VirtualFileUrl externalStorageRoot;

    public ExternalModuleListSerializer(@NotNull VirtualFileUrl externalStorageRoot, @NotNull SerializationContext context2) {
        Intrinsics.checkNotNullParameter(externalStorageRoot, "externalStorageRoot");
        Intrinsics.checkNotNullParameter(context2, "context");
        String string2 = externalStorageRoot.append("project/modules.xml").getUrl();
        Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
        super(string2, context2, null, 4, null);
        this.externalStorageRoot = externalStorageRoot;
    }

    @Override
    public boolean isExternalStorage() {
        return true;
    }

    @Override
    @NotNull
    public String getComponentName() {
        return "ExternalProjectModuleManager";
    }

    @Override
    @NotNull
    public Function1<EntitySource, Boolean> getEntitySourceFilter() {
        return entitySourceFilter.1.INSTANCE;
    }

    @Override
    @Nullable
    protected JpsProjectFileEntitySource.FileInDirectory getSourceToSave(@NotNull ModuleEntity module) {
        Intrinsics.checkNotNullParameter(module, "module");
        EntitySource entitySource = module.getEntitySource();
        JpsImportedEntitySource jpsImportedEntitySource = entitySource instanceof JpsImportedEntitySource ? (JpsImportedEntitySource)entitySource : null;
        JpsFileEntitySource jpsFileEntitySource = jpsImportedEntitySource != null ? jpsImportedEntitySource.getInternalFile() : null;
        return jpsFileEntitySource instanceof JpsProjectFileEntitySource.FileInDirectory ? (JpsProjectFileEntitySource.FileInDirectory)jpsFileEntitySource : null;
    }

    @Override
    @NotNull
    public String getFileName(@NotNull ModuleEntity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        return entity.getName() + ".xml";
    }

    @Override
    @NotNull
    public JpsFileEntitiesSerializer<ModuleEntity> createSerializer(@NotNull JpsFileEntitySource internalSource, @NotNull VirtualFileUrl fileUrl, @Nullable String moduleGroup) {
        Intrinsics.checkNotNullParameter(internalSource, "internalSource");
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        String string2 = PathUtilRt.getFileName(fileUrl.getUrl());
        Intrinsics.checkNotNullExpressionValue(string2, "getFileName(...)");
        String fileName = string2;
        VirtualFileUrl actualFileUrl = Intrinsics.areEqual(PathUtilRt.getFileExtension(fileName), "iml") ? this.externalStorageRoot.append("modules/" + StringsKt.substringBeforeLast$default(fileName, '.', null, 2, null) + ".xml") : fileUrl;
        String filePath = JpsPathUtil.urlToPath(fileUrl.getUrl());
        Intrinsics.checkNotNull(filePath);
        ModulePath modulePath = new ModulePath(filePath, moduleGroup);
        Intrinsics.checkNotNull(actualFileUrl);
        return new ExternalModuleImlFileEntitiesSerializer(modulePath, actualFileUrl, this.getContext(), internalSource, this);
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Intrinsics.checkNotNullParameter(writer, "writer");
        super.deleteObsoleteFile(fileUrl, writer);
        if (FileUtil.extensionEquals(fileUrl, "xml")) {
            writer.saveComponent(fileUrl, "ExternalSystem", null);
            writer.saveComponent(fileUrl, "ExternalFacetManager", null);
            writer.saveComponent(fileUrl, "DeprecatedModuleOptionManager", null);
            writer.saveComponent(fileUrl, "TestModuleProperties", null);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "ExternalModuleListSerializer(" + this.getFileUrl() + ")";
    }
}

