/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.workspace.jps.JpsGlobalFileEntitySource;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsGlobalLibrariesFileSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsSdkEntitySerializer;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\tJ\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsGlobalEntitiesSerializers;", "", "()V", "GLOBAL_LIBRARIES_FILE_NAME", "", "SDK_FILE_NAME", "isSdkBridgeEnabled", "", "createApplicationSerializers", "", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntityTypeSerializer;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "virtualFileUrlManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "sortedRootTypes", "createSdkSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsSdkEntitySerializer;", "intellij.platform.workspace.jps"})
public final class JpsGlobalEntitiesSerializers {
    @NotNull
    public static final JpsGlobalEntitiesSerializers INSTANCE = new JpsGlobalEntitiesSerializers();
    @NotNull
    public static final String SDK_FILE_NAME = "jdk.table";
    @NotNull
    public static final String GLOBAL_LIBRARIES_FILE_NAME = "applicationLibraries";
    private static final boolean isSdkBridgeEnabled = Registry.is("workspace.model.global.sdk.bridge", true);

    private JpsGlobalEntitiesSerializers() {
    }

    @NotNull
    public final List<JpsFileEntityTypeSerializer<WorkspaceEntity>> createApplicationSerializers(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull List<String> sortedRootTypes) {
        Intrinsics.checkNotNullParameter(virtualFileUrlManager, "virtualFileUrlManager");
        Intrinsics.checkNotNullParameter(sortedRootTypes, "sortedRootTypes");
        List serializers = new ArrayList();
        if (isSdkBridgeEnabled) {
            JpsSdkEntitySerializer jpsSdkEntitySerializer = this.createSdkSerializer(virtualFileUrlManager, sortedRootTypes);
            Intrinsics.checkNotNull(jpsSdkEntitySerializer, "null cannot be cast to non-null type com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer<com.intellij.platform.workspace.storage.WorkspaceEntity>");
            serializers.add((JpsFileEntityTypeSerializer)jpsSdkEntitySerializer);
        }
        String string2 = PathManager.getOptionsFile(GLOBAL_LIBRARIES_FILE_NAME).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string2, "getAbsolutePath(...)");
        VirtualFileUrl globalLibrariesFile = virtualFileUrlManager.getOrCreateFromUri(string2);
        JpsGlobalFileEntitySource globalLibrariesEntitySource = new JpsGlobalFileEntitySource(globalLibrariesFile);
        serializers.add((JpsFileEntityTypeSerializer)new JpsGlobalLibrariesFileSerializer(globalLibrariesEntitySource));
        return serializers;
    }

    @NotNull
    public final JpsSdkEntitySerializer createSdkSerializer(@NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull List<String> sortedRootTypes) {
        Intrinsics.checkNotNullParameter(virtualFileUrlManager, "virtualFileUrlManager");
        Intrinsics.checkNotNullParameter(sortedRootTypes, "sortedRootTypes");
        String string2 = PathManager.getOptionsFile(SDK_FILE_NAME).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string2, "getAbsolutePath(...)");
        VirtualFileUrl globalSdkFile = virtualFileUrlManager.getOrCreateFromUri(string2);
        JpsGlobalFileEntitySource globalSdkEntitySource = new JpsGlobalFileEntitySource(globalSdkFile);
        return new JpsSdkEntitySerializer(globalSdkEntitySource, sortedRootTypes);
    }
}

