/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsGlobalFileEntitySource;
import com.intellij.platform.workspace.jps.entities.SdkEntity;
import com.intellij.platform.workspace.jps.entities.SdkRoot;
import com.intellij.platform.workspace.jps.entities.SdkRootTypeId;
import com.intellij.platform.workspace.jps.serialization.impl.ErrorReporter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntityTypeSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import com.intellij.platform.workspace.jps.serialization.impl.JpsSdkEntitySerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsSdkEntitySerializerKt;
import com.intellij.platform.workspace.jps.serialization.impl.LoadingResult;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ:\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2 \u0010&\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020(0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0)0'H\u0016J\u0018\u0010*\u001a\u00020\"2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,H\u0016J@\u0010-\u001a\"\u0012\u001e\u0012\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020(0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0)0'0.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0016\u00105\u001a\u00020\u00022\u0006\u00106\u001a\u0002072\u0006\u00103\u001a\u000204J\u001e\u00108\u001a\b\u0012\u0004\u0012\u0002090\u00062\u0006\u0010:\u001a\u0002072\u0006\u00103\u001a\u000204H\u0002JH\u0010;\u001a\u00020\"2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00020)2 \u0010=\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020(0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0\u00060'2\u0006\u0010>\u001a\u00020?2\u0006\u0010+\u001a\u00020,H\u0016J\u0016\u0010@\u001a\u00020\"2\u0006\u0010A\u001a\u0002072\u0006\u0010B\u001a\u00020\u0002J\u001e\u0010C\u001a\u0002072\u0006\u0010D\u001a\u00020\u00072\f\u0010E\u001a\b\u0012\u0004\u0012\u0002090\u0006H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR/\u0010\u001c\u001a#\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u001f0\u001f0\u001d\u00a2\u0006\u0002\b X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/JpsSdkEntitySerializer;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntityTypeSerializer;", "Lcom/intellij/platform/workspace/jps/entities/SdkEntity;", "entitySource", "Lcom/intellij/platform/workspace/jps/JpsGlobalFileEntitySource;", "sortedRootTypes", "", "", "(Lcom/intellij/platform/workspace/jps/JpsGlobalFileEntitySource;Ljava/util/List;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getEntitySource", "()Lcom/intellij/platform/workspace/jps/JpsGlobalFileEntitySource;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "getFileUrl", "()Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "internalEntitySource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "getInternalEntitySource", "()Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "isExternalStorage", "", "()Z", "mainEntityClass", "Ljava/lang/Class;", "getMainEntityClass", "()Ljava/lang/Class;", "rootTypes", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Lcom/intellij/platform/workspace/jps/entities/SdkRootTypeId;", "Lorg/jetbrains/annotations/NotNull;", "checkAndAddToBuilder", "", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "orphanage", "newEntities", "", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "deleteObsoleteFile", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "loadEntities", "Lcom/intellij/platform/workspace/jps/serialization/impl/LoadingResult;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "errorReporter", "Lcom/intellij/platform/workspace/jps/serialization/impl/ErrorReporter;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "loadSdkEntity", "sdkElement", "Lorg/jdom/Element;", "readRoots", "Lcom/intellij/platform/workspace/jps/entities/SdkRoot;", "rootsElement", "saveEntities", "mainEntities", "entities", "storage", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "saveSdkEntity", "sdkRootElement", "sdkEntity", "writeRoots", "rootType", "roots", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nJpsSdkEntitySerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpsSdkEntitySerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsSdkEntitySerializer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,194:1\n11#2:195\n1549#3:196\n1620#3,3:197\n1855#3,2:200\n1855#3,2:202\n1477#3:204\n1502#3,3:205\n1505#3,3:215\n1855#3,2:218\n1855#3,2:220\n372#4,7:208\n*S KotlinDebug\n*F\n+ 1 JpsSdkEntitySerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/JpsSdkEntitySerializer\n*L\n56#1:195\n71#1:196\n71#1:197,3\n126#1:200,2\n132#1:202,2\n163#1:204\n163#1:205,3\n163#1:215,3\n165#1:218,2\n180#1:220,2\n163#1:208,7\n*E\n"})
public final class JpsSdkEntitySerializer
implements JpsFileEntityTypeSerializer<SdkEntity> {
    @NotNull
    private final JpsGlobalFileEntitySource entitySource;
    @NotNull
    private final List<String> sortedRootTypes;
    @NotNull
    private final Logger LOG;
    @NotNull
    private final ConcurrentMap<String, SdkRootTypeId> rootTypes;

    public JpsSdkEntitySerializer(@NotNull JpsGlobalFileEntitySource entitySource, @NotNull List<String> sortedRootTypes) {
        Intrinsics.checkNotNullParameter(entitySource, "entitySource");
        Intrinsics.checkNotNullParameter(sortedRootTypes, "sortedRootTypes");
        this.entitySource = entitySource;
        this.sortedRootTypes = sortedRootTypes;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(JpsSdkEntitySerializer.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        this.LOG = logger;
        ConcurrentMap<Object, SdkRootTypeId> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> JpsSdkEntitySerializer.rootTypes$lambda$0(rootTypes.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentMap, "createMap(...)");
        this.rootTypes = concurrentMap;
    }

    @NotNull
    public final JpsGlobalFileEntitySource getEntitySource() {
        return this.entitySource;
    }

    @Override
    public boolean isExternalStorage() {
        return false;
    }

    @Override
    @NotNull
    public JpsFileEntitySource getInternalEntitySource() {
        return this.entitySource;
    }

    @Override
    @NotNull
    public VirtualFileUrl getFileUrl() {
        return this.entitySource.getFile();
    }

    @Override
    @NotNull
    public Class<SdkEntity> getMainEntityClass() {
        return SdkEntity.class;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity>>> loadEntities(@NotNull JpsFileContentReader reader, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(errorReporter, "errorReporter");
        Intrinsics.checkNotNullParameter(virtualFileManager, "virtualFileManager");
        String string2 = this.entitySource.getFile().getUrl();
        Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
        Element element = JpsFileContentReader.loadComponent$default(reader, string2, "ProjectJdkTable", null, 4, null);
        if (element == null) {
            return new LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity>>>(MapsKt.emptyMap(), null);
        }
        Element sdkTag = element;
        List<Element> list2 = sdkTag.getChildren("jdk");
        Intrinsics.checkNotNullExpressionValue(list2, "getChildren(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sdkElement;
            Element element2 = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(sdkElement);
            collection.add(this.loadSdkEntity((Element)sdkElement, virtualFileManager));
        }
        List sdkEntities = (List)destination$iv$iv;
        return new LoadingResult<Map<Class<? extends WorkspaceEntity>, Collection<WorkspaceEntity>>>(MapsKt.mapOf(TuplesKt.to(SdkEntity.class, sdkEntities)), null, 2, null);
    }

    @NotNull
    public final SdkEntity loadSdkEntity(@NotNull Element sdkElement, @NotNull VirtualFileUrlManager virtualFileManager) {
        Element additionalDataElement;
        Intrinsics.checkNotNullParameter(sdkElement, "sdkElement");
        Intrinsics.checkNotNullParameter(virtualFileManager, "virtualFileManager");
        String sdkName = sdkElement.getChild("name").getAttributeValue("value");
        String sdkType = sdkElement.getChild("type").getAttributeValue("value");
        String versionValue = sdkElement.getAttributeValue(JpsSdkEntitySerializerKt.access$getELEMENT_VERSION$p());
        if (!Intrinsics.areEqual("2", versionValue)) {
            throw new InvalidDataException("Too old version is not supported: " + versionValue);
        }
        Element element = sdkElement.getChild(JpsSdkEntitySerializerKt.access$getELEMENT_VERSION$p());
        String sdkVersion = element != null ? element.getAttributeValue("value") : null;
        Element element2 = sdkElement.getChild(JpsSdkEntitySerializerKt.access$getELEMENT_HOMEPATH$p());
        Intrinsics.checkNotNullExpressionValue(element2, "getChild(...)");
        String homePath = JpsProjectSerializersImplKt.getAttributeValueStrict(element2, "value");
        VirtualFileUrl homePathVfu = virtualFileManager.getOrCreateFromUri(homePath);
        List<SdkRoot> roots = this.readRoots(JpsProjectSerializersImplKt.getChildTagStrict(sdkElement, JpsSdkEntitySerializerKt.access$getELEMENT_ROOTS$p()), virtualFileManager);
        Element element3 = additionalDataElement = sdkElement.getChild("additional");
        String string2 = element3 != null ? JDOMUtil.write(element3) : "";
        Intrinsics.checkNotNull(string2);
        String additionalData = string2;
        Intrinsics.checkNotNull(sdkName);
        Intrinsics.checkNotNull(sdkType);
        return SdkEntity.Companion.create(sdkName, sdkType, roots, additionalData, this.entitySource, (Function1<? super SdkEntity.Builder, Unit>)new Function1<SdkEntity.Builder, Unit>(homePathVfu, sdkVersion){
            final /* synthetic */ VirtualFileUrl $homePathVfu;
            final /* synthetic */ String $sdkVersion;
            {
                this.$homePathVfu = $homePathVfu;
                this.$sdkVersion = $sdkVersion;
                super(1);
            }

            public final void invoke(@NotNull SdkEntity.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.setHomePath(this.$homePathVfu);
                $this$invoke.setVersion(this.$sdkVersion);
            }
        });
    }

    private final List<SdkRoot> readRoots(Element rootsElement, VirtualFileUrlManager virtualFileManager) {
        List result2 = new ArrayList();
        for (Element rootElement : rootsElement.getChildren()) {
            String rootType = rootElement.getName();
            List<Element> composites = rootElement.getChildren();
            if (composites.size() != 1) {
                this.LOG.error("Single child expected by " + composites + " found");
            }
            Element composite = composites.get(0);
            for (Element rootTag : composite.getChildren("root")) {
                Intrinsics.checkNotNull(rootTag);
                String url = JpsProjectSerializersImplKt.getAttributeValueStrict(rootTag, "url");
                VirtualFileUrl virtualFileUrl = virtualFileManager.getOrCreateFromUri(url);
                Object v2 = this.rootTypes.get(rootType);
                Intrinsics.checkNotNull(v2);
                result2.add(new SdkRoot(virtualFileUrl, (SdkRootTypeId)v2));
            }
        }
        return result2;
    }

    @Override
    public void checkAndAddToBuilder(@NotNull MutableEntityStorage builder, @NotNull MutableEntityStorage orphanage, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends Collection<? extends WorkspaceEntity>> newEntities) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(orphanage, "orphanage");
        Intrinsics.checkNotNullParameter(newEntities, "newEntities");
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)newEntities.values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntity it = (WorkspaceEntity)element$iv;
            boolean bl2 = false;
            builder.addEntity(it);
        }
    }

    @Override
    public void saveEntities(@NotNull Collection<? extends SdkEntity> mainEntities, @NotNull Map<Class<? extends WorkspaceEntity>, ? extends List<? extends WorkspaceEntity>> entities2, @NotNull EntityStorage storage, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(mainEntities, "mainEntities");
        Intrinsics.checkNotNullParameter(entities2, "entities");
        Intrinsics.checkNotNullParameter(storage, "storage");
        Intrinsics.checkNotNullParameter(writer, "writer");
        Element componentTag = JDomSerializationUtil.createComponentElement("ProjectJdkTable");
        Iterable $this$forEach$iv = mainEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkEntity sdkEntity = (SdkEntity)element$iv;
            boolean bl2 = false;
            Element sdkElement = new Element("jdk");
            this.saveSdkEntity(sdkElement, sdkEntity);
            componentTag.addContent(sdkElement);
        }
        String string2 = this.getFileUrl().getUrl();
        Intrinsics.checkNotNullExpressionValue(string2, "getUrl(...)");
        writer.saveComponent(string2, "ProjectJdkTable", componentTag);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveSdkEntity(@NotNull Element sdkRootElement, @NotNull SdkEntity sdkEntity) {
        void $this$groupByTo$iv$iv;
        Object version;
        String it;
        Intrinsics.checkNotNullParameter(sdkRootElement, "sdkRootElement");
        Intrinsics.checkNotNullParameter(sdkEntity, "sdkEntity");
        sdkRootElement.setAttribute(JpsSdkEntitySerializerKt.access$getELEMENT_VERSION$p(), "2");
        Element name2 = new Element("name");
        name2.setAttribute("value", sdkEntity.getName());
        sdkRootElement.addContent(name2);
        String string2 = sdkEntity.getType();
        if (string2 != null) {
            it = string2;
            boolean bl2 = false;
            Element sdkType = new Element("type");
            sdkType.setAttribute("value", it);
            sdkRootElement.addContent(sdkType);
        }
        String string3 = sdkEntity.getVersion();
        if (string3 != null) {
            it = string3;
            boolean bl3 = false;
            version = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_VERSION$p());
            ((Element)version).setAttribute("value", it);
            sdkRootElement.addContent((Element)version);
        }
        Element home = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_HOMEPATH$p());
        VirtualFileUrl virtualFileUrl = sdkEntity.getHomePath();
        home.setAttribute("value", virtualFileUrl != null ? virtualFileUrl.getUrl() : null);
        sdkRootElement.addContent(home);
        Iterable $this$groupBy$iv = sdkEntity.getRoots();
        boolean $i$f$groupBy = false;
        version = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            SdkRoot it2 = (SdkRoot)element$iv$iv;
            boolean bl4 = false;
            String key$iv$iv = it2.getType().getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        SortedMap sortedRoots = MapsKt.toSortedMap(destination$iv$iv);
        Element rootsElement = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_ROOTS$p());
        Iterable $this$forEach$iv = this.sortedRootTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String rootType = (String)element$iv;
            boolean bl6 = false;
            List<SdkRoot> list2 = (List<SdkRoot>)sortedRoots.get(rootType);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            List<SdkRoot> sdkRoots = list2;
            rootsElement.addContent(this.writeRoots(rootType, sdkRoots));
        }
        sdkRootElement.addContent(rootsElement);
        String additionalData = sdkEntity.getAdditionalData();
        if (!StringsKt.isBlank(additionalData)) {
            sdkRootElement.addContent(JDOMUtil.load(additionalData));
        }
    }

    private final Element writeRoots(String rootType, List<SdkRoot> roots) {
        Element composite = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_ROOT$p());
        composite.setAttribute("type", "composite");
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SdkRoot root = (SdkRoot)element$iv;
            boolean bl2 = false;
            Element rootElement = new Element(JpsSdkEntitySerializerKt.access$getELEMENT_ROOT$p());
            rootElement.setAttribute("url", root.getUrl().getUrl());
            rootElement.setAttribute("type", "simple");
            composite.addContent(rootElement);
        }
        Element element = new Element(rootType);
        element.addContent(composite);
        return element;
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.saveComponent(fileUrl, "ProjectJdkTable", null);
    }

    private static final SdkRootTypeId rootTypes$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (SdkRootTypeId)$tmp0.invoke(p0);
    }
}

