/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.LibraryTableId;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tJ\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/LibraryNameGenerator;", "", "()V", "UNIQUE_INDEX_LIBRARY_NAME_SUFFIX", "", "UNNAMED_LIBRARY_NAME_PREFIX", "generateLibraryEntityName", "legacyLibraryName", "exists", "Lkotlin/Function1;", "", "generateUniqueLibraryName", "name", "getLegacyLibraryName", "libraryId", "Lcom/intellij/platform/workspace/jps/entities/LibraryId;", "getLibraryTableId", "Lcom/intellij/platform/workspace/jps/entities/LibraryTableId;", "level", "intellij.platform.workspace.jps"})
public final class LibraryNameGenerator {
    @NotNull
    public static final LibraryNameGenerator INSTANCE = new LibraryNameGenerator();
    @NotNull
    private static final String UNIQUE_INDEX_LIBRARY_NAME_SUFFIX = "-d1a6f608-UNIQUE-INDEX-f29c-4df6-";
    @NotNull
    public static final String UNNAMED_LIBRARY_NAME_PREFIX = "#";

    private LibraryNameGenerator() {
    }

    @Nullable
    public final String getLegacyLibraryName(@NotNull LibraryId libraryId) {
        Intrinsics.checkNotNullParameter(libraryId, "libraryId");
        if (StringsKt.startsWith$default(libraryId.getName(), UNNAMED_LIBRARY_NAME_PREFIX, false, 2, null)) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)libraryId.getName(), UNIQUE_INDEX_LIBRARY_NAME_SUFFIX, false, 2, null)) {
            return StringsKt.substringBefore$default(libraryId.getName(), UNIQUE_INDEX_LIBRARY_NAME_SUFFIX, null, 2, null);
        }
        return libraryId.getName();
    }

    @NotNull
    public final String generateLibraryEntityName(@Nullable String legacyLibraryName, @NotNull Function1<? super String, Boolean> exists) {
        Intrinsics.checkNotNullParameter(exists, "exists");
        if (legacyLibraryName == null) {
            int index2 = 1;
            while (true) {
                String candidate;
                if (!exists.invoke(candidate = UNNAMED_LIBRARY_NAME_PREFIX + index2).booleanValue()) {
                    return candidate;
                }
                ++index2;
            }
        }
        return this.generateUniqueLibraryName(legacyLibraryName, exists);
    }

    @NotNull
    public final String generateUniqueLibraryName(@NotNull String name2, @NotNull Function1<? super String, Boolean> exists) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(exists, "exists");
        if (!exists.invoke(name2).booleanValue()) {
            return name2;
        }
        int index2 = 1;
        String candidate;
        while (exists.invoke(candidate = name2 + UNIQUE_INDEX_LIBRARY_NAME_SUFFIX + index2).booleanValue()) {
            ++index2;
        }
        return candidate;
    }

    @NotNull
    public final LibraryTableId getLibraryTableId(@NotNull String level) {
        Intrinsics.checkNotNullParameter(level, "level");
        String string2 = level;
        if (Intrinsics.areEqual(string2, "module")) {
            throw new IllegalStateException("this method isn't supposed to be used for module-level libraries".toString());
        }
        return Intrinsics.areEqual(string2, "project") ? (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE : (LibraryTableId)new LibraryTableId.GlobalLibraryTableId(level);
    }
}

