/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.platform.workspace.jps.CustomModuleEntitySource;
import com.intellij.platform.workspace.jps.JpsFileDependentEntitySource;
import com.intellij.platform.workspace.jps.JpsFileEntitySource;
import com.intellij.platform.workspace.jps.JpsProjectFileEntitySource;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.ExcludeUrlEntity;
import com.intellij.platform.workspace.jps.entities.ExtensionsKt;
import com.intellij.platform.workspace.jps.entities.FacetEntity;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.jps.entities.ModuleExtensions;
import com.intellij.platform.workspace.jps.entities.ModuleGroupPathEntity;
import com.intellij.platform.workspace.jps.entities.SourceRootEntity;
import com.intellij.platform.workspace.jps.serialization.SerializationContext;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentReader;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileContentWriter;
import com.intellij.platform.workspace.jps.serialization.impl.JpsFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.JpsModuleListSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.ModuleImlFileEntitiesSerializer;
import com.intellij.platform.workspace.jps.serialization.impl.ModuleListSerializerImpl;
import com.intellij.platform.workspace.jps.serialization.impl.ModulePath;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 32\u00020\u0001:\u00013B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0018H\u0016J\u0018\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0018H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u0018H\u0014J,\u0010(\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u00030*0)2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001e\u0010/\u001a\u00020\u001e2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u0018012\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u00102\u001a\u00020\u0003H\u0016R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00064"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl;", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;", "fileUrl", "", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "externalModuleListSerializer", "(Ljava/lang/String;Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;)V", "componentName", "getComponentName", "()Ljava/lang/String;", "getContext", "()Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "entitySourceFilter", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "", "getEntitySourceFilter", "()Lkotlin/jvm/functions/Function1;", "getFileUrl", "isExternalStorage", "()Z", "createSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileEntitiesSerializer;", "Lcom/intellij/platform/workspace/jps/entities/ModuleEntity;", "internalSource", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "moduleGroup", "deleteObsoleteFile", "", "writer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentWriter;", "getFileName", "entity", "getModuleFileUrl", "source", "Lcom/intellij/platform/workspace/jps/JpsProjectFileEntitySource$FileInDirectory;", "module", "getSourceToSave", "loadFileList", "", "Lkotlin/Pair;", "reader", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsFileContentReader;", "virtualFileManager", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlManager;", "saveEntityList", "entities", "Lkotlin/sequences/Sequence;", "toString", "Companion", "intellij.platform.workspace.jps"})
@SourceDebugExtension(value={"SMAP\nModuleImlFileEntitiesSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleImlFileEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1109:1\n1549#2:1110\n1620#2,3:1111\n1045#2:1120\n1855#2,2:1121\n1144#3:1114\n1313#3:1115\n1314#3:1118\n1145#3:1119\n1#4:1116\n1#4:1117\n*S KotlinDebug\n*F\n+ 1 ModuleImlFileEntitiesSerializer.kt\ncom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl\n*L\n1029#1:1110\n1029#1:1111,3\n1044#1:1120\n1049#1:1121,2\n1043#1:1114\n1043#1:1115\n1043#1:1118\n1043#1:1119\n1043#1:1117\n*E\n"})
public class ModuleListSerializerImpl
implements JpsModuleListSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String fileUrl;
    @NotNull
    private final SerializationContext context;
    @Nullable
    private final JpsModuleListSerializer externalModuleListSerializer;

    public ModuleListSerializerImpl(@NotNull String fileUrl, @NotNull SerializationContext context2, @Nullable JpsModuleListSerializer externalModuleListSerializer) {
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Intrinsics.checkNotNullParameter(context2, "context");
        this.fileUrl = fileUrl;
        this.context = context2;
        this.externalModuleListSerializer = externalModuleListSerializer;
    }

    public /* synthetic */ ModuleListSerializerImpl(String string2, SerializationContext serializationContext, JpsModuleListSerializer jpsModuleListSerializer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            jpsModuleListSerializer = null;
        }
        this(string2, serializationContext, jpsModuleListSerializer);
    }

    @Override
    @NotNull
    public String getFileUrl() {
        return this.fileUrl;
    }

    @NotNull
    protected final SerializationContext getContext() {
        return this.context;
    }

    @Override
    public boolean isExternalStorage() {
        return false;
    }

    @NotNull
    public String getComponentName() {
        return "ProjectModuleManager";
    }

    @Override
    @NotNull
    public Function1<EntitySource, Boolean> getEntitySourceFilter() {
        return entitySourceFilter.1.INSTANCE;
    }

    @Override
    @NotNull
    public String getFileName(@NotNull ModuleEntity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        return entity.getName() + ".iml";
    }

    @Override
    @NotNull
    public JpsFileEntitiesSerializer<ModuleEntity> createSerializer(@NotNull JpsFileEntitySource internalSource, @NotNull VirtualFileUrl fileUrl, @Nullable String moduleGroup) {
        Intrinsics.checkNotNullParameter(internalSource, "internalSource");
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        return Companion.createModuleEntitiesSerializer$intellij_platform_workspace_jps(fileUrl, moduleGroup, internalSource, this.context, this, this.externalModuleListSerializer);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<VirtualFileUrl, String>> loadFileList(@NotNull JpsFileContentReader reader, @NotNull VirtualFileUrlManager virtualFileManager) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(virtualFileManager, "virtualFileManager");
        Element element = JpsFileContentReader.loadComponent$default(reader, this.getFileUrl(), this.getComponentName(), null, 4, null);
        if (element == null) {
            return CollectionsKt.emptyList();
        }
        Element moduleManagerTag = element;
        Iterable $this$map$iv = ModulePath.Companion.getPathsToModuleFiles(moduleManagerTag);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModulePath modulePath = (ModulePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TuplesKt.to(virtualFileManager.getOrCreateFromUri("file://" + it.getPath()), it.getGroup()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveEntityList(@NotNull Sequence<? extends ModuleEntity> entities2, @NotNull JpsFileContentWriter writer) {
        void $this$sortedBy$iv;
        ModuleEntity module;
        Iterable $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter(entities2, "entities");
        Intrinsics.checkNotNullParameter(writer, "writer");
        Sequence<? extends ModuleEntity> sequence = SequencesKt.filter(entities2, (Function1)new Function1<ModuleEntity, Boolean>(this){
            final /* synthetic */ ModuleListSerializerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull ModuleEntity moduleEntity) {
                boolean bl2;
                Intrinsics.checkNotNullParameter(moduleEntity, "moduleEntity");
                if (!this.this$0.getEntitySourceFilter().invoke(moduleEntity.getEntitySource()).booleanValue()) {
                    ContentRootEntity cr;
                    boolean bl3;
                    Iterable $this$any$iv;
                    boolean $i$f$any;
                    ModuleListSerializerImpl moduleListSerializerImpl;
                    block20: {
                        Iterable iterable = moduleEntity.getContentRoots();
                        moduleListSerializerImpl = this.this$0;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                cr = (ContentRootEntity)element$iv;
                                boolean bl4 = false;
                                if (!moduleListSerializerImpl.getEntitySourceFilter().invoke(cr.getEntitySource()).booleanValue()) continue;
                                bl3 = true;
                                break block20;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) {
                        boolean bl5;
                        block21: {
                            $this$any$iv = ExtensionsKt.getSourceRoots(moduleEntity);
                            moduleListSerializerImpl = this.this$0;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl5 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    SourceRootEntity sr = (SourceRootEntity)element$iv;
                                    boolean bl6 = false;
                                    if (!moduleListSerializerImpl.getEntitySourceFilter().invoke(sr.getEntitySource()).booleanValue()) continue;
                                    bl5 = true;
                                    break block21;
                                }
                                bl5 = false;
                            }
                        }
                        if (!bl5) {
                            boolean bl7;
                            block23: {
                                $this$any$iv = moduleEntity.getContentRoots();
                                moduleListSerializerImpl = this.this$0;
                                $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl7 = false;
                                } else {
                                    for (T element$iv : $this$any$iv) {
                                        boolean bl8;
                                        block22: {
                                            cr = (ContentRootEntity)element$iv;
                                            boolean bl9 = false;
                                            Iterable $this$any$iv2 = cr.getExcludedUrls();
                                            boolean $i$f$any2 = false;
                                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                                bl8 = false;
                                            } else {
                                                for (T element$iv2 : $this$any$iv2) {
                                                    ExcludeUrlEntity ex = (ExcludeUrlEntity)element$iv2;
                                                    boolean bl10 = false;
                                                    if (!moduleListSerializerImpl.getEntitySourceFilter().invoke(ex.getEntitySource()).booleanValue()) continue;
                                                    bl8 = true;
                                                    break block22;
                                                }
                                                bl8 = false;
                                            }
                                        }
                                        if (!bl8) continue;
                                        bl7 = true;
                                        break block23;
                                    }
                                    bl7 = false;
                                }
                            }
                            if (!bl7) {
                                boolean bl11;
                                block24: {
                                    $this$any$iv = moduleEntity.getFacets();
                                    moduleListSerializerImpl = this.this$0;
                                    $i$f$any = false;
                                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                        bl11 = false;
                                    } else {
                                        for (T element$iv : $this$any$iv) {
                                            FacetEntity it = (FacetEntity)element$iv;
                                            boolean bl12 = false;
                                            if (!moduleListSerializerImpl.getEntitySourceFilter().invoke(it.getEntitySource()).booleanValue()) continue;
                                            bl11 = true;
                                            break block24;
                                        }
                                        bl11 = false;
                                    }
                                }
                                if (!bl11) {
                                    bl2 = false;
                                    return bl2;
                                }
                            }
                        }
                    }
                }
                bl2 = true;
                return bl2;
            }
        });
        Collection destination$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair<JpsProjectFileEntitySource.FileInDirectory, ModuleEntity> pair;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            module = (ModuleEntity)element$iv;
            boolean bl3 = false;
            if (this.getSourceToSave(module) != null) {
                JpsProjectFileEntitySource.FileInDirectory it;
                boolean bl4 = false;
                pair = new Pair<JpsProjectFileEntitySource.FileInDirectory, ModuleEntity>(it, module);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair<JpsProjectFileEntitySource.FileInDirectory, ModuleEntity> it$iv = pair;
            boolean bl5 = false;
            destination$iv.add(it$iv);
        }
        $this$mapNotNullTo$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        List entitiesToSave2 = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                Pair it = (Pair)a2;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((ModuleEntity)it.getSecond()).getName());
                it = (Pair)b2;
                Comparable comparable2 = comparable;
                bl2 = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((ModuleEntity)it.getSecond()).getName()));
            }
        });
        Element componentTag = null;
        if (!((Collection)entitiesToSave2).isEmpty()) {
            void $this$forEach$iv;
            Element modulesTag = new Element("modules");
            Iterable $i$f$mapNotNullTo2 = entitiesToSave2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl6 = false;
                JpsProjectFileEntitySource.FileInDirectory source = (JpsProjectFileEntitySource.FileInDirectory)pair.component1();
                module = (ModuleEntity)pair.component2();
                Element moduleTag = new Element("module");
                String fileUrl = this.getModuleFileUrl(source, module);
                moduleTag.setAttribute("fileurl", fileUrl);
                moduleTag.setAttribute("filepath", JpsPathUtil.urlToPath(fileUrl));
                if (ModuleExtensions.getGroupPath(module) != null) {
                    ModuleGroupPathEntity it;
                    boolean bl7 = false;
                    moduleTag.setAttribute("group", CollectionsKt.joinToString$default(it.getPath(), "/", null, null, 0, null, null, 62, null));
                }
                modulesTag.addContent(moduleTag);
            }
            componentTag = JDomSerializationUtil.createComponentElement(this.getComponentName());
            componentTag.addContent(modulesTag);
        } else {
            componentTag = null;
        }
        writer.saveComponent(this.getFileUrl(), this.getComponentName(), componentTag);
    }

    @Nullable
    protected JpsProjectFileEntitySource.FileInDirectory getSourceToSave(@NotNull ModuleEntity module) {
        Intrinsics.checkNotNullParameter(module, "module");
        EntitySource entitySource = module.getEntitySource();
        if (entitySource instanceof CustomModuleEntitySource) {
            JpsFileEntitySource jpsFileEntitySource = ((CustomModuleEntitySource)entitySource).getInternalSource();
            return jpsFileEntitySource instanceof JpsProjectFileEntitySource.FileInDirectory ? (JpsProjectFileEntitySource.FileInDirectory)jpsFileEntitySource : null;
        }
        if (entitySource instanceof JpsFileDependentEntitySource) {
            JpsFileEntitySource jpsFileEntitySource = ((JpsFileDependentEntitySource)((Object)entitySource)).getOriginalSource();
            return jpsFileEntitySource instanceof JpsProjectFileEntitySource.FileInDirectory ? (JpsProjectFileEntitySource.FileInDirectory)jpsFileEntitySource : null;
        }
        return entitySource instanceof JpsProjectFileEntitySource.FileInDirectory ? (JpsProjectFileEntitySource.FileInDirectory)entitySource : null;
    }

    @Override
    public void deleteObsoleteFile(@NotNull String fileUrl, @NotNull JpsFileContentWriter writer) {
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.saveComponent(fileUrl, "FacetManager", null);
        writer.saveComponent(fileUrl, "NewModuleRootManager", null);
        writer.saveComponent(fileUrl, "DeprecatedModuleOptionManager", null);
        writer.saveComponent(fileUrl, "TestModuleProperties", null);
        writer.saveComponent(fileUrl, "AdditionalModuleElements", null);
    }

    private final String getModuleFileUrl(JpsProjectFileEntitySource.FileInDirectory source, ModuleEntity module) {
        return source.getDirectory().getUrl() + "/" + module.getName() + ".iml";
    }

    @NotNull
    public String toString() {
        return "ModuleListSerializerImpl(" + this.getFileUrl() + ")";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JG\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleListSerializerImpl$Companion;", "", "()V", "createModuleEntitiesSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModuleImlFileEntitiesSerializer;", "fileUrl", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "moduleGroup", "", "source", "Lcom/intellij/platform/workspace/jps/JpsFileEntitySource;", "context", "Lcom/intellij/platform/workspace/jps/serialization/SerializationContext;", "internalModuleListSerializer", "Lcom/intellij/platform/workspace/jps/serialization/impl/JpsModuleListSerializer;", "externalModuleListSerializer", "createModuleEntitiesSerializer$intellij_platform_workspace_jps", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModuleImlFileEntitiesSerializer createModuleEntitiesSerializer$intellij_platform_workspace_jps(@NotNull VirtualFileUrl fileUrl, @Nullable String moduleGroup, @NotNull JpsFileEntitySource source, @NotNull SerializationContext context2, @Nullable JpsModuleListSerializer internalModuleListSerializer, @Nullable JpsModuleListSerializer externalModuleListSerializer) {
            Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
            Intrinsics.checkNotNullParameter(source, "source");
            Intrinsics.checkNotNullParameter(context2, "context");
            String string2 = JpsPathUtil.urlToPath(fileUrl.getUrl());
            Intrinsics.checkNotNullExpressionValue(string2, "urlToPath(...)");
            return new ModuleImlFileEntitiesSerializer(new ModulePath(string2, moduleGroup), fileUrl, source, context2, internalModuleListSerializer, externalModuleListSerializer);
        }

        public static /* synthetic */ ModuleImlFileEntitiesSerializer createModuleEntitiesSerializer$intellij_platform_workspace_jps$default(Companion companion, VirtualFileUrl virtualFileUrl, String string2, JpsFileEntitySource jpsFileEntitySource, SerializationContext serializationContext, JpsModuleListSerializer jpsModuleListSerializer, JpsModuleListSerializer jpsModuleListSerializer2, int n2, Object object) {
            if ((n2 & 0x10) != 0) {
                jpsModuleListSerializer = null;
            }
            if ((n2 & 0x20) != 0) {
                jpsModuleListSerializer2 = null;
            }
            return companion.createModuleEntitiesSerializer$intellij_platform_workspace_jps(virtualFileUrl, string2, jpsFileEntitySource, serializationContext, jpsModuleListSerializer, jpsModuleListSerializer2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

