/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.jps.serialization.impl;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.URLUtil;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath;", "", "path", "", "group", "(Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "moduleName", "getModuleName", "getPath", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.workspace.jps"})
public final class ModulePath {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;
    @Nullable
    private final String group;
    @NotNull
    private final String moduleName;

    public ModulePath(@NotNull String path, @Nullable String group) {
        Intrinsics.checkNotNullParameter(path, "path");
        this.path = path;
        this.group = group;
        this.moduleName = Companion.getModuleNameByFilePath(this.path);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String getGroup() {
        return this.group;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    @Nullable
    public final String component2() {
        return this.group;
    }

    @NotNull
    public final ModulePath copy(@NotNull String path, @Nullable String group) {
        Intrinsics.checkNotNullParameter(path, "path");
        return new ModulePath(path, group);
    }

    public static /* synthetic */ ModulePath copy$default(ModulePath modulePath, String string2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string2 = modulePath.path;
        }
        if ((n2 & 2) != 0) {
            string3 = modulePath.group;
        }
        return modulePath.copy(string2, string3);
    }

    @NotNull
    public String toString() {
        return "ModulePath(path=" + this.path + ", group=" + this.group + ")";
    }

    public int hashCode() {
        int result2 = this.path.hashCode();
        result2 = result2 * 31 + (this.group == null ? 0 : this.group.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModulePath)) {
            return false;
        }
        ModulePath modulePath = (ModulePath)other;
        if (!Intrinsics.areEqual(this.path, modulePath.path)) {
            return false;
        }
        return Intrinsics.areEqual(this.group, modulePath.group);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath$Companion;", "", "()V", "getModuleNameByFilePath", "", "path", "getPathsToModuleFiles", "", "Lcom/intellij/platform/workspace/jps/serialization/impl/ModulePath;", "element", "Lorg/jdom/Element;", "intellij.platform.workspace.jps"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getModuleNameByFilePath(@NotNull String path) {
            Intrinsics.checkNotNullParameter(path, "path");
            String string2 = PathUtilRt.getFileName(path);
            Intrinsics.checkNotNullExpressionValue(string2, "getFileName(...)");
            return StringsKt.removeSuffix(string2, (CharSequence)".iml");
        }

        @NotNull
        public final Set<ModulePath> getPathsToModuleFiles(@NotNull Element element) {
            Intrinsics.checkNotNullParameter(element, "element");
            Element element2 = element.getChild("modules");
            if (element2 == null) {
                return SetsKt.emptySet();
            }
            Element modules = element2;
            List<Element> children2 = modules.getChildren("module");
            LinkedHashSet<ModulePath> paths2 = new LinkedHashSet<ModulePath>(children2.size());
            for (Element moduleElement : children2) {
                String filepath;
                String fileUrlValue = moduleElement.getAttributeValue("fileurl");
                String string2 = filepath = fileUrlValue == null ? moduleElement.getAttributeValue("filepath") : URLUtil.extractPath(fileUrlValue);
                Intrinsics.checkNotNull(string2);
                String string3 = FileUtilRt.toSystemIndependentName(string2);
                Intrinsics.checkNotNullExpressionValue(string3, "toSystemIndependentName(...)");
                paths2.add(new ModulePath(string3, moduleElement.getAttributeValue("group")));
            }
            return paths2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

