/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage;

import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.ChildEntityId;
import com.intellij.platform.workspace.storage.impl.ConnectionId;
import com.intellij.platform.workspace.storage.impl.RefsTableKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.util.containers.FList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001ad\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0014\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\t0\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\r2\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\u00040\rH\u0002\u001a+\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\b\b\u0000\u0010\u0011*\u00020\u0007*\u0002H\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"copyChildren", "", "oldEntityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "parents", "Lcom/intellij/util/containers/FList;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "parentInterfaces", "Ljava/lang/Class;", "originalSnapshot", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "copied", "", "deferred", "createEntityTreeCopy", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "T", "requireTopLevelEntity", "", "(Lcom/intellij/platform/workspace/storage/WorkspaceEntity;Z)Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nentityTreeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 entityTreeUtil.kt\ncom/intellij/platform/workspace/storage/EntityTreeUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1#2:58\n*E\n"})
public final class EntityTreeUtilKt {
    @ApiStatus.Experimental
    @NotNull
    public static final <T extends WorkspaceEntity> WorkspaceEntity.Builder<T> createEntityTreeCopy(@NotNull T $this$createEntityTreeCopy, boolean requireTopLevelEntity) {
        Intrinsics.checkNotNullParameter($this$createEntityTreeCopy, "<this>");
        EntityStorage entityStorage = ((WorkspaceEntityBase)$this$createEntityTreeCopy).getSnapshot();
        Intrinsics.checkNotNull(entityStorage, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.AbstractEntityStorage");
        AbstractEntityStorage originalSnapshot = (AbstractEntityStorage)entityStorage;
        WorkspaceEntityData<? extends WorkspaceEntity> entityData = originalSnapshot.entityDataByIdOrDie$intellij_platform_workspace_storage(((WorkspaceEntityBase)$this$createEntityTreeCopy).getId());
        if (requireTopLevelEntity && !entityData.getRequiredParents().isEmpty()) {
            boolean $i$a$-require-EntityTreeUtilKt$createEntityTreeCopy$32 = false;
            String $i$a$-require-EntityTreeUtilKt$createEntityTreeCopy$32 = "copying is supported only for top-level entities which don't have required parents";
            throw new IllegalArgumentException($i$a$-require-EntityTreeUtilKt$createEntityTreeCopy$32.toString());
        }
        WorkspaceEntity newEntity = entityData.createDetachedEntity(CollectionsKt.emptyList());
        HashSet copied = new HashSet();
        HashSet deferred2 = new HashSet();
        FList<WorkspaceEntity> parents2 = FList.emptyList().prepend(newEntity);
        FList<Class<? extends WorkspaceEntity>> parentInterfaces = FList.emptyList().prepend(entityData.getEntityInterface());
        long l2 = ((WorkspaceEntityBase)$this$createEntityTreeCopy).getId();
        Intrinsics.checkNotNull(parents2);
        Intrinsics.checkNotNull(parentInterfaces);
        EntityTreeUtilKt.copyChildren(l2, parents2, parentInterfaces, originalSnapshot, copied, deferred2);
        deferred2.removeAll(copied);
        if (!deferred2.isEmpty()) {
            boolean bl2 = false;
            String string2 = "some elements weren't copied because their additional parents are located in a separate tree: " + deferred2;
            throw new IllegalArgumentException(string2.toString());
        }
        Intrinsics.checkNotNull(newEntity, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.WorkspaceEntity.Builder<T of com.intellij.platform.workspace.storage.EntityTreeUtilKt.createEntityTreeCopy>");
        return (WorkspaceEntity.Builder)newEntity;
    }

    public static /* synthetic */ WorkspaceEntity.Builder createEntityTreeCopy$default(WorkspaceEntity workspaceEntity, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl2 = false;
        }
        return EntityTreeUtilKt.createEntityTreeCopy(workspaceEntity, bl2);
    }

    private static final void copyChildren(long oldEntityId, FList<WorkspaceEntity> parents2, FList<Class<? extends WorkspaceEntity>> parentInterfaces, AbstractEntityStorage originalSnapshot, Set<Long> copied, Set<Long> deferred2) {
        Iterator<Map.Entry<ConnectionId, List<ChildEntityId>>> iterator2 = originalSnapshot.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(oldEntityId)).entrySet().iterator();
        while (iterator2.hasNext()) {
            List<ChildEntityId> children2 = iterator2.next().getValue();
            Iterator<ChildEntityId> iterator3 = children2.iterator();
            while (iterator3.hasNext()) {
                long child = iterator3.next().unbox-impl();
                WorkspaceEntityData<? extends WorkspaceEntity> childData = originalSnapshot.entityDataByIdOrDie$intellij_platform_workspace_storage(child);
                if (parentInterfaces.containsAll((Collection)childData.getRequiredParents())) {
                    WorkspaceEntity childCopy = childData.createDetachedEntity((List<WorkspaceEntity>)parents2);
                    copied.add(child);
                    FList<WorkspaceEntity> fList = parents2.prepend(childCopy);
                    Intrinsics.checkNotNullExpressionValue(fList, "prepend(...)");
                    FList<Class<? extends WorkspaceEntity>> fList2 = parentInterfaces.prepend(childData.getEntityInterface());
                    Intrinsics.checkNotNullExpressionValue(fList2, "prepend(...)");
                    EntityTreeUtilKt.copyChildren(child, fList, fList2, originalSnapshot, copied, deferred2);
                    continue;
                }
                deferred2.add(child);
            }
        }
    }
}

