/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverter;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.util.containers.Interner;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0010\u001a\u00020\bJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ConnectionId;", "", "parentClass", "", "childClass", "connectionType", "Lcom/intellij/platform/workspace/storage/impl/ConnectionId$ConnectionType;", "isParentNullable", "", "(IILcom/intellij/platform/workspace/storage/impl/ConnectionId$ConnectionType;Z)V", "getChildClass", "()I", "getConnectionType", "()Lcom/intellij/platform/workspace/storage/impl/ConnectionId$ConnectionType;", "()Z", "getParentClass", "canRemoveParent", "debugStr", "", "equals", "other", "hashCode", "toString", "Companion", "ConnectionType", "intellij.platform.workspace.storage"})
public final class ConnectionId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int parentClass;
    private final int childClass;
    @NotNull
    private final ConnectionType connectionType;
    private final boolean isParentNullable;
    @NotNull
    private static final Interner<ConnectionId> interner;

    private ConnectionId(int parentClass, int childClass, ConnectionType connectionType, boolean isParentNullable) {
        this.parentClass = parentClass;
        this.childClass = childClass;
        this.connectionType = connectionType;
        this.isParentNullable = isParentNullable;
    }

    public final int getParentClass() {
        return this.parentClass;
    }

    public final int getChildClass() {
        return this.childClass;
    }

    @NotNull
    public final ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public final boolean isParentNullable() {
        return this.isParentNullable;
    }

    public final boolean canRemoveParent() {
        return this.isParentNullable;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.ConnectionId");
        ConnectionId cfr_ignored_0 = (ConnectionId)other;
        if (this.parentClass != ((ConnectionId)other).parentClass) {
            return false;
        }
        if (this.childClass != ((ConnectionId)other).childClass) {
            return false;
        }
        if (this.connectionType != ((ConnectionId)other).connectionType) {
            return false;
        }
        return this.isParentNullable == ((ConnectionId)other).isParentNullable;
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.parentClass);
        result2 = 31 * result2 + Integer.hashCode(this.childClass);
        result2 = 31 * result2 + this.connectionType.hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.isParentNullable);
        return result2;
    }

    @NotNull
    public String toString() {
        return "Connection(parent=" + ClassToIntConverter.Companion.getInstance().getClassOrDie(this.parentClass).getSimpleName() + " child=" + ClassToIntConverter.Companion.getInstance().getClassOrDie(this.childClass).getSimpleName() + " " + this.connectionType + ")";
    }

    @NotNull
    public final String debugStr() {
        return StringsKt.trimIndent("\n    ConnectionId info:\n      - Parent class: " + ClassToIntConverterKt.findWorkspaceEntity(this.parentClass) + "\n      - Child class: " + ClassToIntConverterKt.findWorkspaceEntity(this.childClass) + "\n      - Connection type: " + this.connectionType + "\n      - Parent of child is nullable: " + this.isParentNullable + "\n  ");
    }

    public /* synthetic */ ConnectionId(int parentClass, int childClass, ConnectionType connectionType, boolean isParentNullable, DefaultConstructorMarker $constructor_marker) {
        this(parentClass, childClass, connectionType, isParentNullable);
    }

    static {
        Interner interner = Interner.createInterner();
        Intrinsics.checkNotNullExpressionValue(interner, "createInterner(...)");
        ConnectionId.interner = interner;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\b\u001a\u00020\u0005\"\b\b\u0000\u0010\t*\u00020\n\"\b\b\u0001\u0010\u000b*\u00020\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ConnectionId$Companion;", "", "()V", "interner", "Lcom/intellij/util/containers/Interner;", "Lcom/intellij/platform/workspace/storage/impl/ConnectionId;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "create", "Parent", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "Child", "parentClass", "Ljava/lang/Class;", "childClass", "connectionType", "Lcom/intellij/platform/workspace/storage/impl/ConnectionId$ConnectionType;", "isParentNullable", "", "", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final synchronized <Parent extends WorkspaceEntity, Child extends WorkspaceEntity> ConnectionId create(@NotNull Class<Parent> parentClass, @NotNull Class<Child> childClass, @NotNull ConnectionType connectionType, boolean isParentNullable) {
            Intrinsics.checkNotNullParameter(parentClass, "parentClass");
            Intrinsics.checkNotNullParameter(childClass, "childClass");
            Intrinsics.checkNotNullParameter((Object)connectionType, "connectionType");
            ConnectionId connectionId = new ConnectionId(ClassToIntConverterKt.toClassId(parentClass), ClassToIntConverterKt.toClassId(childClass), connectionType, isParentNullable, null);
            ConnectionId connectionId2 = interner.intern(connectionId);
            Intrinsics.checkNotNullExpressionValue(connectionId2, "intern(...)");
            return connectionId2;
        }

        @ApiStatus.Internal
        @NotNull
        public final synchronized ConnectionId create(int parentClass, int childClass, @NotNull ConnectionType connectionType, boolean isParentNullable) {
            Intrinsics.checkNotNullParameter((Object)connectionType, "connectionType");
            ConnectionId connectionId = new ConnectionId(parentClass, childClass, connectionType, isParentNullable, null);
            ConnectionId connectionId2 = interner.intern(connectionId);
            Intrinsics.checkNotNullExpressionValue(connectionId2, "intern(...)");
            return connectionId2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ConnectionId$ConnectionType;", "", "(Ljava/lang/String;I)V", "ONE_TO_ONE", "ONE_TO_MANY", "ONE_TO_ABSTRACT_MANY", "ABSTRACT_ONE_TO_ONE", "intellij.platform.workspace.storage"})
    public static final class ConnectionType
    extends Enum<ConnectionType> {
        public static final /* enum */ ConnectionType ONE_TO_ONE = new ConnectionType();
        public static final /* enum */ ConnectionType ONE_TO_MANY = new ConnectionType();
        public static final /* enum */ ConnectionType ONE_TO_ABSTRACT_MANY = new ConnectionType();
        public static final /* enum */ ConnectionType ABSTRACT_ONE_TO_ONE = new ConnectionType();
        private static final /* synthetic */ ConnectionType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConnectionType[] values() {
            return (ConnectionType[])$VALUES.clone();
        }

        public static ConnectionType valueOf(String value) {
            return Enum.valueOf(ConnectionType.class, value);
        }

        @NotNull
        public static EnumEntries<ConnectionType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = connectionTypeArray = new ConnectionType[]{ConnectionType.ONE_TO_ONE, ConnectionType.ONE_TO_MANY, ConnectionType.ONE_TO_ABSTRACT_MANY, ConnectionType.ABSTRACT_ONE_TO_ONE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

