/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.google.common.collect.BiMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.ChildEntityId;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.ConnectionId;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityFamily;
import com.intellij.platform.workspace.storage.impl.ParentEntityId;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.containers.IntIntUniqueBiMap;
import com.intellij.platform.workspace.storage.impl.containers.LinkedBidirectionalMap;
import com.intellij.platform.workspace.storage.impl.containers.NonNegativeIntIntBiMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntMaps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006H\u0002\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a2\u0010\f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00032\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a8\u0010\u0012\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0005j\u0002`\u00060\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a0\u0010\u0016\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\u001cH\u0007\u001a\f\u0010\u001b\u001a\u00020\u0001*\u00020\tH\u0000\u00a8\u0006\u001d"}, d2={"assertCorrectEntityClass", "", "connectionClass", "", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "assertResolvable", "storage", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "clazz", "id", "checkAllStrongConnections", "entityFamilyClass", "keys", "", "debugInfo", "", "checkStrongAbstractConnection", "connectionKeys", "", "entityFamilyClasses", "checkStrongConnection", "Lit/unimi/dsi/fastutil/ints/IntSet;", "connectionTo", "connectionId", "Lcom/intellij/platform/workspace/storage/impl/ConnectionId;", "assertConsistency", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConsistencyChecker.kt\ncom/intellij/platform/workspace/storage/impl/ConsistencyCheckerKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,182:1\n53#2,4:183\n1603#3,9:187\n1855#3:196\n1856#3:198\n1612#3:199\n819#3:200\n847#3,2:201\n1855#3,2:203\n1855#3:205\n1856#3:207\n1855#3,2:208\n1864#3,3:210\n1#4:197\n1#4:206\n*S KotlinDebug\n*F\n+ 1 ConsistencyChecker.kt\ncom/intellij/platform/workspace/storage/impl/ConsistencyCheckerKt\n*L\n17#1:183,4\n26#1:187,9\n26#1:196\n26#1:198\n26#1:199\n115#1:200\n115#1:201,2\n115#1:203,2\n146#1:205\n146#1:207\n156#1:208,2\n166#1:210,3\n26#1:197\n*E\n"})
public final class ConsistencyCheckerKt {
    @ApiStatus.Internal
    public static final void assertConsistency(@NotNull EntityStorage $this$assertConsistency) {
        Intrinsics.checkNotNullParameter($this$assertConsistency, "<this>");
        ConsistencyCheckerKt.assertConsistency((AbstractEntityStorage)$this$assertConsistency);
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertConsistency(@NotNull AbstractEntityStorage $this$assertConsistency) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$assertConsistency, "<this>");
        Logger $this$trace$iv = AbstractEntityStorage.Companion.getLOG();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Checking consistency of " + $this$assertConsistency);
        }
        $this$assertConsistency.getEntitiesByType$intellij_platform_workspace_storage().assertConsistency();
        Iterable $this$mapNotNull$iv = $this$assertConsistency.getEntitiesByType$intellij_platform_workspace_storage().getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List<ConnectionId> it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            EntityFamily it = (EntityFamily)element$iv$iv;
            boolean bl4 = false;
            Object object = it;
            if ((object != null && (object = ((EntityFamily)object).getEntities$intellij_platform_workspace_storage()) != null && (object = (WorkspaceEntityData)CollectionsKt.firstOrNull(object)) != null && (object = ((WorkspaceEntityData)object).createEntity($this$assertConsistency)) != null && (object = UtilsKt.asBase((WorkspaceEntity)object)) != null ? ((WorkspaceEntityBase)object).connectionIdList() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set<ConnectionId> existingConnectionIds = CollectionsKt.toMutableSet(CollectionsKt.flatten((List)destination$iv$iv));
        $this$assertConsistency.getRefs$intellij_platform_workspace_storage().getOneToManyContainer$intellij_platform_workspace_storage().forEach((Function1<Map.Entry<ConnectionId, NonNegativeIntIntBiMap>, Unit>)new Function1<Map.Entry<? extends ConnectionId, ? extends NonNegativeIntIntBiMap>, Unit>(existingConnectionIds, $this$assertConsistency){
            final /* synthetic */ Set<ConnectionId> $existingConnectionIds;
            final /* synthetic */ AbstractEntityStorage $this_assertConsistency;
            {
                this.$existingConnectionIds = $existingConnectionIds;
                this.$this_assertConsistency = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Map.Entry<ConnectionId, ? extends NonNegativeIntIntBiMap> entry) {
                void this_$iv;
                boolean bl2;
                Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                ConnectionId connectionId = entry.getKey();
                NonNegativeIntIntBiMap map2 = entry.getValue();
                this.$existingConnectionIds.remove(connectionId);
                boolean bl3 = bl2 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_MANY;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                NonNegativeIntIntBiMap nonNegativeIntIntBiMap = map2;
                AbstractEntityStorage abstractEntityStorage = this.$this_assertConsistency;
                boolean $i$f$forEachKey = false;
                Int2IntMaps.fastForEach(NonNegativeIntIntBiMap.access$getKey2Value((NonNegativeIntIntBiMap)this_$iv).getBackingMap$intellij_platform_workspace_storage(), new Consumer(abstractEntityStorage, connectionId){
                    final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
                    final /* synthetic */ ConnectionId $connectionId$inlined;
                    {
                        this.$this_assertConsistency$inlined = abstractEntityStorage;
                        this.$connectionId$inlined = connectionId;
                    }

                    public final void accept(Int2IntMap.Entry it) {
                        int parentId = it.getIntValue();
                        int childId = it.getIntKey();
                        boolean bl2 = false;
                        ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                        ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
                    }
                });
                if (!connectionId.isParentNullable()) {
                    ConsistencyCheckerKt.access$checkStrongConnection(this.$this_assertConsistency, map2.getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
                }
                map2.assertConsistency$intellij_platform_workspace_storage();
            }
        });
        $this$assertConsistency.getRefs$intellij_platform_workspace_storage().getOneToOneContainer$intellij_platform_workspace_storage().forEach((Function1<Map.Entry<ConnectionId, IntIntUniqueBiMap>, Unit>)new Function1<Map.Entry<? extends ConnectionId, ? extends IntIntUniqueBiMap>, Unit>(existingConnectionIds, $this$assertConsistency){
            final /* synthetic */ Set<ConnectionId> $existingConnectionIds;
            final /* synthetic */ AbstractEntityStorage $this_assertConsistency;
            {
                this.$existingConnectionIds = $existingConnectionIds;
                this.$this_assertConsistency = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Map.Entry<ConnectionId, ? extends IntIntUniqueBiMap> entry) {
                void this_$iv;
                boolean bl2;
                Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                ConnectionId connectionId = entry.getKey();
                IntIntUniqueBiMap map2 = entry.getValue();
                this.$existingConnectionIds.remove(connectionId);
                boolean bl3 = bl2 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ONE;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                IntIntUniqueBiMap intIntUniqueBiMap = map2;
                AbstractEntityStorage abstractEntityStorage = this.$this_assertConsistency;
                boolean $i$f$forEachKey = false;
                Int2IntMaps.fastForEach(IntIntUniqueBiMap.access$getKey2Value((IntIntUniqueBiMap)this_$iv).getBackingMap$intellij_platform_workspace_storage(), new Consumer(abstractEntityStorage, connectionId){
                    final /* synthetic */ AbstractEntityStorage $this_assertConsistency$inlined;
                    final /* synthetic */ ConnectionId $connectionId$inlined;
                    {
                        this.$this_assertConsistency$inlined = abstractEntityStorage;
                        this.$connectionId$inlined = connectionId;
                    }

                    public final void accept(Int2IntMap.Entry it) {
                        int parentId = it.getIntValue();
                        int childId = it.getIntKey();
                        boolean bl2 = false;
                        ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getParentClass(), parentId);
                        ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency$inlined, this.$connectionId$inlined.getChildClass(), childId);
                    }
                });
                if (!connectionId.isParentNullable()) {
                    ConsistencyCheckerKt.access$checkStrongConnection(this.$this_assertConsistency, map2.getKeys(), connectionId.getChildClass(), connectionId.getParentClass(), connectionId);
                }
            }
        });
        $this$assertConsistency.getRefs$intellij_platform_workspace_storage().getOneToAbstractManyContainer$intellij_platform_workspace_storage().forEach((Function1<Map.Entry<ConnectionId, LinkedBidirectionalMap<ChildEntityId, ParentEntityId>>, Unit>)new Function1<Map.Entry<? extends ConnectionId, ? extends LinkedBidirectionalMap<ChildEntityId, ParentEntityId>>, Unit>(existingConnectionIds, $this$assertConsistency){
            final /* synthetic */ Set<ConnectionId> $existingConnectionIds;
            final /* synthetic */ AbstractEntityStorage $this_assertConsistency;
            {
                this.$existingConnectionIds = $existingConnectionIds;
                this.$this_assertConsistency = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Map.Entry<ConnectionId, LinkedBidirectionalMap<ChildEntityId, ParentEntityId>> entry) {
                boolean bl2;
                Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                ConnectionId connectionId = entry.getKey();
                LinkedBidirectionalMap<ChildEntityId, ParentEntityId> map2 = entry.getValue();
                this.$existingConnectionIds.remove(connectionId);
                boolean bl3 = bl2 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                map2.forEach(new Function1<Map.Entry<ChildEntityId, ParentEntityId>, Unit>(this.$this_assertConsistency, connectionId){
                    final /* synthetic */ AbstractEntityStorage $this_assertConsistency;
                    final /* synthetic */ ConnectionId $connectionId;
                    {
                        this.$this_assertConsistency = $receiver;
                        this.$connectionId = $connectionId;
                        super(1);
                    }

                    public final void invoke(@NotNull Map.Entry<ChildEntityId, ParentEntityId> entry) {
                        Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                        long childId = entry.getKey().unbox-impl();
                        long parentId = entry.getValue().unbox-impl();
                        ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency, EntityIdKt.getClazz(parentId), EntityIdKt.getArrayId(parentId));
                        ConsistencyCheckerKt.access$assertResolvable(this.$this_assertConsistency, EntityIdKt.getClazz(childId), EntityIdKt.getArrayId(childId));
                        ConsistencyCheckerKt.access$assertCorrectEntityClass(this.$connectionId.getParentClass(), parentId);
                        ConsistencyCheckerKt.access$assertCorrectEntityClass(this.$connectionId.getChildClass(), childId);
                    }
                });
                if (!connectionId.isParentNullable()) {
                    Collection<Object> collection;
                    long it;
                    Set<T> set;
                    Iterable $this$mapTo$iv$iv;
                    Iterable $this$map$iv;
                    Iterable iterable = map2.getKeys();
                    AbstractEntityStorage abstractEntityStorage = this.$this_assertConsistency;
                    boolean $i$f$map = false;
                    void var6_9 = $this$map$iv;
                    Collection<Object> destination$iv$iv = (Set<T>)((Object)new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10)));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        long l2 = ((ChildEntityId)item$iv$iv).unbox-impl();
                        set = destination$iv$iv;
                        boolean bl4 = false;
                        set.add(it);
                    }
                    $this$map$iv = map2.getKeys();
                    set = CollectionsKt.toMutableSet((List)destination$iv$iv);
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        it = ((ChildEntityId)item$iv$iv).unbox-impl();
                        collection = destination$iv$iv;
                        boolean bl5 = false;
                        collection.add(EntityIdKt.getClazz(it));
                    }
                    collection = (List)destination$iv$iv;
                    ConsistencyCheckerKt.access$checkStrongAbstractConnection(abstractEntityStorage, set, CollectionsKt.toSet((Iterable)collection), connectionId.debugStr());
                }
            }
        });
        $this$assertConsistency.getRefs$intellij_platform_workspace_storage().getAbstractOneToOneContainer$intellij_platform_workspace_storage().forEach((Function1<Map.Entry<ConnectionId, BiMap<ChildEntityId, ParentEntityId>>, Unit>)new Function1<Map.Entry<? extends ConnectionId, ? extends BiMap<ChildEntityId, ParentEntityId>>, Unit>(existingConnectionIds, $this$assertConsistency){
            final /* synthetic */ Set<ConnectionId> $existingConnectionIds;
            final /* synthetic */ AbstractEntityStorage $this_assertConsistency;
            {
                this.$existingConnectionIds = $existingConnectionIds;
                this.$this_assertConsistency = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Map.Entry<ConnectionId, ? extends BiMap<ChildEntityId, ParentEntityId>> entry) {
                Iterable $this$forEach$iv;
                boolean bl2;
                Intrinsics.checkNotNullParameter(entry, "<name for destructuring parameter 0>");
                ConnectionId connectionId = entry.getKey();
                BiMap<ChildEntityId, ParentEntityId> map2 = entry.getValue();
                this.$existingConnectionIds.remove(connectionId);
                boolean bl3 = bl2 = connectionId.getConnectionType() == ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                Map map3 = map2;
                Object object = this.$this_assertConsistency;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> entry2 = element$iv = iterator2.next();
                    boolean bl4 = false;
                    long childId = ((ChildEntityId)entry2.getKey()).unbox-impl();
                    long parentId = ((ParentEntityId)entry2.getValue()).unbox-impl();
                    Intrinsics.checkNotNull(ParentEntityId.box-impl(parentId));
                    int n2 = EntityIdKt.getClazz(parentId);
                    Intrinsics.checkNotNull(ParentEntityId.box-impl(parentId));
                    ConsistencyCheckerKt.access$assertResolvable((AbstractEntityStorage)object, n2, EntityIdKt.getArrayId(parentId));
                    Intrinsics.checkNotNull(ChildEntityId.box-impl(childId));
                    int n3 = EntityIdKt.getClazz(childId);
                    Intrinsics.checkNotNull(ChildEntityId.box-impl(childId));
                    ConsistencyCheckerKt.access$assertResolvable((AbstractEntityStorage)object, n3, EntityIdKt.getArrayId(childId));
                    int n4 = connectionId.getParentClass();
                    Intrinsics.checkNotNull(ParentEntityId.box-impl(parentId));
                    ConsistencyCheckerKt.access$assertCorrectEntityClass(n4, parentId);
                    int n5 = connectionId.getChildClass();
                    Intrinsics.checkNotNull(ChildEntityId.box-impl(childId));
                    ConsistencyCheckerKt.access$assertCorrectEntityClass(n5, childId);
                }
                if (!connectionId.isParentNullable()) {
                    Collection<Integer> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Set set;
                    void destination$iv;
                    Iterable $this$mapTo$iv;
                    $this$forEach$iv = map2.keySet();
                    object = new HashSet<E>();
                    AbstractEntityStorage abstractEntityStorage = this.$this_assertConsistency;
                    boolean $i$f$mapTo22 = false;
                    for (Map.Entry<K, V> item$iv : $this$mapTo$iv) {
                        void it;
                        long l2 = ((ChildEntityId)((Object)item$iv)).unbox-impl();
                        set = destination$iv;
                        boolean bl5 = false;
                        Intrinsics.checkNotNull(ChildEntityId.box-impl((long)it));
                        set.add((long)it);
                    }
                    $this$mapTo$iv = CollectionsKt.toMutableSet((Iterable)map2.keySet());
                    set = (Set)destination$iv;
                    boolean $i$f$map = false;
                    void $i$f$mapTo22 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        long bl5 = ((ChildEntityId)item$iv$iv).unbox-impl();
                        collection = destination$iv$iv;
                        boolean bl6 = false;
                        Intrinsics.checkNotNull(ChildEntityId.box-impl((long)it));
                        collection.add(EntityIdKt.getClazz((long)it));
                    }
                    collection = (List)destination$iv$iv;
                    ConsistencyCheckerKt.access$checkStrongAbstractConnection(abstractEntityStorage, set, CollectionsKt.toSet((Iterable)collection), connectionId.debugStr());
                }
            }
        });
        Iterable $this$filterNot$iv = existingConnectionIds;
        boolean $i$f$filterNot = false;
        $this$mapNotNullTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ConnectionId it = (ConnectionId)element$iv$iv;
            boolean bl6 = false;
            if (it.isParentNullable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl7;
            ConnectionId connectionId = (ConnectionId)element$iv;
            boolean bl8 = false;
            int childrenClass = connectionId.getChildClass();
            EntityFamily<? extends WorkspaceEntity> entityFamily = $this$assertConsistency.getEntitiesByType$intellij_platform_workspace_storage().get(childrenClass);
            WorkspaceEntityData childWithoutParent = entityFamily != null && (entityFamily = entityFamily.getEntities$intellij_platform_workspace_storage()) != null ? (WorkspaceEntityData)CollectionsKt.firstOrNull(entityFamily) : null;
            boolean bl9 = bl7 = childWithoutParent == null;
            if (!_Assertions.ENABLED || bl7) continue;
            boolean bl10 = false;
            WorkspaceEntityData workspaceEntityData = childWithoutParent;
            Intrinsics.checkNotNull(workspaceEntityData);
            String string2 = StringsKt.trimIndent("\n        There is an entity " + EntityIdKt.asString(workspaceEntityData.createEntityId()) + " of type " + ClassToIntConverterKt.findWorkspaceEntity(childrenClass).getSimpleName() + " without a parent of type " + ClassToIntConverterKt.findWorkspaceEntity(connectionId.getParentClass()).getSimpleName() + "\n        However, the parent field in child is not nullable\n        Child full type: " + ClassToIntConverterKt.findWorkspaceEntity(childrenClass) + "\n        Parent full type: " + ClassToIntConverterKt.findWorkspaceEntity(connectionId.getParentClass()) + "\n        ");
            throw new AssertionError((Object)string2);
        }
        $this$assertConsistency.getIndexes$intellij_platform_workspace_storage().assertConsistency($this$assertConsistency);
    }

    private static final void assertCorrectEntityClass(int connectionClass, long entityId) {
        boolean bl2 = ClassToIntConverterKt.findWorkspaceEntity(connectionClass).isAssignableFrom(ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(entityId)));
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string2 = "Entity storage with connection class " + ClassToIntConverterKt.findWorkspaceEntity(connectionClass) + " contains entity data of wrong type " + entityId;
            throw new AssertionError((Object)string2);
        }
    }

    private static final void assertResolvable(AbstractEntityStorage storage, int clazz, int id2) {
        boolean bl2;
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage.getEntitiesByType$intellij_platform_workspace_storage().get(clazz);
        boolean bl3 = bl2 = (entityFamily != null ? entityFamily.get(id2) : null) != null;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string2 = "Reference to " + ClassToIntConverterKt.findWorkspaceEntity(clazz) + "-:-" + id2 + " cannot be resolved";
            throw new AssertionError((Object)string2);
        }
    }

    private static final void checkAllStrongConnections(AbstractEntityStorage storage, int entityFamilyClass, Set<Long> keys2, String debugInfo) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = storage.getEntitiesByType$intellij_platform_workspace_storage().getEntityFamilies$intellij_platform_workspace_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            throw new IllegalStateException(("Entity family doesn't exist. " + debugInfo).toString());
        }
        EntityFamily<? extends WorkspaceEntity> entityFamily2 = entityFamily;
        Iterable $this$forEach$iv = entityFamily2.getEntities$intellij_platform_workspace_storage();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkspaceEntityData entity = (WorkspaceEntityData)element$iv;
            boolean bl2 = false;
            if (entity == null) continue;
            boolean removed = keys2.remove(entity.createEntityId());
            if (!_Assertions.ENABLED || removed) continue;
            boolean bl3 = false;
            String string2 = "Entity " + entity + " doesn't have a correct connection. " + debugInfo;
            throw new AssertionError((Object)string2);
        }
    }

    private static final void checkStrongAbstractConnection(AbstractEntityStorage storage, Set<Long> connectionKeys, Set<Integer> entityFamilyClasses, String debugInfo) {
        Set<Long> keys2 = CollectionsKt.toMutableSet((Iterable)connectionKeys);
        Iterable $this$forEach$iv = entityFamilyClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int entityFamilyClass = ((Number)element$iv).intValue();
            boolean bl2 = false;
            ConsistencyCheckerKt.checkAllStrongConnections(storage, entityFamilyClass, keys2, debugInfo);
        }
        boolean bl3 = keys2.isEmpty();
        if (_Assertions.ENABLED && !bl3) {
            boolean bl4 = false;
            String string2 = "Store is inconsistent. " + debugInfo;
            throw new AssertionError((Object)string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkStrongConnection(AbstractEntityStorage storage, IntSet connectionKeys, int entityFamilyClass, int connectionTo, ConnectionId connectionId) {
        boolean bl2;
        int counter = 0;
        EntityFamily entityFamily = storage.getEntitiesByType$intellij_platform_workspace_storage().get(entityFamilyClass);
        if (entityFamily == null) {
            entityFamily = new ImmutableEntityFamily();
        }
        EntityFamily entityFamily2 = entityFamily;
        Iterable $this$forEachIndexed$iv = entityFamily2.getEntities$intellij_platform_workspace_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entity;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv;
            int i2 = n2;
            boolean bl3 = false;
            if (entity == null) continue;
            boolean bl4 = connectionKeys.contains(i2);
            if (_Assertions.ENABLED && !bl4) {
                boolean bl5 = false;
                String string2 = StringsKt.trimMargin$default("\n            |Storage inconsistency. Hard reference broken.\n            |Existing entity " + (WorkspaceEntityData)entity + "\n            |Misses a reference to " + ClassToIntConverterKt.findWorkspaceEntity(connectionTo) + "\n            |Reference id: " + i2 + "\n            |ConnectionId: " + connectionId + "\n            ", null, 1, null);
                throw new AssertionError((Object)string2);
            }
            ++counter;
        }
        boolean bl6 = bl2 = counter == connectionKeys.size();
        if (_Assertions.ENABLED && !bl2) {
            boolean bl7 = false;
            String string3 = "Store is inconsistent";
            throw new AssertionError((Object)string3);
        }
    }

    public static final /* synthetic */ void access$checkStrongConnection(AbstractEntityStorage storage, IntSet connectionKeys, int entityFamilyClass, int connectionTo, ConnectionId connectionId) {
        ConsistencyCheckerKt.checkStrongConnection(storage, connectionKeys, entityFamilyClass, connectionTo, connectionId);
    }

    public static final /* synthetic */ void access$assertResolvable(AbstractEntityStorage storage, int clazz, int id2) {
        ConsistencyCheckerKt.assertResolvable(storage, clazz, id2);
    }

    public static final /* synthetic */ void access$assertCorrectEntityClass(int connectionClass, long entityId) {
        ConsistencyCheckerKt.assertCorrectEntityClass(connectionClass, entityId);
    }

    public static final /* synthetic */ void access$checkStrongAbstractConnection(AbstractEntityStorage storage, Set connectionKeys, Set entityFamilyClasses, String debugInfo) {
        ConsistencyCheckerKt.checkStrongAbstractConnection(storage, connectionKeys, entityFamilyClasses, debugInfo);
    }
}

