/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.EntitiesKt;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000fJ\u001b\u0010\u0010\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\u0006\u0010\u0013\u001a\u00020\u0012R\"\u0010\u0003\u001a\u0012\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00050\u0004X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/workspace/storage/impl/EntitiesBarrel;", "", "()V", "entityFamilies", "", "Lcom/intellij/platform/workspace/storage/impl/EntityFamily;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "getEntityFamilies$intellij_platform_workspace_storage", "()Ljava/util/List;", "assertConsistency", "", "exists", "", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "get", "clazz", "", "size", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntitiesBarrel;", "Lcom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nEntitiesBarrel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntitiesBarrel.kt\ncom/intellij/platform/workspace/storage/impl/EntitiesBarrel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 EntityFamily.kt\ncom/intellij/platform/workspace/storage/impl/EntityFamily\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1864#2,2:148\n1864#2,2:151\n1866#2:159\n1866#2:162\n201#3:150\n202#3,2:153\n204#3:156\n206#3:158\n207#3,2:160\n1#4:155\n1#4:157\n*S KotlinDebug\n*F\n+ 1 EntitiesBarrel.kt\ncom/intellij/platform/workspace/storage/impl/EntitiesBarrel\n*L\n122#1:148,2\n126#1:151,2\n126#1:159\n122#1:162\n126#1:150\n126#1:153,2\n126#1:156\n126#1:158\n126#1:160,2\n126#1:155\n*E\n"})
public abstract class EntitiesBarrel {
    private EntitiesBarrel() {
    }

    @NotNull
    public abstract List<EntityFamily<? extends WorkspaceEntity>> getEntityFamilies$intellij_platform_workspace_storage();

    public final boolean exists(long entityId) {
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.get(EntityIdKt.getClazz(entityId));
        return entityFamily != null ? entityFamily.exists(EntityIdKt.getArrayId(entityId)) : false;
    }

    @Nullable
    public EntityFamily<? extends WorkspaceEntity> get(int clazz) {
        return CollectionsKt.getOrNull(this.getEntityFamilies$intellij_platform_workspace_storage(), clazz);
    }

    public final int size() {
        return this.getEntityFamilies$intellij_platform_workspace_storage().size();
    }

    /*
     * WARNING - void declaration
     */
    public final void assertConsistency() {
        HashSet symbolicIds = new HashSet();
        Iterable $this$forEachIndexed$iv = this.getEntityFamilies$intellij_platform_workspace_storage();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void family;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            EntityFamily entityFamily = (EntityFamily)item$iv;
            int i2 = n2;
            boolean bl2 = false;
            if (family == null) continue;
            Class<WorkspaceEntity> clazz = ClassToIntConverterKt.findWorkspaceEntity(i2);
            boolean hasSymbolicId = WorkspaceEntityWithSymbolicId.class.isAssignableFrom(clazz);
            void this_$iv = family;
            boolean $i$f$assertConsistency = false;
            Iterable $this$forEachIndexed$iv$iv = this_$iv.getEntities$intellij_platform_workspace_storage();
            boolean $i$f$forEachIndexed2 = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                boolean bl3;
                boolean bl4;
                void entity$iv;
                int n3;
                if ((n3 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                WorkspaceEntityData workspaceEntityData = (WorkspaceEntityData)item$iv$iv;
                int idx$iv = n3;
                boolean bl5 = false;
                if (entity$iv == null) continue;
                boolean bl6 = bl4 = idx$iv == entity$iv.getId();
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl7 = false;
                    String string2 = "Entity with id " + entity$iv.getId() + " is placed at index " + idx$iv;
                    throw new AssertionError((Object)string2);
                }
                void entityData = entity$iv;
                boolean bl8 = false;
                Class<WorkspaceEntity> immutableClass = entityData.getEntityInterface();
                boolean bl9 = Intrinsics.areEqual(clazz, immutableClass);
                if (_Assertions.ENABLED && !bl9) {
                    boolean bl10 = false;
                    String string3 = StringsKt.trimMargin$default("EntityFamily contains entity data of wrong type:\n                | - EntityFamily class:   " + clazz + "\n                | - entityData class:     " + immutableClass + "\n              ", null, 1, null);
                    throw new AssertionError((Object)string3);
                }
                if (!hasSymbolicId) continue;
                SymbolicEntityId<?> symbolicId = EntitiesKt.symbolicId(entityData);
                boolean bl11 = bl3 = symbolicId != null;
                if (_Assertions.ENABLED && !bl3) {
                    boolean $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = false;
                    String $i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42 = "Symbolic id expected for " + clazz;
                    throw new AssertionError((Object)$i$a$-assert-EntitiesBarrel$assertConsistency$1$1$42);
                }
                boolean bl12 = bl3 = !CollectionsKt.contains(symbolicIds, symbolicId);
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl13 = false;
                    String string4 = "Duplicated symbolic ids: " + symbolicId;
                    throw new AssertionError((Object)string4);
                }
                SymbolicEntityId<?> symbolicEntityId = symbolicId;
                Intrinsics.checkNotNull(symbolicEntityId);
                symbolicIds.add(symbolicEntityId);
            }
            EntityFamily.access$familyCheck((EntityFamily)this_$iv);
        }
    }

    public /* synthetic */ EntitiesBarrel(DefaultConstructorMarker $constructor_marker) {
        this();
    }
}

