/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.EntityTreeUtilKt;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.MutableExternalEntityMapping;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.ApplyChangesFromOperation;
import com.intellij.platform.workspace.storage.impl.ChangeEntry;
import com.intellij.platform.workspace.storage.impl.ChildEntityId;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.ConnectionId;
import com.intellij.platform.workspace.storage.impl.EntitiesKt;
import com.intellij.platform.workspace.storage.impl.EntityFamily;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.ImmutableEntitiesBarrel;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.MutableEntitiesBarrel;
import com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.MutableRefsTable;
import com.intellij.platform.workspace.storage.impl.MutableStorageIndexes;
import com.intellij.platform.workspace.storage.impl.ParentEntityId;
import com.intellij.platform.workspace.storage.impl.RefsTable;
import com.intellij.platform.workspace.storage.impl.RefsTableKt;
import com.intellij.platform.workspace.storage.impl.ReplaceBySourceAsTree;
import com.intellij.platform.workspace.storage.impl.SoftLinkable;
import com.intellij.platform.workspace.storage.impl.StorageIndexes;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceBuilderChangeLog;
import com.intellij.platform.workspace.storage.impl.WorkspaceBuilderChangeLogKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.cache.ChangeOnWorkspaceBuilderChangeLog;
import com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCacheImpl;
import com.intellij.platform.workspace.storage.impl.exceptions.SymbolicIdAlreadyExistsException;
import com.intellij.platform.workspace.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndex;
import com.intellij.platform.workspace.storage.instrumentation.Modification;
import com.intellij.platform.workspace.storage.instrumentation.MutableEntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.url.MutableVirtualFileUrlIndex;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.CollectionFactory;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u008c\u00012\u00020\u00012\u00020\u0002:\u0002\u008c\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J>\u0010:\u001a\u00020/2\n\u0010;\u001a\u00060\u001fj\u0002`<2\u0010\u0010=\u001a\f\u0012\b\u0012\u00060\u001fj\u0002`<0>2\u0016\u0010?\u001a\u0012\u0012\b\u0012\u00060\u001fj\u0002`<\u0012\u0004\u0012\u00020\u00190-H\u0002J\"\u0010@\u001a\u00020/2\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020DH\u0016J \u0010F\u001a\u0002HG\"\b\b\u0000\u0010G*\u00020D2\u0006\u0010H\u001a\u0002HGH\u0096\u0004\u00a2\u0006\u0002\u0010IJ\u0010\u0010J\u001a\u00020/2\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020/2\u0006\u0010K\u001a\u00020\u0002H\u0002J \u0010N\u001a\u00020/\"\b\b\u0000\u0010G*\u00020D2\f\u0010O\u001a\b\u0012\u0004\u0012\u0002HG0PH\u0002J\"\u0010Q\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030S\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030U0T0RH\u0016J&\u0010V\u001a\b\u0012\u0004\u0012\u0002HX0W\"\b\b\u0000\u0010X*\u00020D2\f\u0010Y\u001a\b\u0012\u0004\u0012\u0002HX0SH\u0016J\"\u0010Z\u001a\b\u0012\u0004\u0012\u00020D0W2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020\u00190-H\u0016J\"\u0010]\u001a\b\u0012\u0004\u0012\u0002HG0^\"\u0004\b\u0000\u0010G2\f\u0010_\u001a\b\u0012\u0004\u0012\u0002HG0`H\u0016J\u0006\u0010a\u001a\u00020bJ\b\u0010c\u001a\u00020\u0019H\u0016J\b\u0010d\u001a\u00020\u0019H\u0016J\r\u0010e\u001a\u00020/H\u0000\u00a2\u0006\u0002\bfJ\b\u0010g\u001a\u00020/H\u0002JX\u0010h\u001a\u0002HG\"\u0010\b\u0000\u0010i*\n\u0012\u0006\b\u0001\u0012\u0002HG0j\"\b\b\u0001\u0010G*\u00020D2\f\u0010k\u001a\b\u0012\u0004\u0012\u0002Hi0S2\u0006\u0010l\u001a\u0002HG2\u0017\u0010m\u001a\u0013\u0012\u0004\u0012\u0002Hi\u0012\u0004\u0012\u00020/0-\u00a2\u0006\u0002\bnH\u0016\u00a2\u0006\u0002\u0010oJC\u0010p\u001a\u00020/\"\b\b\u0000\u0010G*\u00020D\"\u000e\b\u0001\u0010X*\b\u0012\u0004\u0012\u0002HG0P\"\u0014\b\u0002\u0010q*\u000e\u0012\u0004\u0012\u0002HG\u0012\u0004\u0012\u0002HX0r2\u0006\u0010H\u001a\u0002Hq\u00a2\u0006\u0002\u0010sJ>\u0010t\u001a\b\u0012\u0004\u0012\u0002Hu0W\"\b\b\u0000\u0010X*\u00020v\"\b\b\u0001\u0010u*\u00020D2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002HX0w2\f\u0010Y\u001a\b\u0012\u0004\u0012\u0002Hu0SH\u0016J\u0010\u0010x\u001a\u00020\u00192\u0006\u0010l\u001a\u00020DH\u0016J3\u0010y\u001a\u00020\u00192\n\u0010z\u001a\u00060\u001fj\u0002`<2\u0018\b\u0002\u0010?\u001a\u0012\u0012\b\u0012\u00060\u001fj\u0002`<\u0012\u0004\u0012\u00020\u00190-H\u0000\u00a2\u0006\u0002\b{J\u0019\u0010|\u001a\u00020/2\n\u0010;\u001a\u00060\u001fj\u0002`<H\u0000\u00a2\u0006\u0002\b}J%\u0010~\u001a\u00020/2\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020\u00190-2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0016J(\u0010\u0081\u0001\u001a\u00020/2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\r\u0010\u0082\u0001\u001a\b\u0012\u0004\u0012\u00020D0TH\u0016J)\u0010\u0083\u0001\u001a\u0004\u0018\u0001HX\"\b\b\u0000\u0010X*\u00020v2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002HX0wH\u0016\u00a2\u0006\u0003\u0010\u0084\u0001J,\u0010\u0085\u0001\u001a\u00020\u00192\u0007\u0010\u0086\u0001\u001a\u00020\u00022\u000b\u0010\u0087\u0001\u001a\u00060\u001fj\u0002`<2\u000b\u0010\u0088\u0001\u001a\u00060\u001fj\u0002`<H\u0002J\n\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J\t\u0010\u008b\u0001\u001a\u00020/H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00198\u0000@\u0000X\u0081\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020#X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010)R\u0010\u0010*\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R@\u00100\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/\u0018\u00010-2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020/\u0018\u00010-@AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R@\u00105\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020/\u0018\u00010-2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020/\u0018\u00010-@AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00102\"\u0004\b7\u00104R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008d\u0001"}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;", "Lcom/intellij/platform/workspace/storage/instrumentation/MutableEntityStorageInstrumentation;", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "originalSnapshot", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntityStorageImpl;", "(Lcom/intellij/platform/workspace/storage/impl/ImmutableEntityStorageImpl;)V", "changeLog", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceBuilderChangeLog;", "getChangeLog$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/WorkspaceBuilderChangeLog;", "engine", "Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;", "getEngine$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;", "setEngine$intellij_platform_workspace_storage", "(Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;)V", "entitiesByType", "Lcom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel;", "getEntitiesByType$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/MutableEntitiesBarrel;", "indexes", "Lcom/intellij/platform/workspace/storage/impl/MutableStorageIndexes;", "getIndexes$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/MutableStorageIndexes;", "keepLastRbsEngine", "", "getKeepLastRbsEngine$intellij_platform_workspace_storage", "()Z", "setKeepLastRbsEngine$intellij_platform_workspace_storage", "(Z)V", "modificationCount", "", "getModificationCount", "()J", "refs", "Lcom/intellij/platform/workspace/storage/impl/MutableRefsTable;", "getRefs$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/MutableRefsTable;", "stackTrace", "", "threadId", "Ljava/lang/Long;", "threadName", "trackStackTrace", "<set-?>", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/impl/ApplyChangesFromOperation;", "", "upgradeApplyChangesFromEngine", "getUpgradeApplyChangesFromEngine$intellij_platform_workspace_storage", "()Lkotlin/jvm/functions/Function1;", "setUpgradeApplyChangesFromEngine$intellij_platform_workspace_storage", "(Lkotlin/jvm/functions/Function1;)V", "upgradeEngine", "getUpgradeEngine$intellij_platform_workspace_storage", "setUpgradeEngine$intellij_platform_workspace_storage", "writingFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "accumulateEntitiesToRemove", "id", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "accumulator", "", "entityFilter", "addChild", "connectionId", "Lcom/intellij/platform/workspace/storage/impl/ConnectionId;", "parent", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "child", "addEntity", "T", "entity", "(Lcom/intellij/platform/workspace/storage/WorkspaceEntity;)Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "applyChangesFrom", "builder", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "applyChangesFromProtection", "assertUniqueSymbolicId", "pEntityData", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "collectChanges", "", "Ljava/lang/Class;", "", "Lcom/intellij/platform/workspace/storage/EntityChange;", "entities", "Lkotlin/sequences/Sequence;", "E", "entityClass", "entitiesBySource", "sourceFilter", "Lcom/intellij/platform/workspace/storage/EntitySource;", "getMutableExternalMapping", "Lcom/intellij/platform/workspace/storage/MutableExternalEntityMapping;", "identifier", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "getMutableVirtualFileUrlIndex", "Lcom/intellij/platform/workspace/storage/url/MutableVirtualFileUrlIndex;", "hasChanges", "hasSameEntities", "incModificationCount", "incModificationCount$intellij_platform_workspace_storage", "lockWrite", "modifyEntity", "M", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity$Builder;", "clazz", "e", "change", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/Class;Lcom/intellij/platform/workspace/storage/WorkspaceEntity;Lkotlin/jvm/functions/Function1;)Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "putEntity", "D", "Lcom/intellij/platform/workspace/storage/impl/ModifiableWorkspaceEntityBase;", "(Lcom/intellij/platform/workspace/storage/impl/ModifiableWorkspaceEntityBase;)V", "referrers", "R", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "removeEntity", "removeEntityByEntityId", "idx", "removeEntityByEntityId$intellij_platform_workspace_storage", "removeSingleEntity", "removeSingleEntity$intellij_platform_workspace_storage", "replaceBySource", "replaceWith", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "replaceChildren", "newChildren", "resolve", "(Lcom/intellij/platform/workspace/storage/SymbolicEntityId;)Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "same", "originalImpl", "addedEntityId", "removedEntityId", "toSnapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "unlockWrite", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nImmutableEntityStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImmutableEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Entities.kt\ncom/intellij/platform/workspace/storage/impl/ModifiableWorkspaceEntityBase\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 9 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 10 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,1069:1\n44#2,2:1070\n46#2:1078\n44#2,2:1079\n46#2:1087\n44#2,2:1088\n46#2:1096\n44#2,2:1097\n46#2:1108\n44#2,2:1109\n46#2:1117\n44#2,2:1118\n46#2:1126\n44#2,2:1127\n46#2:1144\n44#2,2:1145\n46#2:1158\n44#2,2:1159\n46#2:1167\n44#2,2:1168\n46#2:1197\n44#2,2:1198\n46#2:1222\n44#2,2:1226\n46#2:1240\n44#2,2:1253\n46#2:1261\n44#2,2:1262\n46#2:1270\n44#2,2:1271\n46#2:1279\n17#3,6:1072\n17#3,6:1081\n17#3,6:1090\n17#3,5:1099\n22#3:1107\n17#3,6:1111\n17#3,6:1120\n17#3,5:1129\n22#3:1143\n17#3,5:1147\n22#3:1157\n17#3,6:1161\n17#3,5:1170\n22#3:1196\n17#3,5:1200\n22#3:1221\n17#3,5:1228\n22#3:1239\n17#3,6:1255\n17#3,6:1264\n17#3,6:1273\n766#4:1104\n857#4,2:1105\n1855#4:1207\n288#4,2:1211\n1856#4:1216\n1855#4:1217\n1856#4:1220\n1726#4,3:1223\n1238#4,4:1235\n1549#4:1241\n1620#4,3:1242\n1855#4,2:1245\n1855#4,2:1247\n1855#4,2:1249\n1855#4,2:1284\n1855#4,2:1286\n339#5,8:1134\n1#6:1142\n46#7,5:1152\n53#7,4:1280\n11#7:1290\n372#8,7:1175\n372#8,7:1182\n372#8,7:1189\n453#8:1233\n403#8:1234\n215#9,2:1205\n187#9,3:1208\n187#9,3:1213\n215#9,2:1218\n215#9,2:1288\n1313#10,2:1251\n*S KotlinDebug\n*F\n+ 1 ImmutableEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl\n*L\n186#1:1070,2\n186#1:1078\n194#1:1079,2\n194#1:1087\n204#1:1088,2\n204#1:1096\n212#1:1097,2\n212#1:1108\n227#1:1109,2\n227#1:1117\n253#1:1118,2\n253#1:1126\n302#1:1127,2\n302#1:1144\n371#1:1145,2\n371#1:1158\n392#1:1159,2\n392#1:1167\n408#1:1168,2\n408#1:1197\n441#1:1198,2\n441#1:1222\n523#1:1226,2\n523#1:1240\n673#1:1253,2\n673#1:1261\n689#1:1262,2\n689#1:1270\n703#1:1271,2\n703#1:1279\n186#1:1072,6\n194#1:1081,6\n204#1:1090,6\n212#1:1099,5\n212#1:1107\n227#1:1111,6\n253#1:1120,6\n302#1:1129,5\n302#1:1143\n371#1:1147,5\n371#1:1157\n392#1:1161,6\n408#1:1170,5\n408#1:1196\n441#1:1200,5\n441#1:1221\n523#1:1228,5\n523#1:1239\n673#1:1255,6\n689#1:1264,6\n703#1:1273,6\n215#1:1104\n215#1:1105,2\n457#1:1207\n465#1:1211,2\n457#1:1216\n480#1:1217\n480#1:1220\n511#1:1223,3\n529#1:1235,4\n557#1:1241\n557#1:1242,3\n560#1:1245,2\n563#1:1247,2\n566#1:1249,2\n742#1:1284,2\n760#1:1286,2\n320#1:1134,8\n376#1:1152,5\n716#1:1280,4\n832#1:1290\n418#1:1175,7\n423#1:1182,7\n429#1:1189,7\n529#1:1233\n529#1:1234\n447#1:1205,2\n461#1:1208,3\n470#1:1213,3\n485#1:1218,2\n767#1:1288,2\n575#1:1251,2\n*E\n"})
public final class MutableEntityStorageImpl
extends AbstractEntityStorage
implements MutableEntityStorageInstrumentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableEntityStorageImpl originalSnapshot;
    @NotNull
    private final MutableEntitiesBarrel entitiesByType;
    @NotNull
    private final MutableRefsTable refs;
    @NotNull
    private final MutableStorageIndexes indexes;
    private volatile boolean trackStackTrace;
    @NotNull
    private final WorkspaceBuilderChangeLog changeLog;
    @NotNull
    private final AtomicBoolean writingFlag;
    @Nullable
    private volatile String stackTrace;
    @Nullable
    private volatile Long threadId;
    @Nullable
    private volatile String threadName;
    @TestOnly
    private boolean keepLastRbsEngine;
    @Nullable
    private ReplaceBySourceAsTree engine;
    @Nullable
    private Function1<? super ReplaceBySourceAsTree, Unit> upgradeEngine;
    @Nullable
    private Function1<? super ApplyChangesFromOperation, Unit> upgradeApplyChangesFromEngine;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final AtomicLong instancesCounter;
    @NotNull
    private static final AtomicLong getEntitiesTimeMs;
    @NotNull
    private static final AtomicLong getReferrersTimeMs;
    @NotNull
    private static final AtomicLong resolveTimeMs;
    @NotNull
    private static final AtomicLong getEntitiesBySourceTimeMs;
    @NotNull
    private static final AtomicLong addEntityTimeMs;
    @NotNull
    private static final AtomicLong putEntityTimeMs;
    @NotNull
    private static final AtomicLong modifyEntityTimeMs;
    @NotNull
    private static final AtomicLong removeEntityTimeMs;
    @NotNull
    private static final AtomicLong replaceBySourceTimeMs;
    @NotNull
    private static final AtomicLong collectChangesTimeMs;
    @NotNull
    private static final AtomicLong hasSameEntitiesTimeMs;
    @NotNull
    private static final AtomicLong toSnapshotTimeMs;
    @NotNull
    private static final AtomicLong applyChangesFromTimeMs;
    @NotNull
    private static final AtomicLong getMutableExternalMappingTimeMs;
    @NotNull
    private static final AtomicLong getMutableVFUrlIndexTimeMs;

    public MutableEntityStorageImpl(@NotNull ImmutableEntityStorageImpl originalSnapshot) {
        Intrinsics.checkNotNullParameter(originalSnapshot, "originalSnapshot");
        super(null);
        this.originalSnapshot = originalSnapshot;
        this.entitiesByType = MutableEntitiesBarrel.Companion.from(this.originalSnapshot.getEntitiesByType$intellij_platform_workspace_storage());
        this.refs = MutableRefsTable.Companion.from(this.originalSnapshot.getRefs$intellij_platform_workspace_storage());
        this.indexes = this.originalSnapshot.getIndexes$intellij_platform_workspace_storage().toMutable();
        instancesCounter.incrementAndGet();
        this.changeLog = new WorkspaceBuilderChangeLog();
        this.writingFlag = new AtomicBoolean();
    }

    @Override
    @NotNull
    public MutableEntitiesBarrel getEntitiesByType$intellij_platform_workspace_storage() {
        return this.entitiesByType;
    }

    @Override
    @NotNull
    public MutableRefsTable getRefs$intellij_platform_workspace_storage() {
        return this.refs;
    }

    @Override
    @NotNull
    public MutableStorageIndexes getIndexes$intellij_platform_workspace_storage() {
        return this.indexes;
    }

    @NotNull
    public final WorkspaceBuilderChangeLog getChangeLog$intellij_platform_workspace_storage() {
        return this.changeLog;
    }

    public final void incModificationCount$intellij_platform_workspace_storage() {
        WorkspaceBuilderChangeLog workspaceBuilderChangeLog = this.changeLog;
        long l2 = workspaceBuilderChangeLog.getModificationCount();
        workspaceBuilderChangeLog.setModificationCount(l2 + 1L);
    }

    @Override
    public long getModificationCount() {
        return this.changeLog.getModificationCount();
    }

    public final boolean getKeepLastRbsEngine$intellij_platform_workspace_storage() {
        return this.keepLastRbsEngine;
    }

    public final void setKeepLastRbsEngine$intellij_platform_workspace_storage(boolean bl2) {
        this.keepLastRbsEngine = bl2;
    }

    @Nullable
    public final ReplaceBySourceAsTree getEngine$intellij_platform_workspace_storage() {
        return this.engine;
    }

    public final void setEngine$intellij_platform_workspace_storage(@Nullable ReplaceBySourceAsTree replaceBySourceAsTree) {
        this.engine = replaceBySourceAsTree;
    }

    @Nullable
    public final Function1<ReplaceBySourceAsTree, Unit> getUpgradeEngine$intellij_platform_workspace_storage() {
        return this.upgradeEngine;
    }

    @TestOnly
    public final void setUpgradeEngine$intellij_platform_workspace_storage(@Nullable Function1<? super ReplaceBySourceAsTree, Unit> function1) {
        this.upgradeEngine = function1;
    }

    @Nullable
    public final Function1<ApplyChangesFromOperation, Unit> getUpgradeApplyChangesFromEngine$intellij_platform_workspace_storage() {
        return this.upgradeApplyChangesFromEngine;
    }

    @TestOnly
    public final void setUpgradeApplyChangesFromEngine$intellij_platform_workspace_storage(@Nullable Function1<? super ApplyChangesFromOperation, Unit> function1) {
        this.upgradeApplyChangesFromEngine = function1;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> Sequence<E> entities(@NotNull Class<E> entityClass) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter(entityClass, "entityClass");
        AtomicLong arg0$iv = getEntitiesTimeMs;
        boolean bl2 = false;
        Sequence value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        EntityFamily<? extends WorkspaceEntity> entityFamily = this.getEntitiesByType$intellij_platform_workspace_storage().get(ClassToIntConverterKt.toClassId(entityClass));
        Sequence sequence2 = sequence = entityFamily != null && (entityFamily = entityFamily.all()) != null ? SequencesKt.map(entityFamily, (Function1)new Function1<WorkspaceEntityData<? extends WorkspaceEntity>, WorkspaceEntity.Builder<? extends WorkspaceEntity>>(this){
            final /* synthetic */ MutableEntityStorageImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final WorkspaceEntity.Builder<? extends WorkspaceEntity> invoke(@NotNull WorkspaceEntityData<? extends WorkspaceEntity> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.wrapAsModifiable(this.this$0);
            }
        }) : null;
        Sequence<Object> sequence3 = sequence instanceof Sequence ? sequence : null;
        if (sequence3 == null) {
            sequence3 = SequencesKt.emptySequence();
        }
        value$iv = sequence3;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntityWithSymbolicId, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull SymbolicEntityId<? extends E> id2, @NotNull Class<R> entityClass) {
        Intrinsics.checkNotNullParameter(id2, "id");
        Intrinsics.checkNotNullParameter(entityClass, "entityClass");
        AtomicLong arg0$iv = getReferrersTimeMs;
        boolean bl2 = false;
        Sequence value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        int classId2 = ClassToIntConverterKt.toClassId(entityClass);
        value$iv = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.getIndexes$intellij_platform_workspace_storage().getSoftLinks$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(id2)), (Function1)new Function1<Long, Boolean>(classId2){
            final /* synthetic */ int $classId;
            {
                this.$classId = $classId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(long it) {
                return EntityIdKt.getClazz(it) == this.$classId;
            }
        }), new Function1<Long, R>(this){
            final /* synthetic */ MutableEntityStorageImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final R invoke(long it) {
                WorkspaceEntity.Builder<? extends WorkspaceEntity> builder = this.this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(it).wrapAsModifiable(this.this$0);
                Intrinsics.checkNotNull(builder, "null cannot be cast to non-null type R of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.referrers$lambda$1");
                return (R)builder;
            }
        });
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    @Override
    @Nullable
    public <E extends WorkspaceEntityWithSymbolicId> E resolve(@NotNull SymbolicEntityId<? extends E> id2) {
        WorkspaceEntityWithSymbolicId workspaceEntityWithSymbolicId;
        Intrinsics.checkNotNullParameter(id2, "id");
        AtomicLong arg0$iv = resolveTimeMs;
        boolean bl2 = false;
        WorkspaceEntityWithSymbolicId value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        Long l2 = this.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(id2);
        if (l2 == null) {
            workspaceEntityWithSymbolicId = null;
        } else {
            long entityIds = l2;
            WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = this.entityDataById$intellij_platform_workspace_storage(entityIds);
            WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData2 = workspaceEntityData instanceof WorkspaceEntityData ? workspaceEntityData : null;
            if (workspaceEntityData2 == null) {
                workspaceEntityWithSymbolicId = null;
            } else {
                WorkspaceEntityData<? extends WorkspaceEntity> entityData = workspaceEntityData2;
                workspaceEntityWithSymbolicId = (WorkspaceEntityWithSymbolicId)((Object)entityData.wrapAsModifiable(this));
            }
        }
        value$iv = workspaceEntityWithSymbolicId;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (E)value$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Sequence<WorkspaceEntity> entitiesBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter(sourceFilter, "sourceFilter");
        AtomicLong arg0$iv = getEntitiesBySourceTimeMs;
        boolean bl2 = false;
        Sequence<WorkspaceEntity> value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        EntityStorageInternalIndex index2 = this.getIndexes$intellij_platform_workspace_storage().getEntitySourceIndex$intellij_platform_workspace_storage();
        Iterable iterable = index2.entries$intellij_platform_workspace_storage();
        boolean $i$f$filter = false;
        void var14_13 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!sourceFilter.invoke((EntitySource)element$iv$iv).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        value$iv = SequencesKt.flatMap(CollectionsKt.asSequence((List)destination$iv$iv), (Function1)new Function1<EntitySource, Sequence<? extends WorkspaceEntity.Builder<? extends WorkspaceEntity>>>((EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource>)index2, this){
            final /* synthetic */ EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> $index;
            final /* synthetic */ MutableEntityStorageImpl this$0;
            {
                this.$index = $index;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<WorkspaceEntity.Builder<? extends WorkspaceEntity>> invoke(@NotNull EntitySource source) {
                Intrinsics.checkNotNullParameter(source, "source");
                List<Long> list2 = this.$index.getIdsByEntry$intellij_platform_workspace_storage(source);
                if (list2 == null) {
                    throw new IllegalStateException(("Entity source " + source + " expected to be in the index").toString());
                }
                List<Long> entityIds = list2;
                return SequencesKt.map(CollectionsKt.asSequence((Iterable)entityIds), (Function1)new Function1<Long, WorkspaceEntity.Builder<? extends WorkspaceEntity>>(this.this$0){
                    final /* synthetic */ MutableEntityStorageImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final WorkspaceEntity.Builder<? extends WorkspaceEntity> invoke(long it) {
                        return this.this$0.entityDataByIdOrDie$intellij_platform_workspace_storage(it).wrapAsModifiable(this.this$0);
                    }
                });
            }
        });
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T extends WorkspaceEntity> T addEntity(@NotNull T entity) {
        T t2;
        AtomicLong atomicLong;
        long start$iv$iv;
        T value$iv;
        block7: {
            Intrinsics.checkNotNullParameter(entity, "entity");
            AtomicLong arg0$iv = addEntityTimeMs;
            boolean bl2 = false;
            value$iv = null;
            boolean $i$f$measureTimeMillis = false;
            start$iv$iv = System.currentTimeMillis();
            atomicLong = arg0$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            try {
                ModifiableWorkspaceEntityBase modifiableWorkspaceEntityBase;
                this.lockWrite();
                if (entity instanceof ModifiableWorkspaceEntityBase) {
                    modifiableWorkspaceEntityBase = (ModifiableWorkspaceEntityBase)entity;
                } else {
                    if (((WorkspaceEntityBase)entity).getSnapshot() == this) {
                        T t3 = entity;
                        t2 = t3;
                        break block7;
                    }
                    WorkspaceEntity.Builder<T> builder = EntityTreeUtilKt.createEntityTreeCopy(entity, true);
                    Intrinsics.checkNotNull(builder, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase<T of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.addEntity$lambda$4, *>");
                    modifiableWorkspaceEntityBase = (ModifiableWorkspaceEntityBase)builder;
                }
                ModifiableWorkspaceEntityBase entityToAdd = modifiableWorkspaceEntityBase;
                entityToAdd.applyToBuilder(this);
                entityToAdd.getChangedProperty().clear();
            }
            finally {
                this.unlockWrite();
            }
            t2 = entity;
        }
        value$iv = t2;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends WorkspaceEntity, E extends WorkspaceEntityData<T>, D extends ModifiableWorkspaceEntityBase<T, E>> void putEntity(@NotNull D entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        AtomicLong arg0$iv = putEntityTimeMs;
        boolean bl2 = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            this.lockWrite();
            WorkspaceEntityData newEntityData = ModifiableWorkspaceEntityBase.getEntityData$default(entity, false, 1, null);
            this.assertUniqueSymbolicId(newEntityData);
            this.getEntitiesByType$intellij_platform_workspace_storage().add(newEntityData, ClassToIntConverterKt.toClassId(entity.getEntityClass()));
            this.changeLog.addAddEvent$intellij_platform_workspace_storage(newEntityData.createEntityId(), newEntityData);
            this.getIndexes$intellij_platform_workspace_storage().entityAdded(newEntityData);
        }
        finally {
            this.unlockWrite();
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    private final <T extends WorkspaceEntity> void assertUniqueSymbolicId(WorkspaceEntityData<T> pEntityData) {
        block1: {
            SymbolicEntityId<?> symbolicEntityId = EntitiesKt.symbolicId(pEntityData);
            if (symbolicEntityId == null) break block1;
            SymbolicEntityId<?> symbolicId = symbolicEntityId;
            boolean bl2 = false;
            Long ids2 = this.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(symbolicId);
            if (ids2 != null) {
                WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(ids2);
                WorkspaceEntity existingEntity = existingEntityData.createEntity(this);
                this.removeEntity(existingEntity);
                LOG.error(StringsKt.trimIndent("\n              addEntity: symbolic id already exists. Replacing entity with the new one.\n              Symbolic id: " + symbolicId + "\n              \n              Existing entity data: " + existingEntityData + "\n              New entity data: " + pEntityData + "\n              \n              Broken consistency: " + this.getBrokenConsistency$intellij_platform_workspace_storage() + "\n            "), new SymbolicIdAlreadyExistsException(symbolicId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <M extends WorkspaceEntity.Builder<? extends T>, T extends WorkspaceEntity> T modifyEntity(@NotNull Class<M> clazz, @NotNull T e2, @NotNull Function1<? super M, Unit> change) {
        Object obj;
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        Intrinsics.checkNotNullParameter(e2, "e");
        Intrinsics.checkNotNullParameter(change, "change");
        AtomicLong arg0$iv = modifyEntityTimeMs;
        boolean bl2 = false;
        T value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            this.lockWrite();
            if (e2 instanceof ModifiableWorkspaceEntityBase && ((ModifiableWorkspaceEntityBase)e2).getDiff() != this) {
                throw new IllegalStateException("Trying to modify entity from a different builder".toString());
            }
            long entityId = ((WorkspaceEntityBase)e2).getId();
            WorkspaceEntityData<?> workspaceEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this, entityId);
            Intrinsics.checkNotNull(workspaceEntityData, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<T of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.modifyEntity$lambda$9>");
            WorkspaceEntityData<?> originalEntityData = workspaceEntityData;
            WorkspaceEntityData<?> workspaceEntityData2 = this.getEntitiesByType$intellij_platform_workspace_storage().getEntityDataForModification(entityId);
            Intrinsics.checkNotNull(workspaceEntityData2, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<T of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.modifyEntity$lambda$9>");
            WorkspaceEntityData<?> copiedData = workspaceEntityData2;
            WorkspaceEntity.Builder<?> builder = e2 instanceof WorkspaceEntity.Builder ? (WorkspaceEntity.Builder<?>)e2 : copiedData.wrapAsModifiable(this);
            Intrinsics.checkNotNull(builder, "null cannot be cast to non-null type M of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.modifyEntity$lambda$9");
            WorkspaceEntity.Builder<?> modifiableEntity = builder;
            Intrinsics.checkNotNull(modifiableEntity, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase<*, *>");
            ModifiableWorkspaceEntityBase cfr_ignored_0 = (ModifiableWorkspaceEntityBase)modifiableEntity;
            ((ModifiableWorkspaceEntityBase)modifiableEntity).getChangedProperty().clear();
            SymbolicEntityId<WorkspaceEntityWithSymbolicId> beforeSymbolicId = e2 instanceof WorkspaceEntityWithSymbolicId ? ((WorkspaceEntityWithSymbolicId)e2).getSymbolicId() : null;
            ModifiableWorkspaceEntityBase this_$iv = (ModifiableWorkspaceEntityBase)modifiableEntity;
            boolean $i$f$allowModifications$intellij_platform_workspace_storage = false;
            this_$iv.getModifiable().set(true);
            try {
                boolean bl5 = false;
                change.invoke(modifiableEntity);
                ((ModifiableWorkspaceEntityBase)modifiableEntity).afterModification();
            }
            finally {
                this_$iv.getModifiable().remove();
            }
            if (beforeSymbolicId != null) {
                SymbolicEntityId<?> newSymbolicId = EntitiesKt.symbolicId(copiedData);
                if (newSymbolicId != null) {
                    Long ids2 = this.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(newSymbolicId);
                    if (!Intrinsics.areEqual(beforeSymbolicId, newSymbolicId) && ids2 != null) {
                        WorkspaceEntityData<? extends WorkspaceEntity> existingEntityData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(ids2);
                        WorkspaceEntity existingEntity = existingEntityData.createEntity(this);
                        this.removeEntity(existingEntity);
                        LOG.error(StringsKt.trimIndent("\n              modifyEntity: persistent id already exists. Replacing entity with the new one.\n              Old entity: " + existingEntityData + "\n              Persistent id: " + copiedData + "\n              \n              Broken consistency: " + this.getBrokenConsistency$intellij_platform_workspace_storage() + "\n            "), new SymbolicIdAlreadyExistsException(newSymbolicId));
                    }
                } else {
                    LOG.error("Persistent id expected for entity: " + copiedData);
                }
            }
            this.changeLog.addReplaceDataEvent$intellij_platform_workspace_storage(entityId, copiedData, originalEntityData, true);
            if (((ModifiableWorkspaceEntityBase)modifiableEntity).getChangedProperty().contains("entitySource")) {
                EntitySource newSource = copiedData.getEntitySource();
                ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getIndexes$intellij_platform_workspace_storage().getEntitySourceIndex$intellij_platform_workspace_storage()).index$intellij_platform_workspace_storage(entityId, newSource);
                VirtualFileUrl virtualFileUrl = newSource.getVirtualFileUrl();
                if (virtualFileUrl != null) {
                    VirtualFileUrl it = virtualFileUrl;
                    boolean bl6 = false;
                    this.getIndexes$intellij_platform_workspace_storage().getVirtualFileIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(entityId, "entitySource", it);
                }
            }
            Object updatedEntity = copiedData.createEntity(this);
            this.getIndexes$intellij_platform_workspace_storage().updateSymbolicIdIndexes(this, (WorkspaceEntity)updatedEntity, beforeSymbolicId, copiedData, (ModifiableWorkspaceEntityBase)modifiableEntity);
            obj = updatedEntity;
        }
        finally {
            this.unlockWrite();
        }
        Object updatedEntity = obj;
        value$iv = (T)updatedEntity;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntity(@NotNull WorkspaceEntity e2) {
        boolean bl2;
        Intrinsics.checkNotNullParameter(e2, "e");
        AtomicLong arg0$iv = removeEntityTimeMs;
        boolean bl3 = false;
        Boolean value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            this.lockWrite();
            if (e2 instanceof ModifiableWorkspaceEntityBase && ((ModifiableWorkspaceEntityBase)e2).getDiff() != this) {
                throw new IllegalStateException("Trying to remove entity from a different builder".toString());
            }
            Logger $this$debug_u24default$iv = LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl6 = false;
                logger.debug("Removing " + e2.getClass() + "...", e$iv);
            }
            WorkspaceEntityBase cfr_ignored_0 = (WorkspaceEntityBase)e2;
            bl2 = MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage$default(this, ((WorkspaceEntityBase)e2).getId(), null, 2, null);
        }
        finally {
            this.unlockWrite();
        }
        boolean result2 = bl2;
        value$iv = result2;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter, @NotNull EntityStorage replaceWith) {
        Intrinsics.checkNotNullParameter(sourceFilter, "sourceFilter");
        Intrinsics.checkNotNullParameter(replaceWith, "replaceWith");
        AtomicLong arg0$iv = replaceBySourceTimeMs;
        boolean bl2 = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            this.lockWrite();
            AbstractEntityStorage cfr_ignored_0 = (AbstractEntityStorage)replaceWith;
            ReplaceBySourceAsTree rbsEngine = new ReplaceBySourceAsTree();
            if (this.keepLastRbsEngine) {
                this.engine = rbsEngine;
            }
            Function1<? super ReplaceBySourceAsTree, Unit> function1 = this.upgradeEngine;
            if (function1 != null) {
                Function1<? super ReplaceBySourceAsTree, Unit> it = function1;
                boolean bl5 = false;
                it.invoke(rbsEngine);
            }
            rbsEngine.replace(this, (AbstractEntityStorage)replaceWith, sourceFilter);
        }
        finally {
            this.unlockWrite();
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Class<?>, List<EntityChange<?>>> collectChanges() {
        void var3_3;
        AtomicLong arg0$iv = collectChangesTimeMs;
        boolean bl2 = false;
        HashMap value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        HashMap res = new HashMap();
        try {
            this.lockWrite();
            for (Map.Entry<Long, ChangeEntry> entry : this.changeLog.getChangeLog$intellij_platform_workspace_storage().entrySet()) {
                Object object;
                void $this$getOrPut$iv;
                WorkspaceEntityData<? extends WorkspaceEntity> oldData;
                Object key$iv;
                long entityId = ((Number)entry.getKey()).longValue();
                ChangeEntry change = entry.getValue();
                ChangeEntry changeEntry = change;
                if (changeEntry instanceof ChangeEntry.AddEntity) {
                    Object object2;
                    void $this$getOrPut$iv2;
                    WorkspaceEntityBase addedEntity = UtilsKt.asBase(((ChangeEntry.AddEntity)change).getEntityData().createEntity(this));
                    Map map2 = res;
                    key$iv = ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(entityId));
                    boolean $i$f$getOrPut = false;
                    Object value$iv2 = $this$getOrPut$iv2.get(key$iv);
                    if (value$iv2 == null) {
                        boolean bl5 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv2;
                    }
                    ((List)object2).add(new EntityChange.Added<WorkspaceEntity>(addedEntity));
                    continue;
                }
                if (changeEntry instanceof ChangeEntry.RemoveEntity) {
                    Object object3;
                    void $this$getOrPut$iv3;
                    WorkspaceEntityData<? extends WorkspaceEntity> removedData;
                    if (this.originalSnapshot.entityDataById$intellij_platform_workspace_storage(((ChangeEntry.RemoveEntity)change).getId()) == null) continue;
                    WorkspaceEntityBase removedEntity = UtilsKt.asBase(removedData.createEntity(this.originalSnapshot));
                    key$iv = res;
                    Class<WorkspaceEntity> key$iv2 = ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(entityId));
                    boolean $i$f$getOrPut = false;
                    Object value$iv3 = $this$getOrPut$iv3.get(key$iv2);
                    if (value$iv3 == null) {
                        boolean bl6 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv3.put(key$iv2, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv3;
                    }
                    ((List)object3).add(new EntityChange.Removed<WorkspaceEntity>(removedEntity));
                    continue;
                }
                if (!(changeEntry instanceof ChangeEntry.ReplaceEntity) || this.originalSnapshot.entityDataById$intellij_platform_workspace_storage(entityId) == null) continue;
                WorkspaceEntityBase replacedData = UtilsKt.asBase(oldData.createEntity(this.originalSnapshot));
                WorkspaceEntity replaceToData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(entityId).createEntity(this);
                Map key$iv2 = res;
                Class<WorkspaceEntity> key$iv3 = ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(entityId));
                boolean $i$f$getOrPut = false;
                Object value$iv4 = $this$getOrPut$iv.get(key$iv3);
                if (value$iv4 == null) {
                    boolean bl7 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv3, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv4;
                }
                ((List)object).add(new EntityChange.Replaced<WorkspaceEntity>(replacedData, replaceToData));
            }
        }
        finally {
            this.unlockWrite();
        }
        value$iv = res;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (Map)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasSameEntities() {
        void var3_3;
        boolean bl2;
        AtomicLong arg0$iv = hasSameEntitiesTimeMs;
        boolean bl3 = false;
        Boolean value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl4 = false;
        boolean bl5 = false;
        if (this.changeLog.getChangeLog$intellij_platform_workspace_storage().isEmpty()) {
            bl2 = true;
        } else {
            Object object;
            ImmutableEntityStorageImpl original = this.originalSnapshot;
            ArrayList<WorkspaceEntityData<? extends WorkspaceEntity>> adds = new ArrayList<WorkspaceEntityData<? extends WorkspaceEntity>>();
            Map<WorkspaceEntityData<? extends WorkspaceEntity>, WorkspaceEntityData[]> map2 = CollectionFactory.createSmallMemoryFootprintMap();
            Intrinsics.checkNotNullExpressionValue(map2, "createSmallMemoryFootprintMap(...)");
            Map<WorkspaceEntityData<? extends WorkspaceEntity>, WorkspaceEntityData[]> removes = map2;
            Map<Long, ChangeEntry> $this$forEach$iv = this.changeLog.getChangeLog$intellij_platform_workspace_storage();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Long, ChangeEntry>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object2;
                List<WorkspaceEntityData> list2;
                Object element$iv;
                Object object3 = element$iv = iterator2.next();
                boolean bl6 = false;
                ChangeEntry value = object3.getValue();
                if (value instanceof ChangeEntry.AddEntity) {
                    adds.add(((ChangeEntry.AddEntity)value).getEntityData());
                    continue;
                }
                if (!(value instanceof ChangeEntry.RemoveEntity)) continue;
                List existingValue = (List)removes.get(((ChangeEntry.RemoveEntity)value).getOldData());
                Map<WorkspaceEntityData<? extends WorkspaceEntity>, WorkspaceEntityData[]> map3 = removes;
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = ((ChangeEntry.RemoveEntity)value).getOldData();
                if (existingValue != null) {
                    list2 = new ArrayList(CollectionsKt.plus((Collection)existingValue, ((ChangeEntry.RemoveEntity)value).getOldData()));
                } else {
                    object2 = new WorkspaceEntityData[]{((ChangeEntry.RemoveEntity)value).getOldData()};
                    list2 = CollectionsKt.mutableListOf(object2);
                }
                object2 = list2;
                map3.put(workspaceEntityData, (WorkspaceEntityData[])object2);
            }
            ArrayList idsToRemove = new ArrayList();
            Iterable $this$forEach$iv2 = adds;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                boolean hasRemovedMapping;
                boolean bl7;
                long initialEntityId;
                WorkspaceEntityData found;
                long newEntityId;
                List possibleRemovedSameEntity;
                WorkspaceEntityData addedEntityData;
                block25: {
                    WorkspaceEntityData workspaceEntityData;
                    boolean hasMapping;
                    Object element$iv2;
                    boolean bl8;
                    block23: {
                        addedEntityData = (WorkspaceEntityData)element$iv;
                        boolean bl9 = false;
                        if (removes.isEmpty()) continue;
                        possibleRemovedSameEntity = (List)removes.get(addedEntityData);
                        newEntityId = addedEntityData.createEntityId();
                        Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> $this$any$iv = this.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage();
                        boolean $i$f$any = false;
                        if ($this$any$iv.isEmpty()) {
                            bl8 = false;
                        } else {
                            Iterator<Map.Entry<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>>> iterator3 = $this$any$iv.entrySet().iterator();
                            while (iterator3.hasNext()) {
                                object = element$iv2 = iterator3.next();
                                boolean bl10 = false;
                                MutableExternalEntityMappingImpl<?> value = object.getValue();
                                Intrinsics.checkNotNull(value, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.external.ExternalEntityMappingImpl<*>");
                                if (!(((ExternalEntityMappingImpl)value).getDataByEntityId$intellij_platform_workspace_storage(newEntityId) != null)) continue;
                                bl8 = true;
                                break block23;
                            }
                            bl8 = false;
                        }
                    }
                    if (hasMapping = bl8) continue;
                    List list3 = possibleRemovedSameEntity;
                    if (list3 != null) {
                        Object v5;
                        block24: {
                            Iterable $this$firstOrNull$iv = list3;
                            boolean $i$f$firstOrNull = false;
                            element$iv2 = $this$firstOrNull$iv.iterator();
                            while (element$iv2.hasNext()) {
                                Object element$iv3 = element$iv2.next();
                                WorkspaceEntityData possibleRemovedSame = (WorkspaceEntityData)element$iv3;
                                boolean bl11 = false;
                                if (!this.same(original, newEntityId, possibleRemovedSame.createEntityId())) continue;
                                v5 = element$iv3;
                                break block24;
                            }
                            v5 = null;
                        }
                        workspaceEntityData = v5;
                    } else {
                        workspaceEntityData = null;
                    }
                    if ((found = workspaceEntityData) == null) continue;
                    initialEntityId = found.createEntityId();
                    Map<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> $this$any$iv = original.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage();
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl7 = false;
                    } else {
                        Iterator<Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>>> iterator4 = $this$any$iv.entrySet().iterator();
                        while (iterator4.hasNext()) {
                            Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> element$iv4;
                            Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> entry = element$iv4 = iterator4.next();
                            boolean bl12 = false;
                            ExternalEntityMappingImpl<?> value = entry.getValue();
                            if (!(value.getDataByEntityId$intellij_platform_workspace_storage(initialEntityId) != null)) continue;
                            bl7 = true;
                            break block25;
                        }
                        bl7 = false;
                    }
                }
                if (hasRemovedMapping = bl7) continue;
                possibleRemovedSameEntity.remove(found);
                if (possibleRemovedSameEntity.isEmpty()) {
                    removes.remove(addedEntityData);
                }
                ((Collection)idsToRemove).add(TuplesKt.to(newEntityId, initialEntityId));
            }
            HashSet<Long> collapsibleChanges = new HashSet<Long>();
            Iterable $this$forEach$iv3 = idsToRemove;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                Pair pair = (Pair)element$iv;
                boolean bl13 = false;
                long l2 = ((Number)pair.component1()).longValue();
                long initial = ((Number)pair.component2()).longValue();
                collapsibleChanges.add(l2);
                collapsibleChanges.add(initial);
                Map<ConnectionId, ParentEntityId> $this$forEach$iv4 = this.getRefs$intellij_platform_workspace_storage().getParentRefsOfChild-HhnaDKw(RefsTableKt.asChild(l2));
                boolean $i$f$forEach4 = false;
                object = $this$forEach$iv4.entrySet().iterator();
                while (object.hasNext()) {
                    Pair pair2;
                    Pair pair3;
                    Pair it;
                    Pair pair4;
                    Map.Entry element$iv5;
                    Map.Entry entry = element$iv5 = (Map.Entry)object.next();
                    boolean bl14 = false;
                    ConnectionId connection = (ConnectionId)entry.getKey();
                    long parent = ((ParentEntityId)entry.getValue()).unbox-impl();
                    ChangeEntry changedParent = this.changeLog.getChangeLog$intellij_platform_workspace_storage().get(parent);
                    if (!(changedParent instanceof ChangeEntry.ReplaceEntity)) continue;
                    ChangeEntry.ReplaceEntity.Data data = ((ChangeEntry.ReplaceEntity)changedParent).getData();
                    ChangeEntry.ReplaceEntity.Data data2 = ((ChangeEntry.ReplaceEntity)changedParent).getData();
                    if (!Intrinsics.areEqual(data != null ? data.getNewData() : null, data2 != null ? data2.getOldData() : null)) continue;
                    Object object4 = ((ChangeEntry.ReplaceEntity)changedParent).getReferences();
                    boolean bl15 = object4 != null && (object4 = ((ChangeEntry.ReplaceEntity.References)object4).getNewParents()) != null ? object4.isEmpty() : false;
                    if (!bl15 || !((ChangeEntry.ReplaceEntity)changedParent).getReferences().getRemovedParents().isEmpty()) continue;
                    if ((Pair)CollectionsKt.singleOrNull((Iterable)((ChangeEntry.ReplaceEntity)changedParent).getReferences().getRemovedChildren()) != null) {
                        it = pair4;
                        boolean bl16 = false;
                        pair3 = Intrinsics.areEqual(it.getFirst(), connection) && ((ChildEntityId)it.getSecond()).unbox-impl() == initial ? pair4 : null;
                    } else {
                        pair3 = null;
                    }
                    if (pair3 == null) continue;
                    if ((Pair)CollectionsKt.singleOrNull((Iterable)((ChangeEntry.ReplaceEntity)changedParent).getReferences().getNewChildren()) != null) {
                        it = pair4;
                        boolean bl17 = false;
                        pair2 = Intrinsics.areEqual(it.getFirst(), connection) && ((ChildEntityId)it.getSecond()).unbox-impl() == l2 ? pair4 : null;
                    } else {
                        pair2 = null;
                    }
                    if (pair2 == null) continue;
                    collapsibleChanges.add(parent);
                }
            }
            bl2 = Intrinsics.areEqual(collapsibleChanges, this.changeLog.getChangeLog$intellij_platform_workspace_storage().keySet());
        }
        value$iv = bl2;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return var3_3.booleanValue();
    }

    private final boolean same(AbstractEntityStorage originalImpl, long addedEntityId, long removedEntityId) {
        boolean bl2;
        block8: {
            if (addedEntityId == removedEntityId) {
                return true;
            }
            if (EntityIdKt.getClazz(addedEntityId) != EntityIdKt.getClazz(removedEntityId)) {
                return false;
            }
            Map<ConnectionId, ParentEntityId> addedParents = this.getRefs$intellij_platform_workspace_storage().getParentRefsOfChild-HhnaDKw(RefsTableKt.asChild(addedEntityId));
            Map<ConnectionId, ParentEntityId> removeParents = originalImpl.getRefs$intellij_platform_workspace_storage().getParentRefsOfChild-HhnaDKw(RefsTableKt.asChild(removedEntityId));
            if (!Intrinsics.areEqual(addedParents.keySet(), removeParents.keySet())) {
                return false;
            }
            Iterable $this$all$iv = addedParents.entrySet();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl3;
                    Map.Entry entry = (Map.Entry)element$iv;
                    boolean bl4 = false;
                    ConnectionId connectionId = (ConnectionId)entry.getKey();
                    long addedParentEntityId = ((ParentEntityId)entry.getValue()).unbox-impl();
                    ParentEntityId parentEntityId = removeParents.get(connectionId);
                    Intrinsics.checkNotNull(parentEntityId);
                    long removedParentEntityId = parentEntityId.unbox-impl();
                    if (ParentEntityId.equals-impl0(addedParentEntityId, removedParentEntityId)) {
                        bl3 = true;
                    } else {
                        ChangeEntry addedParentInfo = this.changeLog.getChangeLog$intellij_platform_workspace_storage().get(addedParentEntityId);
                        ChangeEntry removedParentInfo = this.changeLog.getChangeLog$intellij_platform_workspace_storage().get(removedParentEntityId);
                        bl3 = addedParentInfo instanceof ChangeEntry.AddEntity && removedParentInfo instanceof ChangeEntry.RemoveEntity ? this.same(originalImpl, addedParentEntityId, removedParentEntityId) : false;
                    }
                    if (bl3) continue;
                    bl2 = false;
                    break block8;
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ImmutableEntityStorage toSnapshot() {
        void var3_3;
        void $this$mapValuesTo$iv$iv;
        AtomicLong arg0$iv = toSnapshotTimeMs;
        boolean bl2 = false;
        ImmutableEntityStorageImpl value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        ImmutableEntitiesBarrel newEntities = this.getEntitiesByType$intellij_platform_workspace_storage().toImmutable();
        RefsTable newRefs = this.getRefs$intellij_platform_workspace_storage().toImmutable();
        StorageIndexes newIndexes = this.getIndexes$intellij_platform_workspace_storage().toImmutable();
        TracedSnapshotCacheImpl cache2 = new TracedSnapshotCacheImpl();
        ImmutableEntityStorageImpl snapshot = new ImmutableEntityStorageImpl(newEntities, newRefs, newIndexes, cache2);
        Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> $this$mapValues$iv = this.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage();
        boolean $i$f$mapValues = false;
        Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl5 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl6 = false;
            Set<Long> set = ((MutableExternalEntityMappingImpl)it.getValue()).getIndexLogBunches$intellij_platform_workspace_storage().getChanges().keySet();
            map4.put(k2, set);
        }
        Map externalMappingChangelog = destination$iv$iv;
        ChangeOnWorkspaceBuilderChangeLog changes = new ChangeOnWorkspaceBuilderChangeLog(this.changeLog, externalMappingChangelog);
        cache2.pullCache(snapshot, this.originalSnapshot.getSnapshotCache$intellij_platform_workspace_storage(), changes);
        value$iv = snapshot;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (ImmutableEntityStorage)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceChildren(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity parent, @NotNull List<? extends WorkspaceEntity> newChildren) {
        Intrinsics.checkNotNullParameter(connectionId, "connectionId");
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter(newChildren, "newChildren");
        switch (WhenMappings.$EnumSwitchMapping$0[connectionId.getConnectionType().ordinal()]) {
            case 1: {
                Long existingChildId;
                long parentId = UtilsKt.asBase(parent).getId();
                if (!(newChildren.size() <= 1)) {
                    boolean $i$a$-check-MutableEntityStorageImpl$replaceChildren$22 = false;
                    String $i$a$-check-MutableEntityStorageImpl$replaceChildren$22 = "ONE_TO_ONE connection may have only one child";
                    throw new IllegalStateException($i$a$-check-MutableEntityStorageImpl$replaceChildren$22.toString());
                }
                WorkspaceEntity workspaceEntity = CollectionsKt.singleOrNull(newChildren);
                ChildEntityId childId = workspaceEntity != null && (workspaceEntity = UtilsKt.asBase(workspaceEntity)) != null ? ChildEntityId.box-impl(RefsTableKt.asChild(((WorkspaceEntityBase)workspaceEntity).getId())) : null;
                ChildEntityId childEntityId = CollectionsKt.singleOrNull(this.getRefs$intellij_platform_workspace_storage().getChildrenByParent-ePHS_xw(connectionId, RefsTableKt.asParent(parentId)));
                Long l2 = existingChildId = childEntityId != null ? Long.valueOf(childEntityId.unbox-impl()) : null;
                if (!(connectionId.isParentNullable() || existingChildId == null || childId != null && childId.unbox-impl() == existingChildId.longValue())) {
                    MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage$default(this, existingChildId, null, 2, null);
                }
                if (childId != null) {
                    UtilsKt.checkCircularDependency(connectionId, EntityIdKt.getArrayId(childId.unbox-impl()), EntityIdKt.getArrayId(parentId), this);
                    List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToOneChildOfParent-V33mNh8(connectionId, parentId, childId.unbox-impl());
                    UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                    break;
                }
                List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().removeRefsByParent-ePHS_xw(connectionId, RefsTableKt.asParent(parentId));
                UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                break;
            }
            case 2: {
                void $this$mapTo$iv$iv;
                long parentId = UtilsKt.asBase(parent).getId();
                Iterable $this$map$iv = newChildren;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    WorkspaceEntity workspaceEntity = (WorkspaceEntity)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(ChildEntityId.box-impl(RefsTableKt.asChild(UtilsKt.asBase((WorkspaceEntity)it).getId())));
                }
                List childrenIds2 = (List)((Object)destination$iv$iv);
                if (!connectionId.isParentNullable()) {
                    Set existingChildren = CollectionsKt.toMutableSet((Iterable)this.getRefs$intellij_platform_workspace_storage().getChildrenByParent-ePHS_xw(connectionId, RefsTableKt.asParent(parentId)));
                    Iterable $this$forEach$iv = childrenIds2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        long it = ((ChildEntityId)element$iv).unbox-impl();
                        boolean bl3 = false;
                        existingChildren.remove(ChildEntityId.box-impl(it));
                    }
                    $this$forEach$iv = existingChildren;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        long it = ((ChildEntityId)element$iv).unbox-impl();
                        boolean bl4 = false;
                        MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage$default(this, it, null, 2, null);
                    }
                }
                Iterable $this$forEach$iv = childrenIds2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    long it = ((ChildEntityId)element$iv).unbox-impl();
                    boolean bl5 = false;
                    UtilsKt.checkCircularDependency(connectionId, EntityIdKt.getArrayId(it), EntityIdKt.getArrayId(parentId), this);
                }
                List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToManyChildrenOfParent(connectionId, parentId, childrenIds2);
                UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                break;
            }
            case 3: {
                Sequence<ChildEntityId> childrenIds3;
                long parentId = RefsTableKt.asParent(UtilsKt.asBase(parent).getId());
                Sequence<ChildEntityId> $this$forEach$iv = childrenIds3 = SequencesKt.map(CollectionsKt.asSequence((Iterable)newChildren), replaceChildren.childrenIds.2.INSTANCE);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    long it = ((ChildEntityId)element$iv).unbox-impl();
                    boolean bl6 = false;
                    UtilsKt.checkCircularDependency(it, parentId, this);
                }
                List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToAbstractManyChildrenOfParent-GnhP5Uc(connectionId, parentId, childrenIds3);
                UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                break;
            }
            case 4: {
                ChildEntityId childId;
                long parentId = RefsTableKt.asParent(UtilsKt.asBase(parent).getId());
                if (!(newChildren.size() <= 1)) {
                    boolean $i$a$-check-MutableEntityStorageImpl$replaceChildren$72 = false;
                    String $i$a$-check-MutableEntityStorageImpl$replaceChildren$72 = "ABSTRACT_ONE_TO_ONE connection may have only one child";
                    throw new IllegalStateException($i$a$-check-MutableEntityStorageImpl$replaceChildren$72.toString());
                }
                WorkspaceEntity workspaceEntity = CollectionsKt.singleOrNull(newChildren);
                ChildEntityId childEntityId = workspaceEntity != null && (workspaceEntity = UtilsKt.asBase(workspaceEntity)) != null ? ChildEntityId.box-impl(RefsTableKt.asChild(((WorkspaceEntityBase)workspaceEntity).getId())) : (childId = null);
                if (childId != null) {
                    List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToAbstractOneChildOfParent-0Hr_qaU(connectionId, parentId, childId.unbox-impl());
                    UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                    break;
                }
                List<Modification> operation = this.getRefs$intellij_platform_workspace_storage().removeRefsByParent-ePHS_xw(connectionId, parentId);
                UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)operation, connectionId);
            }
        }
    }

    @Override
    public void addChild(@NotNull ConnectionId connectionId, @Nullable WorkspaceEntity parent, @NotNull WorkspaceEntity child) {
        Intrinsics.checkNotNullParameter(connectionId, "connectionId");
        Intrinsics.checkNotNullParameter(child, "child");
        switch (WhenMappings.$EnumSwitchMapping$0[connectionId.getConnectionType().ordinal()]) {
            case 1: {
                List<Modification> modifications;
                WorkspaceEntity existingChild;
                WorkspaceEntity workspaceEntity = parent;
                ParentEntityId parentId = workspaceEntity != null && (workspaceEntity = UtilsKt.asBase(workspaceEntity)) != null ? ParentEntityId.box-impl(RefsTableKt.asParent(((WorkspaceEntityBase)workspaceEntity).getId())) : null;
                long childId = UtilsKt.asBase(child).getId();
                if (!connectionId.isParentNullable() && parentId != null && (existingChild = this.getOneChild(connectionId, parent)) != null && !Intrinsics.areEqual(existingChild, child)) {
                    this.removeEntity(existingChild);
                }
                if (parentId != null) {
                    UtilsKt.checkCircularDependency(connectionId, EntityIdKt.getArrayId(childId), EntityIdKt.getArrayId(parentId.unbox-impl()), this);
                    modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToOneParentOfChild(connectionId, childId, parentId.unbox-impl());
                    UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                    break;
                }
                modifications = this.getRefs$intellij_platform_workspace_storage().removeOneToOneRefByChild(connectionId, childId);
                UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                break;
            }
            case 2: {
                ParentEntityId parentId;
                long childId = RefsTableKt.asChild(UtilsKt.asBase(child).getId());
                WorkspaceEntity workspaceEntity = parent;
                ParentEntityId parentEntityId = workspaceEntity != null && (workspaceEntity = UtilsKt.asBase(workspaceEntity)) != null ? ParentEntityId.box-impl(RefsTableKt.asParent(((WorkspaceEntityBase)workspaceEntity).getId())) : (parentId = null);
                if (parentId != null) {
                    UtilsKt.checkCircularDependency(connectionId, EntityIdKt.getArrayId(childId), EntityIdKt.getArrayId(parentId.unbox-impl()), this);
                    List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToManyParentOfChild-b-W3xc0(connectionId, childId, parentId.unbox-impl());
                    UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                    break;
                }
                Modification modification = this.getRefs$intellij_platform_workspace_storage().removeOneToManyRefsByChild-35tkxxE(connectionId, childId);
                if (modification == null) break;
                UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)CollectionsKt.listOf(modification), connectionId);
                break;
            }
            case 3: {
                ParentEntityId parentId;
                long childId = RefsTableKt.asChild(UtilsKt.asBase(child).getId());
                WorkspaceEntity workspaceEntity = parent;
                ParentEntityId parentEntityId = workspaceEntity != null && (workspaceEntity = UtilsKt.asBase(workspaceEntity)) != null ? ParentEntityId.box-impl(RefsTableKt.asParent(((WorkspaceEntityBase)workspaceEntity).getId())) : (parentId = null);
                if (parentId != null) {
                    UtilsKt.checkCircularDependency(childId, parentId.unbox-impl(), this);
                    List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToAbstractManyParentOfChild-bAjmN0I(connectionId, childId, parentId.unbox-impl());
                    UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                    break;
                }
                Modification modification = this.getRefs$intellij_platform_workspace_storage().removeOneToAbstractManyRefsByChild-35tkxxE(connectionId, childId);
                if (modification == null) break;
                UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)CollectionsKt.listOf(modification), connectionId);
                break;
            }
            case 4: {
                WorkspaceEntity existingChild;
                WorkspaceEntity workspaceEntity = parent;
                ParentEntityId parentId = workspaceEntity != null && (workspaceEntity = UtilsKt.asBase(workspaceEntity)) != null ? ParentEntityId.box-impl(RefsTableKt.asParent(((WorkspaceEntityBase)workspaceEntity).getId())) : null;
                long childId = RefsTableKt.asChild(UtilsKt.asBase(child).getId());
                if (!connectionId.isParentNullable() && parentId != null && (existingChild = this.getOneChild(connectionId, parent)) != null && !Intrinsics.areEqual(existingChild, child)) {
                    this.removeEntity(existingChild);
                }
                if (parentId != null) {
                    List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().replaceOneToAbstractOneParentOfChild-bAjmN0I(connectionId, childId, parentId.unbox-impl());
                    UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
                    break;
                }
                Modification modification = this.getRefs$intellij_platform_workspace_storage().removeOneToAbstractOneRefByChild-35tkxxE(connectionId, childId);
                if (modification == null) break;
                UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)CollectionsKt.listOf(modification), connectionId);
            }
        }
    }

    @Override
    public boolean hasChanges() {
        return !this.changeLog.getChangeLog$intellij_platform_workspace_storage().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyChangesFrom(@NotNull MutableEntityStorage builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        AtomicLong arg0$iv = applyChangesFromTimeMs;
        boolean bl2 = false;
        Unit value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            this.lockWrite();
            MutableEntityStorageImpl cfr_ignored_0 = (MutableEntityStorageImpl)builder;
            this.applyChangesFromProtection((AbstractEntityStorage)((Object)builder));
            ApplyChangesFromOperation applyChangesFromOperation = new ApplyChangesFromOperation(this, (MutableEntityStorageImpl)builder);
            Function1<? super ApplyChangesFromOperation, Unit> function1 = this.upgradeApplyChangesFromEngine;
            if (function1 != null) {
                function1.invoke(applyChangesFromOperation);
            }
            applyChangesFromOperation.applyChangesFrom();
        }
        finally {
            this.unlockWrite();
        }
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> MutableExternalEntityMapping<T> getMutableExternalMapping(@NotNull ExternalMappingKey<T> identifier) {
        MutableExternalEntityMappingImpl mutableExternalEntityMappingImpl;
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        AtomicLong arg0$iv = getMutableExternalMappingTimeMs;
        boolean bl2 = false;
        MutableExternalEntityMappingImpl value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            this.lockWrite();
            MutableExternalEntityMappingImpl mutableExternalEntityMappingImpl2 = this.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage().computeIfAbsent(identifier, arg_0 -> MutableEntityStorageImpl.getMutableExternalMapping$lambda$40$lambda$39(getMutableExternalMapping.1.mapping.1.INSTANCE, arg_0));
            Intrinsics.checkNotNull(mutableExternalEntityMappingImpl2, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.external.MutableExternalEntityMappingImpl<T of com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl.getMutableExternalMapping$lambda$40>");
            MutableExternalEntityMappingImpl mapping2 = mutableExternalEntityMappingImpl2;
            mapping2.setTypedEntityStorage$intellij_platform_workspace_storage(this);
            mutableExternalEntityMappingImpl = mapping2;
        }
        finally {
            this.unlockWrite();
        }
        value$iv = mutableExternalEntityMappingImpl;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final MutableVirtualFileUrlIndex getMutableVirtualFileUrlIndex() {
        void var3_3;
        VirtualFileIndex.MutableVirtualFileIndex mutableVirtualFileIndex;
        AtomicLong arg0$iv = getMutableVFUrlIndexTimeMs;
        boolean bl2 = false;
        VirtualFileIndex.MutableVirtualFileIndex value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            this.lockWrite();
            VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex = this.getIndexes$intellij_platform_workspace_storage().getVirtualFileIndex$intellij_platform_workspace_storage();
            virtualFileIndex.setTypedEntityStorage$intellij_platform_workspace_storage(this);
            mutableVirtualFileIndex = virtualFileIndex;
        }
        finally {
            this.unlockWrite();
        }
        value$iv = mutableVirtualFileIndex;
        atomicLong.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return (MutableVirtualFileUrlIndex)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyChangesFromProtection(AbstractEntityStorage builder) {
        Object object;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace2 = false;
        if ($this$trace$iv.isTraceEnabled()) {
            object = $this$trace$iv;
            boolean bl2 = false;
            ((Logger)object).trace("Applying applyChangesFrom. Builder: " + builder);
        }
        if (builder.getStorageIsAlreadyApplied$intellij_platform_workspace_storage()) {
            LOG.error("Builder is already applied.\n Info: \n" + builder.getApplyInfo$intellij_platform_workspace_storage());
        } else {
            builder.setStorageIsAlreadyApplied$intellij_platform_workspace_storage(true);
            if (LOG.isTraceEnabled()) {
                void $this$applyChangesFromProtection_u24lambda_u2443;
                StringBuilder stringBuilder;
                StringBuilder $i$f$trace2 = stringBuilder = new StringBuilder();
                object = builder;
                boolean bl3 = false;
                StringBuilder stringBuilder2 = $this$applyChangesFromProtection_u24lambda_u2443.append("Applying builder using applyChangesFrom. Previous stack trace >>>>");
                Intrinsics.checkNotNullExpressionValue(stringBuilder2, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder2.append('\n'), "append(...)");
                StringBuilder stringBuilder3 = $this$applyChangesFromProtection_u24lambda_u2443.append(ExceptionUtil.currentStackTrace());
                Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append(...)");
                StringBuilder stringBuilder4 = $this$applyChangesFromProtection_u24lambda_u2443.append("<<<<");
                Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append(...)");
                String string2 = stringBuilder.toString();
                Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                ((AbstractEntityStorage)object).setApplyInfo$intellij_platform_workspace_storage(string2);
            }
        }
    }

    public final boolean removeEntityByEntityId$intellij_platform_workspace_storage(long idx, @NotNull Function1<? super Long, Boolean> entityFilter2) {
        Intrinsics.checkNotNullParameter(entityFilter2, "entityFilter");
        Long[] longArray = new Long[]{idx};
        Set<Long> accumulator2 = SetsKt.mutableSetOf(longArray);
        if (!this.getEntitiesByType$intellij_platform_workspace_storage().exists(idx)) {
            return false;
        }
        this.accumulateEntitiesToRemove(idx, accumulator2, entityFilter2);
        Iterable $this$forEach$iv = accumulator2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long id2 = ((Number)element$iv).longValue();
            boolean bl2 = false;
            this.removeSingleEntity$intellij_platform_workspace_storage(id2);
        }
        return true;
    }

    public static /* synthetic */ boolean removeEntityByEntityId$intellij_platform_workspace_storage$default(MutableEntityStorageImpl mutableEntityStorageImpl, long l2, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            function1 = removeEntityByEntityId.1.INSTANCE;
        }
        return mutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage(l2, function1);
    }

    public final void removeSingleEntity$intellij_platform_workspace_storage(long id2) {
        Map<ConnectionId, ParentEntityId> parents2;
        WorkspaceEntityData<WorkspaceEntity> workspaceEntityData = WorkspaceBuilderChangeLogKt.getOriginalEntityData(this, id2);
        Intrinsics.checkNotNull(workspaceEntityData, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<com.intellij.platform.workspace.storage.WorkspaceEntity>");
        WorkspaceEntityData<WorkspaceEntity> originalEntityData = workspaceEntityData;
        Map<ConnectionId, List<ChildEntityId>> children2 = this.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(id2));
        Iterable $this$forEach$iv = children2.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConnectionId connectionId = (ConnectionId)element$iv;
            boolean bl2 = false;
            List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().removeRefsByParent-ePHS_xw(connectionId, RefsTableKt.asParent(id2));
            UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
        }
        Map<ConnectionId, ParentEntityId> $this$forEach$iv2 = parents2 = this.getRefs$intellij_platform_workspace_storage().getParentRefsOfChild-HhnaDKw(RefsTableKt.asChild(id2));
        boolean $i$f$forEach2 = false;
        Iterator<Map.Entry<ConnectionId, ParentEntityId>> iterator2 = $this$forEach$iv2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ConnectionId, ParentEntityId> element$iv;
            Map.Entry<ConnectionId, ParentEntityId> entry = element$iv = iterator2.next();
            boolean bl3 = false;
            ConnectionId connectionId = entry.getKey();
            long parentId = entry.getValue().unbox-impl();
            List<Modification> modifications = this.getRefs$intellij_platform_workspace_storage().removeParentToChildRef-0Hr_qaU(connectionId, parentId, RefsTableKt.asChild(id2));
            UtilsKt.createReplaceEventsForUpdates(this, (Collection<? extends Modification>)modifications, connectionId);
        }
        WorkspaceEntityData<? extends WorkspaceEntity> entityData = this.entityDataByIdOrDie$intellij_platform_workspace_storage(id2);
        if (entityData instanceof SoftLinkable) {
            this.getIndexes$intellij_platform_workspace_storage().removeFromSoftLinksIndex((SoftLinkable)((Object)entityData));
        }
        this.getIndexes$intellij_platform_workspace_storage().entityRemoved(id2);
        this.changeLog.addRemoveEvent$intellij_platform_workspace_storage(id2, originalEntityData);
        this.getEntitiesByType$intellij_platform_workspace_storage().remove(EntityIdKt.getArrayId(id2), EntityIdKt.getClazz(id2));
    }

    private final void lockWrite() {
        Thread currentThread = Thread.currentThread();
        if (this.writingFlag.getAndSet(true) && this.threadId != null) {
            Long l2 = this.threadId;
            long l3 = currentThread.getId();
            if (l2 == null || l2 != l3) {
                LOG.error(StringsKt.trimIndent("\n            Concurrent write to builder from the following threads\n            First Thread: " + this.threadName + "\n            Second Thread: " + currentThread.getName() + "\n            Previous stack trace: " + this.stackTrace + "\n          "));
                this.trackStackTrace = true;
            }
        }
        if (this.trackStackTrace || LOG.isTraceEnabled()) {
            this.stackTrace = ExceptionUtil.currentStackTrace();
        }
        this.threadId = currentThread.getId();
        this.threadName = currentThread.getName();
    }

    private final void unlockWrite() {
        this.writingFlag.set(false);
        this.stackTrace = null;
        this.threadId = null;
        this.threadName = null;
    }

    private final void accumulateEntitiesToRemove(long id2, Set<Long> accumulator2, Function1<? super Long, Boolean> entityFilter2) {
        Map<ConnectionId, List<ChildEntityId>> children2 = this.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(id2));
        Iterator<Map.Entry<ConnectionId, List<ChildEntityId>>> iterator2 = children2.entrySet().iterator();
        while (iterator2.hasNext()) {
            List<ChildEntityId> childrenIds2 = iterator2.next().getValue();
            Iterator<ChildEntityId> iterator3 = childrenIds2.iterator();
            while (iterator3.hasNext()) {
                long childId = iterator3.next().unbox-impl();
                if (accumulator2.contains(childId) || !entityFilter2.invoke((Long)childId).booleanValue()) continue;
                this.accumulateEntitiesToRemove(childId, accumulator2, entityFilter2);
                accumulator2.add(childId);
            }
        }
    }

    private static final MutableExternalEntityMappingImpl getMutableExternalMapping$lambda$40$lambda$39(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (MutableExternalEntityMappingImpl)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MutableEntityStorageImpl.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
        instancesCounter = new AtomicLong();
        getEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        getReferrersTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        resolveTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        getEntitiesBySourceTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        addEntityTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        putEntityTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        modifyEntityTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        removeEntityTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        replaceBySourceTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        collectChangesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        hasSameEntitiesTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        toSnapshotTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        applyChangesFromTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        getMutableExternalMappingTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        getMutableVFUrlIndexTimeMs = MillisecondsMeasurer.constructor-impl$default(null, 1, null);
        MutableEntityStorageImpl.Companion.setupOpenTelemetryReporting(TelemetryManager.Companion.getMeter(PlatformScopesKt.JPS));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u000e\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u0014\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u0015\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u0016\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\u0017\u001a\u00020\u0006X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "addEntityTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "applyChangesFromTimeMs", "collectChangesTimeMs", "getEntitiesBySourceTimeMs", "getEntitiesTimeMs", "getMutableExternalMappingTimeMs", "getMutableVFUrlIndexTimeMs", "getReferrersTimeMs", "hasSameEntitiesTimeMs", "instancesCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "modifyEntityTimeMs", "putEntityTimeMs", "removeEntityTimeMs", "replaceBySourceTimeMs", "resolveTimeMs", "toSnapshotTimeMs", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement instancesCountCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.instances.count").buildObserver();
            ObservableLongMeasurement getEntitiesTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.entities.ms").buildObserver();
            ObservableLongMeasurement getReferrersTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.referrers.ms").buildObserver();
            ObservableLongMeasurement resolveTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.resolve.ms").buildObserver();
            ObservableLongMeasurement getEntitiesBySourceTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.entities.by.source.ms").buildObserver();
            ObservableLongMeasurement addEntityTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.add.entity.ms").buildObserver();
            ObservableLongMeasurement putEntityTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.put.entity.ms").buildObserver();
            ObservableLongMeasurement modifyEntityTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.modify.entity.ms").buildObserver();
            ObservableLongMeasurement removeEntityTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.remove.entity.ms").buildObserver();
            ObservableLongMeasurement replaceBySourceTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.replace.by.source.ms").buildObserver();
            ObservableLongMeasurement collectChangesTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.collect.changes.ms").buildObserver();
            ObservableLongMeasurement hasSameEntitiesTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.has.same.entities.ms").buildObserver();
            ObservableLongMeasurement toSnapshotTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.to.snapshot.ms").buildObserver();
            ObservableLongMeasurement applyChangesFromTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.apply.changes.from.ms").buildObserver();
            ObservableLongMeasurement getMutableExternalMappingTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.mutable.ext.mapping.ms").buildObserver();
            ObservableLongMeasurement getMutableVFUrlIndexTimeCounter = meter.counterBuilder("workspaceModel.mutableEntityStorage.mutable.vfurl.index.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{getEntitiesTimeCounter, getReferrersTimeCounter, resolveTimeCounter, getEntitiesBySourceTimeCounter, addEntityTimeCounter, putEntityTimeCounter, modifyEntityTimeCounter, removeEntityTimeCounter, replaceBySourceTimeCounter, collectChangesTimeCounter, hasSameEntitiesTimeCounter, toSnapshotTimeCounter, applyChangesFromTimeCounter, getMutableExternalMappingTimeCounter, getMutableVFUrlIndexTimeCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(instancesCountCounter, getEntitiesTimeCounter, getReferrersTimeCounter, resolveTimeCounter, getEntitiesBySourceTimeCounter, addEntityTimeCounter, putEntityTimeCounter, modifyEntityTimeCounter, removeEntityTimeCounter, replaceBySourceTimeCounter, collectChangesTimeCounter, hasSameEntitiesTimeCounter, toSnapshotTimeCounter, applyChangesFromTimeCounter, getMutableExternalMappingTimeCounter, getMutableVFUrlIndexTimeCounter), instancesCountCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $instancesCountCounter, ObservableLongMeasurement $getEntitiesTimeCounter, ObservableLongMeasurement $getReferrersTimeCounter, ObservableLongMeasurement $resolveTimeCounter, ObservableLongMeasurement $getEntitiesBySourceTimeCounter, ObservableLongMeasurement $addEntityTimeCounter, ObservableLongMeasurement $putEntityTimeCounter, ObservableLongMeasurement $modifyEntityTimeCounter, ObservableLongMeasurement $removeEntityTimeCounter, ObservableLongMeasurement $replaceBySourceTimeCounter, ObservableLongMeasurement $collectChangesTimeCounter, ObservableLongMeasurement $hasSameEntitiesTimeCounter, ObservableLongMeasurement $toSnapshotTimeCounter, ObservableLongMeasurement $applyChangesFromTimeCounter, ObservableLongMeasurement $getMutableExternalMappingTimeCounter, ObservableLongMeasurement $getMutableVFUrlIndexTimeCounter) {
            $instancesCountCounter.record(instancesCounter.get());
            $getEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getEntitiesTimeMs));
            $getReferrersTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getReferrersTimeMs));
            $resolveTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(resolveTimeMs));
            $getEntitiesBySourceTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getEntitiesBySourceTimeMs));
            $addEntityTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(addEntityTimeMs));
            $putEntityTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(putEntityTimeMs));
            $modifyEntityTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(modifyEntityTimeMs));
            $removeEntityTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(removeEntityTimeMs));
            $replaceBySourceTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(replaceBySourceTimeMs));
            $collectChangesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(collectChangesTimeMs));
            $hasSameEntitiesTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(hasSameEntitiesTimeMs));
            $toSnapshotTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(toSnapshotTimeMs));
            $applyChangesFromTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(applyChangesFromTimeMs));
            $getMutableExternalMappingTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getMutableExternalMappingTimeMs));
            $getMutableVFUrlIndexTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl(getMutableVFUrlIndexTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConnectionId.ConnectionType.values().length];
            try {
                nArray[ConnectionId.ConnectionType.ONE_TO_ONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionId.ConnectionType.ONE_TO_MANY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionId.ConnectionType.ONE_TO_ABSTRACT_MANY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConnectionId.ConnectionType.ABSTRACT_ONE_TO_ONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

