/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.google.common.collect.HashBiMap;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.EntitiesKt;
import com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.NotThisEntityId;
import com.intellij.platform.workspace.storage.impl.SoftLinkable;
import com.intellij.platform.workspace.storage.impl.StorageIndexes;
import com.intellij.platform.workspace.storage.impl.ThisEntityId;
import com.intellij.platform.workspace.storage.impl.WorkspaceBuilderChangeLog;
import com.intellij.platform.workspace.storage.impl.WorkspaceBuilderChangeLogKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.external.ExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.external.MutableExternalEntityMappingImpl;
import com.intellij.platform.workspace.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.MultimapStorageIndex;
import com.intellij.platform.workspace.storage.impl.indices.SymbolicIdInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndex;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u001a\u0010\u000b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\"\u001a\u00020\u001dJ\u001e\u0010#\u001a\u00020\u001b\"\b\b\u0000\u0010$*\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'J\u0012\u0010(\u001a\u00020\u001b2\n\u0010)\u001a\u00060*j\u0002`+J\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.J2\u0010/\u001a\u00020\u001b\"\b\b\u0000\u0010$*\u00020%2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H$0'2\u0010\u00101\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u000102H\u0002J\u0006\u00103\u001a\u00020\u0001J(\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001d2\n\u00106\u001a\u0006\u0012\u0002\b\u0003072\n\u00108\u001a\u0006\u0012\u0002\b\u000307H\u0002J&\u00109\u001a\u00020\u001b2\n\u0010:\u001a\u00060*j\u0002`+2\n\u0010;\u001a\u00060*j\u0002`+2\u0006\u0010<\u001a\u00020\u0001J&\u0010=\u001a\u00020\u001b2\n\u0010>\u001a\u00060*j\u0002`+2\n\u0010?\u001a\u0006\u0012\u0002\b\u00030'2\u0006\u00105\u001a\u00020@J\u000e\u0010A\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.JP\u0010B\u001a\u00020\u001b\"\b\b\u0000\u0010$*\u00020%2\u0006\u00105\u001a\u00020\u001d2\u0006\u0010C\u001a\u00020%2\f\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u0001072\f\u00100\u001a\b\u0012\u0004\u0012\u0002H$0'2\u0012\b\u0002\u00101\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u000102R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R(\u0010\u000b\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0002\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\t\u001a\u00020\nX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006D"}, d2={"Lcom/intellij/platform/workspace/storage/impl/MutableStorageIndexes;", "Lcom/intellij/platform/workspace/storage/impl/StorageIndexes;", "softLinks", "Lcom/intellij/platform/workspace/storage/impl/indices/MultimapStorageIndex$MutableMultimapStorageIndex;", "virtualFileIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "entitySourceIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "symbolicIdIndex", "Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex$MutableSymbolicIdInternalIndex;", "externalMappings", "", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "Lcom/intellij/platform/workspace/storage/impl/external/MutableExternalEntityMappingImpl;", "(Lcom/intellij/platform/workspace/storage/impl/indices/MultimapStorageIndex$MutableMultimapStorageIndex;Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex$MutableSymbolicIdInternalIndex;Ljava/util/Map;)V", "getEntitySourceIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/EntityStorageInternalIndex$MutableEntityStorageInternalIndex;", "getExternalMappings$intellij_platform_workspace_storage", "()Ljava/util/Map;", "getSoftLinks$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/MultimapStorageIndex$MutableMultimapStorageIndex;", "getSymbolicIdIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/SymbolicIdInternalIndex$MutableSymbolicIdInternalIndex;", "getVirtualFileIndex$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "applyExternalMappingChanges", "", "diff", "Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;", "replaceMap", "Lcom/google/common/collect/HashBiMap;", "Lcom/intellij/platform/workspace/storage/impl/NotThisEntityId;", "Lcom/intellij/platform/workspace/storage/impl/ThisEntityId;", "target", "entityAdded", "T", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityData", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "entityRemoved", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "removeFromSoftLinksIndex", "softLinkable", "Lcom/intellij/platform/workspace/storage/impl/SoftLinkable;", "simpleUpdateSoftReferences", "copiedData", "modifiableEntity", "Lcom/intellij/platform/workspace/storage/impl/ModifiableWorkspaceEntityBase;", "toImmutable", "updateComposedIds", "builder", "beforeSymbolicId", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "newSymbolicId", "updateExternalMappingForEntityId", "replaceWithEntityId", "targetEntityId", "replaceWithIndexes", "updateIndices", "oldEntityId", "newEntityData", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "updateSoftLinksIndex", "updateSymbolicIdIndexes", "updatedEntity", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nStorageIndexes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/platform/workspace/storage/impl/MutableStorageIndexes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,288:1\n1#2:289\n1855#3,2:290\n1313#4,2:292\n215#5,2:294\n215#5,2:296\n*S KotlinDebug\n*F\n+ 1 StorageIndexes.kt\ncom/intellij/platform/workspace/storage/impl/MutableStorageIndexes\n*L\n180#1:290,2\n215#1:292,2\n219#1:294,2\n232#1:296,2\n*E\n"})
public final class MutableStorageIndexes
extends StorageIndexes {
    @NotNull
    private final MultimapStorageIndex.MutableMultimapStorageIndex softLinks;
    @NotNull
    private final VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex;
    @NotNull
    private final EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> entitySourceIndex;
    @NotNull
    private final SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex symbolicIdIndex;
    @NotNull
    private final Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> externalMappings;

    public MutableStorageIndexes(@NotNull MultimapStorageIndex.MutableMultimapStorageIndex softLinks, @NotNull VirtualFileIndex.MutableVirtualFileIndex virtualFileIndex, @NotNull EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> entitySourceIndex, @NotNull SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex symbolicIdIndex, @NotNull Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> externalMappings) {
        Intrinsics.checkNotNullParameter(softLinks, "softLinks");
        Intrinsics.checkNotNullParameter(virtualFileIndex, "virtualFileIndex");
        Intrinsics.checkNotNullParameter(entitySourceIndex, "entitySourceIndex");
        Intrinsics.checkNotNullParameter(symbolicIdIndex, "symbolicIdIndex");
        Intrinsics.checkNotNullParameter(externalMappings, "externalMappings");
        super(softLinks, virtualFileIndex, (EntityStorageInternalIndex<EntitySource>)entitySourceIndex, symbolicIdIndex, externalMappings);
        this.softLinks = softLinks;
        this.virtualFileIndex = virtualFileIndex;
        this.entitySourceIndex = entitySourceIndex;
        this.symbolicIdIndex = symbolicIdIndex;
        this.externalMappings = externalMappings;
    }

    @Override
    @NotNull
    public MultimapStorageIndex.MutableMultimapStorageIndex getSoftLinks$intellij_platform_workspace_storage() {
        return this.softLinks;
    }

    @Override
    @NotNull
    public VirtualFileIndex.MutableVirtualFileIndex getVirtualFileIndex$intellij_platform_workspace_storage() {
        return this.virtualFileIndex;
    }

    @NotNull
    public EntityStorageInternalIndex.MutableEntityStorageInternalIndex<EntitySource> getEntitySourceIndex$intellij_platform_workspace_storage() {
        return this.entitySourceIndex;
    }

    @Override
    @NotNull
    public SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex getSymbolicIdIndex$intellij_platform_workspace_storage() {
        return this.symbolicIdIndex;
    }

    @NotNull
    public Map<ExternalMappingKey<?>, MutableExternalEntityMappingImpl<?>> getExternalMappings$intellij_platform_workspace_storage() {
        return this.externalMappings;
    }

    public final <T extends WorkspaceEntity> void entityAdded(@NotNull WorkspaceEntityData<T> entityData) {
        block2: {
            Intrinsics.checkNotNullParameter(entityData, "entityData");
            long pid = entityData.createEntityId();
            if (entityData instanceof SoftLinkable) {
                ((SoftLinkable)((Object)entityData)).index(this.getSoftLinks$intellij_platform_workspace_storage());
            }
            EntitySource entitySource = entityData.getEntitySource();
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspace_storage()).index$intellij_platform_workspace_storage(pid, entitySource);
            SymbolicEntityId<?> symbolicEntityId = EntitiesKt.symbolicId(entityData);
            if (symbolicEntityId != null) {
                SymbolicEntityId<?> symbolicId = symbolicEntityId;
                boolean bl2 = false;
                this.getSymbolicIdIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(pid, symbolicId);
            }
            VirtualFileUrl virtualFileUrl = entitySource.getVirtualFileUrl();
            if (virtualFileUrl == null) break block2;
            VirtualFileUrl it = virtualFileUrl;
            boolean bl3 = false;
            this.getVirtualFileIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(pid, "entitySource", it);
        }
    }

    public final void entityRemoved(long entityId) {
        EntityStorageInternalIndex.MutableEntityStorageInternalIndex.index$intellij_platform_workspace_storage$default((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspace_storage(), entityId, null, 2, null);
        SymbolicIdInternalIndex.MutableSymbolicIdInternalIndex.index$intellij_platform_workspace_storage$default(this.getSymbolicIdIndex$intellij_platform_workspace_storage(), entityId, null, 2, null);
        this.getVirtualFileIndex$intellij_platform_workspace_storage().removeRecordsByEntityId$intellij_platform_workspace_storage(entityId);
        Iterable $this$forEach$iv = this.getExternalMappings$intellij_platform_workspace_storage().values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MutableExternalEntityMappingImpl it = (MutableExternalEntityMappingImpl)element$iv;
            boolean bl2 = false;
            it.remove$intellij_platform_workspace_storage(entityId);
        }
    }

    public final void updateSoftLinksIndex(@NotNull SoftLinkable softLinkable) {
        Intrinsics.checkNotNullParameter(softLinkable, "softLinkable");
        softLinkable.index(this.getSoftLinks$intellij_platform_workspace_storage());
    }

    public final void removeFromSoftLinksIndex(@NotNull SoftLinkable softLinkable) {
        Intrinsics.checkNotNullParameter(softLinkable, "softLinkable");
        long pid = ((WorkspaceEntityData)((Object)softLinkable)).createEntityId();
        for (SymbolicEntityId<?> link : softLinkable.getLinks()) {
            this.getSoftLinks$intellij_platform_workspace_storage().remove$intellij_platform_workspace_storage(pid, link);
        }
    }

    public final void updateIndices(long oldEntityId, @NotNull WorkspaceEntityData<?> newEntityData, @NotNull AbstractEntityStorage builder) {
        block0: {
            SymbolicEntityId<?> symbolicEntityId;
            Intrinsics.checkNotNullParameter(newEntityData, "newEntityData");
            Intrinsics.checkNotNullParameter(builder, "builder");
            long newEntityId = newEntityData.createEntityId();
            this.getVirtualFileIndex$intellij_platform_workspace_storage().updateIndex$intellij_platform_workspace_storage(oldEntityId, newEntityId, builder.getIndexes$intellij_platform_workspace_storage().getVirtualFileIndex$intellij_platform_workspace_storage());
            ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspace_storage()).index$intellij_platform_workspace_storage(newEntityId, newEntityData.getEntitySource());
            SymbolicEntityId<?> symbolicEntityId2 = builder.getIndexes$intellij_platform_workspace_storage().getSymbolicIdIndex$intellij_platform_workspace_storage().getEntryById$intellij_platform_workspace_storage(oldEntityId);
            if (symbolicEntityId2 == null) break block0;
            SymbolicEntityId<?> it = symbolicEntityId = symbolicEntityId2;
            boolean bl2 = false;
            this.getSymbolicIdIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(newEntityId, it);
        }
    }

    private final <T extends WorkspaceEntity> void simpleUpdateSoftReferences(WorkspaceEntityData<T> copiedData, ModifiableWorkspaceEntityBase<?, ?> modifiableEntity) {
        long pid = copiedData.createEntityId();
        if (copiedData instanceof SoftLinkable) {
            ((SoftLinkable)((Object)copiedData)).updateLinksIndex(this.getSoftLinks$intellij_platform_workspace_storage().getEntriesById$intellij_platform_workspace_storage(pid), this.getSoftLinks$intellij_platform_workspace_storage());
        }
    }

    public final void applyExternalMappingChanges(@NotNull MutableEntityStorageImpl diff, @NotNull HashBiMap<NotThisEntityId, ThisEntityId> replaceMap, @NotNull MutableEntityStorageImpl target) {
        Object element$iv;
        Intrinsics.checkNotNullParameter(diff, "diff");
        Intrinsics.checkNotNullParameter(replaceMap, "replaceMap");
        Intrinsics.checkNotNullParameter(target, "target");
        Object $this$forEach$iv = SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)diff.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage().keySet()), new Function1<ExternalMappingKey<?>, Boolean>(this){
            final /* synthetic */ MutableStorageIndexes this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ExternalMappingKey<?> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return this.this$0.getExternalMappings$intellij_platform_workspace_storage().keySet().contains(it);
            }
        });
        boolean $i$f$forEach = false;
        Iterator<Object> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            ExternalMappingKey it = (ExternalMappingKey)element$iv;
            boolean bl2 = false;
            this.getExternalMappings$intellij_platform_workspace_storage().put(it, new MutableExternalEntityMappingImpl());
        }
        $this$forEach$iv = diff.getIndexes$intellij_platform_workspace_storage().getExternalMappings$intellij_platform_workspace_storage();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object = element$iv = (Map.Entry)iterator2.next();
            boolean bl3 = false;
            ExternalMappingKey identifier = (ExternalMappingKey)object.getKey();
            MutableExternalEntityMappingImpl index2 = (MutableExternalEntityMappingImpl)object.getValue();
            MutableExternalEntityMappingImpl<?> mapping2 = this.getExternalMappings$intellij_platform_workspace_storage().get(identifier);
            if (mapping2 == null) continue;
            mapping2.applyChanges(index2, replaceMap, target);
            if (!mapping2.getIndex$intellij_platform_workspace_storage().isEmpty()) continue;
            this.getExternalMappings$intellij_platform_workspace_storage().remove(identifier);
        }
    }

    public final void updateExternalMappingForEntityId(long replaceWithEntityId, long targetEntityId, @NotNull StorageIndexes replaceWithIndexes) {
        Intrinsics.checkNotNullParameter(replaceWithIndexes, "replaceWithIndexes");
        Map<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> $this$forEach$iv = replaceWithIndexes.getExternalMappings$intellij_platform_workspace_storage();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object data;
            Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> element$iv;
            Map.Entry<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            ExternalMappingKey<?> mappingId = entry.getKey();
            ExternalEntityMappingImpl<?> mapping2 = entry.getValue();
            if (mapping2.getIndex$intellij_platform_workspace_storage().get(replaceWithEntityId) == null) continue;
            MutableExternalEntityMappingImpl<?> externalMapping = this.getExternalMappings$intellij_platform_workspace_storage().get(mappingId);
            if (externalMapping == null) {
                MutableExternalEntityMappingImpl newMapping = new MutableExternalEntityMappingImpl();
                newMapping.add$intellij_platform_workspace_storage(targetEntityId, data);
                this.getExternalMappings$intellij_platform_workspace_storage().put(mappingId, newMapping);
                continue;
            }
            externalMapping.add$intellij_platform_workspace_storage(targetEntityId, data);
        }
    }

    public final <T extends WorkspaceEntity> void updateSymbolicIdIndexes(@NotNull MutableEntityStorageImpl builder, @NotNull WorkspaceEntity updatedEntity, @Nullable SymbolicEntityId<?> beforeSymbolicId, @NotNull WorkspaceEntityData<T> copiedData, @Nullable ModifiableWorkspaceEntityBase<?, ?> modifiableEntity) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(updatedEntity, "updatedEntity");
        Intrinsics.checkNotNullParameter(copiedData, "copiedData");
        long entityId = ((WorkspaceEntityBase)updatedEntity).getId();
        if (updatedEntity instanceof WorkspaceEntityWithSymbolicId) {
            SymbolicEntityId<WorkspaceEntityWithSymbolicId> newSymbolicId = ((WorkspaceEntityWithSymbolicId)updatedEntity).getSymbolicId();
            if (beforeSymbolicId != null && !Intrinsics.areEqual(beforeSymbolicId, newSymbolicId)) {
                this.getSymbolicIdIndex$intellij_platform_workspace_storage().index$intellij_platform_workspace_storage(entityId, newSymbolicId);
                this.updateComposedIds(builder, beforeSymbolicId, newSymbolicId);
            }
        }
        this.simpleUpdateSoftReferences(copiedData, modifiableEntity);
    }

    public static /* synthetic */ void updateSymbolicIdIndexes$default(MutableStorageIndexes mutableStorageIndexes, MutableEntityStorageImpl mutableEntityStorageImpl, WorkspaceEntity workspaceEntity, SymbolicEntityId symbolicEntityId, WorkspaceEntityData workspaceEntityData, ModifiableWorkspaceEntityBase modifiableWorkspaceEntityBase, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            modifiableWorkspaceEntityBase = null;
        }
        mutableStorageIndexes.updateSymbolicIdIndexes(mutableEntityStorageImpl, workspaceEntity, symbolicEntityId, workspaceEntityData, modifiableWorkspaceEntityBase);
    }

    private final void updateComposedIds(MutableEntityStorageImpl builder, SymbolicEntityId<?> beforeSymbolicId, SymbolicEntityId<?> newSymbolicId) {
        HashSet idsWithSoftRef = new HashSet(this.getSoftLinks$intellij_platform_workspace_storage().getIdsByEntry$intellij_platform_workspace_storage(beforeSymbolicId));
        for (Long entityId : idsWithSoftRef) {
            WorkspaceEntityData<?> originalEntityData;
            WorkspaceEntityData<?> entity;
            Intrinsics.checkNotNull(entityId);
            Intrinsics.checkNotNull(WorkspaceBuilderChangeLogKt.getOriginalEntityData(builder, entityId), "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<com.intellij.platform.workspace.storage.WorkspaceEntity>");
            Intrinsics.checkNotNull(builder.getEntitiesByType$intellij_platform_workspace_storage().getEntityDataForModification(entityId), "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<com.intellij.platform.workspace.storage.WorkspaceEntity>");
            SymbolicEntityId<?> editingBeforeSymbolicId = EntitiesKt.symbolicId(entity);
            ((SoftLinkable)((Object)entity)).updateLink(beforeSymbolicId, newSymbolicId);
            WorkspaceBuilderChangeLog.addReplaceDataEvent$intellij_platform_workspace_storage$default(builder.getChangeLog$intellij_platform_workspace_storage(), entityId, entity, originalEntityData, false, 8, null);
            MutableStorageIndexes.updateSymbolicIdIndexes$default(builder.getIndexes$intellij_platform_workspace_storage(), builder, entity.createEntity(builder), editingBeforeSymbolicId, entity, null, 16, null);
        }
    }

    @NotNull
    public final StorageIndexes toImmutable() {
        MultimapStorageIndex copiedLinks = this.getSoftLinks$intellij_platform_workspace_storage().toImmutable();
        VirtualFileIndex newVirtualFileIndex = this.getVirtualFileIndex$intellij_platform_workspace_storage().toImmutable();
        EntityStorageInternalIndex<EntitySource> newEntitySourceIndex = ((EntityStorageInternalIndex.MutableEntityStorageInternalIndex)this.getEntitySourceIndex$intellij_platform_workspace_storage()).toImmutable();
        SymbolicIdInternalIndex newSymbolicIdIndex = this.getSymbolicIdIndex$intellij_platform_workspace_storage().toImmutable();
        Map<ExternalMappingKey<?>, ExternalEntityMappingImpl<?>> newExternalMappings = MutableExternalEntityMappingImpl.Companion.toImmutable(this.getExternalMappings$intellij_platform_workspace_storage());
        return new StorageIndexes(copiedLinks, newVirtualFileIndex, newEntitySourceIndex, newSymbolicIdIndex, newExternalMappings);
    }
}

