/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.google.common.collect.HashBiMap;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.DummyParentEntitySource;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.AddElement;
import com.intellij.platform.workspace.storage.impl.ChildEntityId;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.ConnectionId;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.MutableStorageIndexes;
import com.intellij.platform.workspace.storage.impl.ParentsRef;
import com.intellij.platform.workspace.storage.impl.RefsTableKt;
import com.intellij.platform.workspace.storage.impl.RelabelElement;
import com.intellij.platform.workspace.storage.impl.RemoveElement;
import com.intellij.platform.workspace.storage.impl.ReplaceBySourceAsTree;
import com.intellij.platform.workspace.storage.impl.ReplaceBySourceAsTreeKt;
import com.intellij.platform.workspace.storage.impl.ReplaceState;
import com.intellij.platform.workspace.storage.impl.ReplaceWithState;
import com.intellij.platform.workspace.storage.impl.TrackToParents;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.instrumentation.Modification;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b#\b\u0000\u0018\u0000 ^2\u00020\u0001:\u0004^_`aB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u00109\u001a\u00020:2\u000e\u0010;\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010<2\n\u0010=\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010>\u001a\u00020?H\u0002J\"\u0010@\u001a\b\u0012\u0004\u0012\u00020\"0!2\n\u0010A\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010B\u001a\u00020%H\u0002JK\u0010C\u001a(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c0\u001e0\u001bj\u0002`\u001f2\u000e\u0010A\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u00182\u0006\u0010B\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010DJB\u0010E\u001a(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c0\u001e0\u001bj\u0002`\u001f2\n\u0010A\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010B\u001a\u00020%H\u0002J)\u0010F\u001a\u00020:2\n\u0010G\u001a\u00060\u0017j\u0002`\u00182\u000e\u0010H\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018H\u0002\u00a2\u0006\u0002\u0010IJH\u0010J\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001d\u0018\u00010\u001c2\u000e\u0010K\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c2\n\u0010L\u001a\u00060\u0017j\u0002`\u00182\u0006\u0010B\u001a\u00020%2\u0010\u0010M\u001a\f\u0012\b\u0012\u00060\u0017j\u0002`\u00180<H\u0002J1\u0010N\u001a\u00020:2\n\u0010G\u001a\u00060\u0017j\u0002`\u00182\u000e\u0010H\u001a\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u00182\u0006\u0010>\u001a\u00020?H\u0002\u00a2\u0006\u0002\u0010OJ*\u0010P\u001a\u00020:2\u0006\u00107\u001a\u0002082\u0006\u0010+\u001a\u00020,2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tJ8\u0010Q\u001a\u00020:2\n\u0010G\u001a\u00060\u0017j\u0002`\u00182\n\u0010H\u001a\u00060\u0017j\u0002`\u00182\u000e\u0010R\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010<2\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010S\u001a\u00020:*\u00060\u0017j\u0002`\u00182\u0006\u0010T\u001a\u000205H\u0002J\u0018\u0010S\u001a\u00020:*\u00060\u0017j\u0002`\u00182\u0006\u0010T\u001a\u00020(H\u0002J\u0018\u0010U\u001a\u00020:\"\u0004\b\u0000\u0010V*\b\u0012\u0004\u0012\u0002HV0\u001eH\u0002J\u001e\u0010W\u001a\b\u0012\u0004\u0012\u0002HV0!\"\u0004\b\u0000\u0010V*\b\u0012\u0004\u0012\u0002HV0!H\u0002J3\u0010X\u001a\u0004\u0018\u0001HY\"\u0004\b\u0000\u0010Y*\b\u0012\u0004\u0012\u0002HY0\u001e2\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u0002HY\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u00a2\u0006\u0002\u0010[J^\u0010\\\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001d\u0018\u00010\u001c*(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c0\u001e0\u001bj\u0002`\u001f2\u000e\u0010]\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c2\u0010\u0010M\u001a\f\u0012\b\u0012\u00060\u0017j\u0002`\u00180<H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0007RP\u0010\u0015\u001aD\u0012\b\u0012\u00060\u0017j\u0002`\u0018\u00126\u00124\u0012\u0004\u0012\u00020\u001a\u0012*\u0012(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c0\u001e0\u001bj\u0002`\u001f0\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010 \u001a$\u0012\b\u0012\u00060\u0017j\u0002`\u0018\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010#\u001aH\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0018\u00010\u0017j\u0004\u0018\u0001`\u0018\u0012\u0004\u0012\u00020%0$\u0012*\u0012(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c0\u001e0\u001bj\u0002`\u001f0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010.\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u0017@AX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102RP\u00103\u001aD\u0012\b\u0012\u00060\u0017j\u0002`\u0018\u00126\u00124\u0012\u0004\u0012\u00020\u001a\u0012*\u0012(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\u001c0\u001e0\u001bj\u0002`\u001f0\u00190\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\b\u0012\u0004\u0012\u0002050'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010*R\u000e\u00107\u001a\u000208X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;", "", "()V", "addOperations", "Ljava/util/ArrayList;", "Lcom/intellij/platform/workspace/storage/impl/AddElement;", "getAddOperations$intellij_platform_workspace_storage", "()Ljava/util/ArrayList;", "entityFilter", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/EntitySource;", "", "listOfParentsWithPotentiallyBrokenChildrenOrder", "Ljava/util/HashSet;", "Lcom/intellij/platform/workspace/storage/impl/ParentsRef;", "removeOperations", "Lcom/intellij/platform/workspace/storage/impl/RemoveElement;", "getRemoveOperations$intellij_platform_workspace_storage", "replaceOperations", "Lcom/intellij/platform/workspace/storage/impl/RelabelElement;", "getReplaceOperations$intellij_platform_workspace_storage", "replaceWithChildrenEntityDataCache", "Ljava/util/HashMap;", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "", "Lcom/intellij/platform/workspace/storage/impl/ConnectionId;", "", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityDataCustomCollection;", "replaceWithChildrenEntityIdCache", "", "Lcom/intellij/platform/workspace/storage/impl/ChildEntityId;", "replaceWithParentToChildrenCache", "Lkotlin/Pair;", "", "replaceWithState", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/intellij/platform/workspace/storage/impl/ReplaceWithState;", "getReplaceWithState$intellij_platform_workspace_storage", "()Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "replaceWithStorage", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "<set-?>", "shuffleEntities", "getShuffleEntities$intellij_platform_workspace_storage", "()J", "setShuffleEntities$intellij_platform_workspace_storage", "(J)V", "targetChildrenEntityDataCache", "targetState", "Lcom/intellij/platform/workspace/storage/impl/ReplaceState;", "getTargetState$intellij_platform_workspace_storage", "targetStorage", "Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;", "addElementOperation", "", "targetParentEntity", "", "replaceWithEntity", "debugMsg", "", "childrenInReplaceForOrdering", "entityId", "childClazz", "childrenInReplaceWith", "(Ljava/lang/Long;I)Ljava/util/Map;", "childrenInTarget", "doNothingOn", "targetEntityId", "replaceWithEntityId", "(JLjava/lang/Long;)V", "findEntityInTargetStore", "replaceWithEntityData", "targetParentEntityId", "exceptTargetIds", "removeWorkspaceData", "(JLjava/lang/Long;Ljava/lang/String;)V", "replace", "replaceWorkspaceData", "parents", "addState", "state", "maybeShuffle", "E", "maybeShuffled", "removeFirst", "T", "predicate", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "removeSome", "entityData", "Companion", "OperationsApplier", "ReplaceWithProcessor", "TargetProcessor", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nReplaceBySourceAsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1013:1\n53#2,4:1014\n11#2:1026\n1#3:1018\n350#4,7:1019\n*S KotlinDebug\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree\n*L\n109#1:1014,4\n840#1:1026\n817#1:1019,7\n*E\n"})
public final class ReplaceBySourceAsTree {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private MutableEntityStorageImpl targetStorage;
    private AbstractEntityStorage replaceWithStorage;
    private Function1<? super EntitySource, Boolean> entityFilter;
    @NotNull
    private final ArrayList<RelabelElement> replaceOperations = new ArrayList();
    @NotNull
    private final ArrayList<RemoveElement> removeOperations = new ArrayList();
    @NotNull
    private final ArrayList<AddElement> addOperations = new ArrayList();
    @NotNull
    private final Long2ObjectOpenHashMap<ReplaceState> targetState = new Long2ObjectOpenHashMap();
    @NotNull
    private final Long2ObjectOpenHashMap<ReplaceWithState> replaceWithState = new Long2ObjectOpenHashMap();
    @NotNull
    private final HashSet<ParentsRef> listOfParentsWithPotentiallyBrokenChildrenOrder = new HashSet();
    private long shuffleEntities = -1L;
    @NotNull
    private final HashMap<Pair<Long, Integer>, Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>>> replaceWithParentToChildrenCache = new HashMap();
    @NotNull
    private final HashMap<Long, Map<ConnectionId, Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>>>> targetChildrenEntityDataCache = new HashMap();
    @NotNull
    private final HashMap<Long, Map<ConnectionId, Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>>>> replaceWithChildrenEntityDataCache = new HashMap();
    @NotNull
    private final HashMap<Long, Map<ConnectionId, List<ChildEntityId>>> replaceWithChildrenEntityIdCache = new HashMap();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Companion.hashingStrategy.1 hashingStrategy;

    @NotNull
    public final ArrayList<RelabelElement> getReplaceOperations$intellij_platform_workspace_storage() {
        return this.replaceOperations;
    }

    @NotNull
    public final ArrayList<RemoveElement> getRemoveOperations$intellij_platform_workspace_storage() {
        return this.removeOperations;
    }

    @NotNull
    public final ArrayList<AddElement> getAddOperations$intellij_platform_workspace_storage() {
        return this.addOperations;
    }

    @NotNull
    public final Long2ObjectOpenHashMap<ReplaceState> getTargetState$intellij_platform_workspace_storage() {
        return this.targetState;
    }

    @NotNull
    public final Long2ObjectOpenHashMap<ReplaceWithState> getReplaceWithState$intellij_platform_workspace_storage() {
        return this.replaceWithState;
    }

    public final long getShuffleEntities$intellij_platform_workspace_storage() {
        return this.shuffleEntities;
    }

    @TestOnly
    public final void setShuffleEntities$intellij_platform_workspace_storage(long l2) {
        this.shuffleEntities = l2;
    }

    public final void replace(@NotNull MutableEntityStorageImpl targetStorage, @NotNull AbstractEntityStorage replaceWithStorage, @NotNull Function1<? super EntitySource, Boolean> entityFilter2) {
        Intrinsics.checkNotNullParameter(targetStorage, "targetStorage");
        Intrinsics.checkNotNullParameter(replaceWithStorage, "replaceWithStorage");
        Intrinsics.checkNotNullParameter(entityFilter2, "entityFilter");
        this.targetStorage = targetStorage;
        this.replaceWithStorage = replaceWithStorage;
        this.entityFilter = entityFilter2;
        List<WorkspaceEntity> targetEntitiesToReplace = SequencesKt.toList(targetStorage.entitiesBySource(entityFilter2));
        List<WorkspaceEntity> targetEntities = this.maybeShuffled(targetEntitiesToReplace);
        for (WorkspaceEntity targetEntityToReplace : targetEntities) {
            new TargetProcessor().processEntity(targetEntityToReplace);
        }
        Sequence<WorkspaceEntity> replaceWithEntitiesToReplace = replaceWithStorage.entitiesBySource(entityFilter2);
        List<WorkspaceEntity> replaceWithEntities = this.maybeShuffled(SequencesKt.toList(replaceWithEntitiesToReplace));
        for (WorkspaceEntity replaceWithEntityToReplace : replaceWithEntities) {
            new ReplaceWithProcessor().processEntity(replaceWithEntityToReplace);
        }
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace(new OperationsApplier().dumpOperations());
        }
        new OperationsApplier().apply();
    }

    private final void addElementOperation(Set<? extends ParentsRef> targetParentEntity, long replaceWithEntity, String debugMsg) {
        Set<? extends ParentsRef> set = targetParentEntity;
        if (set != null) {
            Set<? extends ParentsRef> it = set;
            boolean bl2 = false;
            CollectionsKt.addAll((Collection)this.listOfParentsWithPotentiallyBrokenChildrenOrder, (Iterable)it);
        }
        ((Collection)this.addOperations).add(new AddElement(targetParentEntity, replaceWithEntity, debugMsg));
        this.addState(replaceWithEntity, ReplaceWithState.ElementMoved.INSTANCE);
    }

    private final void replaceWorkspaceData(long targetEntityId, long replaceWithEntityId, Set<? extends ParentsRef> parents2, String debugMsg) {
        Set<? extends ParentsRef> set = parents2;
        if (set != null) {
            Set<? extends ParentsRef> it = set;
            boolean bl2 = false;
            CollectionsKt.addAll((Collection)this.listOfParentsWithPotentiallyBrokenChildrenOrder, (Iterable)it);
        }
        this.replaceOperations.add(new RelabelElement(targetEntityId, replaceWithEntityId, parents2, debugMsg));
        this.addState(targetEntityId, new ReplaceState.Relabel(replaceWithEntityId, parents2));
        this.addState(replaceWithEntityId, new ReplaceWithState.Relabel(targetEntityId));
    }

    private final void removeWorkspaceData(long targetEntityId, Long replaceWithEntityId, String debugMsg) {
        block0: {
            this.removeOperations.add(new RemoveElement(targetEntityId, debugMsg));
            this.addState(targetEntityId, ReplaceState.Remove.INSTANCE);
            Long l2 = replaceWithEntityId;
            if (l2 == null) break block0;
            this.addState((long)l2, ReplaceWithState.NoChangeTraceLost.INSTANCE);
        }
    }

    private final void doNothingOn(long targetEntityId, Long replaceWithEntityId) {
        block0: {
            this.addState(targetEntityId, new ReplaceState.NoChange(replaceWithEntityId));
            Long l2 = replaceWithEntityId;
            if (l2 == null) break block0;
            this.addState((long)l2, new ReplaceWithState.NoChange(targetEntityId));
        }
    }

    private final void addState(long $this$addState, ReplaceState state) {
        ReplaceState currentState = this.targetState.get($this$addState);
        if (!(currentState == null)) {
            boolean bl2 = false;
            String string2 = "Unexpected existing state for " + $this$addState + ": " + currentState;
            throw new IllegalArgumentException(string2.toString());
        }
        Long l2 = $this$addState;
        ((Map)this.targetState).put(l2, state);
    }

    private final void addState(long $this$addState, ReplaceWithState state) {
        ReplaceWithState currentState = this.replaceWithState.get($this$addState);
        if (!(currentState == null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Long l2 = $this$addState;
        ((Map)this.replaceWithState).put(l2, state);
    }

    private final WorkspaceEntityData<? extends WorkspaceEntity> findEntityInTargetStore(WorkspaceEntityData<? extends WorkspaceEntity> replaceWithEntityData, long targetParentEntityId, int childClazz, Set<Long> exceptTargetIds) {
        Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>> childrenInTargetEntityDataCollection = this.childrenInTarget(targetParentEntityId, childClazz);
        if (childrenInTargetEntityDataCollection.isEmpty()) {
            return null;
        }
        WorkspaceEntityData<? extends WorkspaceEntity> targetEntityData = this.removeSome(childrenInTargetEntityDataCollection, replaceWithEntityData, exceptTargetIds);
        while (targetEntityData != null && this.targetState.get(targetEntityData.createEntityId()) != null) {
            targetEntityData = this.removeSome(childrenInTargetEntityDataCollection, replaceWithEntityData, exceptTargetIds);
        }
        return targetEntityData;
    }

    private final WorkspaceEntityData<? extends WorkspaceEntity> removeSome(Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>> $this$removeSome, WorkspaceEntityData<? extends WorkspaceEntity> entityData, Set<Long> exceptTargetIds) {
        List<WorkspaceEntityData<? extends WorkspaceEntity>> list2 = $this$removeSome.get(entityData);
        if (list2 == null) {
            return null;
        }
        List<WorkspaceEntityData<? extends WorkspaceEntity>> entityDataListWithSameHash = list2;
        if (entityDataListWithSameHash.isEmpty()) {
            return null;
        }
        this.maybeShuffle(entityDataListWithSameHash);
        return this.removeFirst(entityDataListWithSameHash, (Function1)new Function1<WorkspaceEntityData<? extends WorkspaceEntity>, Boolean>(exceptTargetIds){
            final /* synthetic */ Set<Long> $exceptTargetIds;
            {
                this.$exceptTargetIds = $exceptTargetIds;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull WorkspaceEntityData<? extends WorkspaceEntity> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return !this.$exceptTargetIds.contains(it.createEntityId());
            }
        });
    }

    private final <T> T removeFirst(List<T> $this$removeFirst, Function1<? super T, Boolean> predicate) {
        int index2;
        block4: {
            int n2;
            if ($this$removeFirst.isEmpty()) {
                return null;
            }
            List<T> $this$indexOfFirst$iv = $this$removeFirst;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<T> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                T item$iv;
                T it = item$iv = iterator2.next();
                boolean bl2 = false;
                if (predicate.invoke(it).booleanValue()) {
                    n2 = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n2 = index2 = -1;
        }
        if (index2 == -1) {
            return null;
        }
        return $this$removeFirst.remove(index2);
    }

    private final Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>> childrenInReplaceWith(Long entityId, int childClazz) {
        AbstractEntityStorage abstractEntityStorage = this.replaceWithStorage;
        if (abstractEntityStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
            abstractEntityStorage = null;
        }
        return ReplaceBySourceAsTree.Companion.childrenInStorage(entityId, childClazz, abstractEntityStorage, this.replaceWithChildrenEntityDataCache);
    }

    private final Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>> childrenInTarget(long entityId, int childClazz) {
        Long l2 = entityId;
        MutableEntityStorageImpl mutableEntityStorageImpl = this.targetStorage;
        if (mutableEntityStorageImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
            mutableEntityStorageImpl = null;
        }
        return ReplaceBySourceAsTree.Companion.childrenInStorage(l2, childClazz, mutableEntityStorageImpl, this.targetChildrenEntityDataCache);
    }

    private final List<ChildEntityId> childrenInReplaceForOrdering(long entityId, int childClazz) {
        AbstractEntityStorage abstractEntityStorage = this.replaceWithStorage;
        if (abstractEntityStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
            abstractEntityStorage = null;
        }
        return ReplaceBySourceAsTree.Companion.childrenInStorageForOrdering(entityId, childClazz, abstractEntityStorage, this.replaceWithChildrenEntityIdCache);
    }

    private final <E> List<E> maybeShuffled(List<? extends E> $this$maybeShuffled) {
        if (this.shuffleEntities != -1L && $this$maybeShuffled.size() > 1) {
            return CollectionsKt.shuffled((Iterable)$this$maybeShuffled, new Random(this.shuffleEntities));
        }
        return $this$maybeShuffled;
    }

    private final <E> void maybeShuffle(List<E> $this$maybeShuffle) {
        if (this.shuffleEntities != -1L && $this$maybeShuffle.size() > 1) {
            Collections.shuffle($this$maybeShuffle, new Random(this.shuffleEntities));
        }
    }

    public static final /* synthetic */ List access$childrenInReplaceForOrdering(ReplaceBySourceAsTree $this, long entityId, int childClazz) {
        return $this.childrenInReplaceForOrdering(entityId, childClazz);
    }

    public static final /* synthetic */ List access$maybeShuffled(ReplaceBySourceAsTree $this, List $receiver) {
        return $this.maybeShuffled($receiver);
    }

    public static final /* synthetic */ Map access$childrenInReplaceWith(ReplaceBySourceAsTree $this, Long entityId, int childClazz) {
        return $this.childrenInReplaceWith(entityId, childClazz);
    }

    public static final /* synthetic */ HashMap access$getReplaceWithParentToChildrenCache$p(ReplaceBySourceAsTree $this) {
        return $this.replaceWithParentToChildrenCache;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReplaceBySourceAsTree.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        LOG = logger;
        hashingStrategy = new HashingStrategy<WorkspaceEntityData<? extends WorkspaceEntity>>(){

            public int hashCode(@Nullable WorkspaceEntityData<? extends WorkspaceEntity> entityData) {
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = entityData;
                return workspaceEntityData != null ? workspaceEntityData.hashCodeByKey() : 0;
            }

            public boolean equals(@Nullable WorkspaceEntityData<? extends WorkspaceEntity> entityData1, @Nullable WorkspaceEntityData<? extends WorkspaceEntity> entityData2) {
                if (entityData1 == entityData2) {
                    return true;
                }
                if (entityData1 == null || entityData2 == null) {
                    return false;
                }
                return entityData1.equalsByKey(entityData2);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000o\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000*\u0001\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u009d\u0001\u0010\b\u001a(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\f0\tj\u0002`\r2\u000e\u0010\u000e\u001a\n\u0018\u00010\u000fj\u0004\u0018\u0001`\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142H\u0010\u0015\u001aD\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u00126\u00124\u0012\u0004\u0012\u00020\u0018\u0012*\u0012(\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\f0\tj\u0002`\r0\u00170\u0016H\u0002\u00a2\u0006\u0002\u0010\u0019JT\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142(\u0010\u0015\u001a$\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u00170\u0016H\u0002J2\u0010\u001d\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u00142\u000e\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "hashingStrategy", "com/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$Companion$hashingStrategy$1", "Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$Companion$hashingStrategy$1;", "childrenInStorage", "", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityDataCustomCollection;", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "childrenClass", "", "storage", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "childrenCache", "Ljava/util/HashMap;", "", "Lcom/intellij/platform/workspace/storage/impl/ConnectionId;", "(Ljava/lang/Long;ILcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;Ljava/util/HashMap;)Ljava/util/Map;", "childrenInStorageForOrdering", "", "Lcom/intellij/platform/workspace/storage/impl/ChildEntityId;", "findRootEntityInStorage", "rootEntity", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityBase;", "goalStorage", "oppositeStorage", "goalState", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nReplaceBySourceAsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1013:1\n372#2,7:1014\n478#2,7:1021\n372#2,3:1029\n453#2:1032\n403#2:1033\n372#2,7:1037\n375#2,4:1046\n478#2,7:1050\n1#3:1028\n1238#4,2:1034\n1855#4:1036\n1856#4:1044\n1241#4:1045\n*S KotlinDebug\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$Companion\n*L\n856#1:1014,7\n858#1:1021,7\n871#1:1029,3\n872#1:1032\n872#1:1033\n877#1:1037,7\n871#1:1046,4\n883#1:1050,7\n872#1:1034,2\n875#1:1036\n875#1:1044\n872#1:1045\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<ChildEntityId> childrenInStorageForOrdering(long entityId, int childrenClass, AbstractEntityStorage storage, HashMap<Long, Map<ConnectionId, List<ChildEntityId>>> childrenCache) {
            Map targetChildren;
            Object object;
            void $this$getOrPut$iv;
            Map map2 = childrenCache;
            Long key$iv = entityId;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Map<ConnectionId, List<ChildEntityId>> answer$iv = storage.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(entityId));
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Map $this$filterKeys$iv = targetChildren = (Map)object;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                ConnectionId it = (ConnectionId)entry$iv.getKey();
                boolean bl3 = false;
                if (!RefsTableKt.sameClass(it.getChildClass(), childrenClass, it.getConnectionType())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map targetFoundChildren = result$iv;
            if (!(targetFoundChildren.size() < 2)) {
                boolean bl4 = false;
                String string2 = "Got unexpected amount of children";
                throw new IllegalArgumentException(string2.toString());
            }
            if (targetFoundChildren.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            return (List)((Map.Entry)CollectionsKt.single(targetFoundChildren.entrySet())).getValue();
        }

        /*
         * WARNING - void declaration
         */
        private final Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>> childrenInStorage(Long entityId, int childrenClass, AbstractEntityStorage storage, HashMap<Long, Map<ConnectionId, Map<WorkspaceEntityData<? extends WorkspaceEntity>, List<WorkspaceEntityData<? extends WorkspaceEntity>>>>> childrenCache) {
            Map targetChildren;
            Object object;
            if (entityId == null) {
                return new LinkedHashMap();
            }
            Map $this$getOrPut$iv = childrenCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(entityId);
            if (value$iv == null) {
                void $this$mapValuesTo$iv$iv;
                boolean bl2 = false;
                Map<ConnectionId, List<ChildEntityId>> $this$mapValues$iv = storage.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(entityId));
                boolean $i$f$mapValues = false;
                Map<ConnectionId, List<ChildEntityId>> map2 = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    Map<WorkspaceEntityData<? extends WorkspaceEntity>, List> entityDataCollection;
                    void mapEntry;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl3 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k2 = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue(CollectionFactory.createCustomHashingStrategyMap(hashingStrategy), "createCustomHashingStrategyMap(...)");
                    Iterable $this$forEach$iv = (Iterable)mapEntry.getValue();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Object object2;
                        long childEntityId = ((ChildEntityId)element$iv).unbox-impl();
                        boolean bl5 = false;
                        WorkspaceEntityData<? extends WorkspaceEntity> entityData = storage.entityDataByIdOrDie$intellij_platform_workspace_storage(childEntityId);
                        Map<WorkspaceEntityData<? extends WorkspaceEntity>, List> $this$getOrPut$iv2 = entityDataCollection;
                        boolean $i$f$getOrPut2 = false;
                        Object value$iv2 = $this$getOrPut$iv2.get(entityData);
                        if (value$iv2 == null) {
                            boolean bl6 = false;
                            List answer$iv = new ArrayList();
                            $this$getOrPut$iv2.put(entityData, answer$iv);
                            object2 = answer$iv;
                        } else {
                            object2 = value$iv2;
                        }
                        Object v2 = object2;
                        List $this$childrenInStorage_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244 = (List)v2;
                        boolean bl7 = false;
                        $this$childrenInStorage_u24lambda_u247_u24lambda_u246_u24lambda_u245_u24lambda_u244.add(entityData);
                    }
                    Map<WorkspaceEntityData<? extends WorkspaceEntity>, List> map5 = entityDataCollection;
                    map4.put(k2, map5);
                }
                Map answer$iv = destination$iv$iv;
                $this$getOrPut$iv.put(entityId, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Map $this$filterKeys$iv = targetChildren = (Map)object;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                ConnectionId it = (ConnectionId)entry$iv.getKey();
                boolean bl8 = false;
                if (!RefsTableKt.sameClass(it.getChildClass(), childrenClass, it.getConnectionType())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map targetFoundChildren = result$iv;
            if (!(targetFoundChildren.size() < 2)) {
                boolean bl9 = false;
                String string2 = "Got unexpected amount of children";
                throw new IllegalArgumentException(string2.toString());
            }
            if (targetFoundChildren.isEmpty()) {
                return new LinkedHashMap();
            }
            return (Map)((Map.Entry)CollectionsKt.single(targetFoundChildren.entrySet())).getValue();
        }

        private final WorkspaceEntity findRootEntityInStorage(WorkspaceEntityBase rootEntity, AbstractEntityStorage goalStorage, AbstractEntityStorage oppositeStorage, Long2ObjectMap<? extends Object> goalState) {
            WorkspaceEntity workspaceEntity;
            if (rootEntity instanceof WorkspaceEntityWithSymbolicId) {
                SymbolicEntityId<WorkspaceEntityWithSymbolicId> symbolicId = ((WorkspaceEntityWithSymbolicId)((Object)rootEntity)).getSymbolicId();
                workspaceEntity = goalStorage.resolve(symbolicId);
            } else {
                WorkspaceEntityData<? extends WorkspaceEntity> oppositeEntityData = oppositeStorage.entityDataByIdOrDie$intellij_platform_workspace_storage(rootEntity.getId());
                workspaceEntity = SequencesKt.firstOrNull(SequencesKt.filter(goalStorage.entities(ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(rootEntity.getId()))), (Function1)new Function1<WorkspaceEntity, Boolean>(goalState, goalStorage, oppositeEntityData){
                    final /* synthetic */ Long2ObjectMap<? extends Object> $goalState;
                    final /* synthetic */ AbstractEntityStorage $goalStorage;
                    final /* synthetic */ WorkspaceEntityData<? extends WorkspaceEntity> $oppositeEntityData;
                    {
                        this.$goalState = $goalState;
                        this.$goalStorage = $goalStorage;
                        this.$oppositeEntityData = $oppositeEntityData;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull WorkspaceEntity it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        long itId = ((WorkspaceEntityBase)it).getId();
                        if (this.$goalState.get(itId) != null) {
                            return false;
                        }
                        return this.$goalStorage.entityDataByIdOrDie$intellij_platform_workspace_storage(itId).equalsByKey(this.$oppositeEntityData) && this.$goalStorage.getRefs$intellij_platform_workspace_storage().getParentRefsOfChild-HhnaDKw(RefsTableKt.asChild(itId)).isEmpty();
                    }
                }));
            }
            return workspaceEntity;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\b\u0012\u00060\u0007j\u0002`\b\u0018\u00010\u00062\n\u0010\t\u001a\u00060\u0007j\u0002`\b2\u001a\u0010\n\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u00060\u0007j\u0002`\b0\u000bH\u0002J\u0006\u0010\f\u001a\u00020\u0004J\u0006\u0010\r\u001a\u00020\u000eJ0\u0010\u000f\u001a\u00020\u000e2\n\u0010\u0010\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0002J!\u0010\u0016\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\n\u0010\u0017\u001a\u00060\u0007j\u0002`\bH\u0002\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$OperationsApplier;", "", "(Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;)V", "addElement", "", "parents", "", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "replaceWithDataSource", "replaceToTarget", "Lcom/google/common/collect/HashBiMap;", "apply", "dumpOperations", "", "infoOf", "entityId", "store", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "short", "", "debugMsg", "replaceWithEntityFromState", "targetParent", "(J)Ljava/lang/Long;", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nReplaceBySourceAsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$OperationsApplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1013:1\n1620#2,3:1014\n1620#2,3:1017\n1855#2,2:1020\n1855#2,2:1022\n1477#2:1024\n1502#2,3:1025\n1505#2,3:1035\n1855#2,2:1040\n1549#2:1042\n1620#2,3:1043\n1855#2,2:1046\n1855#2,2:1048\n1855#2,2:1050\n1855#2,2:1052\n372#3,7:1028\n215#4,2:1038\n*S KotlinDebug\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$OperationsApplier\n*L\n123#1:1014,3\n135#1:1017,3\n154#1:1020,2\n202#1:1022,2\n212#1:1024\n212#1:1025,3\n212#1:1035,3\n236#1:1040,2\n256#1:1042\n256#1:1043,3\n256#1:1046,2\n265#1:1048,2\n283#1:1050,2\n290#1:1052,2\n212#1:1028,7\n212#1:1038,2\n*E\n"})
    private final class OperationsApplier {
        /*
         * WARNING - void declaration
         */
        public final void apply() {
            void $this$forEach$iv;
            Object object;
            Collection collection;
            HashBiMap<Long, Long> replaceToTarget = HashBiMap.create();
            for (AddElement addOperation : ReplaceBySourceAsTree.this.getAddOperations$intellij_platform_workspace_storage()) {
                HashSet hashSet;
                Set<ParentsRef> set = addOperation.getParents();
                if (set != null) {
                    void $this$mapTo$iv;
                    Iterable iterable = set;
                    Collection destination$iv = new HashSet();
                    boolean $i$f$mapTo = false;
                    for (Object item$iv : $this$mapTo$iv) {
                        Long l2;
                        void it;
                        ParentsRef parentsRef = (ParentsRef)item$iv;
                        collection = destination$iv;
                        boolean bl2 = false;
                        void var13_19 = it;
                        if (var13_19 instanceof ParentsRef.AddedElement) {
                            Intrinsics.checkNotNull(replaceToTarget);
                            l2 = (Long)MapsKt.getValue((Map)replaceToTarget, ((ParentsRef.AddedElement)it).getReplaceWithEntityId());
                        } else if (var13_19 instanceof ParentsRef.TargetRef) {
                            l2 = ((ParentsRef.TargetRef)it).getTargetEntityId();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        collection.add(l2);
                    }
                    hashSet = (HashSet)destination$iv;
                } else {
                    hashSet = null;
                }
                HashSet parents2 = hashSet;
                Set set2 = parents2;
                long l3 = addOperation.getReplaceWithSource();
                Intrinsics.checkNotNull(replaceToTarget);
                this.addElement(set2, l3, replaceToTarget);
            }
            for (RelabelElement operation : ReplaceBySourceAsTree.this.getReplaceOperations$intellij_platform_workspace_storage()) {
                MutableEntityStorageImpl mutableEntityStorageImpl;
                HashSet parents3;
                HashSet hashSet;
                MutableEntityStorageImpl mutableEntityStorageImpl2 = ReplaceBySourceAsTree.this.targetStorage;
                if (mutableEntityStorageImpl2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl2 = null;
                }
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = mutableEntityStorageImpl2.entityDataByIdOrDie$intellij_platform_workspace_storage(operation.getTargetEntityId());
                MutableEntityStorageImpl mutableEntityStorageImpl3 = ReplaceBySourceAsTree.this.targetStorage;
                if (mutableEntityStorageImpl3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl3 = null;
                }
                WorkspaceEntity targetEntity = workspaceEntityData.createEntity(mutableEntityStorageImpl3);
                AbstractEntityStorage abstractEntityStorage = ReplaceBySourceAsTree.this.replaceWithStorage;
                if (abstractEntityStorage == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    abstractEntityStorage = null;
                }
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData2 = abstractEntityStorage.entityDataByIdOrDie$intellij_platform_workspace_storage(operation.getReplaceWithEntityId());
                AbstractEntityStorage abstractEntityStorage2 = ReplaceBySourceAsTree.this.replaceWithStorage;
                if (abstractEntityStorage2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    abstractEntityStorage2 = null;
                }
                WorkspaceEntity replaceWithEntity = workspaceEntityData2.createEntity(abstractEntityStorage2);
                Set<ParentsRef> set = operation.getParents();
                if (set != null) {
                    void destination$iv;
                    void $this$mapTo$iv;
                    Object item$iv;
                    Iterable $i$f$mapTo = set;
                    object = new HashSet();
                    item$iv = ReplaceBySourceAsTree.this;
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv2 : $this$mapTo$iv) {
                        Long l4;
                        void it;
                        ParentsRef parentsRef = (ParentsRef)item$iv2;
                        collection = destination$iv;
                        boolean bl3 = false;
                        void var16_24 = it;
                        if (var16_24 instanceof ParentsRef.AddedElement) {
                            Intrinsics.checkNotNull(replaceToTarget);
                            l4 = (Long)MapsKt.getValue((Map)replaceToTarget, ((ParentsRef.AddedElement)it).getReplaceWithEntityId());
                        } else if (var16_24 instanceof ParentsRef.TargetRef) {
                            l4 = ((ParentsRef.TargetRef)it).getTargetEntityId();
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        Long targetEntityId = l4;
                        MutableEntityStorageImpl mutableEntityStorageImpl4 = ((ReplaceBySourceAsTree)item$iv).targetStorage;
                        if (mutableEntityStorageImpl4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                            mutableEntityStorageImpl4 = null;
                        }
                        Intrinsics.checkNotNull(targetEntityId);
                        WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData3 = mutableEntityStorageImpl4.entityDataByIdOrDie$intellij_platform_workspace_storage(targetEntityId);
                        MutableEntityStorageImpl mutableEntityStorageImpl5 = ((ReplaceBySourceAsTree)item$iv).targetStorage;
                        if (mutableEntityStorageImpl5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                            mutableEntityStorageImpl5 = null;
                        }
                        collection.add(workspaceEntityData3.createEntity(mutableEntityStorageImpl5));
                    }
                    hashSet = (HashSet)destination$iv;
                } else {
                    hashSet = parents3 = null;
                }
                if ((mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl = null;
                }
                mutableEntityStorageImpl.modifyEntity(WorkspaceEntity.Builder.class, targetEntity, new Function1<WorkspaceEntity.Builder<?>, Unit>(replaceWithEntity, parents3){
                    final /* synthetic */ WorkspaceEntity $replaceWithEntity;
                    final /* synthetic */ HashSet<WorkspaceEntity> $parents;
                    {
                        this.$replaceWithEntity = $replaceWithEntity;
                        this.$parents = $parents;
                        super(1);
                    }

                    public final void invoke(@NotNull WorkspaceEntity.Builder<?> $this$modifyEntity) {
                        Intrinsics.checkNotNullParameter($this$modifyEntity, "$this$modifyEntity");
                        ((ModifiableWorkspaceEntityBase)$this$modifyEntity).relabel(this.$replaceWithEntity, (Set<WorkspaceEntity>)this.$parents);
                    }
                });
                MutableEntityStorageImpl mutableEntityStorageImpl6 = ReplaceBySourceAsTree.this.targetStorage;
                if (mutableEntityStorageImpl6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl6 = null;
                }
                MutableStorageIndexes mutableStorageIndexes = mutableEntityStorageImpl6.getIndexes$intellij_platform_workspace_storage();
                long l5 = operation.getReplaceWithEntityId();
                long l6 = operation.getTargetEntityId();
                AbstractEntityStorage abstractEntityStorage3 = ReplaceBySourceAsTree.this.replaceWithStorage;
                if (abstractEntityStorage3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    abstractEntityStorage3 = null;
                }
                mutableStorageIndexes.updateExternalMappingForEntityId(l5, l6, abstractEntityStorage3.getIndexes$intellij_platform_workspace_storage());
            }
            for (RemoveElement removeOperation : ReplaceBySourceAsTree.this.getRemoveOperations$intellij_platform_workspace_storage()) {
                MutableEntityStorageImpl mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage;
                if (mutableEntityStorageImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl = null;
                }
                MutableEntityStorageImpl.removeEntityByEntityId$intellij_platform_workspace_storage$default(mutableEntityStorageImpl, removeOperation.getTargetEntityId(), null, 2, null);
            }
            Iterable iterable = ReplaceBySourceAsTree.this.listOfParentsWithPotentiallyBrokenChildrenOrder;
            ReplaceBySourceAsTree replaceBySourceAsTree = ReplaceBySourceAsTree.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParentsRef parentsRef = (ParentsRef)element$iv;
                boolean bl4 = false;
                object = parentsRef;
                if (object instanceof ParentsRef.AddedElement || !(object instanceof ParentsRef.TargetRef)) continue;
                long targetParent = ((ParentsRef.TargetRef)parentsRef).getTargetEntityId();
                Long l7 = this.replaceWithEntityFromState(targetParent);
                if (l7 == null) {
                    continue;
                }
                long replaceWithParent = l7;
                MutableEntityStorageImpl mutableEntityStorageImpl = replaceBySourceAsTree.targetStorage;
                if (mutableEntityStorageImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl = null;
                }
                Map<ConnectionId, List<ChildEntityId>> children2 = mutableEntityStorageImpl.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(targetParent));
                children2.forEach((arg_0, arg_1) -> OperationsApplier.apply$lambda$3$lambda$2(new Function2<ConnectionId, List<? extends ChildEntityId>, Unit>(replaceBySourceAsTree, replaceWithParent, targetParent, replaceToTarget, this){
                    final /* synthetic */ ReplaceBySourceAsTree this$0;
                    final /* synthetic */ long $replaceWithParent;
                    final /* synthetic */ long $targetParent;
                    final /* synthetic */ HashBiMap<Long, Long> $replaceToTarget;
                    final /* synthetic */ OperationsApplier this$1;
                    {
                        this.this$0 = $receiver;
                        this.$replaceWithParent = $replaceWithParent;
                        this.$targetParent = $targetParent;
                        this.$replaceToTarget = $replaceToTarget;
                        this.this$1 = $receiver2;
                        super(2);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final void invoke(@NotNull ConnectionId connectionId, @NotNull List<ChildEntityId> childEntityIds) {
                        Intrinsics.checkNotNullParameter(connectionId, "connectionId");
                        Intrinsics.checkNotNullParameter(childEntityIds, "childEntityIds");
                        if (childEntityIds.size() < 2) {
                            return;
                        }
                        var4_3 = ReplaceBySourceAsTree.access$childrenInReplaceForOrdering(this.this$0, this.$replaceWithParent, EntityIdKt.getClazz(CollectionsKt.first(childEntityIds).unbox-impl()));
                        $i$f$mapIndexed = false;
                        var6_6 = $this$mapIndexed$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                        $i$f$mapIndexedTo = false;
                        index$iv$iv = 0;
                        var10_15 = $this$mapIndexedTo$iv$iv.iterator();
                        while (var10_15.hasNext()) {
                            item$iv$iv = var10_15.next();
                            if ((var12_19 = index$iv$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            var13_21 = ((ChildEntityId)item$iv$iv).unbox-impl();
                            var15_24 = var12_19;
                            var25_27 = destination$iv$iv;
                            $i$a$-mapIndexed-ReplaceBySourceAsTree$OperationsApplier$apply$2$1$replaceWithChildren$1 = false;
                            var25_27.add(TuplesKt.to((long)childEntityId, (int)index));
                        }
                        replaceWithChildren = MapsKt.toMap((List)destination$iv$iv);
                        $i$f$mapIndexed = childEntityIds;
                        $this$mapIndexedTo$iv$iv = this.$replaceToTarget;
                        destination$iv$iv = this.this$1;
                        $i$f$mapIndexed = false;
                        index$iv$iv = $this$mapIndexed$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
                        $i$f$mapIndexedTo = false;
                        index$iv$iv = 0;
                        for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                            if ((var15_24 = index$iv$iv++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            $i$a$-mapIndexed-ReplaceBySourceAsTree$OperationsApplier$apply$2$1$replaceWithChildren$1 = ((ChildEntityId)item$iv$iv).unbox-impl();
                            var18_30 = var15_24;
                            var25_27 = destination$iv$iv;
                            $i$a$-mapIndexed-ReplaceBySourceAsTree$OperationsApplier$apply$2$1$sortedChildren$1 = false;
                            v0 = (Long)$this$mapIndexedTo$iv$iv.inverse().get((long)childEntityId);
                            if (v0 == null) {
                                v0 = OperationsApplier.access$replaceWithEntityFromState((OperationsApplier)destination$iv$iv, (long)childEntityId);
                            }
                            if ((v1 = (replaceWithChildAssociatedWithCurrentElement = v0)) == null) ** GOTO lbl-1000
                            it = ((Number)v1).longValue();
                            $i$a$-let-ReplaceBySourceAsTree$OperationsApplier$apply$2$1$sortedChildren$1$myIndex$1 = false;
                            v2 = (Integer)replaceWithChildren.get(it);
                            v1 = v2;
                            if (v2 != null) {
                                v3 = v1.intValue();
                            } else lbl-1000:
                            // 2 sources

                            {
                                v3 = index;
                            }
                            myIndex = v3;
                            var25_27.add(TuplesKt.to(ChildEntityId.box-impl((long)childEntityId), (int)myIndex));
                        }
                        $this$mapIndexed$iv = (List)destination$iv$iv;
                        $i$f$sortedBy = false;
                        $this$sortedBy$iv = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                            public final int compare(T a2, T b2) {
                                Pair it = (Pair)a2;
                                boolean bl2 = false;
                                Comparable comparable = (Integer)it.getSecond();
                                it = (Pair)b2;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getSecond()));
                            }
                        });
                        $i$f$map = false;
                        destination$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            index$iv$iv = (Pair)item$iv$iv;
                            var25_27 = destination$iv$iv;
                            $i$a$-map-ReplaceBySourceAsTree$OperationsApplier$apply$2$1$sortedChildren$3 = false;
                            var25_27.add(ChildEntityId.box-impl(((ChildEntityId)it.getFirst()).unbox-impl()));
                        }
                        sortedChildren = (List)destination$iv$iv;
                        v4 = ReplaceBySourceAsTree.access$getTargetStorage$p(this.this$0);
                        if (v4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                            v4 = null;
                        }
                        if (!Intrinsics.areEqual(existingChildren = v4.getRefs$intellij_platform_workspace_storage().getChildrenByParent-ePHS_xw(connectionId, RefsTableKt.asParent(this.$targetParent)), sortedChildren)) {
                            v5 = ReplaceBySourceAsTree.access$getTargetStorage$p(this.this$0);
                            if (v5 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                                v5 = null;
                            }
                            modifications = v5.getRefs$intellij_platform_workspace_storage().replaceChildrenOfParent-GnhP5Uc$intellij_platform_workspace_storage(connectionId, RefsTableKt.asParent(this.$targetParent), sortedChildren);
                            v6 = ReplaceBySourceAsTree.access$getTargetStorage$p(this.this$0);
                            if (v6 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                                v6 = null;
                            }
                            UtilsKt.createReplaceEventsForUpdates(v6, (Collection<? extends Modification>)modifications, connectionId);
                        }
                    }
                }, arg_0, arg_1));
            }
        }

        private final Long replaceWithEntityFromState(long targetParent) {
            Long l2;
            ReplaceState replaceState = ReplaceBySourceAsTree.this.getTargetState$intellij_platform_workspace_storage().get(targetParent);
            if (replaceState == null) {
                return null;
            }
            ReplaceState replaceWithState = replaceState;
            ReplaceState replaceState2 = replaceWithState;
            if (replaceState2 instanceof ReplaceState.NoChange) {
                Long l3 = ((ReplaceState.NoChange)replaceWithState).getReplaceWithEntityId();
                if (l3 == null) {
                    return null;
                }
                l2 = (long)l3;
            } else if (replaceState2 instanceof ReplaceState.Relabel) {
                l2 = ((ReplaceState.Relabel)replaceWithState).getReplaceWithEntityId();
            } else {
                if (replaceState2 instanceof ReplaceState.Remove) {
                    return null;
                }
                throw new NoWhenBranchMatchedException();
            }
            return l2;
        }

        /*
         * WARNING - void declaration
         */
        private final void addElement(Set<Long> parents2, long replaceWithDataSource, HashBiMap<Long, Long> replaceToTarget) {
            void $this$forEach$iv;
            void $this$groupByTo$iv$iv;
            AbstractEntityStorage abstractEntityStorage;
            boolean $i$f$forEach;
            List targetParents = new ArrayList();
            Set<Long> set = parents2;
            if (set != null) {
                void $this$forEach$iv2;
                Iterable iterable = set;
                ReplaceBySourceAsTree replaceBySourceAsTree = ReplaceBySourceAsTree.this;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    long parent = ((Number)element$iv).longValue();
                    boolean bl2 = false;
                    Collection collection = targetParents;
                    MutableEntityStorageImpl mutableEntityStorageImpl = replaceBySourceAsTree.targetStorage;
                    if (mutableEntityStorageImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                        mutableEntityStorageImpl = null;
                    }
                    WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = mutableEntityStorageImpl.entityDataByIdOrDie$intellij_platform_workspace_storage(parent);
                    MutableEntityStorageImpl mutableEntityStorageImpl2 = replaceBySourceAsTree.targetStorage;
                    if (mutableEntityStorageImpl2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                        mutableEntityStorageImpl2 = null;
                    }
                    collection.add(workspaceEntityData.createEntity(mutableEntityStorageImpl2));
                }
            }
            if ((abstractEntityStorage = ReplaceBySourceAsTree.this.replaceWithStorage) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage = null;
            }
            WorkspaceEntity modifiableEntity = abstractEntityStorage.entityDataByIdOrDie$intellij_platform_workspace_storage(replaceWithDataSource).createDetachedEntity(targetParents);
            Intrinsics.checkNotNull(modifiableEntity, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.ModifiableWorkspaceEntityBase<out com.intellij.platform.workspace.storage.WorkspaceEntity, out com.intellij.platform.workspace.storage.impl.WorkspaceEntityData<*>>");
            ModifiableWorkspaceEntityBase cfr_ignored_0 = (ModifiableWorkspaceEntityBase)modifiableEntity;
            Object $this$groupBy$iv = targetParents;
            boolean $i$f$groupBy = false;
            Iterator iterator2 = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                WorkspaceEntity it = (WorkspaceEntity)element$iv$iv;
                boolean bl3 = false;
                KClass key$iv$iv = Reflection.getOrCreateKotlinClass(it.getClass());
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl4 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            $this$groupBy$iv = destination$iv$iv;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object object = element$iv = iterator2.next();
                boolean bl5 = false;
                List entities2 = (List)object.getValue();
                ((ModifiableWorkspaceEntityBase)modifiableEntity).updateReferenceToEntity(((WorkspaceEntity)CollectionsKt.first(entities2)).getEntityInterface(), false, entities2);
            }
            MutableEntityStorageImpl mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage;
            if (mutableEntityStorageImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                mutableEntityStorageImpl = null;
            }
            mutableEntityStorageImpl.addEntity(modifiableEntity);
            MutableEntityStorageImpl mutableEntityStorageImpl3 = ReplaceBySourceAsTree.this.targetStorage;
            if (mutableEntityStorageImpl3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                mutableEntityStorageImpl3 = null;
            }
            MutableStorageIndexes mutableStorageIndexes = mutableEntityStorageImpl3.getIndexes$intellij_platform_workspace_storage();
            long l2 = ((ModifiableWorkspaceEntityBase)modifiableEntity).getId();
            AbstractEntityStorage abstractEntityStorage2 = ReplaceBySourceAsTree.this.replaceWithStorage;
            if (abstractEntityStorage2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage2 = null;
            }
            mutableStorageIndexes.updateExternalMappingForEntityId(replaceWithDataSource, l2, abstractEntityStorage2.getIndexes$intellij_platform_workspace_storage());
            Long l3 = replaceWithDataSource;
            ((Map)replaceToTarget).put(l3, ((ModifiableWorkspaceEntityBase)modifiableEntity).getId());
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String dumpOperations() {
            long it;
            Iterable $this$forEach$iv;
            void $this$mapTo$iv$iv;
            Object object;
            StringBuilder stringBuilder;
            Iterable $this$forEach$iv2;
            StringBuilder stringBuilder2;
            Set targetEntities = new LinkedHashSet();
            Set replaceWithEntities = new LinkedHashSet();
            ReplaceBySourceAsTree replaceBySourceAsTree = ReplaceBySourceAsTree.this;
            StringBuilder $this$dumpOperations_u24lambda_u2413 = stringBuilder2 = new StringBuilder();
            boolean bl2 = false;
            StringBuilder stringBuilder3 = $this$dumpOperations_u24lambda_u2413.append("---- New entities -------");
            Intrinsics.checkNotNullExpressionValue(stringBuilder3, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder3.append('\n'), "append(...)");
            for (AddElement addOperation : replaceBySourceAsTree.getAddOperations$intellij_platform_workspace_storage()) {
                Iterator iterator2 = $this$dumpOperations_u24lambda_u2413;
                long l2 = addOperation.getReplaceWithSource();
                AbstractEntityStorage abstractEntityStorage = replaceBySourceAsTree.replaceWithStorage;
                if (abstractEntityStorage == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    abstractEntityStorage = null;
                }
                StringBuilder stringBuilder4 = ((StringBuilder)((Object)iterator2)).append(this.infoOf(l2, abstractEntityStorage, true, addOperation.getDebugMsg()));
                Intrinsics.checkNotNullExpressionValue(stringBuilder4, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder4.append('\n'), "append(...)");
                ((Collection)replaceWithEntities).add(addOperation.getReplaceWithSource());
                if (addOperation.getParents() == null) {
                    StringBuilder stringBuilder5 = $this$dumpOperations_u24lambda_u2413.append("No parent entities");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder5, "append(...)");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder5.append('\n'), "append(...)");
                } else {
                    StringBuilder stringBuilder6 = $this$dumpOperations_u24lambda_u2413.append("Parents:");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder6, "append(...)");
                    Intrinsics.checkNotNullExpressionValue(stringBuilder6.append('\n'), "append(...)");
                    $this$forEach$iv2 = addOperation.getParents();
                    boolean $i$f$forEach = false;
                    for (Iterator element$iv : $this$forEach$iv2) {
                        ParentsRef parent = (ParentsRef)((Object)element$iv);
                        boolean bl3 = false;
                        ParentsRef parentsRef = parent;
                        if (parentsRef instanceof ParentsRef.AddedElement) {
                            stringBuilder = $this$dumpOperations_u24lambda_u2413;
                            long l3 = ((ParentsRef.AddedElement)parent).getReplaceWithEntityId();
                            AbstractEntityStorage abstractEntityStorage2 = replaceBySourceAsTree.replaceWithStorage;
                            if (abstractEntityStorage2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                                abstractEntityStorage2 = null;
                            }
                            object = "   - " + this.infoOf(l3, abstractEntityStorage2, true, addOperation.getDebugMsg()) + " <--- New Added Entity";
                            StringBuilder stringBuilder7 = stringBuilder.append((String)object);
                            Intrinsics.checkNotNullExpressionValue(stringBuilder7, "append(...)");
                            Intrinsics.checkNotNullExpressionValue(stringBuilder7.append('\n'), "append(...)");
                            ((Collection)replaceWithEntities).add(((ParentsRef.AddedElement)parent).getReplaceWithEntityId());
                            continue;
                        }
                        if (!(parentsRef instanceof ParentsRef.TargetRef)) continue;
                        stringBuilder = $this$dumpOperations_u24lambda_u2413;
                        long l4 = ((ParentsRef.TargetRef)parent).getTargetEntityId();
                        MutableEntityStorageImpl mutableEntityStorageImpl = replaceBySourceAsTree.targetStorage;
                        if (mutableEntityStorageImpl == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                            mutableEntityStorageImpl = null;
                        }
                        StringBuilder stringBuilder8 = stringBuilder.append("   - " + this.infoOf(l4, mutableEntityStorageImpl, true, addOperation.getDebugMsg()) + " <--- Existing Entity");
                        Intrinsics.checkNotNullExpressionValue(stringBuilder8, "append(...)");
                        Intrinsics.checkNotNullExpressionValue(stringBuilder8.append('\n'), "append(...)");
                        ((Collection)targetEntities).add(((ParentsRef.TargetRef)parent).getTargetEntityId());
                    }
                }
                Intrinsics.checkNotNullExpressionValue($this$dumpOperations_u24lambda_u2413.append('\n'), "append(...)");
            }
            StringBuilder stringBuilder9 = $this$dumpOperations_u24lambda_u2413.append("---- No More New Entities -------");
            Intrinsics.checkNotNullExpressionValue(stringBuilder9, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder9.append('\n'), "append(...)");
            StringBuilder stringBuilder10 = $this$dumpOperations_u24lambda_u2413.append("---- Removes -------");
            Intrinsics.checkNotNullExpressionValue(stringBuilder10, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder10.append('\n'), "append(...)");
            Iterable $this$map$iv = replaceBySourceAsTree.getRemoveOperations$intellij_platform_workspace_storage();
            boolean $i$f$map = false;
            $this$forEach$iv2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                RemoveElement bl3 = (RemoveElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(TuplesKt.to(it2.getTargetEntityId(), it2.getDebugMsg()));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair $i$f$mapTo2 = (Pair)element$iv;
                boolean bl5 = false;
                long entityId = ((Number)$i$f$mapTo2.component1()).longValue();
                String debugMsg = (String)$i$f$mapTo2.component2();
                stringBuilder = $this$dumpOperations_u24lambda_u2413;
                MutableEntityStorageImpl mutableEntityStorageImpl = replaceBySourceAsTree.targetStorage;
                if (mutableEntityStorageImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl = null;
                }
                StringBuilder stringBuilder11 = stringBuilder.append(this.infoOf(entityId, mutableEntityStorageImpl, true, debugMsg));
                Intrinsics.checkNotNullExpressionValue(stringBuilder11, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder11.append('\n'), "append(...)");
                object = entityId;
                ((Collection)targetEntities).add(object);
            }
            StringBuilder stringBuilder12 = $this$dumpOperations_u24lambda_u2413.append("---- No More Removes -------");
            Intrinsics.checkNotNullExpressionValue(stringBuilder12, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder12.append('\n'), "append(...)");
            Intrinsics.checkNotNullExpressionValue($this$dumpOperations_u24lambda_u2413.append('\n'), "append(...)");
            StringBuilder stringBuilder13 = $this$dumpOperations_u24lambda_u2413.append("---- Replaces -------");
            Intrinsics.checkNotNullExpressionValue(stringBuilder13, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder13.append('\n'), "append(...)");
            $this$forEach$iv = replaceBySourceAsTree.getReplaceOperations$intellij_platform_workspace_storage();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object item$iv$iv;
                RelabelElement operation = (RelabelElement)element$iv;
                boolean bl6 = false;
                item$iv$iv = $this$dumpOperations_u24lambda_u2413;
                long l5 = operation.getTargetEntityId();
                MutableEntityStorageImpl mutableEntityStorageImpl = replaceBySourceAsTree.targetStorage;
                if (mutableEntityStorageImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl = null;
                }
                String string2 = OperationsApplier.infoOf$default(this, l5, mutableEntityStorageImpl, true, null, 8, null);
                long l6 = operation.getReplaceWithEntityId();
                AbstractEntityStorage abstractEntityStorage = replaceBySourceAsTree.replaceWithStorage;
                if (abstractEntityStorage == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    abstractEntityStorage = null;
                }
                Set<ParentsRef> set = operation.getParents();
                String string3 = string2 + " -> " + OperationsApplier.infoOf$default(this, l6, abstractEntityStorage, true, null, 8, null) + " | Count of parents: " + (set != null ? Integer.valueOf(set.size()) : null) + " | msg: " + operation.getDebugMsg();
                StringBuilder stringBuilder14 = ((StringBuilder)item$iv$iv).append(string3);
                Intrinsics.checkNotNullExpressionValue(stringBuilder14, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder14.append('\n'), "append(...)");
                ((Collection)targetEntities).add(operation.getTargetEntityId());
                ((Collection)replaceWithEntities).add(operation.getReplaceWithEntityId());
            }
            StringBuilder stringBuilder15 = $this$dumpOperations_u24lambda_u2413.append("---- No More Replaces -------");
            Intrinsics.checkNotNullExpressionValue(stringBuilder15, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder15.append('\n'), "append(...)");
            Intrinsics.checkNotNullExpressionValue($this$dumpOperations_u24lambda_u2413.append('\n'), "append(...)");
            StringBuilder stringBuilder16 = $this$dumpOperations_u24lambda_u2413.append("---- Entities -------");
            Intrinsics.checkNotNullExpressionValue(stringBuilder16, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder16.append('\n'), "append(...)");
            Intrinsics.checkNotNullExpressionValue($this$dumpOperations_u24lambda_u2413.append('\n'), "append(...)");
            StringBuilder stringBuilder17 = $this$dumpOperations_u24lambda_u2413.append("---- Target Storage -------");
            Intrinsics.checkNotNullExpressionValue(stringBuilder17, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder17.append('\n'), "append(...)");
            $this$forEach$iv = targetEntities;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = ((Number)element$iv).longValue();
                boolean bl7 = false;
                StringBuilder stringBuilder18 = $this$dumpOperations_u24lambda_u2413;
                MutableEntityStorageImpl mutableEntityStorageImpl = replaceBySourceAsTree.targetStorage;
                if (mutableEntityStorageImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl = null;
                }
                StringBuilder stringBuilder19 = stringBuilder18.append(OperationsApplier.infoOf$default(this, it, mutableEntityStorageImpl, false, null, 8, null));
                Intrinsics.checkNotNullExpressionValue(stringBuilder19, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder19.append('\n'), "append(...)");
                Intrinsics.checkNotNullExpressionValue($this$dumpOperations_u24lambda_u2413.append('\n'), "append(...)");
            }
            Intrinsics.checkNotNullExpressionValue($this$dumpOperations_u24lambda_u2413.append('\n'), "append(...)");
            StringBuilder stringBuilder20 = $this$dumpOperations_u24lambda_u2413.append("---- Replace With Storage -------");
            Intrinsics.checkNotNullExpressionValue(stringBuilder20, "append(...)");
            Intrinsics.checkNotNullExpressionValue(stringBuilder20.append('\n'), "append(...)");
            $this$forEach$iv = replaceWithEntities;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = ((Number)element$iv).longValue();
                boolean bl8 = false;
                StringBuilder stringBuilder21 = $this$dumpOperations_u24lambda_u2413;
                AbstractEntityStorage abstractEntityStorage = replaceBySourceAsTree.replaceWithStorage;
                if (abstractEntityStorage == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    abstractEntityStorage = null;
                }
                StringBuilder stringBuilder22 = stringBuilder21.append(OperationsApplier.infoOf$default(this, it, abstractEntityStorage, false, null, 8, null));
                Intrinsics.checkNotNullExpressionValue(stringBuilder22, "append(...)");
                Intrinsics.checkNotNullExpressionValue(stringBuilder22.append('\n'), "append(...)");
                Intrinsics.checkNotNullExpressionValue($this$dumpOperations_u24lambda_u2413.append('\n'), "append(...)");
            }
            String string4 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue(string4, "toString(...)");
            return string4;
        }

        private final String infoOf(long entityId, AbstractEntityStorage store, boolean bl2, String debugMsg) {
            Object debugMessage;
            WorkspaceEntityData<? extends WorkspaceEntity> entityData = store.entityDataByIdOrDie$intellij_platform_workspace_storage(entityId);
            WorkspaceEntity entity = entityData.createEntity(store);
            String string2 = debugMsg;
            Object object = debugMessage = string2 != null ? " | msg: " + string2 : "";
            return entity instanceof WorkspaceEntityWithSymbolicId ? ((WorkspaceEntityWithSymbolicId)entity).getSymbolicId() + (String)debugMessage : (bl2 ? entity + (String)debugMessage : entity + " | " + entityData + (String)debugMessage);
        }

        static /* synthetic */ String infoOf$default(OperationsApplier operationsApplier, long l2, AbstractEntityStorage abstractEntityStorage, boolean bl2, String string2, int n2, Object object) {
            if ((n2 & 8) != 0) {
                string2 = null;
            }
            return operationsApplier.infoOf(l2, abstractEntityStorage, bl2, string2);
        }

        private static final void apply$lambda$3$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            $tmp0.invoke(p0, p1);
        }

        public static final /* synthetic */ Long access$replaceWithEntityFromState(OperationsApplier $this, long targetParent) {
            return $this.replaceWithEntityFromState(targetParent);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\rH\u0002J$\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0012\b\u0002\u0010\u0013\u001a\f\u0012\b\u0012\u00060\tj\u0002`\n0\u0006J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0015J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J,\u0010\u0016\u001a\u0004\u0018\u00010\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$ReplaceWithProcessor;", "", "(Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;)V", "addSubtree", "", "parents", "", "Lcom/intellij/platform/workspace/storage/impl/ParentsRef;", "replaceWithEntityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "findAndReplaceRootEntity", "replaceWithEntity", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityBase;", "findAndReplaceRootEntityInTargetStore", "replaceWithRootEntity", "findSameEntityInTargetStore", "replaceWithTrack", "Lcom/intellij/platform/workspace/storage/impl/TrackToParents;", "exceptTargetIds", "processEntity", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "processExactEntity", "targetEntity", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nReplaceBySourceAsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$ReplaceWithProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1013:1\n1611#2:1014\n1855#2:1015\n1856#2:1017\n1612#2:1018\n1611#2:1019\n1855#2:1020\n1856#2:1022\n1612#2:1023\n800#2,11:1024\n1271#2,2:1035\n1285#2,4:1037\n1855#2:1042\n1603#2,9:1043\n1855#2:1052\n1856#2:1054\n1612#2:1055\n1856#2:1056\n1#3:1016\n1#3:1021\n1#3:1041\n1#3:1053\n*S KotlinDebug\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$ReplaceWithProcessor\n*L\n336#1:1014\n336#1:1015\n336#1:1017\n336#1:1018\n340#1:1019\n340#1:1020\n340#1:1022\n340#1:1023\n342#1:1024,11\n478#1:1035,2\n478#1:1037,4\n519#1:1042\n527#1:1043,9\n527#1:1052\n527#1:1054\n527#1:1055\n519#1:1056\n336#1:1016\n340#1:1021\n527#1:1053\n*E\n"})
    private final class ReplaceWithProcessor {
        public final void processEntity(@NotNull WorkspaceEntity replaceWithEntity) {
            Intrinsics.checkNotNullParameter(replaceWithEntity, "replaceWithEntity");
            WorkspaceEntityBase cfr_ignored_0 = (WorkspaceEntityBase)replaceWithEntity;
            if (ReplaceBySourceAsTree.this.getReplaceWithState$intellij_platform_workspace_storage().get(((WorkspaceEntityBase)replaceWithEntity).getId()) != null) {
                return;
            }
            long l2 = ((WorkspaceEntityBase)replaceWithEntity).getId();
            AbstractEntityStorage abstractEntityStorage = ReplaceBySourceAsTree.this.replaceWithStorage;
            if (abstractEntityStorage == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage = null;
            }
            this.processEntity(new TrackToParents(l2, abstractEntityStorage));
        }

        /*
         * WARNING - void declaration
         */
        private final ParentsRef processEntity(TrackToParents replaceWithTrack) {
            ParentsRef parentsRef;
            void $this$mapNotNullTo$iv;
            AbstractEntityStorage abstractEntityStorage;
            long replaceWithEntityId = replaceWithTrack.getEntity();
            ReplaceWithState replaceWithEntityState = ReplaceBySourceAsTree.this.getReplaceWithState$intellij_platform_workspace_storage().get(replaceWithEntityId);
            ReplaceWithState replaceWithState = replaceWithEntityState;
            if (Intrinsics.areEqual(replaceWithState, ReplaceWithState.ElementMoved.INSTANCE)) {
                return new ParentsRef.AddedElement(replaceWithEntityId);
            }
            if (replaceWithState instanceof ReplaceWithState.NoChange) {
                return new ParentsRef.TargetRef(((ReplaceWithState.NoChange)replaceWithEntityState).getTargetEntityId());
            }
            if (Intrinsics.areEqual(replaceWithState, ReplaceWithState.NoChangeTraceLost.INSTANCE)) {
                return null;
            }
            if (replaceWithState instanceof ReplaceWithState.Relabel) {
                return new ParentsRef.TargetRef(((ReplaceWithState.Relabel)replaceWithEntityState).getTargetEntityId());
            }
            if (replaceWithState == null) {
                // empty if block
            }
            if ((abstractEntityStorage = ReplaceBySourceAsTree.this.replaceWithStorage) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage = null;
            }
            WorkspaceEntityData<? extends WorkspaceEntity> replaceWithEntityData = abstractEntityStorage.entityDataByIdOrDie$intellij_platform_workspace_storage(replaceWithEntityId);
            AbstractEntityStorage abstractEntityStorage2 = ReplaceBySourceAsTree.this.replaceWithStorage;
            if (abstractEntityStorage2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage2 = null;
            }
            WorkspaceEntity workspaceEntity = replaceWithEntityData.createEntity(abstractEntityStorage2);
            Intrinsics.checkNotNull(workspaceEntity, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase");
            WorkspaceEntityBase replaceWithEntity = (WorkspaceEntityBase)workspaceEntity;
            if (replaceWithTrack.getParents().isEmpty()) {
                return this.findAndReplaceRootEntity(replaceWithEntity);
            }
            if (replaceWithEntity instanceof WorkspaceEntityWithSymbolicId) {
                void $this$mapNotNullTo$iv2;
                MutableEntityStorageImpl mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage;
                if (mutableEntityStorageImpl == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                    mutableEntityStorageImpl = null;
                }
                WorkspaceEntityWithSymbolicId targetEntity = mutableEntityStorageImpl.resolve(((WorkspaceEntityWithSymbolicId)((Object)replaceWithEntity)).getSymbolicId());
                Iterable iterable = replaceWithTrack.getParents();
                Collection destination$iv = new HashSet();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv2;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ParentsRef it$iv;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator2.next();
                    boolean bl2 = false;
                    TrackToParents it = (TrackToParents)element$iv;
                    boolean bl3 = false;
                    if (this.processEntity(it) == null) continue;
                    boolean bl4 = false;
                    destination$iv.add(it$iv);
                }
                HashSet parentsAssociation = (HashSet)destination$iv;
                return this.processExactEntity(targetEntity, replaceWithEntity, parentsAssociation);
            }
            Iterable parentsAssociation = replaceWithTrack.getParents();
            Collection destination$iv = new HashSet();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator $i$f$forEach2 = $this$forEach$iv$iv.iterator();
            while ($i$f$forEach2.hasNext()) {
                ParentsRef it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = $i$f$forEach2.next();
                boolean bl5 = false;
                TrackToParents it = (TrackToParents)element$iv;
                boolean bl6 = false;
                if (this.processEntity(it) == null) continue;
                boolean bl7 = false;
                destination$iv.add(it$iv);
            }
            HashSet parentsAssociation2 = (HashSet)destination$iv;
            if (!((Collection)parentsAssociation2).isEmpty()) {
                Object v7;
                WorkspaceEntityData targetEntityData;
                WorkspaceEntityData workspaceEntityData;
                ReplaceBySourceAsTree replaceBySourceAsTree;
                block19: {
                    void $this$filterIsInstanceTo$iv$iv;
                    Iterable $this$filterIsInstance$iv = parentsAssociation2;
                    boolean $i$f$filterIsInstance = false;
                    $this$forEach$iv$iv = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof ParentsRef.TargetRef)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    replaceBySourceAsTree = ReplaceBySourceAsTree.this;
                    for (ParentsRef.TargetRef parent : $this$filterIsInstance$iv) {
                        boolean bl8 = false;
                        WorkspaceEntityData workspaceEntityData2 = replaceBySourceAsTree.findEntityInTargetStore(replaceWithEntityData, parent.getTargetEntityId(), EntityIdKt.getClazz(replaceWithEntityId), SetsKt.emptySet());
                        if (workspaceEntityData2 == null) continue;
                        workspaceEntityData = workspaceEntityData2;
                        break block19;
                    }
                    workspaceEntityData = null;
                }
                WorkspaceEntityData workspaceEntityData3 = targetEntityData = workspaceEntityData;
                if (workspaceEntityData3 != null) {
                    MutableEntityStorageImpl mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage;
                    if (mutableEntityStorageImpl == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                        mutableEntityStorageImpl = null;
                    }
                    v7 = workspaceEntityData3.createEntity(mutableEntityStorageImpl);
                } else {
                    v7 = null;
                }
                replaceBySourceAsTree = v7;
                WorkspaceEntityBase targetEntity = replaceBySourceAsTree instanceof WorkspaceEntityBase ? (WorkspaceEntityBase)((Object)replaceBySourceAsTree) : null;
                parentsRef = this.processExactEntity(targetEntity, replaceWithEntity, parentsAssociation2);
            } else {
                ReplaceBySourceAsTree.this.addState(replaceWithEntityId, ReplaceWithState.NoChangeTraceLost.INSTANCE);
                parentsRef = null;
            }
            return parentsRef;
        }

        private final ParentsRef findAndReplaceRootEntity(WorkspaceEntityBase replaceWithEntity) {
            boolean bl2;
            long replaceWithEntityId = replaceWithEntity.getId();
            ReplaceWithState currentState = ReplaceBySourceAsTree.this.getReplaceWithState$intellij_platform_workspace_storage().get(replaceWithEntityId);
            boolean bl3 = bl2 = currentState == null;
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            MutableEntityStorageImpl mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage;
            if (mutableEntityStorageImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                mutableEntityStorageImpl = null;
            }
            AbstractEntityStorage abstractEntityStorage = mutableEntityStorageImpl;
            AbstractEntityStorage abstractEntityStorage2 = ReplaceBySourceAsTree.this.replaceWithStorage;
            if (abstractEntityStorage2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage2 = null;
            }
            WorkspaceEntity targetEntity = Companion.findRootEntityInStorage(replaceWithEntity, abstractEntityStorage, abstractEntityStorage2, ReplaceBySourceAsTree.this.getTargetState$intellij_platform_workspace_storage());
            Set<? extends ParentsRef> parents2 = null;
            return this.processExactEntity(targetEntity, replaceWithEntity, parents2);
        }

        private final ParentsRef processExactEntity(WorkspaceEntity targetEntity, WorkspaceEntityBase replaceWithEntity, Set<? extends ParentsRef> parents2) {
            Function1 function1;
            Function1 function12;
            Function1 function13;
            Function1 function14;
            long replaceWithEntityId = replaceWithEntity.getId();
            if (targetEntity == null) {
                ParentsRef parentsRef;
                Function1 function15 = ReplaceBySourceAsTree.this.entityFilter;
                if (function15 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function15 = null;
                }
                if (((Boolean)function15.invoke(replaceWithEntity.getEntitySource())).booleanValue()) {
                    this.addSubtree(parents2, replaceWithEntityId);
                    parentsRef = new ParentsRef.AddedElement(replaceWithEntityId);
                } else {
                    ReplaceBySourceAsTree.this.addState(replaceWithEntityId, ReplaceWithState.NoChangeTraceLost.INSTANCE);
                    parentsRef = null;
                }
                return parentsRef;
            }
            long targetEntityId = ((WorkspaceEntityBase)targetEntity).getId();
            ReplaceState targetCurrentState = ReplaceBySourceAsTree.this.getTargetState$intellij_platform_workspace_storage().get(targetEntityId);
            ReplaceState replaceState = targetCurrentState;
            if (replaceState instanceof ReplaceState.NoChange) {
                return new ParentsRef.TargetRef(targetEntityId);
            }
            if (replaceState instanceof ReplaceState.Relabel) {
                return new ParentsRef.TargetRef(targetEntityId);
            }
            if (Intrinsics.areEqual(replaceState, ReplaceState.Remove.INSTANCE)) {
                return null;
            }
            if (replaceState == null) {
                // empty if block
            }
            if ((function14 = ReplaceBySourceAsTree.this.entityFilter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                function14 = null;
            }
            if (((Boolean)function14.invoke(((WorkspaceEntityBase)targetEntity).getEntitySource())).booleanValue()) {
                Function1 function16 = ReplaceBySourceAsTree.this.entityFilter;
                if (function16 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function16 = null;
                }
                if (((Boolean)function16.invoke(replaceWithEntity.getEntitySource())).booleanValue()) {
                    if (!(replaceWithEntity.getEntitySource() instanceof DummyParentEntitySource)) {
                        ReplaceBySourceAsTree.this.replaceWorkspaceData(((WorkspaceEntityBase)targetEntity).getId(), replaceWithEntity.getId(), parents2, "ReplaceWithProcessor, process exact entity, both entities match filter");
                    } else {
                        ReplaceBySourceAsTree.this.doNothingOn(targetEntityId, replaceWithEntityId);
                    }
                    return new ParentsRef.TargetRef(targetEntityId);
                }
            }
            if ((function13 = ReplaceBySourceAsTree.this.entityFilter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                function13 = null;
            }
            if (((Boolean)function13.invoke(((WorkspaceEntityBase)targetEntity).getEntitySource())).booleanValue()) {
                Function1 function17 = ReplaceBySourceAsTree.this.entityFilter;
                if (function17 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function17 = null;
                }
                if (!((Boolean)function17.invoke(replaceWithEntity.getEntitySource())).booleanValue()) {
                    ReplaceBySourceAsTree.this.removeWorkspaceData(((WorkspaceEntityBase)targetEntity).getId(), replaceWithEntity.getId(), "ReplaceWithProcessor, Process exact entity, replaceWith entity doesn't match filter");
                    return null;
                }
            }
            if ((function12 = ReplaceBySourceAsTree.this.entityFilter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                function12 = null;
            }
            if (!((Boolean)function12.invoke(((WorkspaceEntityBase)targetEntity).getEntitySource())).booleanValue()) {
                Function1 function18 = ReplaceBySourceAsTree.this.entityFilter;
                if (function18 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function18 = null;
                }
                if (((Boolean)function18.invoke(replaceWithEntity.getEntitySource())).booleanValue()) {
                    ParentsRef parentsRef;
                    if (targetEntity instanceof WorkspaceEntityWithSymbolicId) {
                        if (!(replaceWithEntity.getEntitySource() instanceof DummyParentEntitySource)) {
                            ReplaceBySourceAsTree.this.replaceWorkspaceData(targetEntityId, replaceWithEntityId, parents2, "ReplaceWithProcessor, Process exact entity, target entity doesn't match filter");
                        } else {
                            ReplaceBySourceAsTree.this.doNothingOn(targetEntityId, replaceWithEntityId);
                        }
                        parentsRef = new ParentsRef.TargetRef(targetEntityId);
                    } else {
                        this.addSubtree(parents2, replaceWithEntityId);
                        parentsRef = new ParentsRef.AddedElement(replaceWithEntityId);
                    }
                    return parentsRef;
                }
            }
            if ((function1 = ReplaceBySourceAsTree.this.entityFilter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                function1 = null;
            }
            if (!((Boolean)function1.invoke(((WorkspaceEntityBase)targetEntity).getEntitySource())).booleanValue()) {
                Function1 function19 = ReplaceBySourceAsTree.this.entityFilter;
                if (function19 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function19 = null;
                }
                if (!((Boolean)function19.invoke(replaceWithEntity.getEntitySource())).booleanValue()) {
                    ReplaceBySourceAsTree.this.doNothingOn(((WorkspaceEntityBase)targetEntity).getId(), replaceWithEntityId);
                    return new ParentsRef.TargetRef(targetEntityId);
                }
            }
            throw new IllegalStateException("Unexpected branch".toString());
        }

        private final ParentsRef findAndReplaceRootEntityInTargetStore(WorkspaceEntityBase replaceWithRootEntity) {
            MutableEntityStorageImpl mutableEntityStorageImpl;
            long replaceRootEntityId = replaceWithRootEntity.getId();
            ReplaceWithState replaceWithCurrentState = ReplaceBySourceAsTree.this.getReplaceWithState$intellij_platform_workspace_storage().get(replaceRootEntityId);
            ReplaceWithState replaceWithState = replaceWithCurrentState;
            if (replaceWithState instanceof ReplaceWithState.NoChange) {
                return new ParentsRef.TargetRef(((ReplaceWithState.NoChange)replaceWithCurrentState).getTargetEntityId());
            }
            if (Intrinsics.areEqual(replaceWithState, ReplaceWithState.NoChangeTraceLost.INSTANCE)) {
                return null;
            }
            if (replaceWithState instanceof ReplaceWithState.Relabel) {
                return new ParentsRef.TargetRef(((ReplaceWithState.Relabel)replaceWithCurrentState).getTargetEntityId());
            }
            if (Intrinsics.areEqual(replaceWithState, ReplaceWithState.ElementMoved.INSTANCE)) {
                throw new NotImplementedError(null, 1, null);
            }
            if (replaceWithState == null) {
                // empty if block
            }
            if ((mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                mutableEntityStorageImpl = null;
            }
            AbstractEntityStorage abstractEntityStorage = mutableEntityStorageImpl;
            AbstractEntityStorage abstractEntityStorage2 = ReplaceBySourceAsTree.this.replaceWithStorage;
            if (abstractEntityStorage2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage2 = null;
            }
            WorkspaceEntity targetEntity = Companion.findRootEntityInStorage(replaceWithRootEntity, abstractEntityStorage, abstractEntityStorage2, ReplaceBySourceAsTree.this.getTargetState$intellij_platform_workspace_storage());
            return this.processExactEntity(targetEntity, replaceWithRootEntity, null);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final ParentsRef findSameEntityInTargetStore(@NotNull TrackToParents replaceWithTrack, @NotNull Set<Long> exceptTargetIds) {
            AbstractEntityStorage abstractEntityStorage;
            ReplaceWithState replaceWithCurrentState;
            Intrinsics.checkNotNullParameter(replaceWithTrack, "replaceWithTrack");
            Intrinsics.checkNotNullParameter(exceptTargetIds, "exceptTargetIds");
            ReplaceWithState replaceWithState = replaceWithCurrentState = ReplaceBySourceAsTree.this.getReplaceWithState$intellij_platform_workspace_storage().get(replaceWithTrack.getEntity());
            if (replaceWithState instanceof ReplaceWithState.NoChange) {
                return new ParentsRef.TargetRef(((ReplaceWithState.NoChange)replaceWithCurrentState).getTargetEntityId());
            }
            if (Intrinsics.areEqual(replaceWithState, ReplaceWithState.NoChangeTraceLost.INSTANCE)) {
                return null;
            }
            if (replaceWithState instanceof ReplaceWithState.Relabel) {
                return new ParentsRef.TargetRef(((ReplaceWithState.Relabel)replaceWithCurrentState).getTargetEntityId());
            }
            if (Intrinsics.areEqual(replaceWithState, ReplaceWithState.ElementMoved.INSTANCE)) {
                return new ParentsRef.AddedElement(replaceWithTrack.getEntity());
            }
            if (replaceWithState == null) {
                // empty if block
            }
            if ((abstractEntityStorage = ReplaceBySourceAsTree.this.replaceWithStorage) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage = null;
            }
            WorkspaceEntityData<? extends WorkspaceEntity> replaceWithEntityData = abstractEntityStorage.entityDataByIdOrDie$intellij_platform_workspace_storage(replaceWithTrack.getEntity());
            if (replaceWithTrack.getParents().isEmpty()) {
                AbstractEntityStorage abstractEntityStorage2 = ReplaceBySourceAsTree.this.replaceWithStorage;
                if (abstractEntityStorage2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    abstractEntityStorage2 = null;
                }
                WorkspaceEntity workspaceEntity = replaceWithEntityData.createEntity(abstractEntityStorage2);
                Intrinsics.checkNotNull(workspaceEntity, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase");
                return this.findAndReplaceRootEntityInTargetStore((WorkspaceEntityBase)workspaceEntity);
            }
            Iterable $this$associateWith$iv = replaceWithTrack.getParents();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                TrackToParents trackToParents = (TrackToParents)element$iv$iv;
                Object t2 = element$iv$iv;
                Map map2 = result$iv;
                boolean bl2 = false;
                ParentsRef parentsRef = ReplaceWithProcessor.findSameEntityInTargetStore$default(this, (TrackToParents)it, null, 2, null);
                map2.put(t2, parentsRef);
            }
            Map parentsAssociation = result$iv;
            List entriesList = CollectionsKt.toList(parentsAssociation.entrySet());
            boolean isNewParent = false;
            int n2 = entriesList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ParentsRef value = (ParentsRef)((Map.Entry)entriesList.get(i2)).getValue();
                if (value instanceof ParentsRef.TargetRef) {
                    WorkspaceEntityData targetEntityData = ReplaceBySourceAsTree.this.findEntityInTargetStore(replaceWithEntityData, ((ParentsRef.TargetRef)value).getTargetEntityId(), EntityIdKt.getClazz(replaceWithTrack.getEntity()), exceptTargetIds);
                    if (targetEntityData != null) {
                        long it = targetEntityData.createEntityId();
                        boolean bl3 = false;
                        return new ParentsRef.TargetRef(it);
                    }
                    isNewParent = true;
                    continue;
                }
                if (!(value instanceof ParentsRef.AddedElement)) continue;
                isNewParent = true;
            }
            return isNewParent ? (ParentsRef)new ParentsRef.AddedElement(replaceWithTrack.getEntity()) : null;
        }

        public static /* synthetic */ ParentsRef findSameEntityInTargetStore$default(ReplaceWithProcessor replaceWithProcessor, TrackToParents trackToParents, Set set, int n2, Object object) {
            if ((n2 & 2) != 0) {
                set = SetsKt.emptySet();
            }
            return replaceWithProcessor.findSameEntityInTargetStore(trackToParents, set);
        }

        /*
         * WARNING - void declaration
         */
        private final void addSubtree(Set<? extends ParentsRef> parents2, long replaceWithEntityId) {
            void $this$forEach$iv;
            ReplaceWithState currentState = ReplaceBySourceAsTree.this.getReplaceWithState$intellij_platform_workspace_storage().get(replaceWithEntityId);
            Object object = currentState;
            if (Intrinsics.areEqual(object, ReplaceWithState.ElementMoved.INSTANCE)) {
                return;
            }
            if (object instanceof ReplaceWithState.NoChange) {
                throw new IllegalStateException("Unexpected state".toString());
            }
            if (Intrinsics.areEqual(object, ReplaceWithState.NoChangeTraceLost.INSTANCE)) {
                throw new IllegalStateException("Unexpected state".toString());
            }
            if (object instanceof ReplaceWithState.Relabel) {
                throw new IllegalStateException("Unexpected state".toString());
            }
            if (object == null) {
                // empty if block
            }
            ReplaceBySourceAsTree.this.addElementOperation(parents2, replaceWithEntityId, "Adding a subtree for " + EntityIdKt.asString(replaceWithEntityId));
            AbstractEntityStorage abstractEntityStorage = ReplaceBySourceAsTree.this.replaceWithStorage;
            if (abstractEntityStorage == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage = null;
            }
            object = CollectionsKt.flatten((Iterable)abstractEntityStorage.getRefs$intellij_platform_workspace_storage().getChildrenRefsOfParentBy-42Q2mxQ(RefsTableKt.asParent(replaceWithEntityId)).values());
            ReplaceBySourceAsTree replaceBySourceAsTree = ReplaceBySourceAsTree.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapNotNullTo$iv$iv;
                TrackToParents trackToParents;
                ParentsRef sameEntity;
                long childEntityId = ((ChildEntityId)element$iv).unbox-impl();
                boolean bl2 = false;
                AbstractEntityStorage abstractEntityStorage2 = replaceBySourceAsTree.replaceWithStorage;
                if (abstractEntityStorage2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    abstractEntityStorage2 = null;
                }
                WorkspaceEntityData<? extends WorkspaceEntity> replaceWithChildEntityData = abstractEntityStorage2.entityDataByIdOrDie$intellij_platform_workspace_storage(childEntityId);
                Function1 function1 = replaceBySourceAsTree.entityFilter;
                if (function1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function1 = null;
                }
                if (!((Boolean)function1.invoke(replaceWithChildEntityData.getEntitySource())).booleanValue()) continue;
                AbstractEntityStorage abstractEntityStorage3 = replaceBySourceAsTree.replaceWithStorage;
                if (abstractEntityStorage3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    abstractEntityStorage3 = null;
                }
                if ((sameEntity = ReplaceWithProcessor.findSameEntityInTargetStore$default(this, trackToParents = new TrackToParents(childEntityId, abstractEntityStorage3), null, 2, null)) instanceof ParentsRef.TargetRef) continue;
                Iterable $this$mapNotNull$iv = trackToParents.getParents();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ParentsRef it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    TrackToParents it = (TrackToParents)element$iv$iv;
                    boolean bl4 = false;
                    if (ReplaceWithProcessor.findSameEntityInTargetStore$default(this, it, null, 2, null) == null) continue;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List otherParents = (List)destination$iv$iv;
                this.addSubtree(CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)otherParents, new ParentsRef.AddedElement(replaceWithEntityId))), childEntityId);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bJ?\u0010\u0011\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J4\u0010\u0018\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00192\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$TargetProcessor;", "", "(Lcom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree;)V", "findAndReplaceRootEntity", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "targetEntityData", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "(Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;)Ljava/lang/Long;", "findSameEntity", "targetEntityTrack", "Lcom/intellij/platform/workspace/storage/impl/TrackToParents;", "(Lcom/intellij/platform/workspace/storage/impl/TrackToParents;)Ljava/lang/Long;", "processEntity", "", "targetEntityToReplace", "processExactEntity", "targetParents", "", "Lcom/intellij/platform/workspace/storage/impl/ParentsRef;", "replaceWithEntity", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityBase;", "(Ljava/util/Set;Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityData;Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityBase;)Ljava/lang/Long;", "processParentsFromReplaceWithStorage", "Lkotlin/Pair;", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nReplaceBySourceAsTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$TargetProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1013:1\n1549#2:1014\n1620#2,3:1015\n1747#2,3:1018\n1271#2,2:1021\n1285#2,4:1023\n766#2:1037\n857#2,2:1038\n1549#2:1040\n1620#2,3:1041\n1855#2,2:1044\n1855#2,2:1047\n1549#2:1049\n1620#2,3:1050\n125#3:1027\n152#3,2:1028\n154#3:1046\n372#4,7:1030\n1#5:1053\n*S KotlinDebug\n*F\n+ 1 ReplaceBySourceAsTree.kt\ncom/intellij/platform/workspace/storage/impl/ReplaceBySourceAsTree$TargetProcessor\n*L\n590#1:1014\n590#1:1015,3\n596#1:1018,3\n690#1:1021,2\n690#1:1023,4\n701#1:1037\n701#1:1038,2\n702#1:1040\n702#1:1041,3\n706#1:1044,2\n714#1:1047,2\n730#1:1049\n730#1:1050,3\n691#1:1027\n691#1:1028,2\n691#1:1046\n694#1:1030,7\n*E\n"})
    private final class TargetProcessor {
        public final void processEntity(@NotNull WorkspaceEntity targetEntityToReplace) {
            Intrinsics.checkNotNullParameter(targetEntityToReplace, "targetEntityToReplace");
            WorkspaceEntityBase cfr_ignored_0 = (WorkspaceEntityBase)targetEntityToReplace;
            long l2 = ((WorkspaceEntityBase)targetEntityToReplace).getId();
            MutableEntityStorageImpl mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage;
            if (mutableEntityStorageImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                mutableEntityStorageImpl = null;
            }
            this.findSameEntity(new TrackToParents(l2, mutableEntityStorageImpl));
        }

        private final Long findSameEntity(TrackToParents targetEntityTrack) {
            Long l2;
            ReplaceState targetEntityState = ReplaceBySourceAsTree.this.getTargetState$intellij_platform_workspace_storage().get(targetEntityTrack.getEntity());
            if (targetEntityState != null) {
                Long l3;
                ReplaceState replaceState = targetEntityState;
                if (replaceState instanceof ReplaceState.NoChange) {
                    l3 = ((ReplaceState.NoChange)targetEntityState).getReplaceWithEntityId();
                } else if (replaceState instanceof ReplaceState.Relabel) {
                    l3 = ((ReplaceState.Relabel)targetEntityState).getReplaceWithEntityId();
                } else if (Intrinsics.areEqual(replaceState, ReplaceState.Remove.INSTANCE)) {
                    l3 = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return l3;
            }
            MutableEntityStorageImpl mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage;
            if (mutableEntityStorageImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                mutableEntityStorageImpl = null;
            }
            WorkspaceEntityData<? extends WorkspaceEntity> targetEntityData = mutableEntityStorageImpl.entityDataByIdOrDie$intellij_platform_workspace_storage(targetEntityTrack.getEntity());
            if (targetEntityTrack.getParents().isEmpty()) {
                l2 = this.findAndReplaceRootEntity(targetEntityData);
            } else {
                Pair<Set<ParentsRef>, WorkspaceEntityBase> pair = this.processParentsFromReplaceWithStorage(targetEntityTrack, targetEntityData);
                Set<ParentsRef> targetParents = pair.component1();
                WorkspaceEntityBase replaceWithEntity = pair.component2();
                l2 = this.processExactEntity(targetParents, targetEntityData, replaceWithEntity);
            }
            return l2;
        }

        /*
         * WARNING - void declaration
         */
        private final Long processExactEntity(Set<ParentsRef> targetParents, WorkspaceEntityData<? extends WorkspaceEntity> targetEntityData, WorkspaceEntityBase replaceWithEntity) {
            Function1 function1;
            Function1 function12;
            Function1 function13;
            MutableEntityStorageImpl mutableEntityStorageImpl;
            boolean requiredParentMissing;
            block37: {
                boolean bl2;
                if (targetParents != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = targetParents;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        int n2;
                        void it;
                        ParentsRef parentsRef = (ParentsRef)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        void var15_16 = it;
                        if (var15_16 instanceof ParentsRef.AddedElement) {
                            n2 = EntityIdKt.getClazz(((ParentsRef.AddedElement)it).getReplaceWithEntityId());
                        } else if (var15_16 instanceof ParentsRef.TargetRef) {
                            n2 = EntityIdKt.getClazz(((ParentsRef.TargetRef)it).getTargetEntityId());
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        collection.add(n2);
                    }
                    List targetParentClazzes = (List)destination$iv$iv;
                    Iterable $this$any$iv = targetEntityData.getRequiredParents();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Class it = (Class)element$iv;
                            boolean bl4 = false;
                            if (!(!targetParentClazzes.contains(ClassToIntConverterKt.toClassId(it)))) continue;
                            bl2 = true;
                            break block37;
                        }
                        bl2 = false;
                    }
                } else {
                    bl2 = requiredParentMissing = false;
                }
            }
            if ((mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                mutableEntityStorageImpl = null;
            }
            WorkspaceEntity workspaceEntity = targetEntityData.createEntity(mutableEntityStorageImpl);
            Intrinsics.checkNotNull(workspaceEntity, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase");
            WorkspaceEntityBase targetEntity = (WorkspaceEntityBase)workspaceEntity;
            if (replaceWithEntity == null || requiredParentMissing) {
                Long l2;
                boolean bl5;
                Function1 function14 = ReplaceBySourceAsTree.this.entityFilter;
                if (function14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function14 = null;
                }
                if (bl5 = ((Boolean)function14.invoke(targetEntity.getEntitySource())).booleanValue()) {
                    ReplaceBySourceAsTree.this.removeWorkspaceData(targetEntity.getId(), null, "Remove entity, can't find entity in replaceWith");
                    l2 = null;
                } else if (!bl5) {
                    ReplaceBySourceAsTree.this.doNothingOn(targetEntity.getId(), null);
                    l2 = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return l2;
            }
            Function1 function15 = ReplaceBySourceAsTree.this.entityFilter;
            if (function15 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                function15 = null;
            }
            if (((Boolean)function15.invoke(targetEntity.getEntitySource())).booleanValue()) {
                Function1 function16 = ReplaceBySourceAsTree.this.entityFilter;
                if (function16 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function16 = null;
                }
                if (((Boolean)function16.invoke(replaceWithEntity.getEntitySource())).booleanValue()) {
                    if (!(replaceWithEntity.getEntitySource() instanceof DummyParentEntitySource)) {
                        ReplaceBySourceAsTree.this.replaceWorkspaceData(targetEntity.getId(), replaceWithEntity.getId(), targetParents, "TargetProcessor, process exact entity, both entities match filter");
                    } else {
                        ReplaceBySourceAsTree.this.doNothingOn(targetEntity.getId(), replaceWithEntity.getId());
                    }
                    return replaceWithEntity.getId();
                }
            }
            if ((function13 = ReplaceBySourceAsTree.this.entityFilter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                function13 = null;
            }
            if (((Boolean)function13.invoke(targetEntity.getEntitySource())).booleanValue()) {
                Function1 function17 = ReplaceBySourceAsTree.this.entityFilter;
                if (function17 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function17 = null;
                }
                if (!((Boolean)function17.invoke(replaceWithEntity.getEntitySource())).booleanValue()) {
                    ReplaceBySourceAsTree.this.removeWorkspaceData(targetEntity.getId(), replaceWithEntity.getId(), "TargetProcessor, process exact entity, replaceWith entity doesn't match filter");
                    return null;
                }
            }
            if ((function12 = ReplaceBySourceAsTree.this.entityFilter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                function12 = null;
            }
            if (!((Boolean)function12.invoke(targetEntity.getEntitySource())).booleanValue()) {
                Function1 function18 = ReplaceBySourceAsTree.this.entityFilter;
                if (function18 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function18 = null;
                }
                if (((Boolean)function18.invoke(replaceWithEntity.getEntitySource())).booleanValue()) {
                    if (!(replaceWithEntity.getEntitySource() instanceof DummyParentEntitySource)) {
                        ReplaceBySourceAsTree.this.replaceWorkspaceData(targetEntity.getId(), replaceWithEntity.getId(), targetParents, "TargetProcessor, process exact entity, target entity doesn't match filter");
                    } else {
                        ReplaceBySourceAsTree.this.doNothingOn(targetEntity.getId(), replaceWithEntity.getId());
                    }
                    return replaceWithEntity.getId();
                }
            }
            if ((function1 = ReplaceBySourceAsTree.this.entityFilter) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                function1 = null;
            }
            if (!((Boolean)function1.invoke(targetEntity.getEntitySource())).booleanValue()) {
                Function1 function19 = ReplaceBySourceAsTree.this.entityFilter;
                if (function19 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityFilter");
                    function19 = null;
                }
                if (!((Boolean)function19.invoke(replaceWithEntity.getEntitySource())).booleanValue()) {
                    ReplaceBySourceAsTree.this.doNothingOn(targetEntity.getId(), replaceWithEntity.getId());
                    return replaceWithEntity.getId();
                }
            }
            throw new IllegalStateException("Unexpected branch".toString());
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private final Pair<Set<ParentsRef>, WorkspaceEntityBase> processParentsFromReplaceWithStorage(TrackToParents targetEntityTrack, WorkspaceEntityData<? extends WorkspaceEntity> targetEntityData) {
            block20: {
                block19: {
                    targetParents = new LinkedHashSet<E>();
                    v0 = ReplaceBySourceAsTree.access$getTargetStorage$p(ReplaceBySourceAsTree.this);
                    if (v0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                        v0 = null;
                    }
                    targetEntity = targetEntityData.createEntity(v0);
                    replaceWithEntity = null;
                    if (!(targetEntity instanceof WorkspaceEntityWithSymbolicId)) break block19;
                    v1 = ReplaceBySourceAsTree.access$getReplaceWithStorage$p(ReplaceBySourceAsTree.this);
                    if (v1 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                        v1 = null;
                    }
                    replaceWithEntity = (var6_6 = v1.resolve(((WorkspaceEntityWithSymbolicId)targetEntity).getSymbolicId())) instanceof WorkspaceEntityBase != false ? (WorkspaceEntityBase)var6_6 : null;
                    break block20;
                }
                replaceWithParentsCounter = new HashMap<K, V>();
                $this$associateWith$iv = targetEntityTrack.getParents();
                $i$f$associateWith = false;
                result$iv = new LinkedHashMap<K, V>(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
                $this$associateWithTo$iv$iv = $this$associateWith$iv;
                $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    var15_30 = (TrackToParents)element$iv$iv;
                    var38_25 = element$iv$iv;
                    var37_24 = result$iv;
                    $i$a$-associateWith-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$1 = false;
                    var39_26 = this.findSameEntity((TrackToParents)it);
                    var37_24.put(var38_25, var39_26);
                }
                $this$associateWith$iv = result$iv;
                $i$f$associateWith = ReplaceBySourceAsTree.this;
                $i$f$map = false;
                $this$associateWithTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                $i$f$mapTo = false;
                element$iv$iv = $this$mapTo$iv$iv.entrySet().iterator();
                while (element$iv$iv.hasNext()) {
                    $i$a$-associateWith-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$1 = item$iv$iv = (Map.Entry)element$iv$iv.next();
                    var37_24 = destination$iv$iv;
                    $i$a$-map-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$2 = false;
                    targetParent = (TrackToParents)$i$a$-associateWith-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$1.getKey();
                    replaceWithParent = (Long)$i$a$-associateWith-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$1.getValue();
                    var20_39 = ReplaceBySourceAsTree.access$getReplaceWithParentToChildrenCache$p((ReplaceBySourceAsTree)$i$f$associateWith);
                    var21_40 = TuplesKt.to(replaceWithParent, EntityIdKt.getClazz(targetEntityTrack.getEntity()));
                    $i$f$getOrPut = false;
                    value$iv /* !! */  = $this$getOrPut$iv.get(key$iv);
                    if (value$iv /* !! */  == null) {
                        $i$a$-getOrPut-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$2$replaceWithChildrenOfParent$1 = false;
                        answer$iv = ReplaceBySourceAsTree.access$childrenInReplaceWith((ReplaceBySourceAsTree)$i$f$associateWith, replaceWithParent, EntityIdKt.getClazz(targetEntityTrack.getEntity()));
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        v2 /* !! */  = answer$iv;
                    } else {
                        v2 /* !! */  = value$iv /* !! */ ;
                    }
                    if ((mutableListOfEqualEntities = (List)(replaceWithChildrenOfParent = (Map)v2 /* !! */ ).get(targetEntityData)) == null) ** GOTO lbl-1000
                    value$iv /* !! */  = mutableListOfEqualEntities;
                    $i$f$filter = false;
                    answer$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (WorkspaceEntityData)element$iv$iv;
                        $i$a$-filter-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$2$replaceWithChildrenOptions$1 = false;
                        if (!($i$f$associateWith.getReplaceWithState$intellij_platform_workspace_storage().get(it.createEntityId()) == null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $i$f$filter = (List)destination$iv$iv;
                    $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (E item$iv$iv : $this$mapTo$iv$iv) {
                        $i$a$-filter-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$2$replaceWithChildrenOptions$1 = (WorkspaceEntityData)item$iv$iv;
                        var33_62 = destination$iv$iv;
                        $i$a$-map-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$2$replaceWithChildrenOptions$2 = false;
                        var33_62.add(it.createEntityId());
                    }
                    var24_47 = CollectionsKt.toSet((List)destination$iv$iv);
                    if (var24_47 != null) {
                        v3 = var24_47;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = SetsKt.emptySet();
                    }
                    replaceWithChildrenOptions = v3;
                    $this$forEach$iv = replaceWithChildrenOptions;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        replaceWithChildOption = ((Number)element$iv).longValue();
                        $i$a$-forEach-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$parentAssociationsWithChildren$2$1 = false;
                        var30_57 = replaceWithParentsCounter;
                        var31_58 = replaceWithChildOption;
                        v4 = (Integer)replaceWithParentsCounter.get(replaceWithChildOption);
                        if (v4 == null) {
                            v4 = 0;
                        }
                        var32_61 = v4 + 1;
                        var30_57.put(var31_58, var32_61);
                    }
                    var37_24.add(new Triple<TrackToParents, Set<T>, List>(targetParent, replaceWithChildrenOptions, mutableListOfEqualEntities));
                }
                parentAssociationsWithChildren = (List)destination$iv$iv;
                $i$f$associateWith = ReplaceBySourceAsTreeKt.access$withMaxValue(replaceWithParentsCounter);
                v5 = mostCommonReplaceWithChildId = $i$f$associateWith != null && ($i$f$map = ReplaceBySourceAsTree.access$maybeShuffled(ReplaceBySourceAsTree.this, (List)$i$f$associateWith)) != null && ($this$mapTo$iv$iv = (Map.Entry)CollectionsKt.firstOrNull($i$f$map)) != null ? (Long)$this$mapTo$iv$iv.getKey() : null;
                if (mostCommonReplaceWithChildId != null) {
                    $this$forEach$iv = parentAssociationsWithChildren;
                    $i$f$forEach = false;
                    $this$mapTo$iv$iv = $this$forEach$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        element$iv = $this$mapTo$iv$iv.next();
                        var13_22 = (Triple)element$iv;
                        $i$a$-forEach-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$1 = false;
                        targetParent = (TrackToParents)var13_22.component1();
                        replaceWithChildren = (Set)var13_22.component2();
                        replaceWithSimilarEntityData = (List)var13_22.component3();
                        if (!replaceWithChildren.contains(mostCommonReplaceWithChildId)) continue;
                        ((Collection)targetParents).add(new ParentsRef.TargetRef(targetParent.getEntity()));
                        v6 = replaceWithSimilarEntityData;
                        if (v6 == null) continue;
                        v6.removeIf((Predicate<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, processParentsFromReplaceWithStorage$lambda$9$lambda$8(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Z)((Function1)new Function1<WorkspaceEntityData<? extends WorkspaceEntity>, Boolean>(mostCommonReplaceWithChildId){
                            final /* synthetic */ Long $mostCommonReplaceWithChildId;
                            {
                                this.$mostCommonReplaceWithChildId = $mostCommonReplaceWithChildId;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull WorkspaceEntityData<? extends WorkspaceEntity> it) {
                                Intrinsics.checkNotNullParameter(it, "it");
                                return it.getId() == EntityIdKt.getArrayId(this.$mostCommonReplaceWithChildId);
                            }
                        }));
                    }
                    v7 = ReplaceBySourceAsTree.access$getReplaceWithStorage$p(ReplaceBySourceAsTree.this);
                    if (v7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                        v7 = null;
                    }
                    v8 = v7.entityDataByIdOrDie$intellij_platform_workspace_storage(mostCommonReplaceWithChildId);
                    v9 = ReplaceBySourceAsTree.access$getReplaceWithStorage$p(ReplaceBySourceAsTree.this);
                    if (v9 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                        v9 = null;
                    }
                    $this$forEach$iv = v8.createEntity(v9);
                    Intrinsics.checkNotNull($this$forEach$iv, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase");
                    replaceWithEntity = (WorkspaceEntityBase)$this$forEach$iv;
                }
            }
            if (replaceWithEntity != null) {
                v10 = replaceWithEntity.getId();
                v11 = ReplaceBySourceAsTree.access$getReplaceWithStorage$p(ReplaceBySourceAsTree.this);
                if (v11 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                    v11 = null;
                }
                parentAssociationsWithChildren = new TrackToParents(v10, v11).getParents();
                var8_7 = ReplaceBySourceAsTree.this;
                $i$f$map = false;
                $i$f$forEach = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    targetParent = (TrackToParents)item$iv$iv;
                    var37_24 = destination$iv$iv;
                    $i$a$-map-ReplaceBySourceAsTree$TargetProcessor$processParentsFromReplaceWithStorage$alsoTargetParents$1 = false;
                    var37_24.add(var8_7.new ReplaceWithProcessor().findSameEntityInTargetStore((TrackToParents)it, SetsKt.setOf(targetEntityData.createEntityId())));
                }
                alsoTargetParents = (List)destination$iv$iv;
                targetParents.addAll((Collection)CollectionsKt.filterNotNull(alsoTargetParents));
            }
            return new Pair<Set<ParentsRef>, WorkspaceEntityBase>(targetParents, replaceWithEntity);
        }

        @Nullable
        public final Long findAndReplaceRootEntity(@NotNull WorkspaceEntityData<? extends WorkspaceEntity> targetEntityData) {
            WorkspaceEntity workspaceEntity;
            MutableEntityStorageImpl mutableEntityStorageImpl;
            boolean bl2;
            Intrinsics.checkNotNullParameter(targetEntityData, "targetEntityData");
            long targetRootEntityId = targetEntityData.createEntityId();
            ReplaceState currentTargetState = ReplaceBySourceAsTree.this.getTargetState$intellij_platform_workspace_storage().get(targetRootEntityId);
            boolean bl3 = bl2 = currentTargetState == null;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string2 = "This state was already checked before this function";
                throw new AssertionError((Object)string2);
            }
            MutableEntityStorageImpl mutableEntityStorageImpl2 = ReplaceBySourceAsTree.this.targetStorage;
            if (mutableEntityStorageImpl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                mutableEntityStorageImpl2 = null;
            }
            WorkspaceEntity workspaceEntity2 = targetEntityData.createEntity(mutableEntityStorageImpl2);
            Intrinsics.checkNotNull(workspaceEntity2, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase");
            WorkspaceEntityBase workspaceEntityBase = (WorkspaceEntityBase)workspaceEntity2;
            AbstractEntityStorage abstractEntityStorage = ReplaceBySourceAsTree.this.replaceWithStorage;
            if (abstractEntityStorage == null) {
                Intrinsics.throwUninitializedPropertyAccessException("replaceWithStorage");
                abstractEntityStorage = null;
            }
            if ((mutableEntityStorageImpl = ReplaceBySourceAsTree.this.targetStorage) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("targetStorage");
                mutableEntityStorageImpl = null;
            }
            WorkspaceEntityBase replaceWithEntity = (workspaceEntity = Companion.findRootEntityInStorage(workspaceEntityBase, abstractEntityStorage, mutableEntityStorageImpl, ReplaceBySourceAsTree.this.getReplaceWithState$intellij_platform_workspace_storage())) instanceof WorkspaceEntityBase ? (WorkspaceEntityBase)workspaceEntity : null;
            return this.processExactEntity(null, targetEntityData, replaceWithEntity);
        }

        private static final boolean processParentsFromReplaceWithStorage$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

