/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.ClassToIntConverterKt;
import com.intellij.platform.workspace.storage.impl.ConnectionId;
import com.intellij.platform.workspace.storage.impl.EntitiesKt;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.MutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.NotThisEntityId;
import com.intellij.platform.workspace.storage.impl.RefsTableKt;
import com.intellij.platform.workspace.storage.impl.ThisEntityId;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.instrumentation.Modification;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a(\u0010\u0005\u001a\u00020\u00062\n\u0010\t\u001a\u00060\u000ej\u0002`\u000f2\n\u0010\u000b\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\nH\u0000\u001a\u001c\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0000\u001a\u0015\u0010\u001b\u001a\u00020\u001c*\u00060\u000ej\u0002`\u000fH\u0000\u00a2\u0006\u0002\u0010\u001d\u001a\"\u0010\u001e\u001a\u00020\u0006*\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0015\u0010#\u001a\u00020$*\u00060\u000ej\u0002`\u000fH\u0000\u00a2\u0006\u0002\u0010\u001d\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006%"}, d2={"mutable", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "Lcom/intellij/platform/workspace/storage/EntityStorage;", "getMutable", "(Lcom/intellij/platform/workspace/storage/EntityStorage;)Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "checkCircularDependency", "", "connectionId", "Lcom/intellij/platform/workspace/storage/impl/ConnectionId;", "childId", "", "parentId", "storage", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "currentStackTrace", "", "depth", "loadClassByName", "Ljava/lang/Class;", "name", "classLoader", "Ljava/lang/ClassLoader;", "asBase", "Lcom/intellij/platform/workspace/storage/impl/WorkspaceEntityBase;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "asThis", "Lcom/intellij/platform/workspace/storage/impl/ThisEntityId;", "(J)J", "createReplaceEventsForUpdates", "Lcom/intellij/platform/workspace/storage/impl/MutableEntityStorageImpl;", "updates", "", "Lcom/intellij/platform/workspace/storage/instrumentation/Modification;", "notThis", "Lcom/intellij/platform/workspace/storage/impl/NotThisEntityId;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/intellij/platform/workspace/storage/impl/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1855#2,2:91\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/intellij/platform/workspace/storage/impl/UtilsKt\n*L\n75#1:91,2\n*E\n"})
public final class UtilsKt {
    public static final long asThis(long $this$asThis) {
        return ThisEntityId.constructor-impl($this$asThis);
    }

    public static final long notThis(long $this$notThis) {
        return NotThisEntityId.constructor-impl($this$notThis);
    }

    @NotNull
    public static final String currentStackTrace(int depth) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "getStackTrace(...)");
        return CollectionsKt.joinToString$default(ArraysKt.take((Object[])stackTraceElementArray, depth), "\n", null, null, 0, null, currentStackTrace.1.INSTANCE, 30, null);
    }

    @NotNull
    public static final Class<?> loadClassByName(@NotNull String name2, @NotNull ClassLoader classLoader2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(classLoader2, "classLoader");
        if (StringsKt.startsWith$default(name2, "[", false, 2, null)) {
            Class<?> clazz = Class.forName(name2);
            Intrinsics.checkNotNullExpressionValue(clazz, "forName(...)");
            return clazz;
        }
        Class<?> clazz = classLoader2.loadClass(name2);
        Intrinsics.checkNotNullExpressionValue(clazz, "loadClass(...)");
        return clazz;
    }

    public static final void checkCircularDependency(@NotNull ConnectionId connectionId, int childId, int parentId, @NotNull AbstractEntityStorage storage) {
        Intrinsics.checkNotNullParameter(connectionId, "connectionId");
        Intrinsics.checkNotNullParameter(storage, "storage");
        if (connectionId.getParentClass() == connectionId.getChildClass() && childId == parentId) {
            long parentEntityId = EntityIdKt.createEntityId(parentId, connectionId.getParentClass());
            WorkspaceEntityData<? extends WorkspaceEntity> entityData = storage.entityDataByIdOrDie$intellij_platform_workspace_storage(parentEntityId);
            SymbolicEntityId<?> symbolicEntityId = EntitiesKt.symbolicId(entityData);
            if (symbolicEntityId == null || (symbolicEntityId = ((Object)symbolicEntityId).toString()) == null) {
                symbolicEntityId = entityData.toString();
            }
            SymbolicEntityId<?> entityPresentation = symbolicEntityId;
            throw new IllegalStateException(StringsKt.trimMargin$default("Trying to make a circular dependency in entities by setting an entity as a child of itself.\n          |Entity class: " + ClassToIntConverterKt.findWorkspaceEntity(connectionId.getParentClass()) + "\n          |Entity: " + (String)((Object)entityPresentation) + "\n        ", null, 1, null).toString());
        }
    }

    public static final void checkCircularDependency(long childId, long parentId, @NotNull AbstractEntityStorage storage) {
        Intrinsics.checkNotNullParameter(storage, "storage");
        if (childId == parentId) {
            WorkspaceEntityData<? extends WorkspaceEntity> entityData = storage.entityDataByIdOrDie$intellij_platform_workspace_storage(parentId);
            SymbolicEntityId<?> symbolicEntityId = EntitiesKt.symbolicId(entityData);
            if (symbolicEntityId == null || (symbolicEntityId = ((Object)symbolicEntityId).toString()) == null) {
                symbolicEntityId = entityData.toString();
            }
            SymbolicEntityId<?> entityPresentation = symbolicEntityId;
            throw new IllegalStateException(StringsKt.trimMargin$default("Trying to make a circular dependency in entities by setting an entity as a child of itself.\n          |Entity class: " + ClassToIntConverterKt.findWorkspaceEntity(EntityIdKt.getClazz(parentId)) + "\n          |Entity: " + (String)((Object)entityPresentation) + "\n        ", null, 1, null).toString());
        }
    }

    @NotNull
    public static final WorkspaceEntityBase asBase(@NotNull WorkspaceEntity $this$asBase) {
        Intrinsics.checkNotNullParameter($this$asBase, "<this>");
        return (WorkspaceEntityBase)$this$asBase;
    }

    @NotNull
    public static final MutableEntityStorage getMutable(@NotNull EntityStorage $this$mutable) {
        Intrinsics.checkNotNullParameter($this$mutable, "<this>");
        return (MutableEntityStorage)$this$mutable;
    }

    public static final void createReplaceEventsForUpdates(@NotNull MutableEntityStorageImpl $this$createReplaceEventsForUpdates, @NotNull Collection<? extends Modification> updates, @NotNull ConnectionId connectionId) {
        Intrinsics.checkNotNullParameter($this$createReplaceEventsForUpdates, "<this>");
        Intrinsics.checkNotNullParameter(updates, "updates");
        Intrinsics.checkNotNullParameter(connectionId, "connectionId");
        Iterable $this$forEach$iv = updates;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Modification update = (Modification)element$iv;
            boolean bl2 = false;
            Modification modification = update;
            if (modification instanceof Modification.Add) {
                $this$createReplaceEventsForUpdates.getChangeLog$intellij_platform_workspace_storage().addReplaceEventForNewChild-FRG0QjY$intellij_platform_workspace_storage(((Modification.Add)update).getParent(), connectionId, RefsTableKt.asChild(((Modification.Add)update).getChild()), true);
                $this$createReplaceEventsForUpdates.getChangeLog$intellij_platform_workspace_storage().addReplaceEventForNewParent-KZzBy_s$intellij_platform_workspace_storage(((Modification.Add)update).getChild(), connectionId, RefsTableKt.asParent(((Modification.Add)update).getParent()), false);
                continue;
            }
            if (!(modification instanceof Modification.Remove)) continue;
            $this$createReplaceEventsForUpdates.getChangeLog$intellij_platform_workspace_storage().addReplaceEventForRemovedChild-FRG0QjY$intellij_platform_workspace_storage(((Modification.Remove)update).getParent(), connectionId, RefsTableKt.asChild(((Modification.Remove)update).getChild()), true);
            $this$createReplaceEventsForUpdates.getChangeLog$intellij_platform_workspace_storage().addReplaceEventForRemovedParent-KZzBy_s$intellij_platform_workspace_storage(((Modification.Remove)update).getChild(), connectionId, RefsTableKt.asParent(((Modification.Remove)update).getParent()), false);
        }
    }
}

