/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.diagnostic.telemetry.helpers.Nanoseconds;
import com.intellij.platform.diagnostic.telemetry.helpers.NanosecondsMeasurer;
import com.intellij.platform.workspace.storage.CachedValue;
import com.intellij.platform.workspace.storage.CachedValueWithParameter;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u00052\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ;\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\n0\b2\u0006\u0010\u0010\u001a\u0002H\u000f2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0011J\u001a\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\u0005J3\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u000f\"\u0004\b\u0001\u0010\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\n0\b2\u0006\u0010\u0010\u001a\u0002H\u000f\u00a2\u0006\u0002\u0010\u0014R \u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0006\u001a\"\u0012\u0016\u0012\u0014\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u0012\u0002\b\u00030\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ValuesCache;", "", "()V", "cachedValues", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/intellij/platform/workspace/storage/CachedValue;", "cachedValuesWithParameter", "Lkotlin/Pair;", "Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;", "cachedValue", "R", "value", "storage", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "(Lcom/intellij/platform/workspace/storage/CachedValue;Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;)Ljava/lang/Object;", "P", "parameter", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;)Ljava/lang/Object;", "clearCachedValue", "", "(Lcom/intellij/platform/workspace/storage/CachedValueWithParameter;Ljava/lang/Object;)V", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nVersionedEntityStorageImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionedEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/ValuesCache\n+ 2 NanosecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/NanosecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n43#2,2:277\n45#2:285\n43#2,2:287\n45#2:295\n43#2,2:296\n45#2:304\n43#2,2:305\n45#2:313\n31#3,6:279\n31#3,6:289\n31#3,6:298\n31#3,6:307\n1#4:286\n*S KotlinDebug\n*F\n+ 1 VersionedEntityStorageImpl.kt\ncom/intellij/platform/workspace/storage/impl/ValuesCache\n*L\n34#1:277,2\n34#1:285\n55#1:287,2\n55#1:295\n65#1:296,2\n65#1:304\n69#1:305,2\n69#1:313\n34#1:279,6\n55#1:289,6\n65#1:298,6\n69#1:307,6\n*E\n"})
final class ValuesCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<CachedValue<?>, Object> cachedValues;
    @NotNull
    private final Cache<Pair<CachedValueWithParameter<?, ?>, ?>, Object> cachedValuesWithParameter;
    @NotNull
    private static final AtomicLong cachedValueFromCacheNanosec = NanosecondsMeasurer.constructor-impl$default(null, 1, null);
    @NotNull
    private static final AtomicLong cachedValueCalculatedNanosec = NanosecondsMeasurer.constructor-impl$default(null, 1, null);
    @NotNull
    private static final AtomicLong cachedValueWithParametersFromCacheNanosec = NanosecondsMeasurer.constructor-impl$default(null, 1, null);
    @NotNull
    private static final AtomicLong cachedValueWithParametersCalculatedNanosec = NanosecondsMeasurer.constructor-impl$default(null, 1, null);
    @NotNull
    private static final AtomicLong cachedValueClearNanosec = NanosecondsMeasurer.constructor-impl$default(null, 1, null);
    @NotNull
    private static final AtomicLong cachedValueWithParametersClearNanosec = NanosecondsMeasurer.constructor-impl$default(null, 1, null);

    public ValuesCache() {
        Cache cache2 = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue(cache2, "build(...)");
        this.cachedValues = cache2;
        Cache cache3 = Caffeine.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue(cache3, "build(...)");
        this.cachedValuesWithParameter = cache3;
    }

    public final <R> R cachedValue(@NotNull CachedValue<R> value, @NotNull ImmutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(storage, "storage");
        long start = Nanoseconds.Companion.now-LxeuWQM();
        Object o2 = this.cachedValues.getIfPresent(value);
        Object valueToReturn = null;
        if (o2 != null) {
            valueToReturn = o2;
            NanosecondsMeasurer.addElapsedTime-D2aE-ow(cachedValueFromCacheNanosec, start);
        } else {
            AtomicLong arg0$iv = cachedValueCalculatedNanosec;
            boolean bl2 = false;
            Unit value$iv = null;
            boolean $i$f$measureNanoTime = false;
            long start$iv$iv = System.nanoTime();
            AtomicLong atomicLong = arg0$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            R r2 = value.getSource().invoke(storage);
            Intrinsics.checkNotNull(r2);
            valueToReturn = r2;
            this.cachedValues.put(value, valueToReturn);
            value$iv = Unit.INSTANCE;
            atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
        }
        Object object = valueToReturn;
        if (object == null) {
            boolean bl5 = false;
            String string2 = "Cached value must not be null";
            throw new IllegalArgumentException(string2.toString());
        }
        return (R)object;
    }

    public final <P, R> R cachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter, @NotNull ImmutableEntityStorage storage) {
        Intrinsics.checkNotNullParameter(value, "value");
        Intrinsics.checkNotNullParameter(storage, "storage");
        long start = Nanoseconds.Companion.now-LxeuWQM();
        Object o2 = this.cachedValuesWithParameter.getIfPresent(TuplesKt.to(value, parameter));
        Object valueToReturn = null;
        if (o2 != null) {
            valueToReturn = o2;
            NanosecondsMeasurer.addElapsedTime-D2aE-ow(cachedValueWithParametersFromCacheNanosec, start);
        } else {
            AtomicLong arg0$iv = cachedValueWithParametersCalculatedNanosec;
            boolean bl2 = false;
            Unit value$iv = null;
            boolean $i$f$measureNanoTime = false;
            long start$iv$iv = System.nanoTime();
            AtomicLong atomicLong = arg0$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            R r2 = value.getSource().invoke(storage, parameter);
            Intrinsics.checkNotNull(r2);
            valueToReturn = r2;
            this.cachedValuesWithParameter.put(TuplesKt.to(value, parameter), valueToReturn);
            value$iv = Unit.INSTANCE;
            atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
        }
        Object object = valueToReturn;
        if (object == null) {
            boolean bl5 = false;
            String string2 = "Cached value with parameter must not be null";
            throw new IllegalArgumentException(string2.toString());
        }
        return (R)object;
    }

    public final <R> void clearCachedValue(@NotNull CachedValue<R> value) {
        Intrinsics.checkNotNullParameter(value, "value");
        AtomicLong arg0$iv = cachedValueClearNanosec;
        boolean bl2 = false;
        Unit value$iv = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv$iv = System.nanoTime();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        this.cachedValues.invalidate(value);
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
    }

    public final <P, R> void clearCachedValue(@NotNull CachedValueWithParameter<P, R> value, P parameter) {
        Intrinsics.checkNotNullParameter(value, "value");
        AtomicLong arg0$iv = cachedValueWithParametersClearNanosec;
        boolean bl2 = false;
        Unit value$iv = null;
        boolean $i$f$measureNanoTime = false;
        long start$iv$iv = System.nanoTime();
        AtomicLong atomicLong = arg0$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        this.cachedValuesWithParameter.invalidate(TuplesKt.to(value, parameter));
        value$iv = Unit.INSTANCE;
        atomicLong.addAndGet(System.nanoTime() - start$iv$iv);
    }

    static {
        ValuesCache.Companion.setupOpenTelemetryReporting(TelemetryManager.Companion.getMeter(PlatformScopesKt.WorkspaceModel));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0016\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/workspace/storage/impl/ValuesCache$Companion;", "", "()V", "cachedValueCalculatedNanosec", "Lcom/intellij/platform/diagnostic/telemetry/helpers/NanosecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "cachedValueClearNanosec", "cachedValueFromCacheNanosec", "cachedValueWithParametersCalculatedNanosec", "cachedValueWithParametersClearNanosec", "cachedValueWithParametersFromCacheNanosec", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement cachedValueFromCacheCounter = meter.counterBuilder("workspaceModel.cachedValue.from.cache.ms").buildObserver();
            ObservableLongMeasurement cachedValueCalculatedCounter = meter.counterBuilder("workspaceModel.cachedValue.calculated.ms").buildObserver();
            ObservableLongMeasurement cachedValueTotalCounter = meter.counterBuilder("workspaceModel.cachedValue.total.get.ms").buildObserver();
            ObservableLongMeasurement cachedValueWithParametersFromCacheCounter = meter.counterBuilder("workspaceModel.cachedValueWithParameters.from.cache.ms").buildObserver();
            ObservableLongMeasurement cachedValueWithParametersCalculatedCounter = meter.counterBuilder("workspaceModel.cachedValueWithParameters.calculated.ms").buildObserver();
            ObservableLongMeasurement cachedValueWithParametersTotalCounter = meter.counterBuilder("workspaceModel.cachedValueWithParameters.total.get.ms").buildObserver();
            ObservableLongMeasurement cachedValueClearCounter = meter.counterBuilder("workspaceModel.cachedValue.clear.ms").buildObserver();
            ObservableLongMeasurement cachedValueWithParametersClearCounter = meter.counterBuilder("workspaceModel.cachedValueWithParameters.clear.ms").buildObserver();
            ObservableMeasurement[] observableMeasurementArray = new ObservableMeasurement[]{cachedValueCalculatedCounter, cachedValueTotalCounter, cachedValueWithParametersFromCacheCounter, cachedValueWithParametersCalculatedCounter, cachedValueWithParametersTotalCounter, cachedValueClearCounter, cachedValueWithParametersClearCounter};
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(cachedValueFromCacheCounter, cachedValueCalculatedCounter, cachedValueTotalCounter, cachedValueWithParametersFromCacheCounter, cachedValueWithParametersCalculatedCounter, cachedValueWithParametersTotalCounter, cachedValueClearCounter, cachedValueWithParametersClearCounter), cachedValueFromCacheCounter, observableMeasurementArray);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $cachedValueFromCacheCounter, ObservableLongMeasurement $cachedValueCalculatedCounter, ObservableLongMeasurement $cachedValueTotalCounter, ObservableLongMeasurement $cachedValueWithParametersFromCacheCounter, ObservableLongMeasurement $cachedValueWithParametersCalculatedCounter, ObservableLongMeasurement $cachedValueWithParametersTotalCounter, ObservableLongMeasurement $cachedValueClearCounter, ObservableLongMeasurement $cachedValueWithParametersClearCounter) {
            $cachedValueFromCacheCounter.record(NanosecondsMeasurer.asMilliseconds-impl(cachedValueFromCacheNanosec));
            $cachedValueCalculatedCounter.record(NanosecondsMeasurer.asMilliseconds-impl(cachedValueCalculatedNanosec));
            $cachedValueTotalCounter.record(NanosecondsMeasurer.asMilliseconds-impl(cachedValueFromCacheNanosec) + NanosecondsMeasurer.asMilliseconds-impl(cachedValueCalculatedNanosec));
            $cachedValueWithParametersFromCacheCounter.record(NanosecondsMeasurer.asMilliseconds-impl(cachedValueWithParametersFromCacheNanosec));
            $cachedValueWithParametersCalculatedCounter.record(NanosecondsMeasurer.asMilliseconds-impl(cachedValueWithParametersCalculatedNanosec));
            $cachedValueWithParametersTotalCounter.record(NanosecondsMeasurer.asMilliseconds-impl(cachedValueWithParametersFromCacheNanosec) + NanosecondsMeasurer.asMilliseconds-impl(cachedValueWithParametersCalculatedNanosec));
            $cachedValueClearCounter.record(NanosecondsMeasurer.asMilliseconds-impl(cachedValueClearNanosec));
            $cachedValueWithParametersClearCounter.record(NanosecondsMeasurer.asMilliseconds-impl(cachedValueWithParametersClearNanosec));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

