/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.cache;

import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.cache.EntityStorageChange;
import com.intellij.platform.workspace.storage.impl.query.MatchList;
import com.intellij.platform.workspace.storage.impl.query.MatchWithEntityId;
import com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.trace.TracingKt;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/workspace/storage/impl/cache/ChangeOnVersionedChange;", "Lcom/intellij/platform/workspace/storage/impl/cache/EntityStorageChange;", "changes", "Lkotlin/sequences/Sequence;", "Lcom/intellij/platform/workspace/storage/EntityChange;", "(Lkotlin/sequences/Sequence;)V", "size", "", "getSize", "()I", "createTraces", "Lit/unimi/dsi/fastutil/longs/LongOpenHashSet;", "Lcom/intellij/platform/workspace/storage/trace/ReadTraceHashSet;", "snapshot", "Lcom/intellij/platform/workspace/storage/instrumentation/ImmutableEntityStorageInstrumentation;", "createTraces$intellij_platform_workspace_storage", "makeTokensForDiff", "Lcom/intellij/platform/workspace/storage/impl/query/MatchList;", "makeTokensForDiff$intellij_platform_workspace_storage", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nTracedSnapshotCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TracedSnapshotCache.kt\ncom/intellij/platform/workspace/storage/impl/cache/ChangeOnVersionedChange\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,238:1\n1313#2,2:239\n*S KotlinDebug\n*F\n+ 1 TracedSnapshotCache.kt\ncom/intellij/platform/workspace/storage/impl/cache/ChangeOnVersionedChange\n*L\n142#1:239,2\n*E\n"})
public final class ChangeOnVersionedChange
implements EntityStorageChange {
    @NotNull
    private final Sequence<EntityChange<?>> changes;

    public ChangeOnVersionedChange(@NotNull Sequence<? extends EntityChange<?>> changes) {
        Intrinsics.checkNotNullParameter(changes, "changes");
        this.changes = changes;
    }

    @Override
    public int getSize() {
        return 0;
    }

    @NotNull
    public final LongOpenHashSet createTraces$intellij_platform_workspace_storage(@NotNull ImmutableEntityStorageInstrumentation snapshot) {
        Intrinsics.checkNotNullParameter(snapshot, "snapshot");
        return TracingKt.toTraces(this.changes, snapshot);
    }

    @NotNull
    public final MatchList makeTokensForDiff$intellij_platform_workspace_storage() {
        MatchList matchList = new MatchList();
        LongOpenHashSet createdAddTokens = new LongOpenHashSet();
        LongOpenHashSet createdRemovedTokens = new LongOpenHashSet();
        Sequence<EntityChange<?>> $this$forEach$iv = this.changes;
        boolean $i$f$forEach = false;
        Iterator<EntityChange<?>> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            long l2;
            EntityChange<?> element$iv;
            EntityChange<?> change = element$iv = iterator2.next();
            boolean bl2 = false;
            Object object = change.getNewEntity();
            if (object != null && (object = UtilsKt.asBase(object)) != null) {
                l2 = ((WorkspaceEntityBase)object).getId();
            } else {
                Object object2 = change.getOldEntity();
                Long l3 = object2 != null && (object2 = UtilsKt.asBase(object2)) != null ? Long.valueOf(((WorkspaceEntityBase)object2).getId()) : null;
                Intrinsics.checkNotNull(l3);
                l2 = l3;
            }
            long entityId = l2;
            EntityChange<?> entityChange = change;
            if (entityChange instanceof EntityChange.Added) {
                if (!createdAddTokens.add(entityId)) continue;
                matchList.addedMatch(new MatchWithEntityId(entityId, null));
                continue;
            }
            if (entityChange instanceof EntityChange.Removed) {
                if (!createdRemovedTokens.add(entityId)) continue;
                matchList.removedMatch(new MatchWithEntityId(entityId, null));
                continue;
            }
            if (!(entityChange instanceof EntityChange.Replaced)) continue;
            if (createdRemovedTokens.add(entityId)) {
                matchList.removedMatch(new MatchWithEntityId(entityId, null));
            }
            if (!createdAddTokens.add(entityId)) continue;
            matchList.addedMatch(new MatchWithEntityId(entityId, null));
        }
        return matchList;
    }
}

