/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.cache;

import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.impl.cache.CacheHit;
import com.intellij.platform.workspace.storage.impl.cache.CacheHitInSynchronized;
import com.intellij.platform.workspace.storage.impl.cache.CacheHitNotAffectedByChanges;
import com.intellij.platform.workspace.storage.impl.cache.CacheProcessingStatus;
import com.intellij.platform.workspace.storage.impl.cache.CacheResetTracker;
import com.intellij.platform.workspace.storage.impl.cache.CachedValue;
import com.intellij.platform.workspace.storage.impl.cache.CellUpdateInfo;
import com.intellij.platform.workspace.storage.impl.cache.EntityStorageChange;
import com.intellij.platform.workspace.storage.impl.cache.IncrementalUpdate;
import com.intellij.platform.workspace.storage.impl.cache.Initialization;
import com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCache;
import com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCacheKt;
import com.intellij.platform.workspace.storage.impl.cache.UpdateType;
import com.intellij.platform.workspace.storage.impl.query.Cell;
import com.intellij.platform.workspace.storage.impl.query.CellChain;
import com.intellij.platform.workspace.storage.impl.query.CellId;
import com.intellij.platform.workspace.storage.impl.query.Diff;
import com.intellij.platform.workspace.storage.impl.query.DiffCollectorCell;
import com.intellij.platform.workspace.storage.impl.query.DiffImpl;
import com.intellij.platform.workspace.storage.impl.query.MatchSet;
import com.intellij.platform.workspace.storage.impl.query.QueryId;
import com.intellij.platform.workspace.storage.impl.trace.ReadTraceIndex;
import com.intellij.platform.workspace.storage.instrumentation.ImmutableEntityStorageInstrumentation;
import com.intellij.platform.workspace.storage.query.APIKt;
import com.intellij.platform.workspace.storage.query.CollectionQuery;
import com.intellij.platform.workspace.storage.query.QueriesKt;
import com.intellij.platform.workspace.storage.query.StorageQuery;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0019\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0016J:\u0010 \u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001a0!0\u0019\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\"2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0016J\u001f\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004H\u0001\u00a2\u0006\u0002\b$J\u0019\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rH\u0001\u00a2\u0006\u0002\b&J\u001f\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\rH\u0001\u00a2\u0006\u0002\b(J8\u0010)\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030*0\u0019\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J \u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00012\u0006\u00100\u001a\u00020\u0007H\u0016J\u0010\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u0005H\u0002J*\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u00105\u001a\b\u0012\u0004\u0012\u00020\u001106*\b\u0012\u0004\u0012\u00020\u001107H\u0002J\u001e\u00108\u001a\b\u0012\u0004\u0012\u0002H907\"\u0004\b\u0000\u00109*\b\u0012\u0004\u0012\u0002H907H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006:"}, d2={"Lcom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCacheImpl;", "Lcom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCache;", "()V", "changeQueue", "", "Lcom/intellij/platform/workspace/storage/impl/query/QueryId;", "", "Lcom/intellij/platform/workspace/storage/impl/cache/EntityStorageChange;", "lock", "", "pullingCache", "", "queryIdToChain", "Ljava/util/HashMap;", "Lcom/intellij/platform/workspace/storage/impl/query/CellChain;", "queryIdToTraceIndex", "Lcom/intellij/platform/workspace/storage/impl/trace/ReadTraceIndex;", "Lcom/intellij/platform/workspace/storage/impl/cache/CellUpdateInfo;", "shuffleEntities", "", "getShuffleEntities$intellij_platform_workspace_storage", "()J", "setShuffleEntities$intellij_platform_workspace_storage", "(J)V", "cached", "Lcom/intellij/platform/workspace/storage/impl/cache/CachedValue;", "T", "query", "Lcom/intellij/platform/workspace/storage/query/StorageQuery;", "snapshot", "Lcom/intellij/platform/workspace/storage/instrumentation/ImmutableEntityStorageInstrumentation;", "prevStorage", "diff", "Lcom/intellij/platform/workspace/storage/impl/query/Diff;", "Lcom/intellij/platform/workspace/storage/query/CollectionQuery;", "getChangeQueue", "getChangeQueue$intellij_platform_workspace_storage", "getQueryIdToChain", "getQueryIdToChain$intellij_platform_workspace_storage", "getQueryIdToTraceIndex", "getQueryIdToTraceIndex$intellij_platform_workspace_storage", "getUpdatedLastCell", "Lcom/intellij/platform/workspace/storage/impl/query/Cell;", "pullCache", "", "newSnapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "from", "changes", "removeCache", "queryId", "updateCellIndex", "chainId", "firstDiffThenRecalculate", "", "", "maybeShuffled", "E", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nTracedSnapshotCacheImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TracedSnapshotCacheImpl.kt\ncom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCacheImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,246:1\n215#2,2:247\n453#3:249\n403#3:250\n372#3,7:256\n372#3,7:281\n1238#4,4:251\n1855#4:255\n1856#4:264\n1855#4,2:265\n1855#4:267\n1855#4,2:268\n1856#4:270\n3190#4,10:271\n1855#4,2:288\n1#5:263\n*S KotlinDebug\n*F\n+ 1 TracedSnapshotCacheImpl.kt\ncom/intellij/platform/workspace/storage/impl/cache/TracedSnapshotCacheImpl\n*L\n97#1:247,2\n103#1:249\n103#1:250\n108#1:256,7\n219#1:281,7\n103#1:251,4\n107#1:255\n107#1:264\n121#1:265,2\n144#1:267\n149#1:268,2\n144#1:270\n158#1:271,10\n220#1:288,2\n*E\n"})
public final class TracedSnapshotCacheImpl
implements TracedSnapshotCache {
    @NotNull
    private final Object lock = new Object();
    @NotNull
    private final HashMap<QueryId, CellChain> queryIdToChain = new HashMap();
    @NotNull
    private final HashMap<QueryId, ReadTraceIndex<CellUpdateInfo>> queryIdToTraceIndex = new HashMap();
    @NotNull
    private final Map<QueryId, List<EntityStorageChange>> changeQueue = new HashMap();
    private boolean pullingCache;
    private long shuffleEntities = -1L;

    public final long getShuffleEntities$intellij_platform_workspace_storage() {
        return this.shuffleEntities;
    }

    public final void setShuffleEntities$intellij_platform_workspace_storage(long l2) {
        this.shuffleEntities = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void pullCache(@NotNull ImmutableEntityStorage newSnapshot, @NotNull TracedSnapshotCache from2, @NotNull EntityStorageChange changes) {
        Intrinsics.checkNotNullParameter(newSnapshot, "newSnapshot");
        Intrinsics.checkNotNullParameter(from2, "from");
        Intrinsics.checkNotNullParameter(changes, "changes");
        try {
            this.pullingCache = true;
            if (!(from2 instanceof TracedSnapshotCacheImpl)) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            Object object = ((TracedSnapshotCacheImpl)from2).lock;
            synchronized (object) {
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                boolean bl2 = false;
                Map<QueryId, List<EntityStorageChange>> $this$forEach$iv = (Map<QueryId, List<EntityStorageChange>>)((TracedSnapshotCacheImpl)from2).queryIdToTraceIndex;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl3 = false;
                    QueryId chainId = (QueryId)entry.getKey();
                    ReadTraceIndex index2 = (ReadTraceIndex)entry.getValue();
                    ReadTraceIndex newIndex = new ReadTraceIndex();
                    newIndex.pull(index2);
                    ((Map)this.queryIdToTraceIndex).put(chainId, newIndex);
                }
                this.queryIdToChain.putAll((Map<QueryId, CellChain>)((TracedSnapshotCacheImpl)from2).queryIdToChain);
                $this$forEach$iv = ((TracedSnapshotCacheImpl)from2).changeQueue;
                Map<QueryId, List<EntityStorageChange>> map2 = this.changeQueue;
                boolean $i$f$mapValues = false;
                iterator2 = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv;
                    boolean bl4 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k2 = it$iv$iv.getKey();
                    Map map4 = map3;
                    boolean bl5 = false;
                    ArrayList arrayList = new ArrayList((Collection)it.getValue());
                    map4.put(k2, arrayList);
                }
                map2.putAll(destination$iv$iv);
                this.shuffleEntities = ((TracedSnapshotCacheImpl)from2).shuffleEntities;
                ArrayList cachesToRemove = new ArrayList();
                Set<QueryId> set = this.queryIdToChain.keySet();
                Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
                Iterable $this$forEach$iv2 = set;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    Object object2;
                    void $this$getOrPut$iv;
                    QueryId chainId = (QueryId)element$iv;
                    boolean bl6 = false;
                    Map<QueryId, List<EntityStorageChange>> index2 = this.changeQueue;
                    Intrinsics.checkNotNull(chainId);
                    QueryId key$iv = chainId;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl7 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object2 = answer$iv;
                    } else {
                        object2 = value$iv;
                    }
                    List changesQueue = (List)object2;
                    Iterable iterable = changesQueue;
                    int n2 = 0;
                    for (Object e2 : iterable) {
                        void it;
                        EntityStorageChange bl5 = (EntityStorageChange)e2;
                        int n3 = n2;
                        boolean bl8 = false;
                        int n4 = it.getSize();
                        n2 = n3 + n4;
                    }
                    int expectedNewChangelogSize = n2 + changes.getSize();
                    if (expectedNewChangelogSize > TracedSnapshotCache.Companion.getLOG_QUEUE_MAX_SIZE()) {
                        if (CacheResetTracker.INSTANCE.getEnabled()) {
                            CacheResetTracker.INSTANCE.setCacheReset(true);
                        }
                        ((Collection)cachesToRemove).add(chainId);
                        continue;
                    }
                    changesQueue.add(changes);
                }
                $this$forEach$iv2 = cachesToRemove;
                $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    QueryId it = (QueryId)element$iv;
                    boolean bl9 = false;
                    this.removeCache(it);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        finally {
            this.pullingCache = false;
        }
    }

    private final void removeCache(QueryId queryId) {
        this.queryIdToChain.remove(queryId);
        this.queryIdToTraceIndex.remove(queryId);
        this.changeQueue.remove(queryId);
    }

    private final boolean updateCellIndex(QueryId chainId, EntityStorageChange changes, ImmutableEntityStorageInstrumentation newSnapshot, ImmutableEntityStorageInstrumentation prevStorage) {
        ReadTraceIndex cellIndex = (ReadTraceIndex)MapsKt.getValue((Map)this.queryIdToTraceIndex, chainId);
        LongOpenHashSet newTraces = TracedSnapshotCacheKt.createTraces(changes, newSnapshot);
        HashMap<CellId, MatchSet> updatedCells = new HashMap<CellId, MatchSet>();
        boolean cellsUpdated = false;
        Iterable $this$forEach$iv = this.firstDiffThenRecalculate(this.maybeShuffled(cellIndex.get(newTraces)));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CellUpdateInfo updateRequest = (CellUpdateInfo)element$iv;
            boolean bl2 = false;
            cellsUpdated = true;
            CellChain cellChain = this.queryIdToChain.get(updateRequest.getChainId());
            if (cellChain == null) {
                throw new IllegalStateException("Unindexed cell".toString());
            }
            Object object = cellChain;
            Intrinsics.checkNotNull(object);
            CellChain cells = object;
            object = cells.changeInput(newSnapshot, prevStorage, updateRequest, changes, updateRequest.getCellId(), updatedCells);
            CellChain newChain = (CellChain)((Pair)object).component1();
            List tracesAndModifiedCells = (List)((Pair)object).component2();
            Iterable $this$forEach$iv2 = tracesAndModifiedCells;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Pair pair = (Pair)element$iv2;
                boolean bl3 = false;
                LongOpenHashSet traces = (LongOpenHashSet)pair.component1();
                CellUpdateInfo updateRequest2 = (CellUpdateInfo)pair.component2();
                cellIndex.set(traces, updateRequest2);
            }
            ((Map)this.queryIdToChain).put(newChain.getId(), newChain);
        }
        return cellsUpdated;
    }

    private final List<CellUpdateInfo> firstDiffThenRecalculate(Collection<CellUpdateInfo> $this$firstDiffThenRecalculate) {
        Iterable $this$partition$iv = $this$firstDiffThenRecalculate;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            CellUpdateInfo it = (CellUpdateInfo)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual(it.getUpdateType(), UpdateType.DIFF.INSTANCE)) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List diff = pair.component1();
        List recalculate = pair.component2();
        return CollectionsKt.plus((Collection)diff, (Iterable)recalculate);
    }

    @Override
    @NotNull
    public <T> CachedValue<T> cached(@NotNull StorageQuery<T> query, @NotNull ImmutableEntityStorageInstrumentation snapshot, @Nullable ImmutableEntityStorageInstrumentation prevStorage) {
        Intrinsics.checkNotNullParameter(query, "query");
        Intrinsics.checkNotNullParameter(snapshot, "snapshot");
        if (!(!this.pullingCache)) {
            boolean bl2 = false;
            String string2 = "It's not allowed to request query when the cache is pulled from other snapshot";
            throw new IllegalStateException(string2.toString());
        }
        CachedValue<Cell<?>> lastCell = this.getUpdatedLastCell(query, snapshot, prevStorage);
        return new CachedValue(lastCell.getCacheProcessStatus(), lastCell.getValue().data());
    }

    @Override
    @NotNull
    public <T> CachedValue<Diff<T>> diff(@NotNull CollectionQuery<T> query, @NotNull ImmutableEntityStorageInstrumentation snapshot, @Nullable ImmutableEntityStorageInstrumentation prevStorage) {
        Intrinsics.checkNotNullParameter(query, "query");
        Intrinsics.checkNotNullParameter(snapshot, "snapshot");
        if (!(!(query instanceof CollectionQuery.TrackDiff))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        CollectionQuery<T> queryWithDiffTracker = APIKt.trackDiff(query);
        CachedValue<Cell<?>> lastCell = this.getUpdatedLastCell((StorageQuery)queryWithDiffTracker, snapshot, prevStorage);
        if (!(lastCell.getValue() instanceof DiffCollectorCell)) {
            String string3 = "Check failed.";
            throw new IllegalStateException(string3.toString());
        }
        List list2 = ((DiffCollectorCell)lastCell.getValue()).getAddedData();
        Intrinsics.checkNotNull(list2, "null cannot be cast to non-null type kotlin.collections.List<T of com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCacheImpl.diff>");
        List list3 = ((DiffCollectorCell)lastCell.getValue()).getRemovedData();
        Intrinsics.checkNotNull(list3, "null cannot be cast to non-null type kotlin.collections.List<T of com.intellij.platform.workspace.storage.impl.cache.TracedSnapshotCacheImpl.diff>");
        DiffImpl diff = new DiffImpl(list2, list3);
        return new CachedValue<Diff<T>>(lastCell.getCacheProcessStatus(), diff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <T> CachedValue<Cell<?>> getUpdatedLastCell(StorageQuery<T> query, ImmutableEntityStorageInstrumentation snapshot, ImmutableEntityStorageInstrumentation prevStorage) {
        QueryId queryId = query.getQueryId();
        List<EntityStorageChange> changes = this.changeQueue.get(queryId);
        CellChain cellChain = this.queryIdToChain.get(queryId);
        if (cellChain != null && (changes == null || changes.size() == 0)) {
            return new CachedValue(CacheHit.INSTANCE, cellChain.last());
        }
        Object object = this.lock;
        synchronized (object) {
            Object object2;
            void $this$getOrPut$iv;
            block10: {
                List<EntityStorageChange> doubleCheckChanges;
                block9: {
                    boolean bl2 = false;
                    doubleCheckChanges = this.changeQueue.get(queryId);
                    CellChain doubleCheckChain = this.queryIdToChain.get(queryId);
                    if (doubleCheckChain == null || doubleCheckChanges != null && doubleCheckChanges.size() != 0) break block9;
                    CachedValue cachedValue = new CachedValue(CacheHitInSynchronized.INSTANCE, doubleCheckChain.last());
                    return cachedValue;
                }
                if (doubleCheckChanges == null || doubleCheckChanges.size() <= 0) break block10;
                EntityStorageChange collapsedChangelog = TracedSnapshotCacheKt.collapse(doubleCheckChanges);
                boolean recalculated = this.updateCellIndex(queryId, collapsedChangelog, snapshot, prevStorage);
                this.changeQueue.remove(queryId);
                CacheProcessingStatus status = recalculated ? (CacheProcessingStatus)IncrementalUpdate.INSTANCE : (CacheProcessingStatus)CacheHitNotAffectedByChanges.INSTANCE;
                CellChain cellChain2 = this.queryIdToChain.get(queryId);
                Intrinsics.checkNotNull(cellChain2);
                CachedValue cachedValue = new CachedValue(status, cellChain2.last());
                return cachedValue;
            }
            CellChain emptyCellChain = QueriesKt.compile$default(query, null, 1, null);
            Pair<CellChain, List<Pair<LongOpenHashSet, CellUpdateInfo>>> chainWithTraces = emptyCellChain.snapshotInput(snapshot);
            CellChain newChain = chainWithTraces.component1();
            List<Pair<LongOpenHashSet, CellUpdateInfo>> traces = chainWithTraces.component2();
            Map map2 = this.queryIdToTraceIndex;
            QueryId key$iv = newChain.getId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl3 = false;
                ReadTraceIndex answer$iv = new ReadTraceIndex();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            map2 = object2;
            ReadTraceIndex index2 = (ReadTraceIndex)((Object)map2);
            boolean bl4 = false;
            Iterable $this$forEach$iv = traces;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl5 = false;
                LongOpenHashSet trace2 = (LongOpenHashSet)pair.component1();
                CellUpdateInfo updateRequest = (CellUpdateInfo)pair.component2();
                index2.set(trace2, updateRequest);
            }
            ((Map)this.queryIdToChain).put(newChain.getId(), newChain);
            CachedValue cachedValue = new CachedValue(Initialization.INSTANCE, newChain.last());
            return cachedValue;
        }
    }

    @TestOnly
    @NotNull
    public final Map<QueryId, List<EntityStorageChange>> getChangeQueue$intellij_platform_workspace_storage() {
        return this.changeQueue;
    }

    @TestOnly
    @NotNull
    public final HashMap<QueryId, CellChain> getQueryIdToChain$intellij_platform_workspace_storage() {
        return this.queryIdToChain;
    }

    @TestOnly
    @NotNull
    public final HashMap<QueryId, ReadTraceIndex<CellUpdateInfo>> getQueryIdToTraceIndex$intellij_platform_workspace_storage() {
        return this.queryIdToTraceIndex;
    }

    private final <E> Collection<E> maybeShuffled(Collection<? extends E> $this$maybeShuffled) {
        if (this.shuffleEntities != -1L && $this$maybeShuffled.size() > 1) {
            return CollectionsKt.shuffled((Iterable)$this$maybeShuffled, new Random(this.shuffleEntities));
        }
        return $this$maybeShuffled;
    }
}

