/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.containers;

import com.intellij.platform.workspace.storage.impl.containers.BidirectionalSetMap;
import com.intellij.util.containers.CollectionFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010'\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0004B5\b\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001d\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010 2\u0006\u0010\u001c\u001a\u00028\u0001\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0018H\u0016J\u001f\u0010#\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010$J\u001e\u0010%\u001a\u00020\u00162\u0014\u0010&\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010'H\u0016J\u0017\u0010(\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010)\u001a\u00020\u00162\u0006\u0010*\u001a\u00028\u0001\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020-H\u0016R&\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\f\u00a8\u0006."}, d2={"Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalSetMap;", "K", "V", "", "()V", "keyToValueMap", "valueToKeysMap", "", "(Ljava/util/Map;Ljava/util/Map;)V", "entries", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "getValues", "clear", "", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "getKeysByValue", "", "(Ljava/lang/Object;)Ljava/util/Set;", "isEmpty", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "removeValue", "v", "(Ljava/lang/Object;)V", "toString", "", "intellij.platform.workspace.storage"})
public final class BidirectionalSetMap<K, V>
implements Map<K, V>,
KMutableMap {
    @NotNull
    private final Map<K, V> keyToValueMap;
    @NotNull
    private final Map<V, Set<K>> valueToKeysMap;

    private BidirectionalSetMap(Map<K, V> keyToValueMap, Map<V, Set<K>> valueToKeysMap) {
        this.keyToValueMap = keyToValueMap;
        this.valueToKeysMap = valueToKeysMap;
    }

    public BidirectionalSetMap() {
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap();
        Intrinsics.checkNotNullExpressionValue(map2, "createSmallMemoryFootprintMap(...)");
        this(map2, new HashMap());
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        Set array2;
        V oldValue = this.keyToValueMap.put(key, value);
        if (oldValue != null) {
            if (Intrinsics.areEqual(oldValue, value)) {
                return oldValue;
            }
            Set set = this.valueToKeysMap.get(oldValue);
            Intrinsics.checkNotNull(set);
            array2 = set;
            array2.remove(key);
            if (array2.isEmpty()) {
                this.valueToKeysMap.remove(oldValue);
            }
        }
        Set set = this.valueToKeysMap.computeIfAbsent((Set)value, (Function<Set, Set<Object>>)((Function<Object, Set>)arg_0 -> BidirectionalSetMap.put$lambda$0(put.array.1.INSTANCE, arg_0)));
        Intrinsics.checkNotNullExpressionValue(set, "computeIfAbsent(...)");
        array2 = set;
        array2.add(key);
        return oldValue;
    }

    @Override
    public void clear() {
        this.keyToValueMap.clear();
        this.valueToKeysMap.clear();
    }

    @Nullable
    public final Set<K> getKeysByValue(V value) {
        return this.valueToKeysMap.get(value);
    }

    @NotNull
    public Set<K> getKeys() {
        return this.keyToValueMap.keySet();
    }

    public int getSize() {
        return this.keyToValueMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyToValueMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyToValueMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueToKeysMap.containsKey(value);
    }

    @Override
    @Nullable
    public V get(Object key) {
        return this.keyToValueMap.get(key);
    }

    public final void removeValue(V v2) {
        Set<K> ks = this.valueToKeysMap.remove(v2);
        if (ks != null) {
            for (K k2 : ks) {
                this.keyToValueMap.remove(k2);
            }
        }
    }

    @Override
    @Nullable
    public V remove(Object key) {
        V value = this.keyToValueMap.remove(key);
        Set<K> ks = this.valueToKeysMap.get(value);
        if (ks != null) {
            if (ks.size() > 1) {
                ks.remove(key);
            } else {
                TypeIntrinsics.asMutableMap(this.valueToKeysMap).remove(value);
            }
        }
        return value;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> from2) {
        Intrinsics.checkNotNullParameter(from2, "from");
        for (Map.Entry<K, V> entry : from2.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            this.put(key, value);
        }
    }

    @NotNull
    public Set<V> getValues() {
        return this.valueToKeysMap.keySet();
    }

    @NotNull
    public Set<Map.Entry<K, V>> getEntries() {
        return this.keyToValueMap.entrySet();
    }

    @NotNull
    public String toString() {
        return this.keyToValueMap.toString();
    }

    private static final Set put$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Set)$tmp0.invoke(p0);
    }
}

