/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.indices;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.impl.AbstractEntityStorage;
import com.intellij.platform.workspace.storage.impl.EntityIdKt;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityBase;
import com.intellij.platform.workspace.storage.impl.WorkspaceEntityData;
import com.intellij.platform.workspace.storage.impl.containers.BidirectionalLongMultiMap;
import com.intellij.platform.workspace.storage.impl.containers.ContainerExtensionsKt;
import com.intellij.platform.workspace.storage.impl.containers.Object2LongWithDefaultMap;
import com.intellij.platform.workspace.storage.impl.indices.EntityIdWithProperty;
import com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndexKt;
import com.intellij.platform.workspace.storage.url.MutableVirtualFileUrlIndex;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlIndex;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001:\u0001:B\u0007\b\u0010\u00a2\u0006\u0002\u0010\u0002BI\b\u0000\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006\u0012\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0002`\f\u0012\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\t0\u000ej\u0002`\u000f\u00a2\u0006\u0002\u0010\u0010J@\u0010\u0019\u001a\u00020\u001a2.\u0010\u001b\u001a*\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001e0\u001cj\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001e`\u001f2\u0006\u0010 \u001a\u00020\u0005H\u0002J\r\u0010!\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\"J\"\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001d0%0$2\u0006\u0010'\u001a\u00020\tH\u0016J!\u0010(\u001a\u00020\u000b2\n\u0010)\u001a\u00060*j\u0002`+2\u0006\u0010,\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b-J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0/J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\t0\u001e2\u0006\u0010 \u001a\u00020\u0005H\u0002J+\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001e022\n\u00103\u001a\u00060*j\u0002`+H\u0000\u00a2\u0006\u0002\b4J\u001f\u00105\u001a\b\u0012\u0004\u0012\u00020\t0/2\n\u00103\u001a\u00060*j\u0002`+H\u0000\u00a2\u0006\u0002\b6J\u0015\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b9R\u001e\u0010\r\u001a\f\u0012\u0004\u0012\u00020\t0\u000ej\u0002`\u000fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0002`\fX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006;"}, d2={"Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlIndex;", "()V", "entityId2VirtualFileUrl", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityId2Vfu;", "vfu2EntityId", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "Lcom/intellij/platform/workspace/storage/impl/containers/Object2LongWithDefaultMap;", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityIdWithProperty;", "Lcom/intellij/platform/workspace/storage/impl/indices/Vfu2EntityId;", "entityId2JarDir", "Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongMultiMap;", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityId2JarDir;", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap;Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongMultiMap;)V", "getEntityId2JarDir$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongMultiMap;", "getEntityId2VirtualFileUrl$intellij_platform_workspace_storage", "()Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "entityStorage", "Lcom/intellij/platform/workspace/storage/impl/AbstractEntityStorage;", "getVfu2EntityId$intellij_platform_workspace_storage", "()Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap;", "addVirtualFileUrlsToMap", "", "result", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "value", "assertConsistency", "assertConsistency$intellij_platform_workspace_storage", "findEntitiesByUrl", "Lkotlin/sequences/Sequence;", "Lkotlin/Pair;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "fileUrl", "getCompositeKey", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "propertyName", "getCompositeKey$intellij_platform_workspace_storage", "getIndexedJarDirectories", "", "getVirtualFileUrl", "getVirtualFileUrlInfoByEntityId", "", "id", "getVirtualFileUrlInfoByEntityId$intellij_platform_workspace_storage", "getVirtualFiles", "getVirtualFiles$intellij_platform_workspace_storage", "setTypedEntityStorage", "storage", "setTypedEntityStorage$intellij_platform_workspace_storage", "MutableVirtualFileIndex", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nVirtualFileIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileIndex.kt\ncom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,420:1\n1855#2,2:421\n1855#2,2:430\n215#3,2:423\n215#3:425\n215#3,2:426\n216#3:428\n1#4:429\n*S KotlinDebug\n*F\n+ 1 VirtualFileIndex.kt\ncom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex\n*L\n56#1:421,2\n102#1:430,2\n72#1:423,2\n99#1:425\n118#1:426,2\n99#1:428\n*E\n"})
public class VirtualFileIndex
implements VirtualFileUrlIndex {
    @NotNull
    private final Long2ObjectOpenHashMap<Object> entityId2VirtualFileUrl;
    @NotNull
    private final Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> vfu2EntityId;
    @NotNull
    private final BidirectionalLongMultiMap<VirtualFileUrl> entityId2JarDir;
    private AbstractEntityStorage entityStorage;

    public VirtualFileIndex(@NotNull Long2ObjectOpenHashMap<Object> entityId2VirtualFileUrl, @NotNull Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> vfu2EntityId, @NotNull BidirectionalLongMultiMap<VirtualFileUrl> entityId2JarDir) {
        Intrinsics.checkNotNullParameter(entityId2VirtualFileUrl, "entityId2VirtualFileUrl");
        Intrinsics.checkNotNullParameter(vfu2EntityId, "vfu2EntityId");
        Intrinsics.checkNotNullParameter(entityId2JarDir, "entityId2JarDir");
        this.entityId2VirtualFileUrl = entityId2VirtualFileUrl;
        this.vfu2EntityId = vfu2EntityId;
        this.entityId2JarDir = entityId2JarDir;
    }

    @NotNull
    public Long2ObjectOpenHashMap<Object> getEntityId2VirtualFileUrl$intellij_platform_workspace_storage() {
        return this.entityId2VirtualFileUrl;
    }

    @NotNull
    public Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> getVfu2EntityId$intellij_platform_workspace_storage() {
        return this.vfu2EntityId;
    }

    @NotNull
    public BidirectionalLongMultiMap<VirtualFileUrl> getEntityId2JarDir$intellij_platform_workspace_storage() {
        return this.entityId2JarDir;
    }

    public VirtualFileIndex() {
        this(new Long2ObjectOpenHashMap<Object>(), new Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>>(VirtualFileIndexKt.getHashingStrategy()), new BidirectionalLongMultiMap<VirtualFileUrl>());
    }

    @NotNull
    public final Set<VirtualFileUrl> getVirtualFiles$intellij_platform_workspace_storage(long id2) {
        Set result2;
        block1: {
            Object object;
            Object value;
            block2: {
                Object object2;
                result2 = new LinkedHashSet();
                Object object3 = this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().get(id2);
                if (object3 == null) break block1;
                value = object2 = object3;
                boolean bl2 = false;
                object = value;
                if (!(object instanceof Map)) break block2;
                Iterable $this$forEach$iv = ((Map)value).values();
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object vfu = element$iv = iterator2.next();
                    boolean bl3 = false;
                    Object t2 = vfu;
                    Intrinsics.checkNotNull(t2);
                    result2.addAll((Collection)this.getVirtualFileUrl(t2));
                }
                break block1;
            }
            if (!(object instanceof Pair)) break block1;
            Object b2 = ((Pair)value).getSecond();
            Intrinsics.checkNotNull(b2);
            result2.addAll((Collection)this.getVirtualFileUrl(b2));
        }
        return result2;
    }

    @NotNull
    public final Map<String, Set<VirtualFileUrl>> getVirtualFileUrlInfoByEntityId$intellij_platform_workspace_storage(long id2) {
        Object object = this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().get(id2);
        if (object == null) {
            return MapsKt.emptyMap();
        }
        Object property2VfuMap = object;
        HashMap<String, Set<VirtualFileUrl>> copiedVfuMap = new HashMap<String, Set<VirtualFileUrl>>();
        this.addVirtualFileUrlsToMap(copiedVfuMap, property2VfuMap);
        return copiedVfuMap;
    }

    private final void addVirtualFileUrlsToMap(HashMap<String, Set<VirtualFileUrl>> result2, Object value) {
        Object object = value;
        if (object instanceof Map) {
            Map $this$forEach$iv = (Map)value;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator2.next();
                boolean bl2 = false;
                Map map2 = result2;
                Object k2 = it.getKey();
                Intrinsics.checkNotNull(k2, "null cannot be cast to non-null type kotlin.String");
                String string2 = (String)k2;
                Object v2 = it.getValue();
                Intrinsics.checkNotNull(v2);
                Set<VirtualFileUrl> set = this.getVirtualFileUrl(v2);
                map2.put(string2, set);
            }
        } else if (object instanceof Pair) {
            Map map3 = result2;
            Object a2 = ((Pair)value).getFirst();
            Intrinsics.checkNotNull(a2, "null cannot be cast to non-null type kotlin.String");
            String string3 = (String)a2;
            Object b2 = ((Pair)value).getSecond();
            Intrinsics.checkNotNull(b2);
            Set<VirtualFileUrl> set = this.getVirtualFileUrl(b2);
            map3.put(string3, set);
        }
    }

    private final Set<VirtualFileUrl> getVirtualFileUrl(Object value) {
        Set<VirtualFileUrl> set;
        if (value instanceof ObjectOpenHashSet) {
            Intrinsics.checkNotNull(value, "null cannot be cast to non-null type it.unimi.dsi.fastutil.objects.ObjectOpenHashSet<com.intellij.platform.workspace.storage.url.VirtualFileUrl>");
            set = new HashSet((ObjectOpenHashSet)value);
        } else {
            VirtualFileUrl[] virtualFileUrlArray = new VirtualFileUrl[1];
            Intrinsics.checkNotNull(value, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.url.VirtualFileUrl");
            virtualFileUrlArray[0] = value;
            set = SetsKt.mutableSetOf(virtualFileUrlArray);
        }
        return set;
    }

    @Override
    @NotNull
    public Sequence<Pair<WorkspaceEntity, String>> findEntitiesByUrl(@NotNull VirtualFileUrl fileUrl) {
        Intrinsics.checkNotNullParameter(fileUrl, "fileUrl");
        Object object = this.getVfu2EntityId$intellij_platform_workspace_storage().get(fileUrl);
        if (object == null || (object = ((Object2LongWithDefaultMap)object).asSequence()) == null || (object = SequencesKt.mapNotNull(object, (Function1)new Function1<Map.Entry<? extends EntityIdWithProperty, ? extends Long>, Pair<? extends WorkspaceEntity, ? extends String>>(this){
            final /* synthetic */ VirtualFileIndex this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Pair<WorkspaceEntity, String> invoke(@NotNull Map.Entry<EntityIdWithProperty, Long> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                AbstractEntityStorage abstractEntityStorage = VirtualFileIndex.access$getEntityStorage$p(this.this$0);
                if (abstractEntityStorage == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityStorage");
                    abstractEntityStorage = null;
                }
                WorkspaceEntityData<? extends WorkspaceEntity> workspaceEntityData = abstractEntityStorage.entityDataById$intellij_platform_workspace_storage(((Number)it.getValue()).longValue());
                if (workspaceEntityData == null) {
                    return null;
                }
                WorkspaceEntityData<? extends WorkspaceEntity> entityData = workspaceEntityData;
                AbstractEntityStorage abstractEntityStorage2 = VirtualFileIndex.access$getEntityStorage$p(this.this$0);
                if (abstractEntityStorage2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("entityStorage");
                    abstractEntityStorage2 = null;
                }
                return TuplesKt.to(entityData.createEntity(abstractEntityStorage2), it.getKey().getPropertyName());
            }
        })) == null) {
            object = SequencesKt.emptySequence();
        }
        return object;
    }

    @NotNull
    public final Set<VirtualFileUrl> getIndexedJarDirectories() {
        return this.getEntityId2JarDir$intellij_platform_workspace_storage().getValues();
    }

    public final void setTypedEntityStorage$intellij_platform_workspace_storage(@NotNull AbstractEntityStorage storage) {
        Intrinsics.checkNotNullParameter(storage, "storage");
        this.entityStorage = storage;
    }

    public final void assertConsistency$intellij_platform_workspace_storage() {
        boolean bl2;
        HashSet<VirtualFileUrl> existingVfuInFirstMap = new HashSet<VirtualFileUrl>();
        Map $this$forEach$iv = this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl3 = false;
            Long entityId = (Long)entry.getKey();
            Object property2Vfu = entry.getValue();
            Object v2 = property2Vfu;
            if (v2 instanceof Map) {
                Intrinsics.checkNotNull(property2Vfu);
                Map $this$forEach$iv2 = (Map)property2Vfu;
                boolean $i$f$forEach2 = false;
                Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map.Entry element$iv2;
                    Map.Entry entry2 = element$iv2 = iterator3.next();
                    boolean bl4 = false;
                    Object property = entry2.getKey();
                    Object vfus = entry2.getValue();
                    Intrinsics.checkNotNull(property, "null cannot be cast to non-null type kotlin.String");
                    String string2 = (String)property;
                    Object v3 = vfus;
                    Intrinsics.checkNotNull(v3);
                    VirtualFileIndex.assertConsistency$lambda$7$assertProperty2Vfu(existingVfuInFirstMap, this, entityId, string2, v3);
                }
                continue;
            }
            if (!(v2 instanceof Pair)) continue;
            Object a2 = ((Pair)property2Vfu).getFirst();
            Intrinsics.checkNotNull(a2, "null cannot be cast to non-null type kotlin.String");
            String string3 = (String)a2;
            Object b2 = ((Pair)property2Vfu).getSecond();
            Intrinsics.checkNotNull(b2);
            VirtualFileIndex.assertConsistency$lambda$7$assertProperty2Vfu(existingVfuInFirstMap, this, entityId, string3, b2);
        }
        Set set = this.getVfu2EntityId$intellij_platform_workspace_storage().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        ObjectSet existingVfuISecondMap = (ObjectSet)set;
        boolean bl5 = bl2 = existingVfuInFirstMap.size() == existingVfuISecondMap.size();
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-VirtualFileIndex$assertConsistency$42 = false;
            String $i$a$-assert-VirtualFileIndex$assertConsistency$42 = "Different count of VirtualFileUrls EntityId2VirtualFileUrl: " + existingVfuInFirstMap.size() + " Vfu2EntityId: " + existingVfuISecondMap.size();
            throw new AssertionError((Object)$i$a$-assert-VirtualFileIndex$assertConsistency$42);
        }
        existingVfuInFirstMap.removeAll(existingVfuISecondMap);
        bl2 = existingVfuInFirstMap.isEmpty();
        if (_Assertions.ENABLED && !bl2) {
            boolean bl6 = false;
            String string4 = "Both maps contain the same amount of VirtualFileUrls but they are different";
            throw new AssertionError((Object)string4);
        }
    }

    @NotNull
    public final EntityIdWithProperty getCompositeKey$intellij_platform_workspace_storage(long entityId, @NotNull String propertyName) {
        Intrinsics.checkNotNullParameter(propertyName, "propertyName");
        return new EntityIdWithProperty(entityId, propertyName);
    }

    private static final void assertConsistency$lambda$7$assertProperty2Vfu(HashSet<VirtualFileUrl> existingVfuInFirstMap, VirtualFileIndex this$0, Long entityId, String property, Object vfus) {
        Set<VirtualFileUrl> set;
        if (vfus instanceof Set) {
            set = (ObjectOpenHashSet)vfus;
        } else {
            VirtualFileUrl[] virtualFileUrlArray = new VirtualFileUrl[1];
            Intrinsics.checkNotNull(vfus, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.url.VirtualFileUrl");
            virtualFileUrlArray[0] = vfus;
            set = SetsKt.mutableSetOf(virtualFileUrlArray);
        }
        Set<VirtualFileUrl> vfuSet = set;
        Iterable $this$forEach$iv = vfuSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl2;
            VirtualFileUrl vfu = (VirtualFileUrl)element$iv;
            boolean bl3 = false;
            existingVfuInFirstMap.add(vfu);
            Object2LongWithDefaultMap<EntityIdWithProperty> property2EntityId = this$0.getVfu2EntityId$intellij_platform_workspace_storage().get(vfu);
            boolean bl4 = bl2 = property2EntityId != null;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-VirtualFileIndex$assertConsistency$1$assertProperty2Vfu$1$32 = false;
                Intrinsics.checkNotNull(entityId);
                String $i$a$-assert-VirtualFileIndex$assertConsistency$1$assertProperty2Vfu$1$32 = "VirtualFileUrl: " + vfu + " exists in the first collection by EntityId: " + EntityIdKt.asString(entityId) + " with Property: " + property + " but absent at other";
                throw new AssertionError((Object)$i$a$-assert-VirtualFileIndex$assertConsistency$1$assertProperty2Vfu$1$32);
            }
            Intrinsics.checkNotNull(entityId);
            EntityIdWithProperty compositeKey = this$0.getCompositeKey$intellij_platform_workspace_storage(entityId, property);
            Object2LongWithDefaultMap<EntityIdWithProperty> object2LongWithDefaultMap = property2EntityId;
            Intrinsics.checkNotNull(object2LongWithDefaultMap);
            boolean existingEntityId = object2LongWithDefaultMap.contains(compositeKey);
            if (!_Assertions.ENABLED || existingEntityId) continue;
            boolean bl5 = false;
            String string2 = "VirtualFileUrl: " + vfu + " exist in both maps but EntityId: " + EntityIdKt.asString(entityId) + " with Property: " + property + " absent at other";
            throw new AssertionError((Object)string2);
        }
    }

    public static final /* synthetic */ AbstractEntityStorage access$getEntityStorage$p(VirtualFileIndex $this) {
        return $this.entityStorage;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0012\u0018\u0000 G2\u00020\u00012\u00020\u0002:\u0001GBI\b\u0002\u0012\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006\u0012\u001c\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0002`\f\u0012\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\t0\u000ej\u0002`\u000f\u00a2\u0006\u0002\u0010\u0010J\r\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"J$\u0010#\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0010\u0010$\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006H\u0002J\u0015\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0001H\u0001\u00a2\u0006\u0002\b'J<\u0010(\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0002`\f2\u001c\u0010$\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0002`\fH\u0002J\"\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\tH\u0016J-\u0010)\u001a\u00020!2\n\u0010/\u001a\u000600j\u0002`12\u0006\u0010,\u001a\u00020-2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\b2J/\u0010)\u001a\u00020!2\n\u0010/\u001a\u000600j\u0002`12\u0006\u0010,\u001a\u00020-2\f\u00103\u001a\b\u0012\u0004\u0012\u00020\t04H\u0000\u00a2\u0006\u0002\b2J'\u00105\u001a\u00020!2\n\u0010/\u001a\u000600j\u0002`12\f\u00103\u001a\b\u0012\u0004\u0012\u00020\t06H\u0000\u00a2\u0006\u0002\b7J$\u00108\u001a\u00020!2\n\u0010/\u001a\u000600j\u0002`12\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\tH\u0002J\u001c\u00109\u001a\u00020!2\n\u0010/\u001a\u000600j\u0002`12\u0006\u0010,\u001a\u00020-H\u0002J$\u0010:\u001a\u00020!2\n\u0010/\u001a\u000600j\u0002`12\u0006\u0010,\u001a\u00020-2\u0006\u0010;\u001a\u00020\tH\u0002J$\u0010:\u001a\u00020!2\n\u0010/\u001a\u000600j\u0002`12\u0006\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u00020\u0005H\u0002J\u0019\u0010>\u001a\u00020!2\n\u0010/\u001a\u000600j\u0002`1H\u0000\u00a2\u0006\u0002\b?J\b\u0010@\u001a\u00020!H\u0002J\u0006\u0010A\u001a\u00020\u0001J-\u0010B\u001a\u00020!2\n\u0010C\u001a\u000600j\u0002`12\n\u0010D\u001a\u000600j\u0002`12\u0006\u0010E\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\bFR8\u0010\r\u001a\f\u0012\u0004\u0012\u00020\t0\u000ej\u0002`\u000f2\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\t0\u000ej\u0002`\u000f@VX\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R8\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00062\u0010\u0010\u0011\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006@VX\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000RP\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0002`\f2\u001c\u0010\u0011\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bj\u0002`\f@VX\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006H"}, d2={"Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex;", "Lcom/intellij/platform/workspace/storage/url/MutableVirtualFileUrlIndex;", "entityId2VirtualFileUrl", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityId2Vfu;", "vfu2EntityId", "Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "Lcom/intellij/platform/workspace/storage/impl/containers/Object2LongWithDefaultMap;", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityIdWithProperty;", "Lcom/intellij/platform/workspace/storage/impl/indices/Vfu2EntityId;", "entityId2JarDir", "Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongMultiMap;", "Lcom/intellij/platform/workspace/storage/impl/indices/EntityId2JarDir;", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap;Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongMultiMap;)V", "<set-?>", "getEntityId2JarDir$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongMultiMap;", "setEntityId2JarDir", "(Lcom/intellij/platform/workspace/storage/impl/containers/BidirectionalLongMultiMap;)V", "getEntityId2VirtualFileUrl$intellij_platform_workspace_storage", "()Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "setEntityId2VirtualFileUrl", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;)V", "freezed", "", "getVfu2EntityId$intellij_platform_workspace_storage", "()Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap;", "setVfu2EntityId", "(Lit/unimi/dsi/fastutil/objects/Object2ObjectOpenCustomHashMap;)V", "clear", "", "clear$intellij_platform_workspace_storage", "copyEntityMap", "originMap", "copyFrom", "another", "copyFrom$intellij_platform_workspace_storage", "copyVfuMap", "index", "entity", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "propertyName", "", "virtualFileUrl", "id", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "index$intellij_platform_workspace_storage", "virtualFileUrls", "", "indexJarDirectories", "", "indexJarDirectories$intellij_platform_workspace_storage", "indexVirtualFileUrl", "removeByPropertyFromIndexes", "removeFromVfu2EntityIdMap", "vfu", "property", "vfus", "removeRecordsByEntityId", "removeRecordsByEntityId$intellij_platform_workspace_storage", "startWrite", "toImmutable", "updateIndex", "oldId", "newId", "oldIndex", "updateIndex$intellij_platform_workspace_storage", "Companion", "intellij.platform.workspace.storage"})
    @SourceDebugExtension(value={"SMAP\nVirtualFileIndex.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VirtualFileIndex.kt\ncom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,420:1\n1855#2,2:421\n1855#2,2:423\n1855#2,2:430\n215#3,2:425\n215#3,2:428\n215#3:432\n215#3,2:433\n216#3:435\n215#3,2:436\n1#4:427\n11#5:438\n*S KotlinDebug\n*F\n+ 1 VirtualFileIndex.kt\ncom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex\n*L\n191#1:421,2\n198#1:423,2\n330#1:430,2\n210#1:425,2\n220#1:428,2\n349#1:432\n354#1:433,2\n349#1:435\n368#1:436,2\n373#1:438\n*E\n"})
    public static final class MutableVirtualFileIndex
    extends VirtualFileIndex
    implements MutableVirtualFileUrlIndex {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private Long2ObjectOpenHashMap<Object> entityId2VirtualFileUrl;
        @NotNull
        private Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> vfu2EntityId;
        @NotNull
        private BidirectionalLongMultiMap<VirtualFileUrl> entityId2JarDir;
        private boolean freezed;
        @NotNull
        private static final Logger LOG;
        private static final int DEFAULT_COLLECTION_SIZE = 2;
        @NotNull
        public static final String VIRTUAL_FILE_INDEX_ENTITY_SOURCE_PROPERTY = "entitySource";

        private MutableVirtualFileIndex(Long2ObjectOpenHashMap<Object> entityId2VirtualFileUrl, Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> vfu2EntityId, BidirectionalLongMultiMap<VirtualFileUrl> entityId2JarDir) {
            super(entityId2VirtualFileUrl, vfu2EntityId, entityId2JarDir);
            this.entityId2VirtualFileUrl = entityId2VirtualFileUrl;
            this.vfu2EntityId = vfu2EntityId;
            this.entityId2JarDir = entityId2JarDir;
            this.freezed = true;
        }

        @Override
        @NotNull
        public Long2ObjectOpenHashMap<Object> getEntityId2VirtualFileUrl$intellij_platform_workspace_storage() {
            return this.entityId2VirtualFileUrl;
        }

        public void setEntityId2VirtualFileUrl(@NotNull Long2ObjectOpenHashMap<Object> long2ObjectOpenHashMap) {
            Intrinsics.checkNotNullParameter(long2ObjectOpenHashMap, "<set-?>");
            this.entityId2VirtualFileUrl = long2ObjectOpenHashMap;
        }

        @Override
        @NotNull
        public Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> getVfu2EntityId$intellij_platform_workspace_storage() {
            return this.vfu2EntityId;
        }

        public void setVfu2EntityId(@NotNull Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> object2ObjectOpenCustomHashMap) {
            Intrinsics.checkNotNullParameter(object2ObjectOpenCustomHashMap, "<set-?>");
            this.vfu2EntityId = object2ObjectOpenCustomHashMap;
        }

        @Override
        @NotNull
        public BidirectionalLongMultiMap<VirtualFileUrl> getEntityId2JarDir$intellij_platform_workspace_storage() {
            return this.entityId2JarDir;
        }

        public void setEntityId2JarDir(@NotNull BidirectionalLongMultiMap<VirtualFileUrl> bidirectionalLongMultiMap) {
            Intrinsics.checkNotNullParameter(bidirectionalLongMultiMap, "<set-?>");
            this.entityId2JarDir = bidirectionalLongMultiMap;
        }

        @Override
        public synchronized void index(@NotNull WorkspaceEntity entity, @NotNull String propertyName, @Nullable VirtualFileUrl virtualFileUrl) {
            Intrinsics.checkNotNullParameter(entity, "entity");
            Intrinsics.checkNotNullParameter(propertyName, "propertyName");
            this.index$intellij_platform_workspace_storage(((WorkspaceEntityBase)entity).getId(), propertyName, virtualFileUrl);
        }

        public final synchronized void index$intellij_platform_workspace_storage(long id2, @NotNull String propertyName, @NotNull Collection<? extends VirtualFileUrl> virtualFileUrls) {
            Intrinsics.checkNotNullParameter(propertyName, "propertyName");
            Intrinsics.checkNotNullParameter(virtualFileUrls, "virtualFileUrls");
            this.startWrite();
            HashSet<VirtualFileUrl> newVirtualFileUrls = new HashSet<VirtualFileUrl>(virtualFileUrls);
            Object property2Vfu = this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().get(id2);
            if (property2Vfu != null) {
                Object object = property2Vfu;
                if (TypeIntrinsics.isMutableMap(object)) {
                    Object existingVfu = ((Map)property2Vfu).get(propertyName);
                    if (existingVfu != null && MutableVirtualFileIndex.index$cleanExistingVfu(newVirtualFileUrls, this, id2, propertyName, existingVfu)) {
                        TypeIntrinsics.asMutableMap((Map)property2Vfu).remove(propertyName);
                        if (((Map)property2Vfu).isEmpty()) {
                            this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().remove(id2);
                        }
                    }
                } else if (object instanceof Pair) {
                    Object a2 = ((Pair)property2Vfu).getFirst();
                    Intrinsics.checkNotNull(a2, "null cannot be cast to non-null type kotlin.String");
                    String existingPropertyName = (String)a2;
                    if (Intrinsics.areEqual(existingPropertyName, propertyName)) {
                        Object b2 = ((Pair)property2Vfu).getSecond();
                        Intrinsics.checkNotNull(b2);
                        if (MutableVirtualFileIndex.index$cleanExistingVfu(newVirtualFileUrls, this, id2, propertyName, b2)) {
                            this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().remove(id2);
                        }
                    }
                }
            }
            Iterable $this$forEach$iv = newVirtualFileUrls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFileUrl it = (VirtualFileUrl)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull(it);
                this.indexVirtualFileUrl(id2, propertyName, it);
            }
        }

        public final synchronized void indexJarDirectories$intellij_platform_workspace_storage(long id2, @NotNull Set<? extends VirtualFileUrl> virtualFileUrls) {
            Intrinsics.checkNotNullParameter(virtualFileUrls, "virtualFileUrls");
            this.getEntityId2JarDir$intellij_platform_workspace_storage().removeKey(id2);
            if (virtualFileUrls.isEmpty()) {
                return;
            }
            Iterable $this$forEach$iv = virtualFileUrls;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VirtualFileUrl it = (VirtualFileUrl)element$iv;
                boolean bl2 = false;
                this.getEntityId2JarDir$intellij_platform_workspace_storage().put(id2, it);
            }
        }

        public final synchronized void index$intellij_platform_workspace_storage(long id2, @NotNull String propertyName, @Nullable VirtualFileUrl virtualFileUrl) {
            Intrinsics.checkNotNullParameter(propertyName, "propertyName");
            this.startWrite();
            this.removeByPropertyFromIndexes(id2, propertyName);
            if (virtualFileUrl == null) {
                return;
            }
            this.indexVirtualFileUrl(id2, propertyName, virtualFileUrl);
        }

        public static /* synthetic */ void index$intellij_platform_workspace_storage$default(MutableVirtualFileIndex mutableVirtualFileIndex, long l2, String string2, VirtualFileUrl virtualFileUrl, int n2, Object object) {
            if ((n2 & 4) != 0) {
                virtualFileUrl = null;
            }
            mutableVirtualFileIndex.index$intellij_platform_workspace_storage(l2, string2, virtualFileUrl);
        }

        public final void updateIndex$intellij_platform_workspace_storage(long oldId, long newId, @NotNull VirtualFileIndex oldIndex) {
            Set<VirtualFileUrl> set;
            Intrinsics.checkNotNullParameter(oldIndex, "oldIndex");
            Map<String, Set<VirtualFileUrl>> $this$forEach$iv = oldIndex.getVirtualFileUrlInfoByEntityId$intellij_platform_workspace_storage(oldId);
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Set<VirtualFileUrl>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Set<VirtualFileUrl>> element$iv;
                Map.Entry<String, Set<VirtualFileUrl>> entry = element$iv = iterator2.next();
                boolean bl2 = false;
                String property = entry.getKey();
                Set<VirtualFileUrl> vfus = entry.getValue();
                this.index$intellij_platform_workspace_storage(newId, property, (Collection<? extends VirtualFileUrl>)vfus);
            }
            Set<VirtualFileUrl> $this$updateIndex_u24lambda_u244 = set = oldIndex.getEntityId2JarDir$intellij_platform_workspace_storage().getValues(oldId);
            boolean bl3 = false;
            this.indexJarDirectories$intellij_platform_workspace_storage(newId, CollectionsKt.toSet((Iterable)$this$updateIndex_u24lambda_u244));
        }

        public final synchronized void removeRecordsByEntityId$intellij_platform_workspace_storage(long id2) {
            this.startWrite();
            this.getEntityId2JarDir$intellij_platform_workspace_storage().removeKey(id2);
            Object object = this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().remove(id2);
            if (object == null) {
                return;
            }
            Object removedValue = object;
            Object object2 = removedValue;
            if (TypeIntrinsics.isMutableMap(object2)) {
                Map $this$forEach$iv = (Map)removedValue;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Object property = entry.getKey();
                    Object vfu = entry.getValue();
                    Intrinsics.checkNotNull(property, "null cannot be cast to non-null type kotlin.String");
                    String string2 = (String)property;
                    Object v2 = vfu;
                    Intrinsics.checkNotNull(v2);
                    this.removeFromVfu2EntityIdMap(id2, string2, v2);
                }
            } else if (object2 instanceof Pair) {
                Object a2 = ((Pair)removedValue).getFirst();
                Intrinsics.checkNotNull(a2, "null cannot be cast to non-null type kotlin.String");
                String string3 = (String)a2;
                Object b2 = ((Pair)removedValue).getSecond();
                Intrinsics.checkNotNull(b2);
                this.removeFromVfu2EntityIdMap(id2, string3, b2);
            }
        }

        @TestOnly
        public final void clear$intellij_platform_workspace_storage() {
            this.startWrite();
            this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().clear();
            this.getVfu2EntityId$intellij_platform_workspace_storage().clear();
            this.getEntityId2JarDir$intellij_platform_workspace_storage().clear();
        }

        @TestOnly
        public final void copyFrom$intellij_platform_workspace_storage(@NotNull VirtualFileIndex another) {
            Intrinsics.checkNotNullParameter(another, "another");
            this.startWrite();
            this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().putAll((Map<Long, Object>)another.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage());
            this.getVfu2EntityId$intellij_platform_workspace_storage().putAll((Map<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>>)another.getVfu2EntityId$intellij_platform_workspace_storage());
            ContainerExtensionsKt.putAll(this.getEntityId2JarDir$intellij_platform_workspace_storage(), another.getEntityId2JarDir$intellij_platform_workspace_storage());
        }

        private final void startWrite() {
            if (!this.freezed) {
                return;
            }
            this.freezed = false;
            this.setEntityId2VirtualFileUrl(this.copyEntityMap(this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage()));
            this.setVfu2EntityId(this.copyVfuMap(this.getVfu2EntityId$intellij_platform_workspace_storage()));
            this.setEntityId2JarDir(this.getEntityId2JarDir$intellij_platform_workspace_storage().copy());
        }

        @NotNull
        public final VirtualFileIndex toImmutable() {
            this.freezed = true;
            return new VirtualFileIndex(this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage(), this.getVfu2EntityId$intellij_platform_workspace_storage(), this.getEntityId2JarDir$intellij_platform_workspace_storage());
        }

        private final void indexVirtualFileUrl(long id2, String propertyName, VirtualFileUrl virtualFileUrl) {
            Object property2Vfu = this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().get(id2);
            if (property2Vfu != null) {
                Pair<String, Object> newProperty2Vfu;
                Object object;
                Object object2 = property2Vfu;
                if (TypeIntrinsics.isMutableMap(object2)) {
                    TypeIntrinsics.asMutableMap(property2Vfu);
                    Object vfu = ((Map)property2Vfu).get(propertyName);
                    if (vfu == null) {
                        ((Map)property2Vfu).put(propertyName, virtualFileUrl);
                    } else {
                        ((Map)property2Vfu).put(propertyName, MutableVirtualFileIndex.indexVirtualFileUrl$addVfuToPropertyName(virtualFileUrl, vfu));
                    }
                    object = property2Vfu;
                } else if (object2 instanceof Pair) {
                    Pair cfr_ignored_0 = (Pair)property2Vfu;
                    if (!Intrinsics.areEqual(((Pair)property2Vfu).getFirst(), propertyName)) {
                        Map<Object, Object> map2 = CollectionFactory.createSmallMemoryFootprintMap(2);
                        Intrinsics.checkNotNullExpressionValue(map2, "createSmallMemoryFootprintMap(...)");
                        Map<Object, Object> result2 = map2;
                        result2.put(((Pair)property2Vfu).getFirst(), ((Pair)property2Vfu).getSecond());
                        result2.put(propertyName, virtualFileUrl);
                        object = result2;
                    } else {
                        object = new Pair<String, Object>(propertyName, MutableVirtualFileIndex.indexVirtualFileUrl$addVfuToPropertyName(virtualFileUrl, ((Pair)property2Vfu).getSecond()));
                    }
                } else {
                    object = newProperty2Vfu = null;
                }
                if (newProperty2Vfu != null) {
                    Long l2 = id2;
                    ((Map)this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage()).put(l2, newProperty2Vfu);
                }
            } else {
                Long l3 = id2;
                ((Map)this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage()).put(l3, new Pair<String, VirtualFileUrl>(propertyName, virtualFileUrl));
            }
            Object2LongWithDefaultMap<EntityIdWithProperty> property2EntityId = this.getVfu2EntityId$intellij_platform_workspace_storage().getOrDefault(virtualFileUrl, new Object2LongWithDefaultMap());
            property2EntityId.put(this.getCompositeKey$intellij_platform_workspace_storage(id2, propertyName), id2);
            ((Map)this.getVfu2EntityId$intellij_platform_workspace_storage()).put(virtualFileUrl, property2EntityId);
        }

        private final void removeByPropertyFromIndexes(long id2, String propertyName) {
            Object object = this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().get(id2);
            if (object == null) {
                return;
            }
            Object property2vfu = object;
            Object object2 = property2vfu;
            if (TypeIntrinsics.isMutableMap(object2)) {
                TypeIntrinsics.asMutableMap(property2vfu);
                Object v2 = ((Map)property2vfu).remove(propertyName);
                if (v2 == null) {
                    return;
                }
                Object vfu = v2;
                if (((Map)property2vfu).isEmpty()) {
                    this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().remove(id2);
                }
                this.removeFromVfu2EntityIdMap(id2, propertyName, vfu);
            } else if (object2 instanceof Pair) {
                Object a2 = ((Pair)property2vfu).getFirst();
                Intrinsics.checkNotNull(a2, "null cannot be cast to non-null type kotlin.String");
                String existingPropertyName = (String)a2;
                if (!Intrinsics.areEqual(existingPropertyName, propertyName)) {
                    return;
                }
                this.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage().remove(id2);
                Object b2 = ((Pair)property2vfu).getSecond();
                Intrinsics.checkNotNull(b2);
                this.removeFromVfu2EntityIdMap(id2, propertyName, b2);
            }
        }

        private final void removeFromVfu2EntityIdMap(long id2, String property, Object vfus) {
            if (vfus instanceof Set) {
                Iterable $this$forEach$iv = (Iterable)vfus;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.url.VirtualFileUrl");
                    this.removeFromVfu2EntityIdMap(id2, property, (VirtualFileUrl)it);
                }
            } else {
                Intrinsics.checkNotNull(vfus, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.url.VirtualFileUrl");
                this.removeFromVfu2EntityIdMap(id2, property, (VirtualFileUrl)vfus);
            }
        }

        private final void removeFromVfu2EntityIdMap(long id2, String propertyName, VirtualFileUrl vfu) {
            Object2LongWithDefaultMap<EntityIdWithProperty> property2EntityId = this.getVfu2EntityId$intellij_platform_workspace_storage().get(vfu);
            if (property2EntityId == null) {
                LOG.error("The record for " + id2 + " <=> " + vfu + " should be available in both maps");
                return;
            }
            property2EntityId.removeLong(this.getCompositeKey$intellij_platform_workspace_storage(id2, propertyName));
            if (property2EntityId.isEmpty()) {
                this.getVfu2EntityId$intellij_platform_workspace_storage().remove(vfu);
            }
        }

        private final Long2ObjectOpenHashMap<Object> copyEntityMap(Long2ObjectOpenHashMap<Object> originMap) {
            Long2ObjectOpenHashMap<Object> copiedMap = new Long2ObjectOpenHashMap<Object>();
            Map $this$forEach$iv = originMap;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                Long entityId = (Long)entry.getKey();
                Object vfuMap = entry.getValue();
                Object v2 = vfuMap;
                if (v2 instanceof Map) {
                    Map copiedVfuMap;
                    Intrinsics.checkNotNull(vfuMap, "null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                    Map cfr_ignored_0 = (Map)vfuMap;
                    Intrinsics.checkNotNullExpressionValue(CollectionFactory.createSmallMemoryFootprintMap(((Map)vfuMap).size()), "createSmallMemoryFootprintMap(...)");
                    Map $this$forEach$iv2 = (Map)vfuMap;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator3 = $this$forEach$iv2.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        Map.Entry element$iv2;
                        Map.Entry it = element$iv2 = iterator3.next();
                        boolean bl3 = false;
                        Object k2 = it.getKey();
                        Object v3 = it.getValue();
                        Intrinsics.checkNotNull(v3);
                        copiedVfuMap.put(k2, MutableVirtualFileIndex.copyEntityMap$getVirtualFileUrl(v3));
                    }
                    ((Map)copiedMap).put(entityId, copiedVfuMap);
                    continue;
                }
                if (!(v2 instanceof Pair)) continue;
                Object a2 = ((Pair)vfuMap).getFirst();
                Intrinsics.checkNotNull(a2, "null cannot be cast to non-null type kotlin.String");
                String string2 = (String)a2;
                Object b2 = ((Pair)vfuMap).getSecond();
                Intrinsics.checkNotNull(b2);
                Pair<String, Object> copiedVfuPair = new Pair<String, Object>(string2, MutableVirtualFileIndex.copyEntityMap$getVirtualFileUrl(b2));
                ((Map)copiedMap).put(entityId, copiedVfuPair);
            }
            return copiedMap;
        }

        private final Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> copyVfuMap(Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> originMap) {
            Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>> copiedMap = new Object2ObjectOpenCustomHashMap<VirtualFileUrl, Object2LongWithDefaultMap<EntityIdWithProperty>>(VirtualFileIndexKt.getHashingStrategy());
            Map $this$forEach$iv = originMap;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                VirtualFileUrl key = (VirtualFileUrl)entry.getKey();
                Object2LongWithDefaultMap value = (Object2LongWithDefaultMap)entry.getValue();
                Map map2 = copiedMap;
                Intrinsics.checkNotNull(value);
                map2.put(key, Object2LongWithDefaultMap.Companion.from(value));
            }
            return copiedMap;
        }

        private static final boolean index$cleanExistingVfu$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean index$cleanExistingVfu(HashSet<VirtualFileUrl> newVirtualFileUrls, MutableVirtualFileIndex this$0, long $id, String $propertyName, Object existingVfu) {
            if (existingVfu instanceof Set) {
                Intrinsics.checkNotNull(existingVfu, "null cannot be cast to non-null type it.unimi.dsi.fastutil.objects.ObjectOpenHashSet<com.intellij.platform.workspace.storage.url.VirtualFileUrl>");
                ObjectOpenHashSet cfr_ignored_0 = (ObjectOpenHashSet)existingVfu;
                ((ObjectOpenHashSet)existingVfu).removeIf(arg_0 -> MutableVirtualFileIndex.index$cleanExistingVfu$lambda$0(new Function1<VirtualFileUrl, Boolean>(newVirtualFileUrls, this$0, $id, $propertyName){
                    final /* synthetic */ HashSet<VirtualFileUrl> $newVirtualFileUrls;
                    final /* synthetic */ MutableVirtualFileIndex this$0;
                    final /* synthetic */ long $id;
                    final /* synthetic */ String $propertyName;
                    {
                        this.$newVirtualFileUrls = $newVirtualFileUrls;
                        this.this$0 = $receiver;
                        this.$id = $id;
                        this.$propertyName = $propertyName;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(VirtualFileUrl vfu) {
                        boolean elementRemoved = this.$newVirtualFileUrls.remove(vfu);
                        if (!elementRemoved) {
                            Intrinsics.checkNotNull(vfu);
                            MutableVirtualFileIndex.access$removeFromVfu2EntityIdMap(this.this$0, this.$id, this.$propertyName, vfu);
                        }
                        return !elementRemoved;
                    }
                }, arg_0));
                if (((Set)existingVfu).isEmpty()) {
                    return true;
                }
            } else {
                Intrinsics.checkNotNull(existingVfu, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.url.VirtualFileUrl");
                VirtualFileUrl cfr_ignored_1 = (VirtualFileUrl)existingVfu;
                boolean elementRemoved = newVirtualFileUrls.remove(existingVfu);
                if (!elementRemoved) {
                    this$0.removeFromVfu2EntityIdMap($id, $propertyName, (VirtualFileUrl)existingVfu);
                    return true;
                }
            }
            return false;
        }

        private static final Object indexVirtualFileUrl$addVfuToPropertyName(VirtualFileUrl $virtualFileUrl, Object vfu) {
            if (vfu instanceof ObjectOpenHashSet) {
                ((ObjectOpenHashSet)vfu).add($virtualFileUrl);
                return vfu;
            }
            Set set = CollectionFactory.createSmallMemoryFootprintSet(2);
            Intrinsics.checkNotNullExpressionValue(set, "createSmallMemoryFootprintSet(...)");
            Set result2 = set;
            Intrinsics.checkNotNull(vfu, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.url.VirtualFileUrl");
            result2.add((VirtualFileUrl)vfu);
            result2.add($virtualFileUrl);
            return result2;
        }

        private static final Object copyEntityMap$getVirtualFileUrl(Object value) {
            Set set;
            if (value instanceof Set) {
                Set set2 = CollectionFactory.createSmallMemoryFootprintSet(value);
                set = set2;
                Intrinsics.checkNotNullExpressionValue(set2, "createSmallMemoryFootprintSet(...)");
            } else {
                set = value;
            }
            return set;
        }

        public /* synthetic */ MutableVirtualFileIndex(Long2ObjectOpenHashMap entityId2VirtualFileUrl, Object2ObjectOpenCustomHashMap vfu2EntityId, BidirectionalLongMultiMap entityId2JarDir, DefaultConstructorMarker $constructor_marker) {
            this(entityId2VirtualFileUrl, vfu2EntityId, entityId2JarDir);
        }

        public static final /* synthetic */ void access$removeFromVfu2EntityIdMap(MutableVirtualFileIndex $this, long id2, String propertyName, VirtualFileUrl vfu) {
            $this.removeFromVfu2EntityIdMap(id2, propertyName, vfu);
        }

        static {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(MutableVirtualFileIndex.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
            LOG = logger;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex$Companion;", "", "()V", "DEFAULT_COLLECTION_SIZE", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "VIRTUAL_FILE_INDEX_ENTITY_SOURCE_PROPERTY", "", "from", "Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex$MutableVirtualFileIndex;", "other", "Lcom/intellij/platform/workspace/storage/impl/indices/VirtualFileIndex;", "from$intellij_platform_workspace_storage", "intellij.platform.workspace.storage"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final MutableVirtualFileIndex from$intellij_platform_workspace_storage(@NotNull VirtualFileIndex other) {
                Intrinsics.checkNotNullParameter(other, "other");
                if (other instanceof MutableVirtualFileIndex) {
                    ((MutableVirtualFileIndex)other).freezed = true;
                }
                return new MutableVirtualFileIndex(other.getEntityId2VirtualFileUrl$intellij_platform_workspace_storage(), other.getVfu2EntityId$intellij_platform_workspace_storage(), other.getEntityId2JarDir$intellij_platform_workspace_storage(), null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

