/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.serialization.registration;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.objenesis.instantiator.ObjectInstantiator;
import com.esotericsoftware.kryo.kryo5.serializers.DefaultSerializers;
import com.esotericsoftware.kryo.kryo5.serializers.FieldSerializer;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.intellij.platform.workspace.storage.EntityTypesResolver;
import com.intellij.platform.workspace.storage.impl.ChangeEntry;
import com.intellij.platform.workspace.storage.impl.ChildEntityId;
import com.intellij.platform.workspace.storage.impl.ConnectionId;
import com.intellij.platform.workspace.storage.impl.ImmutableEntitiesBarrel;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityFamily;
import com.intellij.platform.workspace.storage.impl.ParentEntityId;
import com.intellij.platform.workspace.storage.impl.RefsTable;
import com.intellij.platform.workspace.storage.impl.containers.BidirectionalLongMultiMap;
import com.intellij.platform.workspace.storage.impl.containers.BidirectionalSetMap;
import com.intellij.platform.workspace.storage.impl.containers.Int2IntWithDefaultMap;
import com.intellij.platform.workspace.storage.impl.containers.LinkedBidirectionalMap;
import com.intellij.platform.workspace.storage.impl.containers.MutableIntIntUniqueBiMap;
import com.intellij.platform.workspace.storage.impl.containers.MutableNonNegativeIntIntBiMap;
import com.intellij.platform.workspace.storage.impl.containers.MutableNonNegativeIntIntMultiMap;
import com.intellij.platform.workspace.storage.impl.containers.MutableWorkspaceList;
import com.intellij.platform.workspace.storage.impl.containers.MutableWorkspaceSet;
import com.intellij.platform.workspace.storage.impl.indices.EntityStorageInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.MultimapStorageIndex;
import com.intellij.platform.workspace.storage.impl.indices.SymbolicIdInternalIndex;
import com.intellij.platform.workspace.storage.impl.indices.VirtualFileIndex;
import com.intellij.platform.workspace.storage.impl.references.ImmutableAbstractOneToOneContainer;
import com.intellij.platform.workspace.storage.impl.references.ImmutableOneToAbstractManyContainer;
import com.intellij.platform.workspace.storage.impl.references.ImmutableOneToManyContainer;
import com.intellij.platform.workspace.storage.impl.references.ImmutableOneToOneContainer;
import com.intellij.platform.workspace.storage.impl.serialization.CacheMetadata;
import com.intellij.platform.workspace.storage.impl.serialization.SerializableEntityId;
import com.intellij.platform.workspace.storage.impl.serialization.TypeInfo;
import com.intellij.platform.workspace.storage.impl.serialization.registration.EmptySerializer;
import com.intellij.platform.workspace.storage.impl.serialization.registration.SerializerRegistrarKt;
import com.intellij.platform.workspace.storage.impl.serialization.registration.StorageRegistrar;
import com.intellij.platform.workspace.storage.impl.serialization.serializer.DefaultListSerializer;
import com.intellij.platform.workspace.storage.impl.serialization.serializer.DefaultMapSerializer;
import com.intellij.platform.workspace.storage.impl.serialization.serializer.DefaultSetSerializer;
import com.intellij.platform.workspace.storage.impl.serialization.serializer.HashMultimapSerializer;
import com.intellij.platform.workspace.storage.impl.serialization.serializer.Int2IntOpenHashMapSerializer;
import com.intellij.platform.workspace.storage.impl.serialization.serializer.Int2IntWithDefaultMapSerializer;
import com.intellij.platform.workspace.storage.impl.serialization.serializer.ObjectOpenHashSetSerializer;
import com.intellij.platform.workspace.storage.impl.serialization.serializer.StorageSerializerUtil;
import com.intellij.platform.workspace.storage.metadata.model.EntityMetadata;
import com.intellij.platform.workspace.storage.metadata.model.ExtPropertyMetadata;
import com.intellij.platform.workspace.storage.metadata.model.ExtendableClassMetadata;
import com.intellij.platform.workspace.storage.metadata.model.FinalClassMetadata;
import com.intellij.platform.workspace.storage.metadata.model.OwnPropertyMetadata;
import com.intellij.platform.workspace.storage.metadata.model.PropertyMetadata;
import com.intellij.platform.workspace.storage.metadata.model.StorageClassMetadata;
import com.intellij.platform.workspace.storage.metadata.model.StorageTypeMetadata;
import com.intellij.platform.workspace.storage.metadata.model.ValueTypeMetadata;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/workspace/storage/impl/serialization/registration/StorageClassesRegistrar;", "Lcom/intellij/platform/workspace/storage/impl/serialization/registration/StorageRegistrar;", "serializerUtil", "Lcom/intellij/platform/workspace/storage/impl/serialization/serializer/StorageSerializerUtil;", "typesResolver", "Lcom/intellij/platform/workspace/storage/EntityTypesResolver;", "(Lcom/intellij/platform/workspace/storage/impl/serialization/serializer/StorageSerializerUtil;Lcom/intellij/platform/workspace/storage/EntityTypesResolver;)V", "kotlinCollectionsToRegistrar", "", "Ljava/lang/Class;", "kotlinPluginId", "", "registerChangeEntry", "", "kryo", "Lcom/esotericsoftware/kryo/kryo5/Kryo;", "registerClasses", "registerCollections", "registerDefaultSerializers", "registerEmptyCollections", "registerFieldSerializers", "registerKotlinCollections", "registerKotlinCollectionsInKotlinPlugin", "registerMetadataClasses", "registerRefsTableClasses", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nStorageRegistrar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageRegistrar.kt\ncom/intellij/platform/workspace/storage/impl/serialization/registration/StorageClassesRegistrar\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SerializerRegistrar.kt\ncom/intellij/platform/workspace/storage/impl/serialization/registration/SerializerRegistrarKt\n*L\n1#1,253:1\n1855#2,2:254\n1855#2,2:256\n13#3:258\n13#3:259\n13#3:260\n13#3:261\n17#3,3:262\n17#3,3:265\n17#3,3:268\n17#3,3:271\n17#3,3:274\n17#3,3:277\n17#3,3:280\n*S KotlinDebug\n*F\n+ 1 StorageRegistrar.kt\ncom/intellij/platform/workspace/storage/impl/serialization/registration/StorageClassesRegistrar\n*L\n164#1:254,2\n170#1:256,2\n228#1:258\n231#1:259\n232#1:260\n233#1:261\n244#1:262,3\n245#1:265,3\n246#1:268,3\n248#1:271,3\n249#1:274,3\n250#1:277,3\n251#1:280,3\n*E\n"})
public final class StorageClassesRegistrar
implements StorageRegistrar {
    @NotNull
    private final StorageSerializerUtil serializerUtil;
    @NotNull
    private final EntityTypesResolver typesResolver;
    @NotNull
    private final String kotlinPluginId;
    @NotNull
    private final List<Class<?>> kotlinCollectionsToRegistrar;

    public StorageClassesRegistrar(@NotNull StorageSerializerUtil serializerUtil, @NotNull EntityTypesResolver typesResolver) {
        Intrinsics.checkNotNullParameter(serializerUtil, "serializerUtil");
        Intrinsics.checkNotNullParameter(typesResolver, "typesResolver");
        this.serializerUtil = serializerUtil;
        this.typesResolver = typesResolver;
        this.kotlinPluginId = "org.jetbrains.kotlin";
        Class[] classArray = new Class[]{ArrayDeque.class, CollectionsKt.emptyList().getClass(), MapsKt.emptyMap().getClass(), SetsKt.emptySet().getClass()};
        this.kotlinCollectionsToRegistrar = CollectionsKt.listOf(classArray);
    }

    @Override
    public void registerClasses(@NotNull Kryo kryo) {
        Intrinsics.checkNotNullParameter(kryo, "kryo");
        this.registerDefaultSerializers(kryo);
        kryo.register(Int2IntOpenHashMap.class, new Int2IntOpenHashMapSerializer());
        kryo.register(Long.TYPE, this.serializerUtil.getEntityIdSerializer$intellij_platform_workspace_storage());
        kryo.register(HashMultimap.class, new HashMultimapSerializer());
        kryo.register(Int2IntWithDefaultMap.class, new Int2IntWithDefaultMapSerializer());
        kryo.register(ConnectionId.class, this.serializerUtil.getConnectionIdSerializer$intellij_platform_workspace_storage());
        kryo.register(ImmutableEntitiesBarrel.class, this.serializerUtil.getImmutableEntitiesBarrelSerializer$intellij_platform_workspace_storage());
        kryo.register(ChildEntityId.class, this.serializerUtil.getChildEntityIdSerializer$intellij_platform_workspace_storage());
        kryo.register(ParentEntityId.class, this.serializerUtil.getParentEntityIdSerializer$intellij_platform_workspace_storage());
        kryo.register(ObjectOpenHashSet.class, new ObjectOpenHashSetSerializer());
        kryo.register(SymbolicIdInternalIndex.class, this.serializerUtil.getSymbolicIdIndexSerializer$intellij_platform_workspace_storage());
        kryo.register(EntityStorageInternalIndex.class, this.serializerUtil.getEntityStorageIndexSerializer$intellij_platform_workspace_storage());
        kryo.register(MultimapStorageIndex.class, this.serializerUtil.getMultimapStorageIndexSerializer$intellij_platform_workspace_storage());
        kryo.register(BidirectionalLongMultiMap.class, this.serializerUtil.getEntityId2JarDirSerializer$intellij_platform_workspace_storage());
        kryo.register(Object2ObjectOpenCustomHashMap.class, this.serializerUtil.getVfu2EntityIdSerializer$intellij_platform_workspace_storage());
        kryo.register(Long2ObjectOpenHashMap.class, this.serializerUtil.getEntityId2VfuSerializer$intellij_platform_workspace_storage());
        kryo.register(TypeInfo.class);
        this.registerCollections(kryo);
        kryo.register(byte[].class);
        kryo.register(ImmutableEntityFamily.class);
        kryo.register(VirtualFileIndex.class);
        kryo.register(EntityStorageInternalIndex.class);
        kryo.register(SymbolicIdInternalIndex.class);
        kryo.register(int[].class);
        kryo.register(Pair.class);
        kryo.register(MultimapStorageIndex.class);
        kryo.register(SerializableEntityId.class);
        this.registerRefsTableClasses(kryo);
        this.registerChangeEntry(kryo);
        this.registerMetadataClasses(kryo);
        this.registerFieldSerializers(kryo);
        this.registerEmptyCollections(kryo);
        kryo.register(UUID.class);
    }

    private final void registerDefaultSerializers(Kryo kryo) {
        kryo.addDefaultSerializer(VirtualFileUrl.class, this.serializerUtil.getVirtualFileUrlSerializer$intellij_platform_workspace_storage());
        kryo.addDefaultSerializer(List.class, DefaultListSerializer.class);
        kryo.addDefaultSerializer(Set.class, DefaultSetSerializer.class);
        kryo.addDefaultSerializer(Map.class, DefaultMapSerializer.class);
    }

    private final void registerCollections(Kryo kryo) {
        kryo.register(List.class);
        kryo.register(Set.class);
        kryo.register(Map.class);
        kryo.register(List.class);
        kryo.register(Set.class);
        kryo.register(Map.class);
        kryo.register(Object[].class);
        this.registerKotlinCollections(kryo);
        this.registerKotlinCollectionsInKotlinPlugin(kryo);
        kryo.register(ArrayList.class);
        kryo.register(LinkedList.class);
        kryo.register(Stack.class);
        kryo.register(Vector.class);
        kryo.register(HashSet.class);
        kryo.register(EnumSet.class);
        kryo.register(TreeSet.class);
        kryo.register(HashMap.class);
        kryo.register(TreeMap.class);
        kryo.register(EnumMap.class);
        kryo.register(Hashtable.class);
        kryo.register(WeakHashMap.class);
        kryo.register(IdentityHashMap.class);
        kryo.register(SmartList.class).setInstantiator(StorageClassesRegistrar::registerCollections$lambda$0);
        kryo.register(LinkedHashMap.class).setInstantiator(StorageClassesRegistrar::registerCollections$lambda$1);
        kryo.register(BidirectionalSetMap.class).setInstantiator(StorageClassesRegistrar::registerCollections$lambda$2);
        kryo.register(BidirectionalMultiMap.class).setInstantiator(StorageClassesRegistrar::registerCollections$lambda$3);
        kryo.register(HashBiMap.class).setInstantiator(StorageClassesRegistrar::registerCollections$lambda$4);
        kryo.register(LinkedHashSet.class).setInstantiator(StorageClassesRegistrar::registerCollections$lambda$5);
        kryo.register(LinkedBidirectionalMap.class).setInstantiator(StorageClassesRegistrar::registerCollections$lambda$6);
        kryo.register(ObjectOpenHashSet.class).setInstantiator(StorageClassesRegistrar::registerCollections$lambda$7);
        kryo.register(Object2ObjectOpenHashMap.class).setInstantiator(StorageClassesRegistrar::registerCollections$lambda$8);
        kryo.register(MutableWorkspaceList.class);
        kryo.register(MutableWorkspaceSet.class);
        kryo.register(Arrays.asList(new Integer[0]).getClass());
    }

    private final void registerKotlinCollections(Kryo kryo) {
        Iterable $this$forEach$iv = this.kotlinCollectionsToRegistrar;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Class it = (Class)element$iv;
            boolean bl2 = false;
            kryo.register(it);
        }
    }

    private final void registerKotlinCollectionsInKotlinPlugin(Kryo kryo) {
        ClassLoader classLoader2 = this.typesResolver.getClassLoader(this.kotlinPluginId);
        if (classLoader2 != null) {
            Iterable $this$forEach$iv = this.kotlinCollectionsToRegistrar;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Class it = (Class)element$iv;
                boolean bl2 = false;
                Class<?> classInKotlinPlugin = classLoader2.loadClass(it.getName());
                kryo.register(classInKotlinPlugin);
            }
        }
    }

    private final void registerRefsTableClasses(Kryo kryo) {
        kryo.register(RefsTable.class);
        kryo.register(ImmutableOneToOneContainer.class);
        kryo.register(ImmutableOneToManyContainer.class);
        kryo.register(ImmutableAbstractOneToOneContainer.class);
        kryo.register(ImmutableOneToAbstractManyContainer.class);
        kryo.register(MutableIntIntUniqueBiMap.class);
        kryo.register(MutableNonNegativeIntIntBiMap.class);
        kryo.register(MutableNonNegativeIntIntMultiMap.ByList.class);
    }

    private final void registerChangeEntry(Kryo kryo) {
        kryo.register(ChangeEntry.AddEntity.class);
        kryo.register(ChangeEntry.RemoveEntity.class);
        kryo.register(ChangeEntry.ReplaceEntity.class);
        kryo.register(ChangeEntry.ReplaceEntity.Data.class);
        kryo.register(ChangeEntry.ReplaceEntity.References.class);
    }

    private final void registerMetadataClasses(Kryo kryo) {
        kryo.register(CacheMetadata.class);
        kryo.register(CacheMetadata.Id.class);
        kryo.register(CacheMetadata.SerializableTypeMetadata.class);
        kryo.register(StorageTypeMetadata.class);
        kryo.register(EntityMetadata.class);
        kryo.register(StorageClassMetadata.class);
        kryo.register(FinalClassMetadata.class);
        kryo.register(FinalClassMetadata.ClassMetadata.class);
        kryo.register(FinalClassMetadata.ObjectMetadata.class);
        kryo.register(FinalClassMetadata.EnumClassMetadata.class);
        kryo.register(FinalClassMetadata.KnownClass.class);
        kryo.register(ExtendableClassMetadata.class);
        kryo.register(ExtendableClassMetadata.AbstractClassMetadata.class);
        kryo.register(PropertyMetadata.class);
        kryo.register(OwnPropertyMetadata.class);
        kryo.register(ExtPropertyMetadata.class);
        kryo.register(ValueTypeMetadata.class);
        kryo.register(ValueTypeMetadata.ParameterizedType.class);
        kryo.register(ValueTypeMetadata.SimpleType.class);
        kryo.register(ValueTypeMetadata.SimpleType.PrimitiveType.class);
        kryo.register(ValueTypeMetadata.SimpleType.CustomType.class);
        kryo.register(ValueTypeMetadata.EntityReference.class);
        kryo.register(ConnectionId.ConnectionType.class);
    }

    private final void registerFieldSerializers(Kryo kryo) {
        Class<?> type$iv = Collections.unmodifiableCollection(SetsKt.emptySet()).getClass();
        boolean $i$f$registerFieldSerializer = false;
        SerializerRegistrarKt.access$registerSerializer(kryo, type$iv, new FieldSerializer(kryo, type$iv), new ObjectInstantiator(){

            public final T newInstance() {
                boolean bl2 = false;
                return (T)Collections.unmodifiableCollection((Collection)SetsKt.emptySet());
            }
        });
        type$iv = Collections.unmodifiableSet(SetsKt.emptySet()).getClass();
        $i$f$registerFieldSerializer = false;
        SerializerRegistrarKt.access$registerSerializer(kryo, type$iv, new FieldSerializer(kryo, type$iv), new ObjectInstantiator(){

            public final T newInstance() {
                boolean bl2 = false;
                return (T)Collections.unmodifiableSet(SetsKt.emptySet());
            }
        });
        type$iv = Collections.unmodifiableList(CollectionsKt.emptyList()).getClass();
        $i$f$registerFieldSerializer = false;
        SerializerRegistrarKt.access$registerSerializer(kryo, type$iv, new FieldSerializer(kryo, type$iv), new ObjectInstantiator(){

            public final T newInstance() {
                boolean bl2 = false;
                return (T)Collections.unmodifiableList(CollectionsKt.emptyList());
            }
        });
        type$iv = Collections.unmodifiableMap(MapsKt.emptyMap()).getClass();
        $i$f$registerFieldSerializer = false;
        SerializerRegistrarKt.access$registerSerializer(kryo, type$iv, new FieldSerializer(kryo, type$iv), new ObjectInstantiator(){

            public final T newInstance() {
                boolean bl2 = false;
                return (T)Collections.unmodifiableMap(MapsKt.emptyMap());
            }
        });
    }

    private final void registerEmptyCollections(Kryo kryo) {
        kryo.register(Collections.EMPTY_LIST.getClass(), new DefaultSerializers.CollectionsEmptyListSerializer());
        kryo.register(Collections.EMPTY_MAP.getClass(), new DefaultSerializers.CollectionsEmptyMapSerializer());
        kryo.register(Collections.EMPTY_SET.getClass(), new DefaultSerializers.CollectionsEmptySetSerializer());
        kryo.register(CollectionsKt.listOf(null).getClass(), new DefaultSerializers.CollectionsSingletonListSerializer());
        kryo.register(Collections.singletonMap(null, null).getClass(), new DefaultSerializers.CollectionsSingletonMapSerializer());
        kryo.register(SetsKt.setOf(null).getClass(), new DefaultSerializers.CollectionsSingletonSetSerializer());
        boolean $i$f$registerSingletonSerializer = false;
        ObjectInstantiator getter1$iv = new ObjectInstantiator(){

            public final Object newInstance() {
                boolean bl2 = false;
                List<T> list2 = ContainerUtil.emptyList();
                Intrinsics.checkNotNullExpressionValue(list2, "emptyList(...)");
                return list2;
            }
        };
        SerializerRegistrarKt.access$registerSerializer(kryo, getter1$iv.newInstance().getClass(), EmptySerializer.INSTANCE, getter1$iv);
        $i$f$registerSingletonSerializer = false;
        getter1$iv = new ObjectInstantiator(){

            public final Object newInstance() {
                boolean bl2 = false;
                MostlySingularMultiMap<K, V> mostlySingularMultiMap = MostlySingularMultiMap.emptyMap();
                Intrinsics.checkNotNullExpressionValue(mostlySingularMultiMap, "emptyMap(...)");
                return mostlySingularMultiMap;
            }
        };
        SerializerRegistrarKt.access$registerSerializer(kryo, getter1$iv.newInstance().getClass(), EmptySerializer.INSTANCE, getter1$iv);
        $i$f$registerSingletonSerializer = false;
        getter1$iv = new ObjectInstantiator(){

            public final Object newInstance() {
                boolean bl2 = false;
                MultiMap<K, V> multiMap = MultiMap.empty();
                Intrinsics.checkNotNullExpressionValue(multiMap, "empty(...)");
                return multiMap;
            }
        };
        SerializerRegistrarKt.access$registerSerializer(kryo, getter1$iv.newInstance().getClass(), EmptySerializer.INSTANCE, getter1$iv);
        $i$f$registerSingletonSerializer = false;
        getter1$iv = new ObjectInstantiator(){

            public final Object newInstance() {
                boolean bl2 = false;
                return MapsKt.emptyMap();
            }
        };
        SerializerRegistrarKt.access$registerSerializer(kryo, getter1$iv.newInstance().getClass(), EmptySerializer.INSTANCE, getter1$iv);
        $i$f$registerSingletonSerializer = false;
        getter1$iv = new ObjectInstantiator(){

            public final Object newInstance() {
                boolean bl2 = false;
                return CollectionsKt.emptyList();
            }
        };
        SerializerRegistrarKt.access$registerSerializer(kryo, getter1$iv.newInstance().getClass(), EmptySerializer.INSTANCE, getter1$iv);
        $i$f$registerSingletonSerializer = false;
        getter1$iv = new ObjectInstantiator(){

            public final Object newInstance() {
                boolean bl2 = false;
                return SetsKt.emptySet();
            }
        };
        SerializerRegistrarKt.access$registerSerializer(kryo, getter1$iv.newInstance().getClass(), EmptySerializer.INSTANCE, getter1$iv);
        $i$f$registerSingletonSerializer = false;
        getter1$iv = new ObjectInstantiator(){

            public final Object newInstance() {
                boolean bl2 = false;
                boolean $i$f$emptyArray = false;
                return new Object[0];
            }
        };
        SerializerRegistrarKt.access$registerSerializer(kryo, getter1$iv.newInstance().getClass(), EmptySerializer.INSTANCE, getter1$iv);
    }

    private static final SmartList registerCollections$lambda$0() {
        return new SmartList();
    }

    private static final LinkedHashMap registerCollections$lambda$1() {
        return new LinkedHashMap();
    }

    private static final BidirectionalSetMap registerCollections$lambda$2() {
        return new BidirectionalSetMap();
    }

    private static final BidirectionalMultiMap registerCollections$lambda$3() {
        return new BidirectionalMultiMap();
    }

    private static final HashBiMap registerCollections$lambda$4() {
        return HashBiMap.create();
    }

    private static final LinkedHashSet registerCollections$lambda$5() {
        return new LinkedHashSet();
    }

    private static final LinkedBidirectionalMap registerCollections$lambda$6() {
        return new LinkedBidirectionalMap();
    }

    private static final ObjectOpenHashSet registerCollections$lambda$7() {
        return new ObjectOpenHashSet();
    }

    private static final Object2ObjectOpenHashMap registerCollections$lambda$8() {
        return new Object2ObjectOpenHashMap();
    }
}

