/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.url;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.workspace.storage.impl.url.BasePath;
import com.intellij.platform.workspace.storage.url.UrlRelativizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/workspace/storage/impl/url/UrlRelativizerImpl;", "Lcom/intellij/platform/workspace/storage/url/UrlRelativizer;", "basePathNameToUrl", "", "Lkotlin/Pair;", "", "(Ljava/util/List;)V", "basePaths", "", "Lcom/intellij/platform/workspace/storage/impl/url/BasePath;", "getBasePaths$intellij_platform_workspace_storage", "()Ljava/util/List;", "protocols", "addBasePath", "", "identifier", "url", "addBasePathWithProtocols", "getAllBasePathIdentifiers", "normalizeUrl", "toAbsoluteUrl", "toRelativeUrl", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nUrlRelativizerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlRelativizerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/UrlRelativizerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n1855#2,2:143\n1549#2:145\n1620#2,3:146\n*S KotlinDebug\n*F\n+ 1 UrlRelativizerImpl.kt\ncom/intellij/platform/workspace/storage/impl/url/UrlRelativizerImpl\n*L\n24#1:143,2\n85#1:145\n85#1:146,3\n*E\n"})
public class UrlRelativizerImpl
implements UrlRelativizer {
    @NotNull
    private final List<BasePath> basePaths;
    @NotNull
    private final List<String> protocols;

    public UrlRelativizerImpl(@NotNull List<Pair<String, String>> basePathNameToUrl) {
        Intrinsics.checkNotNullParameter(basePathNameToUrl, "basePathNameToUrl");
        this.basePaths = new ArrayList();
        String[] stringArray = new String[]{"file", "jar", "jrt"};
        this.protocols = CollectionsKt.listOf(stringArray);
        Iterable $this$forEach$iv = basePathNameToUrl;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl2 = false;
            this.addBasePathWithProtocols((String)it.getFirst(), (String)it.getSecond());
        }
    }

    public /* synthetic */ UrlRelativizerImpl(List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(list2);
    }

    @NotNull
    public final List<BasePath> getBasePaths$intellij_platform_workspace_storage() {
        return this.basePaths;
    }

    @Override
    @NotNull
    public String toRelativeUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String string2 = FileUtil.toSystemIndependentName(url);
        Intrinsics.checkNotNullExpressionValue(string2, "toSystemIndependentName(...)");
        String systemIndependentUrl = string2;
        for (BasePath basePath : this.basePaths) {
            if (!FileUtil.startsWith(systemIndependentUrl, basePath.getUrl$intellij_platform_workspace_storage())) continue;
            String string3 = basePath.getIdentifier$intellij_platform_workspace_storage();
            String string4 = systemIndependentUrl.substring(basePath.getUrl$intellij_platform_workspace_storage().length());
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            return string3 + string4;
        }
        return systemIndependentUrl;
    }

    @Override
    @NotNull
    public String toAbsoluteUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter(url, "url");
        String string2 = FileUtil.toSystemIndependentName(url);
        Intrinsics.checkNotNullExpressionValue(string2, "toSystemIndependentName(...)");
        String systemIndependentUrl = string2;
        for (BasePath basePath : this.basePaths) {
            if (!StringsKt.startsWith$default(systemIndependentUrl, basePath.getIdentifier$intellij_platform_workspace_storage(), false, 2, null)) continue;
            String string3 = basePath.getUrl$intellij_platform_workspace_storage();
            String string4 = systemIndependentUrl.substring(basePath.getIdentifier$intellij_platform_workspace_storage().length());
            Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
            return string3 + string4;
        }
        return systemIndependentUrl;
    }

    private final void addBasePath(String identifier, String url) {
        this.basePaths.add(new BasePath(identifier, url));
    }

    public final void addBasePathWithProtocols(@NotNull String identifier, @NotNull String url) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(url, "url");
        String normalizedUrl = this.normalizeUrl(url);
        String preparedIdentifier = "$" + identifier + "$";
        this.addBasePath(preparedIdentifier, normalizedUrl);
        for (String protocol : this.protocols) {
            this.addBasePath(protocol + ":" + preparedIdentifier, protocol + ":" + normalizedUrl);
            this.addBasePath(protocol + ":/" + preparedIdentifier, protocol + ":/" + normalizedUrl);
            this.addBasePath(protocol + "://" + preparedIdentifier, protocol + "://" + normalizedUrl);
        }
        CollectionsKt.sort(this.basePaths);
    }

    private final String normalizeUrl(String url) {
        String string2 = StringUtil.trimTrailing(FileUtil.toSystemIndependentName(url), '/');
        Intrinsics.checkNotNullExpressionValue(string2, "trimTrailing(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @NotNull
    public final List<String> getAllBasePathIdentifiers() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.basePaths;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void basePath;
            BasePath basePath2 = (BasePath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(basePath.getIdentifier$intellij_platform_workspace_storage());
        }
        return (List)destination$iv$iv;
    }

    public UrlRelativizerImpl() {
        this(null, 1, null);
    }
}

