/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.url;

import com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlManagerImpl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\bH\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlImpl;", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrl;", "id", "", "manager", "Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "(ILcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;)V", "cachedUrl", "", "getId", "()I", "getManager$intellij_platform_workspace_storage", "()Lcom/intellij/platform/workspace/storage/impl/url/VirtualFileUrlManagerImpl;", "append", "relativePath", "equals", "", "other", "", "getFileName", "getParent", "getPresentableUrl", "getSubTreeFileUrls", "", "getUrl", "getUrlSegments", "hashCode", "toString", "intellij.platform.workspace.storage"})
public class VirtualFileUrlImpl
implements VirtualFileUrl {
    private final int id;
    @NotNull
    private final VirtualFileUrlManagerImpl manager;
    @Nullable
    private String cachedUrl;

    public VirtualFileUrlImpl(int id2, @NotNull VirtualFileUrlManagerImpl manager) {
        Intrinsics.checkNotNullParameter(manager, "manager");
        this.id = id2;
        this.manager = manager;
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final VirtualFileUrlManagerImpl getManager$intellij_platform_workspace_storage() {
        return this.manager;
    }

    @Override
    @NotNull
    public String getUrl() {
        if (this.cachedUrl == null) {
            this.cachedUrl = this.manager.getUrlById(this.id);
        }
        String string2 = this.cachedUrl;
        Intrinsics.checkNotNull(string2);
        return string2;
    }

    @NotNull
    public final List<String> getUrlSegments() {
        char[] cArray = new char[]{'/', '\\'};
        return StringsKt.split$default((CharSequence)this.getUrl(), cArray, false, 0, 6, null);
    }

    @Override
    @NotNull
    public String getFileName() {
        return StringsKt.substringAfterLast$default(this.getUrl(), '/', null, 2, null);
    }

    @Override
    @Nullable
    public VirtualFileUrl getParent() {
        return this.manager.getParentVirtualUrl$intellij_platform_workspace_storage(this);
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        String calculatedUrl = this.getUrl();
        if (StringsKt.startsWith$default(calculatedUrl, "file://", false, 2, null)) {
            String string2 = calculatedUrl.substring(7);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            return string2;
        }
        if (StringsKt.startsWith$default(calculatedUrl, "jar://", false, 2, null)) {
            String removedSuffix = StringsKt.removeSuffix(StringsKt.removeSuffix(calculatedUrl, (CharSequence)"!/"), (CharSequence)"!");
            String string3 = removedSuffix.substring(6);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            return string3;
        }
        return calculatedUrl;
    }

    @Override
    @NotNull
    public List<VirtualFileUrl> getSubTreeFileUrls() {
        return this.manager.getSubtreeVirtualUrlsById$intellij_platform_workspace_storage(this);
    }

    @Override
    @NotNull
    public VirtualFileUrl append(@NotNull String relativePath) {
        Intrinsics.checkNotNullParameter(relativePath, "relativePath");
        return this.manager.append$intellij_platform_workspace_storage(this, StringsKt.removePrefix(relativePath, (CharSequence)"/"));
    }

    @NotNull
    public String toString() {
        return this.getUrl();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull(other, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.url.VirtualFileUrlImpl");
        VirtualFileUrlImpl cfr_ignored_0 = (VirtualFileUrlImpl)other;
        return this.id == ((VirtualFileUrlImpl)other).id;
    }

    public int hashCode() {
        return this.id;
    }
}

