/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.metadata.impl;

import com.intellij.platform.workspace.storage.metadata.MetadataStorage;
import com.intellij.platform.workspace.storage.metadata.model.StorageTypeMetadata;
import com.intellij.platform.workspace.storage.metadata.utils.TypesCollectorKt;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001B5\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0004J\u001c\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00042\n\u0010\u0012\u001a\u00060\u0007j\u0002`\bH\u0004J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0004H\u0016J\u001d\u0010\u0015\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\u0006\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u000eH$J\b\u0010\u0018\u001a\u00020\u000eH$R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/platform/workspace/storage/metadata/impl/MetadataStorageBase;", "Lcom/intellij/platform/workspace/storage/metadata/MetadataStorage;", "metadataByTypeFqn", "", "", "Lcom/intellij/platform/workspace/storage/metadata/model/StorageTypeMetadata;", "metadataHashByTypeFqn", "", "Lcom/intellij/platform/workspace/storage/metadata/MetadataHash;", "(Ljava/util/Map;Ljava/util/Map;)V", "hashMetadataIsInitialized", "", "metadataIsInitialized", "addMetadata", "", "typeMetadata", "addMetadataHash", "typeFqn", "metadataHash", "getMetadataByTypeFqnOrNull", "fqName", "getMetadataHashByTypeFqnOrNull", "(Ljava/lang/String;)Ljava/lang/Integer;", "initializeMetadata", "initializeMetadataHash", "intellij.platform.workspace.storage"})
public abstract class MetadataStorageBase
implements MetadataStorage {
    @NotNull
    private final Map<String, StorageTypeMetadata> metadataByTypeFqn;
    @NotNull
    private final Map<String, Integer> metadataHashByTypeFqn;
    private boolean metadataIsInitialized;
    private boolean hashMetadataIsInitialized;

    public MetadataStorageBase(@NotNull Map<String, StorageTypeMetadata> metadataByTypeFqn, @NotNull Map<String, Integer> metadataHashByTypeFqn) {
        Intrinsics.checkNotNullParameter(metadataByTypeFqn, "metadataByTypeFqn");
        Intrinsics.checkNotNullParameter(metadataHashByTypeFqn, "metadataHashByTypeFqn");
        this.metadataByTypeFqn = metadataByTypeFqn;
        this.metadataHashByTypeFqn = metadataHashByTypeFqn;
    }

    public /* synthetic */ MetadataStorageBase(Map map2, Map map3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            map2 = new HashMap();
        }
        if ((n2 & 2) != 0) {
            map3 = new HashMap();
        }
        this(map2, map3);
    }

    @Override
    @Nullable
    public StorageTypeMetadata getMetadataByTypeFqnOrNull(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        if (!this.metadataIsInitialized) {
            this.metadataIsInitialized = true;
            this.initializeMetadata();
        }
        return this.metadataByTypeFqn.get(fqName);
    }

    @Override
    @Nullable
    public Integer getMetadataHashByTypeFqnOrNull(@NotNull String fqName) {
        Intrinsics.checkNotNullParameter(fqName, "fqName");
        if (!this.hashMetadataIsInitialized) {
            this.hashMetadataIsInitialized = true;
            this.initializeMetadataHash();
        }
        return this.metadataHashByTypeFqn.get(fqName);
    }

    protected abstract void initializeMetadata();

    protected abstract void initializeMetadataHash();

    protected final void addMetadata(@NotNull StorageTypeMetadata typeMetadata) {
        Intrinsics.checkNotNullParameter(typeMetadata, "typeMetadata");
        TypesCollectorKt.collectTypesByFqn$default(typeMetadata, this.metadataByTypeFqn, null, 2, null);
    }

    protected final void addMetadataHash(@NotNull String typeFqn, int metadataHash) {
        Intrinsics.checkNotNullParameter(typeFqn, "typeFqn");
        Integer n2 = metadataHash;
        this.metadataHashByTypeFqn.put(typeFqn, n2);
    }

    public MetadataStorageBase() {
        this(null, null, 3, null);
    }
}

