/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.trace;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.workspace.storage.EntitySource;
import com.intellij.platform.workspace.storage.ExternalEntityMapping;
import com.intellij.platform.workspace.storage.ExternalMappingKey;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.SymbolicEntityId;
import com.intellij.platform.workspace.storage.WorkspaceEntity;
import com.intellij.platform.workspace.storage.WorkspaceEntityWithSymbolicId;
import com.intellij.platform.workspace.storage.impl.ConnectionId;
import com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImpl;
import com.intellij.platform.workspace.storage.impl.UtilsKt;
import com.intellij.platform.workspace.storage.trace.ReadTrace;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlIndex;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 42\u00020\u0001:\u00014B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ!\u0010\u000b\u001a\u00020\f\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0096\u0002J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\u0012\"\b\b\u0000\u0010\r*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015H\u0016J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\f0\u0005H\u0016J \u0010\u0019\u001a\u00020\u001a\"\b\b\u0000\u0010\r*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u0015H\u0016J\"\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001c\"\u0004\b\u0000\u0010\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001fH\u0016J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013H\u0016J\u001a\u0010$\u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0013H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u0013H\u0016J\b\u0010'\u001a\u00020(H\u0016J1\u0010)\u001a\u0002H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u00132\n\u0010*\u001a\u00060+j\u0002`,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u001d0.H\u0016\u00a2\u0006\u0002\u0010/J>\u00100\u001a\b\u0012\u0004\u0012\u0002H10\u0012\"\b\b\u0000\u0010\r*\u00020\u000e\"\b\b\u0001\u00101*\u00020\u00132\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H10\u0015H\u0016J'\u00102\u001a\u0004\u0018\u0001H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0016\u00a2\u0006\u0002\u00103R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u00065"}, d2={"Lcom/intellij/platform/workspace/storage/trace/ReadTracker;", "Lcom/intellij/platform/workspace/storage/impl/ImmutableEntityStorageImpl;", "snapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "onRead", "Lkotlin/Function1;", "Lcom/intellij/platform/workspace/storage/trace/ReadTrace;", "", "(Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;Lkotlin/jvm/functions/Function1;)V", "getOnRead$intellij_platform_workspace_storage", "()Lkotlin/jvm/functions/Function1;", "contains", "", "E", "Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "id", "Lcom/intellij/platform/workspace/storage/SymbolicEntityId;", "entities", "Lkotlin/sequences/Sequence;", "Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "entityClass", "Ljava/lang/Class;", "entitiesBySource", "sourceFilter", "Lcom/intellij/platform/workspace/storage/EntitySource;", "entityCount", "", "getExternalMapping", "Lcom/intellij/platform/workspace/storage/ExternalEntityMapping;", "T", "identifier", "Lcom/intellij/platform/workspace/storage/ExternalMappingKey;", "getManyChildren", "connectionId", "Lcom/intellij/platform/workspace/storage/impl/ConnectionId;", "parent", "getOneChild", "getParent", "child", "getVirtualFileUrlIndex", "Lcom/intellij/platform/workspace/storage/url/VirtualFileUrlIndex;", "initializeEntity", "entityId", "", "Lcom/intellij/platform/workspace/storage/impl/EntityId;", "newInstance", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)Lcom/intellij/platform/workspace/storage/WorkspaceEntity;", "referrers", "R", "resolve", "(Lcom/intellij/platform/workspace/storage/SymbolicEntityId;)Lcom/intellij/platform/workspace/storage/WorkspaceEntityWithSymbolicId;", "Companion", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\ntracing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 tracing.kt\ncom/intellij/platform/workspace/storage/trace/ReadTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,328:1\n53#2,4:329\n53#2,4:333\n53#2,4:337\n53#2,4:341\n53#2,4:345\n53#2,4:349\n53#2,4:353\n53#2,4:357\n53#2,4:361\n11#2:365\n*S KotlinDebug\n*F\n+ 1 tracing.kt\ncom/intellij/platform/workspace/storage/trace/ReadTracker\n*L\n47#1:329,4\n54#1:333,4\n62#1:337,4\n69#1:341,4\n76#1:345,4\n83#1:349,4\n98#1:353,4\n105#1:357,4\n112#1:361,4\n124#1:365\n*E\n"})
public final class ReadTracker
extends ImmutableEntityStorageImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<ReadTrace, Unit> onRead;
    @NotNull
    private static final Logger log;

    private ReadTracker(ImmutableEntityStorage snapshot, Function1<? super ReadTrace, Unit> onRead) {
        Intrinsics.checkNotNull(snapshot, "null cannot be cast to non-null type com.intellij.platform.workspace.storage.impl.ImmutableEntityStorageImpl");
        super(((ImmutableEntityStorageImpl)snapshot).getEntitiesByType$intellij_platform_workspace_storage(), ((ImmutableEntityStorageImpl)snapshot).getRefs$intellij_platform_workspace_storage(), ((ImmutableEntityStorageImpl)snapshot).getIndexes$intellij_platform_workspace_storage(), ((ImmutableEntityStorageImpl)snapshot).getSnapshotCache$intellij_platform_workspace_storage());
        this.onRead = onRead;
        if (!(!(snapshot instanceof ReadTracker))) {
            boolean bl2 = false;
            String string2 = "Recursive read tracker is not supported";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    @NotNull
    public final Function1<ReadTrace, Unit> getOnRead$intellij_platform_workspace_storage() {
        return this.onRead;
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntity> Sequence<E> entities(@NotNull Class<E> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, "entityClass");
        ReadTrace.EntitiesOfType trace2 = new ReadTrace.EntitiesOfType(entityClass);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Read trace of `entities` function: " + trace2);
        }
        this.onRead.invoke(trace2);
        return super.entities(entityClass);
    }

    @Override
    public <E extends WorkspaceEntity> int entityCount(@NotNull Class<E> entityClass) {
        Intrinsics.checkNotNullParameter(entityClass, "entityClass");
        ReadTrace.EntitiesOfType trace2 = new ReadTrace.EntitiesOfType(entityClass);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Read trace of `entitiesAmount` function: " + trace2);
        }
        this.onRead.invoke(trace2);
        return super.entityCount(entityClass);
    }

    @Override
    @NotNull
    public <E extends WorkspaceEntityWithSymbolicId, R extends WorkspaceEntity> Sequence<R> referrers(@NotNull SymbolicEntityId<? extends E> id2, @NotNull Class<R> entityClass) {
        Intrinsics.checkNotNullParameter(id2, "id");
        Intrinsics.checkNotNullParameter(entityClass, "entityClass");
        ReadTrace.HasSymbolicLinkTo trace2 = new ReadTrace.HasSymbolicLinkTo(id2, entityClass);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Read trace of `referrers` function: " + trace2);
        }
        this.onRead.invoke(trace2);
        return super.referrers(id2, entityClass);
    }

    @Override
    @Nullable
    public <E extends WorkspaceEntityWithSymbolicId> E resolve(@NotNull SymbolicEntityId<? extends E> id2) {
        Intrinsics.checkNotNullParameter(id2, "id");
        ReadTrace.Resolve trace2 = new ReadTrace.Resolve(id2);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Read trace of `resolve` function: " + trace2);
        }
        this.onRead.invoke(trace2);
        return super.resolve(id2);
    }

    @Override
    public <E extends WorkspaceEntityWithSymbolicId> boolean contains(@NotNull SymbolicEntityId<? extends E> id2) {
        Intrinsics.checkNotNullParameter(id2, "id");
        ReadTrace.Resolve trace2 = new ReadTrace.Resolve(id2);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Read trace of `contains` function: " + trace2);
        }
        this.onRead.invoke(trace2);
        return super.contains(id2);
    }

    @Override
    @NotNull
    public <T> ExternalEntityMapping<T> getExternalMapping(@NotNull ExternalMappingKey<T> identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        ReadTrace.ExternalMappingAccess trace2 = new ReadTrace.ExternalMappingAccess(identifier);
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Read trace of `getExternalMapping` function: " + trace2);
        }
        this.onRead.invoke(trace2);
        return super.getExternalMapping(identifier);
    }

    @Override
    @NotNull
    public VirtualFileUrlIndex getVirtualFileUrlIndex() {
        String string2 = "The VirtualFileUrlIndex is not supported for read tracing at the moment";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @NotNull
    public Sequence<WorkspaceEntity> entitiesBySource(@NotNull Function1<? super EntitySource, Boolean> sourceFilter) {
        Intrinsics.checkNotNullParameter(sourceFilter, "sourceFilter");
        String string2 = "The entitiesBySource is not supported for read tracing at the moment";
        throw new NotImplementedError("An operation is not implemented: " + string2);
    }

    @Override
    @Nullable
    public WorkspaceEntity getOneChild(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity parent) {
        Intrinsics.checkNotNullParameter(connectionId, "connectionId");
        Intrinsics.checkNotNullParameter(parent, "parent");
        ReadTrace.SomeFieldAccess trace2 = new ReadTrace.SomeFieldAccess(UtilsKt.asBase(parent).getId());
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Read trace of `getOneChild` function: " + trace2);
        }
        this.onRead.invoke(trace2);
        return super.getOneChild(connectionId, parent);
    }

    @Override
    @NotNull
    public Sequence<WorkspaceEntity> getManyChildren(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity parent) {
        Intrinsics.checkNotNullParameter(connectionId, "connectionId");
        Intrinsics.checkNotNullParameter(parent, "parent");
        ReadTrace.SomeFieldAccess trace2 = new ReadTrace.SomeFieldAccess(UtilsKt.asBase(parent).getId());
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Read trace of `getManyChildren` function: " + trace2);
        }
        this.onRead.invoke(trace2);
        return super.getManyChildren(connectionId, parent);
    }

    @Override
    @Nullable
    public WorkspaceEntity getParent(@NotNull ConnectionId connectionId, @NotNull WorkspaceEntity child) {
        Intrinsics.checkNotNullParameter(connectionId, "connectionId");
        Intrinsics.checkNotNullParameter(child, "child");
        ReadTrace.SomeFieldAccess trace2 = new ReadTrace.SomeFieldAccess(UtilsKt.asBase(child).getId());
        Logger $this$trace$iv = log;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl2 = false;
            logger.trace("Read trace of `getParent` function: " + trace2);
        }
        this.onRead.invoke(trace2);
        return super.getParent(connectionId, child);
    }

    @Override
    @NotNull
    public <T extends WorkspaceEntity> T initializeEntity(long entityId, @NotNull Function0<? extends T> newInstance) {
        Intrinsics.checkNotNullParameter(newInstance, "newInstance");
        WorkspaceEntity instance2 = (WorkspaceEntity)newInstance.invoke();
        UtilsKt.asBase(instance2).setOnRead$intellij_platform_workspace_storage(this.onRead);
        return (T)instance2;
    }

    public /* synthetic */ ReadTracker(ImmutableEntityStorage snapshot, Function1 onRead, DefaultConstructorMarker $constructor_marker) {
        this(snapshot, onRead);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ReadTracker.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getInstance(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/workspace/storage/trace/ReadTracker$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "trace", "", "Lcom/intellij/platform/workspace/storage/trace/ReadTrace;", "snapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "action", "Lkotlin/Function1;", "", "tracedSnapshot", "Lcom/intellij/platform/workspace/storage/trace/ReadTracker;", "addTo", "Lit/unimi/dsi/fastutil/longs/LongArrayList;", "intellij.platform.workspace.storage"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ReadTrace> trace(@NotNull ImmutableEntityStorage snapshot, @NotNull Function1<? super ImmutableEntityStorage, Unit> action2) {
            HashSet<ReadTrace> hashSet;
            Intrinsics.checkNotNullParameter(snapshot, "snapshot");
            Intrinsics.checkNotNullParameter(action2, "action");
            HashSet<ReadTrace> traces = hashSet = new HashSet<ReadTrace>();
            boolean bl2 = false;
            ReadTracker traced2 = new ReadTracker(snapshot, new Function1<ReadTrace, Unit>(traces){
                final /* synthetic */ HashSet<ReadTrace> $traces;
                {
                    this.$traces = $traces;
                    super(1);
                }

                public final void invoke(@NotNull ReadTrace it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    this.$traces.add(it);
                }
            }, null);
            action2.invoke(traced2);
            return hashSet;
        }

        @NotNull
        public final ReadTracker tracedSnapshot(@NotNull ImmutableEntityStorage snapshot, @NotNull LongArrayList addTo) {
            Intrinsics.checkNotNullParameter(snapshot, "snapshot");
            Intrinsics.checkNotNullParameter(addTo, "addTo");
            return new ReadTracker(snapshot, new Function1<ReadTrace, Unit>(addTo){
                final /* synthetic */ LongArrayList $addTo;
                {
                    this.$addTo = $addTo;
                    super(1);
                }

                public final void invoke(@NotNull ReadTrace it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    this.$addTo.add(it.getHash());
                }
            }, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

