/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.StubPsiFactory;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentProviderElementType;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaStubElementType<StubT extends StubElement<?>, PsiT extends PsiElement>
extends ILightStubElementType<StubT, PsiT>
implements ICompositeElementType,
ParentProviderElementType {
    private final boolean myLeftBound;
    private final Set<IElementType> myParentElementTypes;

    protected JavaStubElementType(@NotNull @NonNls String debugName, @NotNull IElementType parentElementType) {
        if (debugName == null) {
            JavaStubElementType.$$$reportNull$$$0(0);
        }
        if (parentElementType == null) {
            JavaStubElementType.$$$reportNull$$$0(1);
        }
        this(debugName, false, parentElementType);
    }

    protected JavaStubElementType(@NotNull @NonNls String debugName, boolean leftBound, @NotNull IElementType parentElementType) {
        if (debugName == null) {
            JavaStubElementType.$$$reportNull$$$0(2);
        }
        if (parentElementType == null) {
            JavaStubElementType.$$$reportNull$$$0(3);
        }
        super(debugName, JavaLanguage.INSTANCE);
        this.myLeftBound = leftBound;
        this.myParentElementTypes = Collections.singleton(parentElementType);
    }

    @Override
    @NotNull
    public Set<IElementType> getParents() {
        Set<IElementType> set = this.myParentElementTypes;
        if (set == null) {
            JavaStubElementType.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public String getExternalId() {
        String string2 = "java." + this.toString();
        if (string2 == null) {
            JavaStubElementType.$$$reportNull$$$0(5);
        }
        return string2;
    }

    protected StubPsiFactory getPsiFactory(StubT stub) {
        return this.getFileStub(stub).getPsiFactory();
    }

    public boolean isCompiled(StubT stub) {
        return this.getFileStub(stub).isCompiled();
    }

    private PsiJavaFileStub getFileStub(StubT stub) {
        Object parent = stub;
        while (!(parent instanceof PsiFileStub)) {
            parent = parent.getParentStub();
        }
        return (PsiJavaFileStub)parent;
    }

    @Override
    public abstract PsiT createPsi(@NotNull ASTNode var1);

    @Override
    @NotNull
    public final StubT createStub(@NotNull PsiT psi, StubElement<? extends PsiElement> parentStub) {
        if (psi == null) {
            JavaStubElementType.$$$reportNull$$$0(6);
        }
        String message2 = "Should not be called. Element=" + psi + "; class" + psi.getClass() + "; file=" + (psi.isValid() ? psi.getContainingFile() : "-");
        throw new UnsupportedOperationException(message2);
    }

    @Override
    public boolean isLeftBound() {
        return this.myLeftBound;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElementType";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/JavaStubElementType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/JavaStubElementType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getParents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

