/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.light.LightElement;
import java.util.StringJoiner;
import org.jetbrains.annotations.NotNull;

public class LightReferenceParameterList
extends LightElement
implements PsiReferenceParameterList {
    private final PsiTypeElement[] myTypeElements;
    private final String myText;

    public LightReferenceParameterList(PsiManager manager, PsiTypeElement[] referenceElements) {
        super(manager, JavaLanguage.INSTANCE);
        this.myTypeElements = referenceElements;
        this.myText = this.calculateText();
    }

    private String calculateText() {
        if (this.myTypeElements.length == 0) {
            return "";
        }
        StringJoiner buffer = new StringJoiner(",", "<", ">");
        for (PsiTypeElement type : this.myTypeElements) {
            buffer.add(type.getText());
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        return "PsiReferenceParameterList";
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            LightReferenceParameterList.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitReferenceParameterList(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiElement copy() {
        PsiTypeElement[] elements = new PsiTypeElement[this.myTypeElements.length];
        for (int i2 = 0; i2 < this.myTypeElements.length; ++i2) {
            PsiTypeElement typeElement = this.myTypeElements[i2];
            elements[i2] = (PsiTypeElement)typeElement.copy();
        }
        return new LightReferenceParameterList(this.myManager, elements);
    }

    @Override
    public PsiTypeElement @NotNull [] getTypeParameterElements() {
        if (this.myTypeElements == null) {
            LightReferenceParameterList.$$$reportNull$$$0(1);
        }
        return this.myTypeElements;
    }

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(this.myTypeElements);
        if (psiTypeArray == null) {
            LightReferenceParameterList.$$$reportNull$$$0(2);
        }
        return psiTypeArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/light/LightReferenceParameterList";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/light/LightReferenceParameterList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

