/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.ReparseableASTNode;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElementVisitor;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.testFramework.ReadOnlyLightVirtualFile;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeElement
extends ElementBase
implements ASTNode,
ReparseableASTNode,
Cloneable {
    public static final TreeElement[] EMPTY_ARRAY = new TreeElement[0];
    private TreeElement myNextSibling;
    private TreeElement myPrevSibling;
    private CompositeElement myParent;
    private final IElementType myType;
    private volatile int myStartOffsetInParent;

    public TreeElement(@NotNull IElementType type) {
        if (type == null) {
            TreeElement.$$$reportNull$$$0(0);
        }
        this.myStartOffsetInParent = -1;
        this.myType = type;
    }

    private static PsiFileImpl getCachedFile(@NotNull TreeElement each) {
        FileElement node;
        if (each == null) {
            TreeElement.$$$reportNull$$$0(1);
        }
        return (node = (FileElement)SharedImplUtil.findFileElement(each)) == null ? null : (PsiFileImpl)node.getCachedPsi();
    }

    @Override
    @NotNull
    public Object clone() {
        TreeElement clone = (TreeElement)super.clone();
        clone.myNextSibling = null;
        clone.myPrevSibling = null;
        clone.myParent = null;
        clone.myStartOffsetInParent = -1;
        TreeElement treeElement = clone;
        if (treeElement == null) {
            TreeElement.$$$reportNull$$$0(2);
        }
        return treeElement;
    }

    @Override
    public ASTNode copyElement() {
        CharTable table = SharedImplUtil.findCharTableByTree(this);
        return ChangeUtil.copyElement(this, table);
    }

    public PsiManagerEx getManager() {
        CompositeElement parent;
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null) {
            return PsiManagerEx.getInstanceEx(project);
        }
        TreeElement element = this;
        while ((parent = element.getTreeParent()) != null) {
            element = parent;
        }
        if (element instanceof FileElement) {
            return element.getManager();
        }
        parent = this.getTreeParent();
        if (parent != null) {
            return parent.getManager();
        }
        return null;
    }

    @Override
    public abstract LeafElement findLeafElementAt(int var1);

    public abstract char @NotNull [] textToCharArray();

    @Override
    public abstract TreeElement getFirstChildNode();

    @Override
    public abstract TreeElement getLastChildNode();

    public abstract int getCachedLength();

    @Override
    public TextRange getTextRange() {
        int start = this.getStartOffset();
        return new TextRange(start, start + this.getTextLength());
    }

    @Override
    public int getStartOffset() {
        int result2 = 0;
        TreeElement current2 = this;
        while (current2.myParent != null) {
            result2 += current2.getStartOffsetInParent();
            current2 = current2.myParent;
        }
        return result2;
    }

    @Override
    public final int getStartOffsetInParent() {
        TreeElement prev;
        if (this.myParent == null) {
            return -1;
        }
        int offsetInParent = this.myStartOffsetInParent;
        if (offsetInParent != -1) {
            return offsetInParent;
        }
        if (DebugUtil.CHECK_INSIDE_ATOMIC_ACTION_ENABLED) {
            this.assertReadAccessAllowed();
        }
        TreeElement cur = this;
        while ((prev = cur.getTreePrev()) != null) {
            cur = prev;
            offsetInParent = cur.myStartOffsetInParent;
            if (offsetInParent == -1) continue;
            break;
        }
        if (offsetInParent == -1) {
            offsetInParent = 0;
            cur.myStartOffsetInParent = 0;
        }
        while (cur != this) {
            TreeElement next = cur.getTreeNext();
            next.myStartOffsetInParent = offsetInParent += cur.getTextLength();
            cur = next;
        }
        return offsetInParent;
    }

    public int getTextOffset() {
        return this.getStartOffset();
    }

    public boolean textMatches(@NotNull CharSequence buffer, int startOffset, int endOffset) {
        if (buffer == null) {
            TreeElement.$$$reportNull$$$0(3);
        }
        return this.textMatches(buffer, startOffset) == endOffset;
    }

    protected abstract int textMatches(@NotNull CharSequence var1, int var2);

    public boolean textMatches(@NotNull CharSequence seq) {
        if (seq == null) {
            TreeElement.$$$reportNull$$$0(4);
        }
        return this.textMatches(seq, 0, seq.length());
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            TreeElement.$$$reportNull$$$0(5);
        }
        return this.getTextLength() == element.getTextLength() && this.textMatches(element.getText());
    }

    @Override
    @NonNls
    public String toString() {
        return "Element(" + this.getElementType() + ")";
    }

    @Override
    public final CompositeElement getTreeParent() {
        return this.myParent;
    }

    @Override
    public final TreeElement getTreePrev() {
        return this.myPrevSibling;
    }

    final void setTreeParent(CompositeElement parent) {
        if (parent == this.myParent) {
            return;
        }
        PsiFileImpl file2 = TreeElement.getCachedFile(this);
        if (file2 != null) {
            file2.beforeAstChange();
        }
        this.myParent = parent;
        if (parent != null && parent.getElementType() != TokenType.DUMMY_HOLDER) {
            DebugUtil.revalidateNode(this);
        }
    }

    final void setTreePrev(TreeElement prev) {
        this.myPrevSibling = prev;
        TreeElement.clearRelativeOffsets(this);
    }

    @Override
    public final TreeElement getTreeNext() {
        return this.myNextSibling;
    }

    final void setTreeNext(TreeElement next) {
        this.myNextSibling = next;
        TreeElement.clearRelativeOffsets(next);
    }

    static void clearRelativeOffsets(TreeElement element) {
        for (TreeElement cur = element; cur != null && cur.myStartOffsetInParent != -1; cur = cur.getTreeNext()) {
            cur.myStartOffsetInParent = -1;
        }
    }

    public void clearCaches() {
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public abstract int hc();

    public abstract void acceptTree(@NotNull TreeElementVisitor var1);

    protected void onInvalidated() {
        DebugUtil.onInvalidated(this);
    }

    @Override
    public final void applyReplaceOnReparse(@NotNull ASTNode newChild) {
        if (newChild == null) {
            TreeElement.$$$reportNull$$$0(6);
        }
        TreeElement newTreeElement = (TreeElement)newChild;
        newTreeElement.rawRemove();
        this.rawReplaceWithList(newTreeElement);
        newTreeElement.clearCaches();
        if (!(newTreeElement instanceof FileElement)) {
            newTreeElement.getTreeParent().subtreeChanged();
        }
    }

    public void rawInsertBeforeMe(@NotNull TreeElement firstNew) {
        TreeElement anchorPrev;
        if (firstNew == null) {
            TreeElement.$$$reportNull$$$0(7);
        }
        if ((anchorPrev = this.getTreePrev()) == null) {
            firstNew.rawRemoveUpToLast();
            CompositeElement p2 = this.getTreeParent();
            if (p2 != null) {
                p2.setFirstChildNode(firstNew);
            }
            while (true) {
                TreeElement treeNext = firstNew.getTreeNext();
                assert (treeNext != this) : "Attempt to create cycle";
                firstNew.setTreeParent(p2);
                if (treeNext == null) break;
                firstNew = treeNext;
            }
            this.setTreePrev(firstNew);
            firstNew.setTreeNext(this);
            if (p2 != null) {
                p2.subtreeChanged();
            }
        } else {
            anchorPrev.rawInsertAfterMe(firstNew);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawInsertAfterMe(@NotNull TreeElement firstNew) {
        if (firstNew == null) {
            TreeElement.$$$reportNull$$$0(8);
        }
        this.rawInsertAfterMeWithoutNotifications(firstNew);
        CompositeElement parent = this.getTreeParent();
        if (parent != null) {
            parent.subtreeChanged();
        }
    }

    final void rawInsertAfterMeWithoutNotifications(@NotNull TreeElement firstNew) {
        if (firstNew == null) {
            TreeElement.$$$reportNull$$$0(9);
        }
        firstNew.rawRemoveUpToWithoutNotifications(null, false);
        CompositeElement p2 = this.getTreeParent();
        TreeElement treeNext = this.getTreeNext();
        firstNew.setTreePrev(this);
        this.setTreeNext(firstNew);
        while (true) {
            TreeElement n2 = firstNew.getTreeNext();
            assert (n2 != this) : "Attempt to create cycle";
            firstNew.setTreeParent(p2);
            if (n2 == null) break;
            firstNew = n2;
        }
        if (treeNext == null) {
            if (p2 != null) {
                firstNew.setTreeParent(p2);
                p2.setLastChildNode(firstNew);
            }
        } else {
            firstNew.setTreeNext(treeNext);
            treeNext.setTreePrev(firstNew);
        }
        DebugUtil.checkTreeStructure(this);
    }

    public void rawRemove() {
        TreeElement next = this.getTreeNext();
        CompositeElement parent = this.getTreeParent();
        TreeElement prev = this.getTreePrev();
        if (prev != null) {
            prev.setTreeNext(next);
        } else if (parent != null) {
            parent.setFirstChildNode(next);
        }
        if (next != null) {
            next.setTreePrev(prev);
        } else if (parent != null) {
            parent.setLastChildNode(prev);
        }
        DebugUtil.checkTreeStructure(parent);
        DebugUtil.checkTreeStructure(prev);
        DebugUtil.checkTreeStructure(next);
        this.invalidate();
    }

    public void rawReplaceWithList(@Nullable TreeElement firstNew) {
        if (firstNew != null) {
            this.rawInsertAfterMeWithoutNotifications(firstNew);
        }
        this.rawRemove();
    }

    protected void invalidate() {
        CompositeElement parent = this.getTreeParent();
        if (parent != null) {
            parent.subtreeChanged();
        }
        this.onInvalidated();
        this.setTreeNext(null);
        this.setTreePrev(null);
        this.setTreeParent(null);
    }

    public void rawRemoveUpToLast() {
        this.rawRemoveUpTo(null);
    }

    public void rawRemoveUpTo(@Nullable TreeElement end) {
        CompositeElement parent = this.getTreeParent();
        this.rawRemoveUpToWithoutNotifications(end, true);
        if (parent != null) {
            parent.subtreeChanged();
        }
    }

    final void rawRemoveUpToWithoutNotifications(@Nullable TreeElement end, boolean invalidate) {
        TreeElement element;
        TreeElement endPrev;
        if (this == end) {
            return;
        }
        CompositeElement parent = this.getTreeParent();
        TreeElement startPrev = this.getTreePrev();
        TreeElement treeElement = endPrev = end != null ? end.getTreePrev() : null;
        assert (end == null || end.getTreeParent() == parent) : "Trying to remove non-child";
        if (end != null) {
            for (element = this; element != end && element != null; element = element.getTreeNext()) {
            }
            assert (element == end) : end + " is not successor of " + this + " in the .getTreeNext() chain";
        }
        if (parent != null) {
            if (this.getTreePrev() == null) {
                parent.setFirstChildNode(end);
            }
            if (end == null) {
                parent.setLastChildNode(startPrev);
            }
        }
        if (startPrev != null) {
            startPrev.setTreeNext(end);
        }
        if (end != null) {
            end.setTreePrev(startPrev);
        }
        this.setTreePrev(null);
        if (endPrev != null) {
            endPrev.setTreeNext(null);
        }
        if (parent != null) {
            for (element = this; element != null; element = element.getTreeNext()) {
                element.setTreeParent(null);
                if (!invalidate) continue;
                element.onInvalidated();
            }
        }
        DebugUtil.checkTreeStructure(parent);
        DebugUtil.checkTreeStructure(this);
    }

    @Override
    @NotNull
    public IElementType getElementType() {
        IElementType iElementType = this.myType;
        if (iElementType == null) {
            TreeElement.$$$reportNull$$$0(10);
        }
        return iElementType;
    }

    void assertReadAccessAllowed() {
        boolean ok;
        PsiElement psi;
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return;
        }
        FileElement fileElement = TreeUtil.getFileElement(this);
        PsiElement psiElement = psi = fileElement == null ? null : fileElement.getCachedPsi();
        if (psi == null) {
            return;
        }
        FileViewProvider provider = psi instanceof PsiFile ? ((PsiFile)psi).getViewProvider() : null;
        boolean bl2 = ok = provider != null && provider.getVirtualFile() instanceof ReadOnlyLightVirtualFile;
        if (!ok) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/TreeElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstNew";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/TreeElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFile";
                break;
            }
            case 2: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyReplaceOnReparse";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rawInsertBeforeMe";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "rawInsertAfterMe";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "rawInsertAfterMeWithoutNotifications";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

