/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PsiDeclarationStatementImpl
extends CompositePsiElement
implements PsiDeclarationStatement {
    private static final TokenSet DECLARED_ELEMENT_BIT_SET = TokenSet.create(JavaElementType.LOCAL_VARIABLE, JavaElementType.CLASS);

    public PsiDeclarationStatementImpl() {
        super(JavaElementType.DECLARATION_STATEMENT);
    }

    @Override
    public PsiElement @NotNull [] getDeclaredElements() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(DECLARED_ELEMENT_BIT_SET, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(1);
        }
        if (child.getElementType() == JavaTokenType.COMMA) {
            return 23;
        }
        return super.getChildRole(child);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        TreeElement next;
        if (child == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(2);
        }
        if (DECLARED_ELEMENT_BIT_SET.contains(child.getElementType())) {
            PsiElement[] declaredElements = this.getDeclaredElements();
            int length = declaredElements.length;
            if (length == 1) {
                this.getTreeParent().deleteChildInternal(this);
                return;
            }
            if (length > 0) {
                if (SourceTreeToPsiMap.psiElementToTree(declaredElements[length - 1]) == child) {
                    this.removeCommaBefore(child);
                    CharTable charTable = SharedImplUtil.findCharTableByTree(this);
                    LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", charTable, this.getManager());
                    SourceTreeToPsiMap.psiToTreeNotNull(declaredElements[length - 2]).addChild(semicolon, null);
                } else if (SourceTreeToPsiMap.psiElementToTree(declaredElements[0]) == child) {
                    next = (CompositeElement)SourceTreeToPsiMap.psiToTreeNotNull(declaredElements[1]);
                    ASTNode copyChild = child.copyElement();
                    ASTNode nameChild = ((CompositeElement)copyChild).findChildByRole(9);
                    assert (nameChild != null);
                    this.removeCommaBefore(next);
                    ((CompositeElement)next).addInternal((TreeElement)copyChild.getFirstChildNode(), nameChild.getTreePrev(), null, Boolean.FALSE);
                } else {
                    this.removeCommaBefore(child);
                }
            }
        }
        super.deleteChildInternal(child);
        TreeElement first2 = this.getFirstChildNode();
        if (first2 != null && !DECLARED_ELEMENT_BIT_SET.contains(first2.getElementType())) {
            TreeElement last2 = first2;
            while ((next = last2.getTreeNext()) != null && !DECLARED_ELEMENT_BIT_SET.contains(next.getElementType())) {
                last2 = next;
            }
            this.getTreeParent().addInternal(first2, last2, this, Boolean.TRUE);
        }
    }

    private void removeCommaBefore(ASTNode child) {
        ASTNode prev = child;
        while ((prev = prev.getTreePrev()) != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(prev.getElementType())) {
        }
        if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
            this.deleteChildInternal(prev);
        }
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitDeclarationStatement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(4);
        }
        if (state == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            PsiDeclarationStatementImpl.$$$reportNull$$$0(6);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        for (PsiElement element : this.getDeclaredElements()) {
            if (element != lastParent) {
                if (element instanceof PsiVariable && ((PsiVariable)element).isUnnamed() || processor.execute(element, state)) continue;
                return false;
            }
            ElementClassHint hint = processor.getHint(ElementClassHint.KEY);
            if (!(lastParent instanceof PsiClass) || hint != null && !hint.shouldProcess(ElementClassHint.DeclarationKind.CLASS) || processor.execute(lastParent, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "PsiDeclarationStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredElements";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/java/PsiDeclarationStatementImpl";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteChildInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

