/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface StubInconsistencyReporter {
    public static StubInconsistencyReporter getInstance() {
        return ApplicationManager.getApplication().getService(StubInconsistencyReporter.class);
    }

    public void reportEnforcedStubInconsistency(@NotNull Project var1, @NotNull SourceOfCheck var2, @NotNull EnforcedInconsistencyType var3);

    public void reportStubInconsistency(@NotNull Project var1, @NotNull SourceOfCheck var2, @NotNull InconsistencyType var3, @Nullable EnforcedInconsistencyType var4);

    public static enum EnforcedInconsistencyType {
        PsiOfUnexpectedClass("psi_of_unexpected_class"),
        Other("other");

        private final String fusDescription;

        private EnforcedInconsistencyType(String fusDescription) {
            this.fusDescription = fusDescription;
        }

        public String getFusDescription() {
            return this.fusDescription;
        }
    }

    public static enum InconsistencyType {
        DifferentNumberOfPsiTrees("different_number_of_psi_trees"),
        MismatchingPsiTree("mismatching_psi_tree");

        private final String fusDescription;

        private InconsistencyType(String fusDescription) {
            this.fusDescription = fusDescription;
        }

        public String getFusDescription() {
            return this.fusDescription;
        }
    }

    public static enum SourceOfCheck {
        DeliberateAdditionalCheckInCompletion("deliberate_additional_check_in_completion"),
        DeliberateAdditionalCheckInIntentions("deliberate_additional_check_in_intentions"),
        WrongTypePsiInStubHelper("wrong_type_psi_in_stub_helper"),
        OffsetOutsideFileInJava("offset_outside_file_in_java"),
        CheckAfterExceptionInJava("check_after_exception_in_java"),
        NoPsiMatchingASTinJava("no_psi_matching_ast_in_java"),
        ForTests("for_tests"),
        Other("other");

        private final String fusDescription;

        private SourceOfCheck(String fusDescription) {
            this.fusDescription = fusDescription;
        }

        public String getFusDescription() {
            return this.fusDescription;
        }
    }
}

