/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonProcessors {
    private static final Processor<Object> FALSE = __ -> false;
    private static final Processor<Object> TRUE = __ -> true;

    @NotNull
    public static <T> Processor<T> notNullProcessor(@NotNull Processor<? super T> processor) {
        if (processor == null) {
            CommonProcessors.$$$reportNull$$$0(0);
        }
        Processor<Object> processor2 = processor::process;
        if (processor2 == null) {
            CommonProcessors.$$$reportNull$$$0(1);
        }
        return processor2;
    }

    @Deprecated
    @NotNull
    public static <T> Processor<T> processAll(@NotNull Consumer<? super T> consumer2) {
        if (consumer2 == null) {
            CommonProcessors.$$$reportNull$$$0(2);
        }
        Processor<Object> processor = t2 -> {
            consumer2.consume(t2);
            return true;
        };
        if (processor == null) {
            CommonProcessors.$$$reportNull$$$0(3);
        }
        return processor;
    }

    @NotNull
    public static <T> Processor<T> alwaysFalse() {
        Processor<Object> processor = FALSE;
        if (processor == null) {
            CommonProcessors.$$$reportNull$$$0(4);
        }
        return processor;
    }

    @NotNull
    public static <T> Processor<T> alwaysTrue() {
        Processor<Object> processor = TRUE;
        if (processor == null) {
            CommonProcessors.$$$reportNull$$$0(5);
        }
        return processor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/CommonProcessors";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/CommonProcessors";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "processAll";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysFalse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "alwaysTrue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "notNullProcessor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FindFirstAndOnlyProcessor<T>
    extends FindFirstProcessor<T> {
        @Override
        public boolean process(T t2) {
            boolean firstFound = this.getFoundValue() != null;
            boolean result2 = super.process(t2);
            if (!result2) {
                if (firstFound) {
                    this.reset();
                }
                return !firstFound;
            }
            return true;
        }
    }

    public static class FindFirstProcessor<T>
    extends FindProcessor<T> {
        @Override
        protected boolean accept(T t2) {
            return true;
        }
    }

    public static abstract class FindProcessor<T>
    implements Processor<T> {
        private T myValue;

        public boolean isFound() {
            return this.myValue != null;
        }

        @Nullable
        public T getFoundValue() {
            return this.myValue;
        }

        @Nullable
        public T reset() {
            T prev = this.myValue;
            this.myValue = null;
            return prev;
        }

        @Override
        public boolean process(T t2) {
            if (this.accept(t2)) {
                this.myValue = t2;
                return false;
            }
            return true;
        }

        protected abstract boolean accept(T var1);
    }

    public static class UniqueProcessor<T>
    implements Processor<T> {
        private final Set<T> processed;
        private final Processor<? super T> myDelegate;

        public UniqueProcessor(@NotNull Processor<? super T> delegate2) {
            if (delegate2 == null) {
                UniqueProcessor.$$$reportNull$$$0(0);
            }
            this.myDelegate = delegate2;
            this.processed = new HashSet<T>();
        }

        public UniqueProcessor(@NotNull Processor<? super T> delegate2, @NotNull @NotNull HashingStrategy<? super @NotNull T> strategy) {
            if (delegate2 == null) {
                UniqueProcessor.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                UniqueProcessor.$$$reportNull$$$0(2);
            }
            this.myDelegate = delegate2;
            this.processed = new ObjectOpenCustomHashSet<T>(FastUtilHashingStrategies.adaptAsNotNull(strategy));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean process(T t2) {
            Set<T> set = this.processed;
            synchronized (set) {
                if (this.processed.contains(t2)) {
                    return true;
                }
            }
            boolean result2 = this.myDelegate.process(t2);
            Set<T> set2 = this.processed;
            synchronized (set2) {
                this.processed.add(t2);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "strategy";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/CommonProcessors$UniqueProcessor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CollectUniquesProcessor<T>
    implements Processor<T> {
        private final Set<T> myCollection = new HashSet<T>();

        @Override
        public boolean process(T t2) {
            this.myCollection.add(t2);
            return true;
        }

        public T @NotNull [] toArray(T @NotNull [] a2) {
            if (a2 == null) {
                CollectUniquesProcessor.$$$reportNull$$$0(0);
            }
            T[] TArray = this.myCollection.toArray(a2);
            if (TArray == null) {
                CollectUniquesProcessor.$$$reportNull$$$0(1);
            }
            return TArray;
        }

        @NotNull
        public Collection<T> getResults() {
            Set<T> set = this.myCollection;
            if (set == null) {
                CollectUniquesProcessor.$$$reportNull$$$0(2);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/CommonProcessors$CollectUniquesProcessor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/CommonProcessors$CollectUniquesProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class CollectProcessor<T>
    implements Processor<T> {
        private final Collection<T> myCollection;

        public CollectProcessor(@NotNull Collection<T> collection) {
            if (collection == null) {
                CollectProcessor.$$$reportNull$$$0(0);
            }
            this.myCollection = collection;
        }

        public CollectProcessor() {
            this.myCollection = new ArrayList<T>();
        }

        @Override
        public boolean process(T t2) {
            if (this.accept(t2)) {
                this.myCollection.add(t2);
            }
            return true;
        }

        protected boolean accept(T t2) {
            return true;
        }

        public T @NotNull [] toArray(T @NotNull [] a2) {
            if (a2 == null) {
                CollectProcessor.$$$reportNull$$$0(1);
            }
            T[] TArray = this.myCollection.toArray(a2);
            if (TArray == null) {
                CollectProcessor.$$$reportNull$$$0(2);
            }
            return TArray;
        }

        @NotNull
        public Collection<T> getResults() {
            Collection<T> collection = this.myCollection;
            if (collection == null) {
                CollectProcessor.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "collection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "a";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/CommonProcessors$CollectProcessor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/CommonProcessors$CollectProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toArray";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResults";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "toArray";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

