/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiConstructorUtil {
    @NotNull
    private static final TokenSet CONSTRUCTOR_CALL_TOKENS = TokenSet.create(JavaTokenType.SUPER_KEYWORD, JavaTokenType.THIS_KEYWORD);

    @Nullable
    public static PsiMethodCallExpression findThisOrSuperCallInConstructor(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(0);
        }
        if (!constructor.isConstructor()) {
            return null;
        }
        return (PsiMethodCallExpression)CachedValuesManager.getCachedValue(constructor, () -> {
            PsiCodeBlock body = constructor.getBody();
            if (body == null) {
                return new CachedValueProvider.Result<Object>(null, PsiModificationTracker.MODIFICATION_COUNT);
            }
            Ref result2 = new Ref();
            PsiTreeUtil.processElements(body, PsiMethodCallExpression.class, call2 -> {
                if (JavaPsiConstructorUtil.isConstructorCall(call2)) {
                    result2.set(call2);
                    return false;
                }
                return true;
            });
            return new CachedValueProvider.Result<PsiMethodCallExpression>((PsiMethodCallExpression)result2.get(), PsiModificationTracker.MODIFICATION_COUNT);
        });
    }

    @Contract(value="null -> false")
    public static boolean isChainedConstructorCall(@Nullable PsiElement call2) {
        if (!(call2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiElement child = ((PsiMethodCallExpression)call2).getMethodExpression().getReferenceNameElement();
        return PsiUtil.isJavaToken(child, JavaTokenType.THIS_KEYWORD);
    }

    @Contract(value="null -> false")
    public static boolean isSuperConstructorCall(@Nullable PsiElement call2) {
        if (!(call2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiElement child = ((PsiMethodCallExpression)call2).getMethodExpression().getReferenceNameElement();
        return PsiUtil.isJavaToken(child, JavaTokenType.SUPER_KEYWORD);
    }

    @Contract(value="null -> false")
    public static boolean isConstructorCall(@Nullable PsiElement call2) {
        if (!(call2 instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiElement child = ((PsiMethodCallExpression)call2).getMethodExpression().getReferenceNameElement();
        return PsiUtil.isJavaToken(child, CONSTRUCTOR_CALL_TOKENS);
    }

    public static PsiMethod findConstructorInSuper(@NotNull PsiMethod constructor) {
        if (constructor == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(1);
        }
        return JavaPsiConstructorUtil.findConstructorInSuper(constructor, new HashSet());
    }

    private static PsiMethod findConstructorInSuper(@NotNull PsiMethod constructor, @NotNull Set<? super PsiMethod> visited) {
        PsiClass superClass;
        PsiClass containingClass;
        if (constructor == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(2);
        }
        if (visited == null) {
            JavaPsiConstructorUtil.$$$reportNull$$$0(3);
        }
        if (!visited.add(constructor)) {
            return null;
        }
        PsiMethodCallExpression call2 = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor(constructor);
        if (JavaPsiConstructorUtil.isSuperConstructorCall(call2)) {
            PsiMethod superConstructor = call2.resolveMethod();
            if (superConstructor != null) {
                return superConstructor;
            }
        } else if (JavaPsiConstructorUtil.isChainedConstructorCall(call2)) {
            PsiMethod chainedConstructor = call2.resolveMethod();
            if (chainedConstructor != null) {
                return JavaPsiConstructorUtil.findConstructorInSuper(chainedConstructor, visited);
            }
            return null;
        }
        if ((containingClass = constructor.getContainingClass()) != null && (superClass = containingClass.getSuperClass()) != null && superClass.getName() != null) {
            MethodSignature defConstructor = MethodSignatureUtil.createMethodSignature(superClass.getName(), PsiType.EMPTY_ARRAY, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY, true);
            return MethodSignatureUtil.findMethodBySignature(superClass, defConstructor, false);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/JavaPsiConstructorUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findThisOrSuperCallInConstructor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findConstructorInSuper";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

