/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ReflectionUtil;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public abstract class WeakListener<Src, Listener>
implements InvocationHandler {
    private final WeakReference<Listener> myDelegate;
    private Src mySource;

    protected WeakListener(Src source, Class<Listener> listenerInterface, Listener listenerImpl) {
        this.mySource = source;
        this.myDelegate = new WeakReference<Listener>(listenerImpl);
        ClassLoader classLoader2 = listenerImpl.getClass().getClassLoader();
        Listener proxy = ReflectionUtil.proxy(classLoader2, listenerInterface, this);
        this.addListener(source, proxy);
    }

    protected abstract void addListener(Src var1, Listener var2);

    protected abstract void removeListener(Src var1, Listener var2);

    @Override
    public final Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        Object listenerImplObject = this.myDelegate.get();
        if (listenerImplObject == null) {
            this.removeListener(this.mySource, proxy);
            this.mySource = null;
            return null;
        }
        return method.invoke(listenerImplObject, params);
    }
}

