/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CeProcessCanceledException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CancellationException;
import java.util.function.BiConsumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QueueProcessor<T> {
    private static final Logger LOG = Logger.getInstance(QueueProcessor.class);
    private final BiConsumer<? super T, ? super Runnable> myProcessor;
    private final Deque<Pair<T, ModalityState>> myQueue;
    private boolean isProcessing;
    private boolean myStarted;
    private final ThreadToUse myThreadToUse;
    private final Condition<?> myDeathCondition;

    public QueueProcessor(@NotNull Consumer<? super T> processor) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(0);
        }
        this(processor, Conditions.alwaysFalse());
    }

    public QueueProcessor(@NotNull Consumer<? super T> processor, @NotNull Condition<?> deathCondition) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(1);
        }
        if (deathCondition == null) {
            QueueProcessor.$$$reportNull$$$0(2);
        }
        this(processor, deathCondition, true);
    }

    public QueueProcessor(@NotNull Consumer<? super T> processor, @NotNull Condition<?> deathCondition, boolean autostart) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(3);
        }
        if (deathCondition == null) {
            QueueProcessor.$$$reportNull$$$0(4);
        }
        this(QueueProcessor.wrappingProcessor(processor), autostart, ThreadToUse.POOLED, deathCondition);
    }

    @NotNull
    public static QueueProcessor<Runnable> createRunnableQueueProcessor() {
        return new QueueProcessor<Runnable>(new RunnableConsumer());
    }

    @NotNull
    public static QueueProcessor<Runnable> createRunnableQueueProcessor(@NotNull ThreadToUse threadToUse) {
        if (threadToUse == null) {
            QueueProcessor.$$$reportNull$$$0(5);
        }
        return new QueueProcessor<Runnable>(QueueProcessor.wrappingProcessor(new RunnableConsumer()), true, threadToUse, Conditions.alwaysFalse());
    }

    @NotNull
    private static <T> BiConsumer<T, Runnable> wrappingProcessor(@NotNull Consumer<? super T> processor) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(6);
        }
        BiConsumer<Object, Runnable> biConsumer = (item, continuation) -> {
            try {
                QueueProcessor.runSafely(() -> processor.consume(item));
            }
            finally {
                continuation.run();
            }
        };
        if (biConsumer == null) {
            QueueProcessor.$$$reportNull$$$0(7);
        }
        return biConsumer;
    }

    public QueueProcessor(@NotNull BiConsumer<? super T, ? super Runnable> processor, boolean autostart, @NotNull ThreadToUse threadToUse, @NotNull Condition<?> deathCondition) {
        if (processor == null) {
            QueueProcessor.$$$reportNull$$$0(8);
        }
        if (threadToUse == null) {
            QueueProcessor.$$$reportNull$$$0(9);
        }
        if (deathCondition == null) {
            QueueProcessor.$$$reportNull$$$0(10);
        }
        this.myQueue = new ArrayDeque<Pair<T, ModalityState>>();
        this.myProcessor = processor;
        this.myStarted = autostart;
        this.myThreadToUse = threadToUse;
        this.myDeathCondition = deathCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Deque<Pair<T, ModalityState>> deque = this.myQueue;
        synchronized (deque) {
            if (this.myStarted) {
                return;
            }
            this.myStarted = true;
            if (!this.myQueue.isEmpty()) {
                this.startProcessing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishProcessing(boolean continueProcessing) {
        Deque<Pair<T, ModalityState>> deque = this.myQueue;
        synchronized (deque) {
            this.isProcessing = false;
            if (this.myQueue.isEmpty()) {
                this.myQueue.notifyAll();
            } else if (continueProcessing) {
                this.startProcessing();
            }
        }
    }

    public void add(@NotNull T t2, ModalityState state) {
        if (t2 == null) {
            QueueProcessor.$$$reportNull$$$0(11);
        }
        this.doAdd(t2, state, false);
    }

    public void add(@NotNull T element) {
        if (element == null) {
            QueueProcessor.$$$reportNull$$$0(12);
        }
        this.doAdd(element, null, false);
    }

    public void addFirst(@NotNull T element) {
        if (element == null) {
            QueueProcessor.$$$reportNull$$$0(13);
        }
        this.doAdd(element, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAdd(@NotNull T element, @Nullable ModalityState state, boolean atHead) {
        if (element == null) {
            QueueProcessor.$$$reportNull$$$0(14);
        }
        Deque<Pair<T, ModalityState>> deque = this.myQueue;
        synchronized (deque) {
            Pair<T, ModalityState> pair = Pair.create(element, state);
            if (atHead) {
                this.myQueue.addFirst(pair);
            } else {
                this.myQueue.add(pair);
            }
            this.startProcessing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Deque<Pair<T, ModalityState>> deque = this.myQueue;
        synchronized (deque) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        this.assertCorrectThread();
        Deque<Pair<T, ModalityState>> deque = this.myQueue;
        synchronized (deque) {
            while (this.isProcessing) {
                try {
                    this.myQueue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitFor(long timeoutMS) {
        this.assertCorrectThread();
        Deque<Pair<T, ModalityState>> deque = this.myQueue;
        synchronized (deque) {
            long start = System.currentTimeMillis();
            while (this.isProcessing) {
                long rest = timeoutMS - (System.currentTimeMillis() - start);
                if (rest <= 0L) {
                    return !this.isProcessing;
                }
                try {
                    this.myQueue.wait(rest);
                }
                catch (InterruptedException interruptedException) {}
            }
            return true;
        }
    }

    private void assertCorrectThread() {
        if (this.myThreadToUse == ThreadToUse.AWT) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
    }

    private void startProcessing() {
        LOG.assertTrue(Thread.holdsLock(this.myQueue));
        if (this.isProcessing || !this.myStarted) {
            return;
        }
        this.isProcessing = true;
        Pair<T, ModalityState> pair = this.myQueue.removeFirst();
        T item = pair.getFirst();
        Runnable runnable = () -> {
            if (this.myDeathCondition.value(null)) {
                this.finishProcessing(false);
                return;
            }
            QueueProcessor.runSafely(() -> this.myProcessor.accept(item, () -> this.finishProcessing(true)));
        };
        Application application = ApplicationManager.getApplication();
        switch (this.myThreadToUse) {
            case AWT: {
                ModalityState state = pair.getSecond();
                if (state == null) {
                    application.invokeLater(runnable);
                    break;
                }
                application.invokeLater(runnable, state);
                break;
            }
            case POOLED: {
                if (application == null) {
                    SwingUtilities.invokeLater(runnable);
                    break;
                }
                AppJavaExecutorUtil.executeOnPooledIoThread(runnable);
            }
        }
    }

    public static void runSafely(@NotNull Runnable run2) {
        if (run2 == null) {
            QueueProcessor.$$$reportNull$$$0(15);
        }
        try {
            run2.run();
        }
        catch (ProcessCanceledException e2) {
            throw e2;
        }
        catch (CancellationException e3) {
            throw new CeProcessCanceledException(e3);
        }
        catch (Throwable e4) {
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isUnitTestMode()) {
                throw e4;
            }
            try {
                LOG.error(e4);
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Deque<Pair<T, ModalityState>> deque = this.myQueue;
        synchronized (deque) {
            return this.myQueue.isEmpty() && !this.isProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dismissLastTasks(int remaining) {
        Deque<Pair<T, ModalityState>> deque = this.myQueue;
        synchronized (deque) {
            while (this.myQueue.size() > remaining) {
                this.myQueue.pollLast();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingItemsToProcess() {
        Deque<Pair<T, ModalityState>> deque = this.myQueue;
        synchronized (deque) {
            return !this.myQueue.isEmpty();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deathCondition";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadToUse";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/QueueProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "run";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/QueueProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "wrappingProcessor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createRunnableQueueProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "wrappingProcessor";
                break;
            }
            case 7: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addFirst";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doAdd";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "runSafely";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }

    public static enum ThreadToUse {
        AWT,
        POOLED;

    }

    private static final class RunnableConsumer
    implements Consumer<Runnable> {
        private RunnableConsumer() {
        }

        @Override
        public void consume(Runnable runnable) {
            runnable.run();
        }
    }
}

