/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class CharTrie {
    private int myAllNodesSize;
    private char[] myAllNodesChars;
    private char[] myAllNodesParents;
    private char[][] myAllNodesChildren;
    private static final int LENGTH_SLOT_LENGTH = 1;
    private static final ArrayFactory<char[]> FACTORY = x$0 -> new char[x$0][];

    public CharTrie() {
        this.init();
    }

    private void init() {
        this.myAllNodesChars = null;
        this.myAllNodesParents = null;
        this.myAllNodesChildren = null;
        this.myAllNodesSize = 0;
        this.addNode(-1, '\u0000');
    }

    private void addNode(int parentIndex, char ch) {
        if (this.myAllNodesSize == 0) {
            int initialCapacity = 10;
            this.myAllNodesChars = new char[initialCapacity];
            this.myAllNodesParents = new char[initialCapacity];
            this.myAllNodesChildren = new char[initialCapacity][];
        } else if (this.myAllNodesSize >= this.myAllNodesChars.length) {
            int increment = Math.max(this.myAllNodesSize >> 2, 10);
            int newSize = this.myAllNodesSize + increment;
            this.myAllNodesChars = ArrayUtil.realloc(this.myAllNodesChars, newSize);
            this.myAllNodesParents = ArrayUtil.realloc(this.myAllNodesParents, newSize);
            this.myAllNodesChildren = ArrayUtil.realloc(this.myAllNodesChildren, newSize, FACTORY);
        }
        this.myAllNodesChars[this.myAllNodesSize] = ch;
        this.myAllNodesParents[this.myAllNodesSize] = (char)parentIndex;
        this.myAllNodesChildren[this.myAllNodesSize] = null;
        ++this.myAllNodesSize;
        assert (this.myAllNodesSize < 65535);
    }

    public int size() {
        return this.myAllNodesSize;
    }

    public String getReversedString(int hashCode) {
        return new String(this.getReversedChars(hashCode));
    }

    public String getString(int hashCode) {
        return new String(this.getChars(hashCode));
    }

    public int getHashCode(char[] chars) {
        return this.getHashCode(chars, 0, chars.length);
    }

    public int getHashCode(char[] chars, int offset, int length) {
        int index2 = 0;
        for (int i2 = offset; i2 < offset + length; ++i2) {
            index2 = this.getSubNode(index2, chars[i2], true);
        }
        return index2;
    }

    public int getHashCode(CharSequence seq) {
        int index2 = 0;
        int l2 = seq.length();
        for (int i2 = 0; i2 < l2; ++i2) {
            index2 = this.getSubNode(index2, seq.charAt(i2), true);
        }
        return index2;
    }

    public long getMaximumMatch(CharSequence seq, int offset, int length) {
        int nextIndex;
        int index2 = 0;
        int resultingLength = 0;
        while (length-- > 0 && (nextIndex = this.findSubNode(index2, seq.charAt(offset++))) != 0) {
            index2 = nextIndex;
            ++resultingLength;
        }
        return (long)index2 + ((long)resultingLength << 32);
    }

    public char @NotNull [] getChars(int hashCode) {
        int length = 0;
        int run2 = hashCode;
        while (run2 > 0) {
            ++length;
            run2 = this.myAllNodesParents[run2];
        }
        char[] result2 = new char[length];
        run2 = hashCode;
        for (int i2 = 0; i2 < length; ++i2) {
            assert (run2 > 0);
            result2[length - i2 - 1] = this.myAllNodesChars[run2];
            run2 = this.myAllNodesParents[run2];
        }
        if (result2 == null) {
            CharTrie.$$$reportNull$$$0(0);
        }
        return result2;
    }

    public int getHashCodeForReversedChars(char[] chars) {
        return this.getHashCodeForReversedChars(chars, chars.length - 1, chars.length);
    }

    public int getHashCodeForReversedChars(char[] chars, int offset, int length) {
        int index2 = 0;
        while (length-- > 0) {
            index2 = this.getSubNode(index2, chars[offset--], true);
        }
        return index2;
    }

    public char @NotNull [] getReversedChars(int hashCode) {
        int length = 0;
        int run2 = hashCode;
        while (run2 > 0) {
            ++length;
            run2 = this.myAllNodesParents[run2];
        }
        char[] result2 = new char[length];
        run2 = hashCode;
        for (int i2 = 0; i2 < length; ++i2) {
            assert (run2 > 0);
            result2[i2] = this.myAllNodesChars[run2];
            run2 = this.myAllNodesParents[run2];
        }
        if (result2 == null) {
            CharTrie.$$$reportNull$$$0(1);
        }
        return result2;
    }

    public int findSubNode(int parentIndex, char c2) {
        return this.getSubNode(parentIndex, c2, false);
    }

    private int getSubNode(int parentIndex, char c2, boolean createIfNotExists) {
        if (this.myAllNodesChildren[parentIndex] == null) {
            if (!createIfNotExists) {
                return 0;
            }
            char[] chars = new char[2];
            this.myAllNodesChildren[parentIndex] = chars;
        }
        char[] children2 = this.myAllNodesChildren[parentIndex];
        char childrenCount = children2[children2.length - 1];
        int left = 0;
        int right = childrenCount - '\u0001';
        while (left <= right) {
            int middle = left + right >> 1;
            char index2 = children2[middle];
            int comp = this.myAllNodesChars[index2] - c2;
            if (comp == 0) {
                return index2;
            }
            if (comp < 0) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        if (!createIfNotExists) {
            return 0;
        }
        if (childrenCount == children2.length - 1) {
            this.myAllNodesChildren[parentIndex] = ArrayUtil.realloc(children2, children2.length * 3 / 2 + 1 + 1);
            children2 = this.myAllNodesChildren[parentIndex];
        }
        if (left != childrenCount) {
            System.arraycopy(children2, left, children2, left + 1, childrenCount - left);
        }
        int index3 = this.myAllNodesSize;
        children2[left] = (char)index3;
        assert (childrenCount + '\u0001' < 65535);
        children2[children2.length - 1] = (char)(childrenCount + '\u0001');
        this.addNode(parentIndex, c2);
        return index3;
    }

    public void clear() {
        this.init();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/containers/CharTrie";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReversedChars";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

