/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.Interner;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class PathInterner {
    private final ObjectOpenHashSet<CharSegment> interner = new ObjectOpenHashSet();

    @Contract(value="_,true->!null")
    private CharSegment[] internParts(@NotNull CharSequence path, boolean forAddition) {
        if (path == null) {
            PathInterner.$$$reportNull$$$0(0);
        }
        boolean asBytes = forAddition && IOUtil.isAscii(path);
        ArrayList<CharSegment> key = new ArrayList<CharSegment>();
        SubSegment flyweightKey = new SubSegment();
        for (int start = 0; start < path.length(); start += flyweightKey.length()) {
            flyweightKey.findSubStringUntilNextSeparator(path, start);
            CharSegment interned = this.interner.get(flyweightKey);
            if (interned == null) {
                if (!forAddition) {
                    return null;
                }
                interned = flyweightKey.createPersistentCopy(asBytes);
                this.interner.addOrGet(interned);
            }
            key.add(interned);
        }
        return key.toArray(new CharSegment[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/util/containers/PathInterner", "internParts"));
    }

    private static class CharSegment {
        private final Object encodedString;
        private final int hc;

        private CharSegment(@NotNull Object encodedString, int hc) {
            if (encodedString == null) {
                CharSegment.$$$reportNull$$$0(0);
            }
            this.encodedString = encodedString;
            this.hc = hc;
        }

        void appendTo(@NotNull StringBuilder sb) {
            if (sb == null) {
                CharSegment.$$$reportNull$$$0(1);
            }
            if (this.encodedString instanceof CharSequence) {
                sb.append(this.encodedString);
                return;
            }
            int oldLen = sb.length();
            sb.setLength(oldLen + this.length());
            byte[] bytes2 = (byte[])this.encodedString;
            for (int i2 = 0; i2 < bytes2.length; ++i2) {
                sb.setCharAt(oldLen + i2, (char)bytes2[i2]);
            }
        }

        char charAt(int i2) {
            if (this.encodedString instanceof CharSequence) {
                return ((CharSequence)this.encodedString).charAt(i2);
            }
            return (char)((byte[])this.encodedString)[i2];
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof CharSegment)) {
                return false;
            }
            CharSegment wrapper = (CharSegment)o2;
            if (this.hashCode() != wrapper.hashCode()) {
                return false;
            }
            if (this.length() != wrapper.length()) {
                return false;
            }
            for (int i2 = 0; i2 < this.length(); ++i2) {
                if (this.charAt(i2) == wrapper.charAt(i2)) continue;
                return false;
            }
            return true;
        }

        int length() {
            if (this.encodedString instanceof CharSequence) {
                return ((CharSequence)this.encodedString).length();
            }
            return (char)((byte[])this.encodedString).length;
        }

        public int hashCode() {
            return this.hc;
        }

        public String toString() {
            return this.encodedString instanceof String ? (String)this.encodedString : new String((byte[])this.encodedString, StandardCharsets.ISO_8859_1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "encodedString";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sb";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/containers/PathInterner$CharSegment";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "appendTo";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class SubSegment
    extends CharSegment {
        private Object encodedString;
        private int start;
        private int end;
        private int computedHc;

        private SubSegment() {
            super("", 0);
        }

        void findSubStringUntilNextSeparator(@NotNull CharSequence s2, int start) {
            if (s2 == null) {
                SubSegment.$$$reportNull$$$0(0);
            }
            this.encodedString = s2;
            this.start = start;
            while (start < s2.length() && SubSegment.isSeparator(s2.charAt(start))) {
                ++start;
            }
            while (start < s2.length() && !SubSegment.isSeparator(s2.charAt(start))) {
                ++start;
            }
            this.end = start;
            this.computedHc = StringUtil.stringHashCode(s2, this.start, this.end);
        }

        private static boolean isSeparator(char c2) {
            return c2 == '/' || c2 == '\\' || c2 == '.' || c2 == ' ' || c2 == '_' || c2 == '$';
        }

        @Override
        char charAt(int i2) {
            if (this.encodedString instanceof CharSequence) {
                return ((CharSequence)this.encodedString).charAt(this.start + i2);
            }
            return (char)((byte[])this.encodedString)[this.start + i2];
        }

        @Override
        int length() {
            return this.end - this.start;
        }

        @Override
        public int hashCode() {
            return this.computedHc;
        }

        @NotNull
        CharSegment createPersistentCopy(boolean asBytes) {
            Object newEncodedString;
            CharSequence string2 = (CharSequence)this.encodedString;
            if (asBytes) {
                byte[] bytes2 = ArrayUtil.newByteArray(this.length());
                for (int i2 = 0; i2 < bytes2.length; ++i2) {
                    bytes2[i2] = (byte)string2.charAt(i2 + this.start);
                }
                newEncodedString = bytes2;
            } else {
                newEncodedString = string2.subSequence(this.start, this.end);
            }
            return new CharSegment(newEncodedString, this.computedHc);
        }

        @Override
        public String toString() {
            return (this.encodedString instanceof String ? (String)this.encodedString : new String((byte[])this.encodedString, StandardCharsets.ISO_8859_1)).substring(this.start, this.end);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/containers/PathInterner$SubSegment", "findSubStringUntilNextSeparator"));
        }
    }

    public static final class PathEnumerator
    extends Interner<CharSequence> {
        private final Object2IntMap<CharSegment[]> mySeqToIdx = new Object2IntOpenCustomHashMap<CharSegment[]>(ObjectArrays.HASH_STRATEGY);
        private final List<CharSequence> myIdxToSeq = new ArrayList<CharSequence>();
        private final PathInterner myInterner = new PathInterner();

        public PathEnumerator() {
            this.myIdxToSeq.add(null);
        }

        @NotNull
        public List<CharSequence> getAllPaths() {
            List<CharSequence> list2 = this.myIdxToSeq.subList(1, this.myIdxToSeq.size());
            if (list2 == null) {
                PathEnumerator.$$$reportNull$$$0(0);
            }
            return list2;
        }

        public int addPath(@NotNull CharSequence path) {
            CharSegment[] seq;
            if (path == null) {
                PathEnumerator.$$$reportNull$$$0(1);
            }
            if (!this.mySeqToIdx.containsKey(seq = this.myInterner.internParts(path, true))) {
                this.mySeqToIdx.put(seq, this.myIdxToSeq.size());
                this.myIdxToSeq.add(new SegmentedCharSequence(seq));
            }
            return this.mySeqToIdx.getInt(seq);
        }

        @NotNull
        public CharSequence retrievePath(int idx) {
            CharSequence charSequence;
            try {
                charSequence = this.myIdxToSeq.get(idx);
            }
            catch (IndexOutOfBoundsException e2) {
                throw new IllegalArgumentException("Illegal index: " + idx);
            }
            if (charSequence == null) {
                PathEnumerator.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        public boolean containsPath(@NotNull CharSequence path) {
            CharSegment[] key;
            if (path == null) {
                PathEnumerator.$$$reportNull$$$0(3);
            }
            return (key = this.myInterner.internParts(path, false)) != null && this.mySeqToIdx.containsKey(key);
        }

        @Override
        @NotNull
        public CharSequence intern(@NotNull CharSequence path) {
            if (path == null) {
                PathEnumerator.$$$reportNull$$$0(4);
            }
            CharSequence charSequence = this.retrievePath(this.addPath(path));
            if (charSequence == null) {
                PathEnumerator.$$$reportNull$$$0(5);
            }
            return charSequence;
        }

        @Override
        @NotNull
        public Set<CharSequence> getValues() {
            Set<CharSequence> set = CollectionFactory.createSmallMemoryFootprintSet(this.getAllPaths());
            if (set == null) {
                PathEnumerator.$$$reportNull$$$0(6);
            }
            return set;
        }

        @Override
        public void clear() {
            this.myInterner.interner.clear();
            this.mySeqToIdx.clear();
            this.myIdxToSeq.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/PathInterner$PathEnumerator";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllPaths";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/PathInterner$PathEnumerator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "retrievePath";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intern";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValues";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "containsPath";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "intern";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class SegmentedCharSequence
    implements CharSequenceWithStringHash {
        private final CharSegment[] myWrappers;
        private transient int hash;

        private SegmentedCharSequence(CharSegment @NotNull [] wrappers) {
            if (wrappers == null) {
                SegmentedCharSequence.$$$reportNull$$$0(0);
            }
            this.myWrappers = wrappers;
        }

        @Override
        public int length() {
            int length = 0;
            for (CharSegment wrapper : this.myWrappers) {
                length += wrapper.length();
            }
            return length;
        }

        @Override
        public char charAt(int index2) {
            for (CharSegment wrapper : this.myWrappers) {
                int length = wrapper.length();
                if (index2 < length) {
                    return wrapper.charAt(index2);
                }
                index2 -= length;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().substring(start, end);
        }

        @Override
        @NotNull
        public String toString() {
            StringBuilder b2 = new StringBuilder(this.length());
            for (CharSegment wrapper : this.myWrappers) {
                wrapper.appendTo(b2);
            }
            String string2 = b2.toString();
            if (string2 == null) {
                SegmentedCharSequence.$$$reportNull$$$0(1);
            }
            return string2;
        }

        private static int pow31(int p2) {
            int base = 31;
            int r2 = 1;
            while (p2 != 0) {
                if ((p2 & 1) != 0) {
                    r2 *= base;
                }
                base *= base;
                p2 >>= 1;
            }
            return r2;
        }

        @Override
        public int hashCode() {
            int h2 = this.hash;
            if (h2 == 0) {
                h2 = this.myWrappers[0].hc;
                for (int i2 = 1; i2 < this.myWrappers.length; ++i2) {
                    CharSegment wrapper = this.myWrappers[i2];
                    h2 = h2 * SegmentedCharSequence.pow31(wrapper.length()) + wrapper.hc;
                }
                this.hash = h2;
                return h2;
            }
            return h2;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CharSequence)) {
                return false;
            }
            CharSequence other = (CharSequence)obj;
            if (this.length() != other.length()) {
                return false;
            }
            int i2 = 0;
            for (CharSegment wrapper : this.myWrappers) {
                byte[] bytes2;
                if (wrapper.encodedString instanceof String) {
                    if (!CharArrayUtil.regionMatches(other, i2, i2 + wrapper.length(), (CharSequence)((String)wrapper.encodedString))) {
                        return false;
                    }
                    i2 += wrapper.length();
                    continue;
                }
                for (byte b2 : bytes2 = (byte[])wrapper.encodedString) {
                    char c2 = (char)b2;
                    if (c2 == other.charAt(i2++)) continue;
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string2;
            switch (n2) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappers";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/PathInterner$SegmentedCharSequence";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/PathInterner$SegmentedCharSequence";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

