/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.n;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Unmodifiable
public final class UnmodifiableHashMap<K, V>
implements Map<K, V> {
    private static final UnmodifiableHashMap<Object, Object> EMPTY = new UnmodifiableHashMap<Object, Object>(HashingStrategy.canonical(), ArrayUtilRt.EMPTY_OBJECT_ARRAY, null, null, null, null, null, null);
    @NotNull
    private final HashingStrategy<K> strategy;
    private final Object @NotNull [] data;
    private final K k1;
    private final K k2;
    private final K k3;
    private final V v1;
    private final V v2;
    private final V v3;
    private final int size;
    private Set<K> keySet;
    private Collection<V> values;

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> empty() {
        UnmodifiableHashMap<Object, Object> unmodifiableHashMap = EMPTY;
        if (unmodifiableHashMap == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(0);
        }
        return unmodifiableHashMap;
    }

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> empty(@NotNull HashingStrategy<K> strategy) {
        if (strategy == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(1);
        }
        if (strategy == HashingStrategy.canonical()) {
            return UnmodifiableHashMap.empty();
        }
        return new UnmodifiableHashMap<Object, Object>(strategy, ArrayUtilRt.EMPTY_OBJECT_ARRAY, null, null, null, null, null, null);
    }

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> fromMap(@NotNull Map<? extends K, ? extends V> map2) {
        if (map2 == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(2);
        }
        return UnmodifiableHashMap.fromMap(HashingStrategy.canonical(), map2);
    }

    @NotNull
    public static <K, V> UnmodifiableHashMap<K, V> fromMap(@NotNull HashingStrategy<K> strategy, @NotNull Map<? extends K, ? extends V> map2) {
        if (strategy == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(3);
        }
        if (map2 == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(4);
        }
        if (map2 instanceof UnmodifiableHashMap && ((UnmodifiableHashMap)map2).strategy == strategy) {
            UnmodifiableHashMap unmodifiableHashMap = (UnmodifiableHashMap)map2;
            if (unmodifiableHashMap == null) {
                UnmodifiableHashMap.$$$reportNull$$$0(5);
            }
            return unmodifiableHashMap;
        }
        if (map2.isEmpty()) {
            return UnmodifiableHashMap.empty(strategy);
        }
        if (map2.size() <= 3) {
            K k1 = null;
            K k22 = null;
            K k3 = null;
            V v1 = null;
            V v22 = null;
            V v3 = null;
            Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
            if (iterator2.hasNext()) {
                Map.Entry<K, V> e2 = iterator2.next();
                k1 = e2.getKey();
                v1 = e2.getValue();
                if (iterator2.hasNext()) {
                    e2 = iterator2.next();
                    k22 = e2.getKey();
                    v22 = e2.getValue();
                    if (iterator2.hasNext()) {
                        e2 = iterator2.next();
                        k3 = e2.getKey();
                        v3 = e2.getValue();
                        assert (!iterator2.hasNext());
                    }
                }
            }
            return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)strategy, ArrayUtilRt.EMPTY_OBJECT_ARRAY, k1, v1, k22, v22, k3, v3);
        }
        Object[] newData = new Object[map2.size() * 4];
        map2.forEach((k2, v2) -> UnmodifiableHashMap.insert(strategy, newData, Objects.requireNonNull(k2), v2));
        return new UnmodifiableHashMap<Object, Object>(strategy, newData, null, null, null, null, null, null);
    }

    private UnmodifiableHashMap(@NotNull HashingStrategy<K> strategy, Object @NotNull [] data, @Nullable K k1, @Nullable V v1, @Nullable K k2, @Nullable V v2, @Nullable K k3, @Nullable V v3) {
        if (strategy == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(6);
        }
        if (data == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(7);
        }
        this.strategy = strategy;
        this.data = data;
        this.k1 = k1;
        this.k2 = k2;
        this.k3 = k3;
        this.v1 = v1;
        this.v2 = v2;
        this.v3 = v3;
        this.size = data.length / 4 + (k1 == null ? 0 : (k2 == null ? 1 : (k3 == null ? 2 : 3)));
    }

    @Contract(pure=true)
    @NotNull
    public UnmodifiableHashMap<K, V> without(@NotNull K key) {
        int pos;
        if (key == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(8);
        }
        int n2 = pos = this.data.length == 0 ? -1 : UnmodifiableHashMap.tablePos(this.strategy, this.data, key);
        if (pos >= 0) {
            Object[] newData = new Object[(this.size - 1) * 4];
            for (int i2 = 0; i2 < this.data.length; i2 += 2) {
                Object k2;
                if (i2 == pos || (k2 = this.data[i2]) == null) continue;
                Object v2 = this.data[i2 + 1];
                UnmodifiableHashMap.insert(this.strategy, newData, k2, v2);
            }
            if (this.k1 != null) {
                UnmodifiableHashMap.insert(this.strategy, newData, this.k1, this.v1);
                if (this.k2 != null) {
                    UnmodifiableHashMap.insert(this.strategy, newData, this.k2, this.v2);
                    if (this.k3 != null) {
                        UnmodifiableHashMap.insert(this.strategy, newData, this.k3, this.v3);
                    }
                }
            }
            return new UnmodifiableHashMap<Object, Object>(this.strategy, newData, null, null, null, null, null, null);
        }
        if (this.k1 != null) {
            if (this.strategy.equals(this.k1, key)) {
                return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, this.k2, this.v2, this.k3, this.v3, null, null);
            }
            if (this.k2 != null) {
                if (this.strategy.equals(this.k2, key)) {
                    return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, this.k1, this.v1, this.k3, this.v3, null, null);
                }
                if (this.k3 != null && this.strategy.equals(this.k3, key)) {
                    return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, this.k1, this.v1, this.k2, this.v2, null, null);
                }
            }
        }
        UnmodifiableHashMap unmodifiableHashMap = this;
        if (unmodifiableHashMap == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(9);
        }
        return unmodifiableHashMap;
    }

    @Contract(pure=true)
    @NotNull
    public UnmodifiableHashMap<K, V> with(@NotNull K key, @Nullable V value) {
        int pos;
        if (key == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(10);
        }
        int n2 = pos = this.data.length == 0 ? -1 : UnmodifiableHashMap.tablePos(this.strategy, this.data, key);
        if (pos >= 0) {
            if (this.data[pos + 1] == value) {
                UnmodifiableHashMap<K, V> unmodifiableHashMap = this;
                if (unmodifiableHashMap == null) {
                    UnmodifiableHashMap.$$$reportNull$$$0(11);
                }
                return unmodifiableHashMap;
            }
            Object[] copy2 = (Object[])this.data.clone();
            copy2[pos + 1] = value;
            return new UnmodifiableHashMap<K, V>(this.strategy, copy2, this.k1, this.v1, this.k2, this.v2, this.k3, this.v3);
        }
        if (this.k1 == null) {
            return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, key, value, null, null, null, null);
        }
        if (this.strategy.equals(this.k1, key)) {
            return value == this.v1 ? this : new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, value, this.k2, this.v2, this.k3, this.v3);
        }
        if (this.k2 == null) {
            return new UnmodifiableHashMap<Object, Object>((HashingStrategy<Object>)this.strategy, this.data, this.k1, this.v1, key, value, null, null);
        }
        if (this.strategy.equals(this.k2, key)) {
            return value == this.v2 ? this : new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, this.v1, this.k2, value, this.k3, this.v3);
        }
        if (this.k3 == null) {
            return new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, this.v1, this.k2, this.v2, key, value);
        }
        if (this.strategy.equals(this.k3, key)) {
            return value == this.v3 ? this : new UnmodifiableHashMap<K, V>(this.strategy, this.data, this.k1, this.v1, this.k2, this.v2, this.k3, value);
        }
        Object[] newData = new Object[(this.size + 1) * 4];
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            Object k2 = this.data[i2];
            if (k2 == null) continue;
            Object v2 = this.data[i2 + 1];
            UnmodifiableHashMap.insert(this.strategy, newData, k2, v2);
        }
        UnmodifiableHashMap.insert(this.strategy, newData, this.k1, this.v1);
        UnmodifiableHashMap.insert(this.strategy, newData, this.k2, this.v2);
        UnmodifiableHashMap.insert(this.strategy, newData, this.k3, this.v3);
        UnmodifiableHashMap.insert(this.strategy, newData, key, value);
        return new UnmodifiableHashMap<Object, Object>(this.strategy, newData, null, null, null, null, null, null);
    }

    @NotNull
    public UnmodifiableHashMap<K, V> withAll(@NotNull Map<? extends K, ? extends V> map2) {
        if (map2 == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(12);
        }
        if (this.isEmpty()) {
            return UnmodifiableHashMap.fromMap(this.strategy, map2);
        }
        int mapSize = map2.size();
        if (mapSize == 0) {
            UnmodifiableHashMap unmodifiableHashMap = this;
            if (unmodifiableHashMap == null) {
                UnmodifiableHashMap.$$$reportNull$$$0(13);
            }
            return unmodifiableHashMap;
        }
        if (mapSize == 1) {
            Map.Entry<K, V> entry = map2.entrySet().iterator().next();
            UnmodifiableHashMap<K, V> unmodifiableHashMap = this.with(entry.getKey(), entry.getValue());
            if (unmodifiableHashMap == null) {
                UnmodifiableHashMap.$$$reportNull$$$0(14);
            }
            return unmodifiableHashMap;
        }
        n newMap = this.strategy == HashingStrategy.canonical() ? new Object2ObjectOpenHashMap(mapSize + this.size) : new Object2ObjectOpenCustomHashMap(mapSize + this.size, UnmodifiableHashMap.getFastutilHashingStrategy(this.strategy));
        newMap.putAll(this);
        newMap.putAll(map2);
        return UnmodifiableHashMap.fromMap(this.strategy, newMap);
    }

    @NotNull
    private static <K> Hash.Strategy<K> getFastutilHashingStrategy(final @NotNull HashingStrategy<K> strategy) {
        if (strategy == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(15);
        }
        return new Hash.Strategy<K>(){

            @Override
            public int hashCode(@Nullable K o2) {
                return o2 == null ? 0 : strategy.hashCode(o2);
            }

            @Override
            public boolean equals(@Nullable K a2, @Nullable K b2) {
                return a2 == b2 || a2 != null && b2 != null && strategy.equals(a2, b2);
            }
        };
    }

    private static <K> void insert(HashingStrategy<K> strategy, Object[] data, K k2, Object v2) {
        int insertPos = UnmodifiableHashMap.tablePos(strategy, data, k2);
        assert ((insertPos ^= 0xFFFFFFFF) >= 0);
        data[insertPos] = k2;
        data[insertPos + 1] = v2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        Object typedKey = key;
        if (this.data.length > 0 && UnmodifiableHashMap.tablePos(this.strategy, this.data, typedKey) >= 0) {
            return true;
        }
        if (this.k1 != null) {
            if (this.strategy.equals(this.k1, typedKey)) {
                return true;
            }
            if (this.k2 != null) {
                if (this.strategy.equals(this.k2, typedKey)) {
                    return true;
                }
                if (this.k3 != null) {
                    return this.strategy.equals(this.k3, typedKey);
                }
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.k1 != null) {
            if (Objects.equals(this.v1, value)) {
                return true;
            }
            if (this.k2 != null) {
                if (Objects.equals(this.v2, value)) {
                    return true;
                }
                if (this.k3 != null && Objects.equals(this.v3, value)) {
                    return true;
                }
            }
        }
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            if (this.data[i2] == null || !Objects.equals(this.data[i2 + 1], value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return this.getOrDefault(key, null);
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        if (key == null) {
            return defaultValue;
        }
        Object typedKey = key;
        if (this.k1 != null) {
            if (this.strategy.equals(this.k1, typedKey)) {
                return this.v1;
            }
            if (this.k2 != null) {
                if (this.strategy.equals(this.k2, typedKey)) {
                    return this.v2;
                }
                if (this.k3 != null && this.strategy.equals(this.k3, typedKey)) {
                    return this.v3;
                }
            }
        }
        if (this.data.length == 0) {
            return defaultValue;
        }
        int pos = UnmodifiableHashMap.tablePos(this.strategy, this.data, typedKey);
        V v2 = pos < 0 ? defaultValue : this.data[pos + 1];
        return v2;
    }

    private static <K> int tablePos(HashingStrategy<K> strategy, Object[] data, K key) {
        int pos = Math.floorMod(strategy.hashCode(key), data.length / 2) * 2;
        Object candidate;
        while ((candidate = data[pos]) != null) {
            if (strategy.equals(candidate, key)) {
                return pos;
            }
            if ((pos += 2) != data.length) continue;
            pos = 0;
        }
        return ~pos;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        if (this.k1 != null) {
            h2 += this.strategy.hashCode(this.k1) ^ Objects.hashCode(this.v1);
            if (this.k2 != null) {
                h2 += this.strategy.hashCode(this.k2) ^ Objects.hashCode(this.v2);
                if (this.k3 != null) {
                    h2 += this.strategy.hashCode(this.k3) ^ Objects.hashCode(this.v3);
                }
            }
        }
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            Object key = this.data[i2];
            if (key == null) continue;
            h2 += this.strategy.hashCode(key) ^ Objects.hashCode(this.data[i2 + 1]);
        }
        return h2;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map2 = (Map)obj;
        if (this.size() != map2.size()) {
            return false;
        }
        if (this.k1 != null) {
            if (!Objects.equals(map2.get(this.k1), this.v1)) {
                return false;
            }
            if (this.k2 != null) {
                if (!Objects.equals(map2.get(this.k2), this.v2)) {
                    return false;
                }
                if (this.k3 != null && !Objects.equals(map2.get(this.k3), this.v3)) {
                    return false;
                }
            }
        }
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            Object key = this.data[i2];
            if (key == null || Objects.equals(map2.get(key), this.data[i2 + 1])) continue;
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(@NotNull Map<? extends K, ? extends V> m4) {
        if (m4 == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action2) {
        if (this.k1 != null) {
            if (this.k2 != null) {
                if (this.k3 != null) {
                    action2.accept(this.k3, this.v3);
                }
                action2.accept(this.k2, this.v2);
            }
            action2.accept(this.k1, this.v1);
        }
        for (int i2 = 0; i2 < this.data.length; i2 += 2) {
            Object key = this.data[i2];
            if (key == null) continue;
            action2.accept(key, this.data[i2 + 1]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        this.forEach((k2, v2) -> {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(k2).append('=').append(v2);
        });
        return sb.append('}').toString();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                @NotNull
                public Iterator<K> iterator() {
                    return new MyIterator<K>(){

                        @Override
                        K fieldElement(int offset) {
                            return offset == 0 ? UnmodifiableHashMap.this.k1 : (offset == 1 ? UnmodifiableHashMap.this.k2 : UnmodifiableHashMap.this.k3);
                        }

                        @Override
                        K tableElement(int offset) {
                            return UnmodifiableHashMap.this.data[offset];
                        }
                    };
                }

                @Override
                public void forEach(Consumer<? super K> action2) {
                    if (UnmodifiableHashMap.this.k1 != null) {
                        if (UnmodifiableHashMap.this.k2 != null) {
                            if (UnmodifiableHashMap.this.k3 != null) {
                                action2.accept(UnmodifiableHashMap.this.k3);
                            }
                            action2.accept(UnmodifiableHashMap.this.k2);
                        }
                        action2.accept(UnmodifiableHashMap.this.k1);
                    }
                    for (int i2 = 0; i2 < UnmodifiableHashMap.this.data.length; i2 += 2) {
                        Object key = UnmodifiableHashMap.this.data[i2];
                        if (key == null) continue;
                        Object k2 = UnmodifiableHashMap.this.data[i2];
                        action2.accept(k2);
                    }
                }

                @Override
                public boolean contains(Object o2) {
                    return UnmodifiableHashMap.this.containsKey(o2);
                }

                @Override
                public int size() {
                    return UnmodifiableHashMap.this.size();
                }
            };
        }
        Set<K> set = this.keySet;
        if (set == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(17);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                @NotNull
                public Iterator<V> iterator() {
                    return new MyIterator<V>(){

                        @Override
                        V fieldElement(int offset) {
                            return offset == 0 ? UnmodifiableHashMap.this.v1 : (offset == 1 ? UnmodifiableHashMap.this.v2 : UnmodifiableHashMap.this.v3);
                        }

                        @Override
                        V tableElement(int offset) {
                            return UnmodifiableHashMap.this.data[offset + 1];
                        }
                    };
                }

                @Override
                public void forEach(Consumer<? super V> action2) {
                    if (UnmodifiableHashMap.this.k1 != null) {
                        if (UnmodifiableHashMap.this.k2 != null) {
                            if (UnmodifiableHashMap.this.k3 != null) {
                                action2.accept(UnmodifiableHashMap.this.v3);
                            }
                            action2.accept(UnmodifiableHashMap.this.v2);
                        }
                        action2.accept(UnmodifiableHashMap.this.v1);
                    }
                    for (int i2 = 0; i2 < UnmodifiableHashMap.this.data.length; i2 += 2) {
                        Object key = UnmodifiableHashMap.this.data[i2];
                        if (key == null) continue;
                        Object v2 = UnmodifiableHashMap.this.data[i2 + 1];
                        action2.accept(v2);
                    }
                }

                @Override
                public boolean contains(Object o2) {
                    return UnmodifiableHashMap.this.containsValue(o2);
                }

                @Override
                public int size() {
                    return UnmodifiableHashMap.this.size();
                }
            };
        }
        Collection<V> collection = this.values;
        if (collection == null) {
            UnmodifiableHashMap.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            @NotNull
            public Iterator<Map.Entry<K, V>> iterator() {
                return new MyIterator<Map.Entry<K, V>>(){

                    @Override
                    Map.Entry<K, V> fieldElement(int offset) {
                        return offset == 0 ? new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.k1, UnmodifiableHashMap.this.v1) : (offset == 1 ? new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.k2, UnmodifiableHashMap.this.v2) : new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.k3, UnmodifiableHashMap.this.v3));
                    }

                    @Override
                    Map.Entry<K, V> tableElement(int offset) {
                        return new AbstractMap.SimpleImmutableEntry<Object, Object>(UnmodifiableHashMap.this.data[offset], UnmodifiableHashMap.this.data[offset + 1]);
                    }
                };
            }

            @Override
            public int size() {
                return UnmodifiableHashMap.this.size();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/UnmodifiableHashMap";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 2: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "empty";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/UnmodifiableHashMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "without";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "with";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "withAll";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "empty";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromMap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "without";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "with";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "withAll";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFastutilHashingStrategy";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private abstract class MyIterator<E>
    implements Iterator<E> {
        int pos;

        MyIterator() {
            if (UnmodifiableHashMap.this.k1 == null) {
                this.pos = -1;
                this.advance();
            } else {
                this.pos = UnmodifiableHashMap.this.k2 == null ? -1 : (UnmodifiableHashMap.this.k3 == null ? -2 : -3);
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos < UnmodifiableHashMap.this.data.length;
        }

        private void advance() {
            this.pos = this.pos < 0 ? ++this.pos : (this.pos += 2);
            if (this.pos >= 0) {
                while (this.pos < UnmodifiableHashMap.this.data.length && UnmodifiableHashMap.this.data[this.pos] == null) {
                    ++this.pos;
                }
            }
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.pos < 0) {
                int offset = ~this.pos;
                this.advance();
                return this.fieldElement(offset);
            }
            int offset = this.pos;
            this.advance();
            return this.tableElement(offset);
        }

        abstract E fieldElement(int var1);

        abstract E tableElement(int var1);
    }
}

