/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.diff;

import com.intellij.util.diff.DiffConfig;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.BitSet;

class MyersLCS {
    private final int[] myFirst;
    private final int[] mySecond;
    private final int myStart1;
    private final int myStart2;
    private final int myCount1;
    private final int myCount2;
    private final BitSet myChanges1;
    private final BitSet myChanges2;
    private final int[] VForward;
    private final int[] VBackward;

    MyersLCS(int[] first2, int[] second2) {
        this(first2, second2, 0, first2.length, 0, second2.length, new BitSet(first2.length), new BitSet(second2.length));
    }

    MyersLCS(int[] first2, int[] second2, int start1, int count1, int start2, int count2, BitSet changes1, BitSet changes2) {
        this.myFirst = first2;
        this.mySecond = second2;
        this.myStart1 = start1;
        this.myStart2 = start2;
        this.myCount1 = count1;
        this.myCount2 = count2;
        this.myChanges1 = changes1;
        this.myChanges2 = changes2;
        this.myChanges1.set(this.myStart1, this.myStart1 + this.myCount1);
        this.myChanges2.set(this.myStart2, this.myStart2 + this.myCount2);
        int totalSequenceLength = this.myCount1 + this.myCount2;
        this.VForward = new int[totalSequenceLength + 1];
        this.VBackward = new int[totalSequenceLength + 1];
    }

    public void executeLinear() {
        try {
            int threshold = 20000 + 10 * (int)Math.sqrt(this.myCount1 + this.myCount2);
            this.execute(threshold, false);
        }
        catch (FilesTooBigForDiffException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public void execute() {
        try {
            this.execute(this.myCount1 + this.myCount2, false);
        }
        catch (FilesTooBigForDiffException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public void executeWithThreshold() throws FilesTooBigForDiffException {
        int threshold = Math.max(20000 + 10 * (int)Math.sqrt(this.myCount1 + this.myCount2), DiffConfig.DELTA_THRESHOLD_SIZE);
        this.execute(threshold, true);
    }

    private void execute(int threshold, boolean throwException) throws FilesTooBigForDiffException {
        if (this.myCount1 == 0 || this.myCount2 == 0) {
            return;
        }
        this.execute(0, this.myCount1, 0, this.myCount2, Math.min(threshold, this.myCount1 + this.myCount2), throwException);
    }

    private void execute(int oldStart, int oldEnd, int newStart, int newEnd, int differenceEstimate, boolean throwException) throws FilesTooBigForDiffException {
        assert (oldStart <= oldEnd && newStart <= newEnd);
        if (oldStart < oldEnd && newStart < newEnd) {
            int oldLength = oldEnd - oldStart;
            int newLength = newEnd - newStart;
            this.VForward[newLength + 1] = 0;
            this.VBackward[newLength + 1] = 0;
            int halfD = (differenceEstimate + 1) / 2;
            int td = -1;
            int kk = -1;
            int xx = -1;
            block0: for (int d2 = 0; d2 <= halfD; ++d2) {
                int y2;
                int x2;
                int k2;
                int L2 = newLength + Math.max(-d2, -newLength + ((d2 ^ newLength) & 1));
                int R2 = newLength + Math.min(d2, oldLength - ((d2 ^ oldLength) & 1));
                for (k2 = L2; k2 <= R2; k2 += 2) {
                    x2 = k2 == L2 || k2 != R2 && this.VForward[k2 - 1] < this.VForward[k2 + 1] ? this.VForward[k2 + 1] : this.VForward[k2 - 1] + 1;
                    y2 = x2 - k2 + newLength;
                    x2 += this.commonSubsequenceLengthForward(oldStart + x2, newStart + y2, Math.min(oldEnd - oldStart - x2, newEnd - newStart - y2));
                    this.VForward[k2] = x2;
                }
                if ((oldLength - newLength) % 2 != 0) {
                    for (k2 = L2; k2 <= R2; k2 += 2) {
                        if (oldLength - (d2 - 1) > k2 || k2 > oldLength + (d2 - 1) || this.VForward[k2] + this.VBackward[newLength + oldLength - k2] < oldLength) continue;
                        xx = this.VForward[k2];
                        kk = k2;
                        td = 2 * d2 - 1;
                        break block0;
                    }
                }
                for (k2 = L2; k2 <= R2; k2 += 2) {
                    x2 = k2 == L2 || k2 != R2 && this.VBackward[k2 - 1] < this.VBackward[k2 + 1] ? this.VBackward[k2 + 1] : this.VBackward[k2 - 1] + 1;
                    y2 = x2 - k2 + newLength;
                    x2 += this.commonSubsequenceLengthBackward(oldEnd - 1 - x2, newEnd - 1 - y2, Math.min(oldEnd - oldStart - x2, newEnd - newStart - y2));
                    this.VBackward[k2] = x2;
                }
                if ((oldLength - newLength) % 2 != 0) continue;
                for (k2 = L2; k2 <= R2; k2 += 2) {
                    if (oldLength - d2 > k2 || k2 > oldLength + d2 || this.VForward[oldLength + newLength - k2] + this.VBackward[k2] < oldLength) continue;
                    xx = oldLength - this.VBackward[k2];
                    kk = oldLength + newLength - k2;
                    td = 2 * d2;
                    break block0;
                }
            }
            if (td > 1) {
                int yy = xx - kk + newLength;
                int oldDiff = (td + 1) / 2;
                if (0 < xx && 0 < yy) {
                    this.execute(oldStart, oldStart + xx, newStart, newStart + yy, oldDiff, throwException);
                }
                if (oldStart + xx < oldEnd && newStart + yy < newEnd) {
                    this.execute(oldStart + xx, oldEnd, newStart + yy, newEnd, td - oldDiff, throwException);
                }
            } else if (td >= 0) {
                int x3 = oldStart;
                int y3 = newStart;
                while (x3 < oldEnd && y3 < newEnd) {
                    int commonLength = this.commonSubsequenceLengthForward(x3, y3, Math.min(oldEnd - x3, newEnd - y3));
                    if (commonLength > 0) {
                        this.addUnchanged(x3, y3, commonLength);
                        x3 += commonLength;
                        y3 += commonLength;
                        continue;
                    }
                    if (oldEnd - oldStart > newEnd - newStart) {
                        ++x3;
                        continue;
                    }
                    ++y3;
                }
            } else if (throwException) {
                throw new FilesTooBigForDiffException();
            }
        }
    }

    private void addUnchanged(int start1, int start2, int count2) {
        this.myChanges1.set(this.myStart1 + start1, this.myStart1 + start1 + count2, false);
        this.myChanges2.set(this.myStart2 + start2, this.myStart2 + start2 + count2, false);
    }

    private int commonSubsequenceLengthForward(int oldIndex, int newIndex, int maxLength) {
        int x2 = oldIndex;
        int y2 = newIndex;
        maxLength = Math.min(maxLength, Math.min(this.myCount1 - oldIndex, this.myCount2 - newIndex));
        while (x2 - oldIndex < maxLength && this.myFirst[this.myStart1 + x2] == this.mySecond[this.myStart2 + y2]) {
            ++x2;
            ++y2;
        }
        return x2 - oldIndex;
    }

    private int commonSubsequenceLengthBackward(int oldIndex, int newIndex, int maxLength) {
        int x2 = oldIndex;
        int y2 = newIndex;
        maxLength = Math.min(maxLength, Math.min(oldIndex, newIndex) + 1);
        while (oldIndex - x2 < maxLength && this.myFirst[this.myStart1 + x2] == this.mySecond[this.myStart2 + y2]) {
            --x2;
            --y2;
        }
        return oldIndex - x2;
    }

    public BitSet[] getChanges() {
        return new BitSet[]{this.myChanges1, this.myChanges2};
    }
}

