/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fmap;

import com.intellij.util.fmap.FMap;
import com.intellij.util.fmap.MapBackedFMap;
import com.intellij.util.fmap.TwoKeysFMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ArrayBackedFMap<K, V>
implements FMap<K, V> {
    static final int ARRAY_THRESHOLD = 8;
    @NotNull
    private final @NotNull Object @NotNull [] myData;

    ArrayBackedFMap(Object ... data) {
        if (data == null) {
            ArrayBackedFMap.$$$reportNull$$$0(0);
        }
        assert (6 <= data.length);
        assert (data.length <= 16);
        this.myData = data;
    }

    ArrayBackedFMap(@NotNull Map<? extends K, ? extends V> map2) {
        if (map2 == null) {
            ArrayBackedFMap.$$$reportNull$$$0(1);
        }
        assert (map2.size() <= 8);
        Object[] data = new Object[map2.size() * 2];
        int i2 = 0;
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            data[i2++] = entry.getKey();
            data[i2++] = entry.getValue();
        }
        assert (i2 == data.length);
        this.myData = data;
    }

    @Override
    @NotNull
    public FMap<K, V> plus(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(2);
        }
        if (value == null) {
            ArrayBackedFMap.$$$reportNull$$$0(3);
        }
        for (int i2 = 0; i2 < this.myData.length; i2 += 2) {
            if (!this.asKey(i2).equals(key)) continue;
            if (this.asValue(i2 + 1).equals(value)) {
                ArrayBackedFMap arrayBackedFMap = this;
                if (arrayBackedFMap == null) {
                    ArrayBackedFMap.$$$reportNull$$$0(4);
                }
                return arrayBackedFMap;
            }
            Object[] newData = (Object[])this.myData.clone();
            newData[i2 + 1] = value;
            return new ArrayBackedFMap<K, V>(newData);
        }
        if (this.size() < 8) {
            int length = this.myData.length;
            Object[] newData = Arrays.copyOf(this.myData, length + 2);
            newData[length] = key;
            newData[length + 1] = value;
            return new ArrayBackedFMap<K, V>(newData);
        }
        Map<K, V> map2 = this.toMapInner();
        map2.put(key, value);
        return new MapBackedFMap<K, V>(map2);
    }

    @Override
    @NotNull
    public FMap<K, V> minus(@NotNull K key) {
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(5);
        }
        for (int i2 = 0; i2 < this.myData.length; i2 += 2) {
            if (!this.asKey(i2).equals(key)) continue;
            if (this.size() == 3) {
                if (i2 == 0) {
                    return new TwoKeysFMap<K, V>(this.asKey(2), this.asValue(3), this.asKey(4), this.asValue(5));
                }
                if (i2 == 2) {
                    return new TwoKeysFMap<K, V>(this.asKey(0), this.asValue(1), this.asKey(4), this.asValue(5));
                }
                assert (i2 == 4);
                return new TwoKeysFMap<K, V>(this.asKey(0), this.asValue(1), this.asKey(2), this.asValue(3));
            }
            Object[] newData = new Object[this.myData.length - 2];
            System.arraycopy(this.myData, 0, newData, 0, i2);
            System.arraycopy(this.myData, i2 + 2, newData, i2, this.myData.length - 2 - i2);
            return new ArrayBackedFMap<K, V>(newData);
        }
        ArrayBackedFMap arrayBackedFMap = this;
        if (arrayBackedFMap == null) {
            ArrayBackedFMap.$$$reportNull$$$0(6);
        }
        return arrayBackedFMap;
    }

    @Override
    @Nullable
    public V get(@NotNull K key) {
        if (key == null) {
            ArrayBackedFMap.$$$reportNull$$$0(7);
        }
        for (int i2 = 0; i2 < this.myData.length; i2 += 2) {
            if (!this.asKey(i2).equals(key)) continue;
            return this.asValue(i2 + 1);
        }
        return null;
    }

    private K asKey(int i2) {
        return (K)this.myData[i2];
    }

    private V asValue(int i2) {
        return (V)this.myData[i2];
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return this.myData.length / 2;
    }

    @Override
    @NotNull
    public Collection<K> keys() {
        ArrayList<K> result2 = new ArrayList<K>(this.size());
        for (int i2 = 0; i2 < this.myData.length; i2 += 2) {
            result2.add(this.asKey(i2));
        }
        ArrayList<K> arrayList = result2;
        if (arrayList == null) {
            ArrayBackedFMap.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Map<K, V> toMap() {
        Map<K, V> map2 = Collections.unmodifiableMap(this.toMapInner());
        if (map2 == null) {
            ArrayBackedFMap.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @NotNull
    private Map<K, V> toMapInner() {
        HashMap<K, V> map2 = new HashMap<K, V>(this.size());
        for (int i2 = 0; i2 < this.myData.length; i2 += 2) {
            map2.put(this.asKey(i2), this.asValue(i2 + 1));
        }
        HashMap<K, V> hashMap = map2;
        if (hashMap == null) {
            ArrayBackedFMap.$$$reportNull$$$0(10);
        }
        return hashMap;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ArrayBackedFMap map2 = (ArrayBackedFMap)o2;
        if (this.size() != map2.size()) {
            return false;
        }
        return this.toMapInner().equals(map2.toMapInner());
    }

    public int hashCode() {
        int keysHash = 0;
        int valuesHash = 0;
        for (int i2 = 0; i2 < this.myData.length; i2 += 2) {
            keysHash ^= this.asKey(i2).hashCode();
            valuesHash ^= this.asValue(i2 + 1).hashCode();
        }
        return keysHash + 31 * valuesHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        for (int i2 = 0; i2 < this.myData.length; i2 += 2) {
            sb.append("  ").append(this.asKey(i2)).append(": ").append(this.asValue(i2 + 1)).append(",\n");
        }
        sb.append("]");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/fmap/ArrayBackedFMap";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/fmap/ArrayBackedFMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "plus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "minus";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toMapInner";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "plus";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "minus";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

