/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.containers;

import com.intellij.openapi.util.ThreadLocalCachedIntArray;
import com.intellij.util.indexing.containers.IntIdsIterator;

public final class SortedFileIdSetIterator
implements IntIdsIterator {
    private final int[] myBits;
    private final int myBitsLength;
    private final int myOffset;
    private int myPosition;
    private final int mySize;
    private static final ThreadLocalCachedIntArray ourSpareBuffer = new ThreadLocalCachedIntArray();
    private static final int INT_BITS_SHIFT = 5;

    private SortedFileIdSetIterator(int[] bits, int bitsLength, int offset, int size) {
        this.myBits = bits;
        this.myBitsLength = bitsLength;
        this.myOffset = offset;
        this.myPosition = SortedFileIdSetIterator.nextSetBit(0, this.myBits, this.myBitsLength);
        this.mySize = size;
    }

    @Override
    public boolean hasNext() {
        return this.myPosition != -1;
    }

    @Override
    public int next() {
        int next = this.myPosition + this.myOffset;
        this.myPosition = SortedFileIdSetIterator.nextSetBit(this.myPosition + 1, this.myBits, this.myBitsLength);
        return next;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public boolean hasAscendingOrder() {
        return true;
    }

    @Override
    public IntIdsIterator createCopyInInitialState() {
        return new SortedFileIdSetIterator(this.myBits, this.myBitsLength, this.myOffset, this.mySize);
    }

    public static IntIdsIterator getTransientIterator(IntIdsIterator intIterator) {
        IntIdsIterator intIteratorCloned = intIterator.createCopyInInitialState();
        int max = 0;
        int min2 = Integer.MAX_VALUE;
        while (intIterator.hasNext()) {
            int nextInt = intIterator.next();
            max = Math.max(max, nextInt);
            min2 = Math.min(min2, nextInt);
        }
        assert (min2 > 0);
        int offset = min2 >> 5 << 5;
        int bitsLength = (max - offset >> 5) + 1;
        int[] bits = ourSpareBuffer.getBuffer(bitsLength);
        for (int i2 = 0; i2 < bitsLength; ++i2) {
            bits[i2] = 0;
        }
        intIterator = intIteratorCloned;
        int size = 0;
        while (intIterator.hasNext()) {
            int mask;
            int id2 = intIterator.next() - offset;
            if ((bits[id2 >> 5] & (mask = 1 << id2)) != 0) continue;
            int n2 = id2 >> 5;
            bits[n2] = bits[n2] | mask;
            ++size;
        }
        return new SortedFileIdSetIterator(bits, bitsLength, offset, size);
    }

    private static int nextSetBit(int bitIndex, int[] bits, int bitsLength) {
        int wordIndex = bitIndex >> 5;
        if (wordIndex >= bitsLength) {
            return -1;
        }
        int word = bits[wordIndex] & -1 << bitIndex;
        while (word == 0) {
            if (++wordIndex == bitsLength) {
                return -1;
            }
            word = bits[wordIndex];
        }
        return (wordIndex << 5) + Long.numberOfTrailingZeros(word);
    }
}

