/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.MapIndexStorageCache;
import com.intellij.util.indexing.impl.MapIndexStorageCacheProvider;
import com.intellij.util.indexing.impl.MapIndexStoragePassThroughCache;
import com.intellij.util.indexing.impl.MapIndexStorageSlruCache;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jj\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u0002H\b0\u0006\"\u0004\b\u0000\u0010\u0007\"\u0004\b\u0001\u0010\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b0\n2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u0002H\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u000b0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/impl/MapIndexStorageCacheSlruProvider;", "Lcom/intellij/util/indexing/impl/MapIndexStorageCacheProvider;", "()V", "USE_SLRU", "", "createCache", "Lcom/intellij/util/indexing/impl/MapIndexStorageCache;", "Key", "Value", "keyReader", "Ljava/util/function/Function;", "Lcom/intellij/util/indexing/impl/ChangeTrackingValueContainer;", "evictionListener", "Ljava/util/function/BiConsumer;", "hashingStrategy", "Lcom/intellij/util/containers/hash/EqualityPolicy;", "cacheSize", "", "intellij.platform.util"})
@ApiStatus.Internal
public final class MapIndexStorageCacheSlruProvider
implements MapIndexStorageCacheProvider {
    @NotNull
    public static final MapIndexStorageCacheSlruProvider INSTANCE = new MapIndexStorageCacheSlruProvider();
    private static final boolean USE_SLRU = SystemProperties.getBooleanProperty("idea.use.slru.for.file.based.index", true);

    private MapIndexStorageCacheSlruProvider() {
    }

    @Override
    @NotNull
    public <Key, Value> MapIndexStorageCache<Key, Value> createCache(@NotNull Function<Key, ChangeTrackingValueContainer<Value>> keyReader, @NotNull BiConsumer<Key, ChangeTrackingValueContainer<Value>> evictionListener, @NotNull EqualityPolicy<Key> hashingStrategy2, int cacheSize) {
        Intrinsics.checkNotNullParameter(keyReader, "keyReader");
        Intrinsics.checkNotNullParameter(evictionListener, "evictionListener");
        Intrinsics.checkNotNullParameter(hashingStrategy2, "hashingStrategy");
        return USE_SLRU ? (MapIndexStorageCache)new MapIndexStorageSlruCache<Key, Value>(keyReader, evictionListener, hashingStrategy2, cacheSize) : (MapIndexStorageCache)new MapIndexStoragePassThroughCache<Key, Value>(keyReader, evictionListener, hashingStrategy2, cacheSize);
    }
}

