/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.PosixFilePermissionsUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.Enumeration;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Decompressor {
    @Nullable
    private Predicate<? super Entry> myFilter = null;
    @Nullable
    private List<String> myPathPrefix = null;
    private boolean myOverwrite = true;
    private EscapingSymlinkPolicy myEscapingSymlinkPolicy = EscapingSymlinkPolicy.ALLOW;
    private BiConsumer<? super Entry, ? super Path> myPostProcessor;

    public Decompressor filter(@Nullable Predicate<? super String> filter2) {
        this.myFilter = filter2 != null ? e2 -> filter2.test(e2.type == Entry.Type.DIR ? e2.name + '/' : e2.name) : null;
        return this;
    }

    public Decompressor entryFilter(@Nullable Predicate<? super Entry> filter2) {
        this.myFilter = filter2;
        return this;
    }

    public Decompressor overwrite(boolean overwrite) {
        this.myOverwrite = overwrite;
        return this;
    }

    public Decompressor escapingSymlinkPolicy(EscapingSymlinkPolicy policy) {
        this.myEscapingSymlinkPolicy = policy;
        return this;
    }

    public Decompressor postProcessor(@Nullable Consumer<? super Path> consumer2) {
        this.myPostProcessor = consumer2 != null ? (entry, path) -> consumer2.accept((Path)path) : null;
        return this;
    }

    public Decompressor postProcessor(@Nullable BiConsumer<? super Entry, ? super Path> consumer2) {
        this.myPostProcessor = consumer2;
        return this;
    }

    public Decompressor removePrefixPath(@Nullable String prefix) throws IOException {
        this.myPathPrefix = prefix != null ? Decompressor.normalizePathAndSplit(prefix) : null;
        return this;
    }

    public final void extract(@NotNull File outputDir) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(0);
        }
        this.extract(outputDir.toPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void extract(@NotNull Path outputDir) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(1);
        }
        this.openStream();
        try {
            Entry entry;
            while ((entry = this.nextEntry()) != null) {
                if (this.myFilter != null && !this.myFilter.test(entry) || this.myPathPrefix != null && (entry = Decompressor.mapPathPrefix(entry, this.myPathPrefix)) == null) continue;
                Path outputFile = Decompressor.entryFile(outputDir, entry.name);
                switch (entry.type) {
                    case DIR: {
                        NioFiles.createDirectories(outputFile);
                        break;
                    }
                    case FILE: {
                        if (!this.myOverwrite && Files.exists(outputFile, new LinkOption[0])) break;
                        InputStream inputStream = this.openEntryStream(entry);
                        try {
                            NioFiles.createDirectories(outputFile.getParent());
                            try (OutputStream outputStream = Files.newOutputStream(outputFile, new OpenOption[0]);){
                                StreamUtil.copy(inputStream, outputStream);
                            }
                            if (entry.mode == 0) break;
                            Decompressor.setAttributes(entry.mode, outputFile);
                            break;
                        }
                        finally {
                            this.closeEntryStream(inputStream);
                        }
                    }
                    case SYMLINK: {
                        if (entry.linkTarget == null || entry.linkTarget.isEmpty()) {
                            throw new IOException("Invalid symlink entry: " + entry.name + " (empty target)");
                        }
                        String target = entry.linkTarget;
                        switch (this.myEscapingSymlinkPolicy) {
                            case DISALLOW: {
                                Decompressor.verifySymlinkTarget(entry.name, entry.linkTarget, outputDir, outputFile);
                                break;
                            }
                            case RELATIVIZE_ABSOLUTE: {
                                if (!OSAgnosticPathUtil.isAbsolute(target)) break;
                                target = FileUtil.join(outputDir.toString(), entry.linkTarget.substring(1));
                            }
                        }
                        if (!this.myOverwrite && Files.exists(outputFile, LinkOption.NOFOLLOW_LINKS)) break;
                        try {
                            Path outputTarget = Paths.get(target, new String[0]);
                            NioFiles.createDirectories(outputFile.getParent());
                            Files.deleteIfExists(outputFile);
                            Files.createSymbolicLink(outputFile, outputTarget, new FileAttribute[0]);
                            break;
                        }
                        catch (InvalidPathException e2) {
                            throw new IOException("Invalid symlink entry: " + entry.name + " -> " + target, e2);
                        }
                    }
                }
                if (this.myPostProcessor == null) continue;
                this.myPostProcessor.accept(entry, outputFile);
            }
        }
        finally {
            this.closeStream();
        }
    }

    private static void verifySymlinkTarget(String entryName, String linkTarget, Path outputDir, Path outputFile) throws IOException {
        try {
            Path outputTarget = Paths.get(linkTarget, new String[0]);
            if (outputTarget.isAbsolute()) {
                throw new IOException("Invalid symlink (absolute path): " + entryName + " -> " + linkTarget);
            }
            Path linkTargetNormalized = outputFile.getParent().resolve(outputTarget).normalize();
            if (!linkTargetNormalized.startsWith(outputDir.normalize())) {
                throw new IOException("Invalid symlink (points outside of output directory): " + entryName + " -> " + linkTarget);
            }
        }
        catch (InvalidPathException e2) {
            throw new IOException("Failed to verify symlink entry scope: " + entryName + " -> " + linkTarget, e2);
        }
    }

    @Nullable
    private static Entry mapPathPrefix(Entry e2, List<String> prefix) throws IOException {
        List<String> ourPathSplit = Decompressor.normalizePathAndSplit(e2.name);
        if (prefix.size() >= ourPathSplit.size() || !ourPathSplit.subList(0, prefix.size()).equals(prefix)) {
            return null;
        }
        String newName = String.join((CharSequence)"/", ourPathSplit.subList(prefix.size(), ourPathSplit.size()));
        return new Entry(newName, e2.type, e2.mode, e2.linkTarget, e2.size);
    }

    private static List<String> normalizePathAndSplit(String path) throws IOException {
        Decompressor.ensureValidPath(path);
        String canonicalPath = FileUtilRt.toCanonicalPath(path, '/', true);
        return FileUtilRt.splitPath(StringUtil.trimLeading(canonicalPath, '/'), '/');
    }

    private static void setAttributes(int mode, Path outputFile) throws IOException {
        if (SystemInfo.isWindows) {
            DosFileAttributeView attrs = Files.getFileAttributeView(outputFile, DosFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                if ((mode & 1) != 0) {
                    attrs.setReadOnly(true);
                }
                if ((mode & 2) != 0) {
                    attrs.setHidden(true);
                }
            }
        } else {
            PosixFileAttributeView attrs = Files.getFileAttributeView(outputFile, PosixFileAttributeView.class, new LinkOption[0]);
            if (attrs != null) {
                attrs.setPermissions(PosixFilePermissionsUtil.fromUnixMode(mode));
            }
        }
    }

    protected Decompressor() {
    }

    protected abstract void openStream() throws IOException;

    @Nullable
    protected abstract Entry nextEntry() throws IOException;

    protected abstract InputStream openEntryStream(Entry var1) throws IOException;

    protected abstract void closeEntryStream(InputStream var1) throws IOException;

    protected abstract void closeStream() throws IOException;

    private static void ensureValidPath(String entryName) throws IOException {
        if (entryName.contains("..") && ArrayUtil.contains("..", entryName.split("[/\\\\]"))) {
            throw new IOException("Invalid entry name: " + entryName);
        }
    }

    @NotNull
    public static Path entryFile(@NotNull Path outputDir, @NotNull String entryName) throws IOException {
        if (outputDir == null) {
            Decompressor.$$$reportNull$$$0(2);
        }
        if (entryName == null) {
            Decompressor.$$$reportNull$$$0(3);
        }
        Decompressor.ensureValidPath(entryName);
        Path path = outputDir.resolve(StringUtil.trimLeading(entryName, '/'));
        if (path == null) {
            Decompressor.$$$reportNull$$$0(4);
        }
        return path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/Decompressor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/Decompressor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "entryFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "entryFile";
                break;
            }
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum EscapingSymlinkPolicy {
        ALLOW,
        DISALLOW,
        RELATIVIZE_ABSOLUTE;

    }

    public static final class Entry {
        public static final int DOS_READ_ONLY = 1;
        public static final int DOS_HIDDEN = 2;
        public final String name;
        public final Type type;
        public final int mode;
        public final long size;
        @Nullable
        public final String linkTarget;

        Entry(String name2, boolean isDirectory, long size) {
            this(name2, isDirectory ? Type.DIR : Type.FILE, 0, null, size);
        }

        Entry(String name2, Type type, int mode, @Nullable String linkTarget, long size) {
            int s2;
            name2 = name2.trim().replace('\\', '/');
            int e2 = name2.length() - 1;
            for (s2 = 0; s2 < e2 && name2.charAt(s2) == '/'; ++s2) {
            }
            while (e2 >= s2 && name2.charAt(e2) == '/') {
                --e2;
            }
            this.name = name2.substring(s2, e2 + 1);
            this.type = type;
            this.mode = mode;
            this.linkTarget = linkTarget;
            this.size = size;
        }

        public static enum Type {
            FILE,
            DIR,
            SYMLINK;

        }
    }

    public static final class Zip
    extends Decompressor {
        private final Path mySource;
        private java.util.zip.ZipFile myZip;
        private Enumeration<? extends ZipEntry> myEntries;
        private ZipEntry myEntry;

        public Zip(@NotNull Path file2) {
            if (file2 == null) {
                Zip.$$$reportNull$$$0(0);
            }
            this.mySource = file2;
        }

        public Zip(@NotNull File file2) {
            if (file2 == null) {
                Zip.$$$reportNull$$$0(1);
            }
            this.mySource = file2.toPath();
        }

        @NotNull
        public Decompressor withZipExtensions() {
            return new ExtZip(this.mySource);
        }

        @Override
        protected void openStream() throws IOException {
            this.myZip = new java.util.zip.ZipFile(this.mySource.toFile());
            this.myEntries = this.myZip.entries();
        }

        @Override
        protected Entry nextEntry() {
            this.myEntry = this.myEntries.hasMoreElements() ? this.myEntries.nextElement() : null;
            return this.myEntry == null ? null : new Entry(this.myEntry.getName(), this.myEntry.isDirectory(), this.myEntry.getSize());
        }

        @Override
        protected InputStream openEntryStream(Entry entry) throws IOException {
            return this.myZip.getInputStream(this.myEntry);
        }

        @Override
        protected void closeEntryStream(InputStream stream) throws IOException {
            stream.close();
        }

        @Override
        protected void closeStream() throws IOException {
            this.myZip.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/Decompressor$Zip", "<init>"));
        }

        private static final class ExtZip
        extends Decompressor {
            private final Path mySource;
            private ZipFile myZip;
            private Enumeration<? extends ZipArchiveEntry> myEntries;
            private ZipArchiveEntry myEntry;

            ExtZip(Path file2) {
                this.mySource = file2;
            }

            @Override
            protected void openStream() throws IOException {
                this.myZip = new ZipFile(Files.newByteChannel(this.mySource, new OpenOption[0]));
                this.myEntries = this.myZip.getEntries();
            }

            @Override
            protected Entry nextEntry() throws IOException {
                ZipArchiveEntry zipArchiveEntry = this.myEntry = this.myEntries.hasMoreElements() ? this.myEntries.nextElement() : null;
                if (this.myEntry == null) {
                    return null;
                }
                int platform = this.myEntry.getPlatform();
                if (SystemInfo.isWindows) {
                    if (platform == 3) {
                        return new Entry(this.myEntry.getName(), ExtZip.type(this.myEntry), 0, this.myZip.getUnixSymlink(this.myEntry), this.myEntry.getSize());
                    }
                    if (platform == 0) {
                        return new Entry(this.myEntry.getName(), ExtZip.type(this.myEntry), (int)this.myEntry.getExternalAttributes(), null, this.myEntry.getSize());
                    }
                } else {
                    if (platform == 3) {
                        return new Entry(this.myEntry.getName(), ExtZip.type(this.myEntry), this.myEntry.getUnixMode(), this.myZip.getUnixSymlink(this.myEntry), this.myEntry.getSize());
                    }
                    if (platform == 0) {
                        long attributes = this.myEntry.getExternalAttributes();
                        int unixMode = (attributes & 1L) != 0L ? 292 : 420;
                        return new Entry(this.myEntry.getName(), ExtZip.type(this.myEntry), unixMode, this.myZip.getUnixSymlink(this.myEntry), this.myEntry.getSize());
                    }
                }
                return new Entry(this.myEntry.getName(), this.myEntry.isDirectory(), this.myEntry.getSize());
            }

            private static Entry.Type type(ZipArchiveEntry e2) {
                return e2.isUnixSymlink() ? Entry.Type.SYMLINK : (e2.isDirectory() ? Entry.Type.DIR : Entry.Type.FILE);
            }

            @Override
            protected InputStream openEntryStream(Entry entry) throws IOException {
                return this.myZip.getInputStream(this.myEntry);
            }

            @Override
            protected void closeEntryStream(InputStream stream) throws IOException {
                stream.close();
            }

            @Override
            protected void closeStream() throws IOException {
                this.myZip.close();
            }
        }
    }

    public static final class Tar
    extends Decompressor {
        private final Object mySource;
        private TarArchiveInputStream myStream;

        public Tar(@NotNull Path file2) {
            if (file2 == null) {
                Tar.$$$reportNull$$$0(0);
            }
            this.mySource = file2;
        }

        public Tar(@NotNull File file2) {
            if (file2 == null) {
                Tar.$$$reportNull$$$0(1);
            }
            this.mySource = file2.toPath();
        }

        public Tar(@NotNull InputStream stream) {
            if (stream == null) {
                Tar.$$$reportNull$$$0(2);
            }
            this.mySource = stream;
        }

        @Override
        protected void openStream() throws IOException {
            InputStream input2;
            block2: {
                input2 = new BufferedInputStream(this.mySource instanceof Path ? Files.newInputStream((Path)this.mySource, new OpenOption[0]) : (InputStream)this.mySource);
                try {
                    input2 = new CompressorStreamFactory().createCompressorInputStream(input2);
                }
                catch (CompressorException e2) {
                    Throwable cause = e2.getCause();
                    if (!(cause instanceof IOException)) break block2;
                    throw (IOException)cause;
                }
            }
            this.myStream = new TarArchiveInputStream(input2);
        }

        @Override
        protected Entry nextEntry() throws IOException {
            TarArchiveEntry te;
            while (!((te = this.myStream.getNextTarEntry()) == null || te.isFile() && !te.isLink() || te.isDirectory() || te.isSymbolicLink())) {
            }
            if (te == null) {
                return null;
            }
            if (!SystemInfo.isWindows) {
                return new Entry(te.getName(), Tar.type(te), te.getMode(), te.getLinkName(), te.getSize());
            }
            if (te.isSymbolicLink()) {
                return new Entry(te.getName(), Entry.Type.SYMLINK, 0, te.getLinkName(), te.getSize());
            }
            return new Entry(te.getName(), te.isDirectory(), te.getSize());
        }

        private static Entry.Type type(TarArchiveEntry te) {
            return te.isSymbolicLink() ? Entry.Type.SYMLINK : (te.isDirectory() ? Entry.Type.DIR : Entry.Type.FILE);
        }

        @Override
        protected InputStream openEntryStream(Entry entry) {
            return this.myStream;
        }

        @Override
        protected void closeEntryStream(InputStream stream) {
        }

        @Override
        protected void closeStream() throws IOException {
            if (this.mySource instanceof Path) {
                this.myStream.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "stream";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/Decompressor$Tar";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

