/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.MathUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PageCacheUtils;
import com.intellij.util.io.PagedFileStorageWithRWLockedPageContent;
import com.intellij.util.io.pagecache.FilePageCacheStatistics;
import com.intellij.util.io.pagecache.impl.ConfinedIntValue;
import com.intellij.util.io.pagecache.impl.DefaultMemoryManager;
import com.intellij.util.io.pagecache.impl.FrugalQuantileEstimator;
import com.intellij.util.io.pagecache.impl.IMemoryManager;
import com.intellij.util.io.pagecache.impl.PageImpl;
import com.intellij.util.io.pagecache.impl.PagesTable;
import com.intellij.util.io.pagecache.impl.Throttler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FilePageCacheLockFree
implements AutoCloseable {
    private static final Logger LOG = Logger.getInstance(FilePageCacheLockFree.class);
    public static final String DEFAULT_HOUSEKEEPER_THREAD_NAME = "FilePageCache housekeeper";
    private static final int INITIAL_PAGES_TABLE_SIZE = 256;
    private static final int STATE_NOT_STARTED = 0;
    private static final int STATE_WAITING_FIRST_STORAGE_REGISTRATION = 1;
    private static final int STATE_WORKING = 2;
    private static final int STATE_CLOSED = 3;
    public static final int TOKENS_PER_USE = 8;
    public static final int TOKENS_INITIALLY = 16;
    private static final int DEFAULT_PERCENTS_OF_PAGES_TO_PREPARE_FOR_RECLAIM = 10;
    private static final int MAX_PAGES_TO_TRY_RECLAIM_ON_ALLOCATION = 10;
    private final IMemoryManager memoryManager;
    private final Map<Path, PagesTable> pagesPerFile = CollectionFactory.createSmallMemoryFootprintMap();
    private final CyclicIterator<PagesTable> pageTableCyclicIterator = new CyclicIterator();
    private final PagesToReclaim pagesToProbablyReclaim = new PagesToReclaim();
    private final PagesForReclaimCollector pagesForReclaimCollector = new PagesForReclaimCollector(10, 20);
    private final RateController rateController = new RateController();
    private final ConcurrentLinkedQueue<Command> commandsQueue = new ConcurrentLinkedQueue();
    private final Thread housekeeperThread;
    private final Object housekeeperSleepLock = new Object();
    private volatile int state = 0;
    private final FilePageCacheStatistics statistics = new FilePageCacheStatistics();
    private final Throttler releaseMemoryOverflowThrottler = new Throttler(100L, TimeUnit.MILLISECONDS);

    public FilePageCacheLockFree(long cacheCapacityBytes) {
        this(cacheCapacityBytes, cacheCapacityBytes / 10L);
    }

    public FilePageCacheLockFree(long cacheCapacityBytes, long heapCapacityBytes) {
        this(cacheCapacityBytes, heapCapacityBytes, r2 -> new Thread(r2, DEFAULT_HOUSEKEEPER_THREAD_NAME));
    }

    public FilePageCacheLockFree(long cacheCapacityBytes, ThreadFactory maintenanceThreadFactory) {
        this(cacheCapacityBytes, cacheCapacityBytes / 10L, maintenanceThreadFactory);
    }

    public FilePageCacheLockFree(long cacheCapacityBytes, long heapCapacityBytes, ThreadFactory maintenanceThreadFactory) {
        this.memoryManager = new DefaultMemoryManager(cacheCapacityBytes, heapCapacityBytes, this.statistics);
        this.housekeeperThread = maintenanceThreadFactory.newThread(this::cacheMaintenanceLoop);
        this.housekeeperThread.setDaemon(true);
        this.state = 1;
    }

    public long getCacheCapacityBytes() {
        return this.memoryManager.nativeCapacityBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PagesTable registerStorage(@NotNull PagedFileStorageWithRWLockedPageContent storage) throws IOException {
        if (storage == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(0);
        }
        this.checkNotClosed();
        Map<Path, PagesTable> map2 = this.pagesPerFile;
        synchronized (map2) {
            Path absolutePath = storage.getFile().toAbsolutePath();
            if (this.pagesPerFile.containsKey(absolutePath)) {
                throw new IOException("Storage for [" + absolutePath + "] is already registered");
            }
            boolean firstStorageRegistered = this.pagesPerFile.isEmpty();
            PagesTable pages = new PagesTable(256);
            this.pagesPerFile.put(absolutePath, pages);
            if (firstStorageRegistered && this.state == 1) {
                this.housekeeperThread.start();
                this.state = 2;
            }
            return pages;
        }
    }

    Future<?> enqueueStoragePagesClosing(@NotNull PagedFileStorageWithRWLockedPageContent storage, @NotNull CompletableFuture<Object> finish) {
        if (storage == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(1);
        }
        if (finish == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(2);
        }
        this.checkNotClosed();
        PostCloseStorageCleanupCommand task = new PostCloseStorageCleanupCommand(storage, finish);
        this.commandsQueue.add(task);
        return task.onFinish;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterruptedException {
        FilePageCacheLockFree filePageCacheLockFree = this;
        synchronized (filePageCacheLockFree) {
            if (this.state != 3) {
                this.housekeeperThread.interrupt();
                this.housekeeperThread.join();
                this.state = 3;
            }
        }
    }

    public FilePageCacheStatistics getStatistics() {
        this.statistics.nativeBytesCurrentlyUsed(this.memoryManager.nativeBytesUsed());
        this.statistics.heapBytesCurrentlyUsed(this.memoryManager.heapBytesUsed());
        return this.statistics;
    }

    public String dumpContent() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Path, PagesTable> e2 : this.pagesPerFile.entrySet()) {
            Path path = e2.getKey();
            PagesTable pagesTable = e2.getValue();
            AtomicReferenceArray<PageImpl> pages = pagesTable.pages();
            int pagesCount = 0;
            int pageSize = 0;
            for (int i2 = 0; i2 < pages.length(); ++i2) {
                PageImpl page = pages.get(i2);
                if (page == null) continue;
                pageSize = page.pageSize();
                if (page.isTombstone()) continue;
                ++pagesCount;
            }
            sb.append('[').append(path).append("]: pageSize=").append(pageSize).append('\n');
            sb.append("\tpagesTable: ").append(pagesCount).append(" live out of ").append(pages.length()).append('\n');
            sb.append(pagesTable.probeLengthsHistogram()).append('\n');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMaintenanceLoop() {
        while (!Thread.interrupted()) {
            long turnStartedAtNs = System.nanoTime();
            try {
                boolean actuallyDidSomeMaintenance = false;
                if (!this.commandsQueue.isEmpty()) {
                    int reclaimed = this.cleanClosedStoragesAndReclaimPages(1);
                    this.statistics.closedStoragesReclaimed(reclaimed);
                    actuallyDidSomeMaintenance = true;
                }
                int pagesRemainedForReclaim = 0;
                int pagesDroppedFromReclaimQueue = 0;
                Iterator it = this.pagesToProbablyReclaim.pagesToProbablyReclaimQueue.iterator();
                while (it.hasNext()) {
                    PageImpl page = (PageImpl)it.next();
                    if (!this.pagesForReclaimCollector.isGoodForReclaim(page)) {
                        it.remove();
                        ++pagesDroppedFromReclaimQueue;
                        continue;
                    }
                    ++pagesRemainedForReclaim;
                }
                int pagesDemandForecast = this.rateController.predictPagesDemandForNextTurn();
                boolean pageDeficitIsLikely = this.isPageDeficitLikely(pagesRemainedForReclaim, pagesDemandForecast);
                if (pageDeficitIsLikely || this.pagesToProbablyReclaim.isOlderThen(turnStartedAtNs, TimeUnit.MILLISECONDS.toNanos(500L))) {
                    this.refillPagesForReclaim(pagesDemandForecast);
                    int pagesFlushed = this.pagesForReclaimCollector.ensureEnoughCleanPagesToReclaim(0.5);
                    actuallyDidSomeMaintenance = true;
                    pagesRemainedForReclaim = this.pagesForReclaimCollector.totalPagesPreparedToReclaim();
                    pageDeficitIsLikely = this.isPageDeficitLikely(pagesRemainedForReclaim, pagesDemandForecast);
                }
                if (this.memoryManager.hasOverflow()) {
                    boolean executed = this.releaseMemoryOverflowThrottler.runThrottled(turnStartedAtNs, () -> this.releasePagesAllocatedAboveCapacity(10));
                    actuallyDidSomeMaintenance |= executed;
                }
                long timeSpentNs = System.nanoTime() - turnStartedAtNs;
                if (actuallyDidSomeMaintenance) {
                    this.statistics.cacheMaintenanceTurnDone(timeSpentNs);
                } else {
                    this.statistics.cacheMaintenanceTurnSkipped(timeSpentNs);
                }
                if (!pageDeficitIsLikely) {
                    this.pagesForReclaimCollector.collectLessAggressively();
                    Object object = this.housekeeperSleepLock;
                    synchronized (object) {
                        this.housekeeperSleepLock.wait(1L);
                        continue;
                    }
                }
                if (pagesRemainedForReclaim > 0) {
                    Thread.yield();
                    continue;
                }
                this.pagesForReclaimCollector.collectMoreAggressively();
            }
            catch (InterruptedException e2) {
                break;
            }
            catch (Throwable t2) {
                LOG.error("Exception in FilePageCache housekeeper thread (thread continue to run)", t2);
            }
        }
        LOG.info("maintenance loop interrupted -> exiting");
    }

    private boolean isPageDeficitLikely(int pagesRemainedForReclaim, int pagesDemandForecast) {
        boolean memoryBudgetIsAboutToExhaust = this.memoryManager.nativeBytesUsed() > 4L * this.memoryManager.nativeCapacityBytes() / 5L;
        boolean pagesPileIsAboutToExhaust = pagesDemandForecast > pagesRemainedForReclaim;
        return pagesPileIsAboutToExhaust && memoryBudgetIsAboutToExhaust;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refillPagesForReclaim(int pagesToCollect) {
        CyclicIterator<PagesTable> pagesTablesToScan = this.threadSafeCopyOfPagesTables();
        int totalPagesCount = Math.max(this.statistics.totalPagesAllocated() - this.statistics.totalPagesReclaimed(), 0);
        this.pagesForReclaimCollector.startCollectingTurn(pagesToCollect, totalPagesCount);
        try {
            int tablesToScan = pagesTablesToScan.size();
            for (int pageTableNo = 0; pageTableNo < tablesToScan; ++pageTableNo) {
                PagesTable pageTable = pagesTablesToScan.next();
                AtomicReferenceArray<PageImpl> pages = pageTable.pages();
                int pagesAliveInTable = 0;
                int pagesCount = pages.length();
                for (int i2 = 0; i2 < pagesCount; ++i2) {
                    boolean succeed;
                    PageImpl page = pages.get(i2);
                    if (page == null || page.isTombstone()) continue;
                    if (page.isAboutToUnmap() && page.usageCount() == 0 && (succeed = page.tryMoveTowardsPreTombstone(false))) {
                        this.unmapPageAndReclaimBuffer(page);
                        continue;
                    }
                    ++pagesAliveInTable;
                    int tokensOfUsefulness = FilePageCacheLockFree.adjustPageUsefulness(page);
                    page.updateLocalTokensOfUsefulness(tokensOfUsefulness);
                    this.pagesForReclaimCollector.takePageIfGoodForReclaim(page);
                }
                pageTable.shrinkIfNeeded(pagesAliveInTable);
            }
        }
        finally {
            this.pagesForReclaimCollector.finishCollectingTurn();
        }
        this.pagesToProbablyReclaim.refill(this.pagesForReclaimCollector);
    }

    private void releasePagesAllocatedAboveCapacity(int maxPagesToReclaim) {
        int remainsToReclaim = maxPagesToReclaim;
        Iterator<PageImpl> it = this.pagesToProbablyReclaim.iterator();
        while (it.hasNext() && this.memoryManager.hasOverflow()) {
            boolean succeed;
            PageImpl candidate = it.next();
            if (candidate == null) {
                return;
            }
            ByteBuffer pageBuffer = candidate.pageBufferUnchecked();
            if (pageBuffer == null || pageBuffer.isDirect() || !candidate.isUsable() && !candidate.isAboutToUnmap() || candidate.usageCount() != 0 || !(succeed = candidate.tryMoveTowardsPreTombstone(false))) continue;
            it.remove();
            this.unmapPageAndReclaimBuffer(candidate);
            if (--remainsToReclaim != 0) continue;
            return;
        }
    }

    private static int adjustPageUsefulness(@NotNull PageImpl page) {
        int usageCount;
        if (page == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(3);
        }
        if ((usageCount = page.usageCount()) > 0) {
            return page.addTokensOfUsefulness(usageCount * 8);
        }
        return page.decayTokensOfUsefulness(7, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cleanClosedStoragesAndReclaimPages(int maxStoragesToProcess) {
        Command command2;
        int successfullyCleaned = 0;
        for (int i2 = 0; i2 < maxStoragesToProcess && (command2 = this.commandsQueue.poll()) != null; ++i2) {
            if (!(command2 instanceof PostCloseStorageCleanupCommand)) continue;
            PostCloseStorageCleanupCommand closeStorageCommand = (PostCloseStorageCleanupCommand)command2;
            PagedFileStorageWithRWLockedPageContent storage = closeStorageCommand.storageToClose;
            CompletableFuture futureToFinalize = closeStorageCommand.onFinish;
            if (!storage.isClosed()) {
                AssertionError error = new AssertionError((Object)("Code bug: storage " + storage + " must be closed before PostCloseStorageCleanupCommand is queued"));
                futureToFinalize.completeExceptionally((Throwable)((Object)error));
                throw error;
            }
            PagesTable pagesTable = storage.pages();
            boolean somePagesStillInUse = this.tryToReclaimAll(pagesTable);
            if (!somePagesStillInUse) {
                Path file2 = storage.getFile();
                try {
                    PageCacheUtils.CHANNELS_CACHE.closeChannel(file2);
                }
                catch (Throwable t2) {
                    LOG.error("Can't close channel for " + file2, t2);
                    futureToFinalize.completeExceptionally(t2);
                }
                ++successfullyCleaned;
                Map<Path, PagesTable> map2 = this.pagesPerFile;
                synchronized (map2) {
                    Path absolutePath = storage.getFile().toAbsolutePath();
                    PagesTable removed = this.pagesPerFile.remove(absolutePath);
                    assert (removed != null) : "Storage for [" + absolutePath + "] must exists";
                }
                futureToFinalize.complete(null);
                continue;
            }
            this.commandsQueue.offer(command2);
        }
        return successfullyCleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CyclicIterator<PagesTable> threadSafeCopyOfPagesTables() {
        Map<Path, PagesTable> map2 = this.pagesPerFile;
        synchronized (map2) {
            this.pageTableCyclicIterator.update(this.pagesPerFile.values());
            return this.pageTableCyclicIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryToReclaimAll(@NotNull PagesTable pagesTable) {
        if (pagesTable == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(4);
        }
        pagesTable.pagesLock().lock();
        try {
            AtomicReferenceArray<PageImpl> pages = pagesTable.pages();
            boolean somePagesStillInUse = false;
            for (int i2 = 0; i2 < pages.length(); ++i2) {
                PageImpl page = pages.get(i2);
                if (page == null || page.isTombstone()) continue;
                boolean succeed = page.tryMoveTowardsPreTombstone(true);
                if (succeed) {
                    if (page.pageBufferUnchecked() != null) {
                        this.unmapPageAndReclaimBuffer(page);
                    } else {
                        page.entomb();
                    }
                }
                somePagesStillInUse |= !page.isTombstone();
            }
            boolean bl2 = somePagesStillInUse;
            return bl2;
        }
        finally {
            pagesTable.pagesLock().unlock();
        }
    }

    void unmapPageAndReclaimBuffer(@NotNull PageImpl pageToReclaim) {
        if (pageToReclaim == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(5);
        }
        ByteBuffer pageBuffer = FilePageCacheLockFree.entombPageAndGetPageBuffer(pageToReclaim);
        this.reclaimPageBuffer(pageToReclaim.pageSize(), pageBuffer);
    }

    void reclaimPageBuffer(int pageSize, @NotNull ByteBuffer pageBuffer) {
        if (pageBuffer == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(6);
        }
        this.memoryManager.releaseBuffer(pageSize, pageBuffer);
    }

    void waitForHousekeepingTurn(int maxWaitMs) {
        this.pagesToProbablyReclaim.waitForRefill(maxWaitMs);
    }

    @NotNull
    private static ByteBuffer entombPageAndGetPageBuffer(@NotNull PageImpl pageToUnmap) {
        if (pageToUnmap == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(7);
        }
        if (!pageToUnmap.isPreTombstone()) {
            throw new AssertionError((Object)("Bug: page must be PRE_TOMBSTONE: " + pageToUnmap));
        }
        if (pageToUnmap.isDirty()) {
            try {
                pageToUnmap.flush();
            }
            catch (IOException e2) {
                throw new UncheckedIOException("Can't flush page: " + pageToUnmap, e2);
            }
        }
        ByteBuffer pageBuffer = pageToUnmap.detachTombstoneBuffer();
        pageToUnmap.entomb();
        ByteBuffer byteBuffer = pageBuffer;
        if (byteBuffer == null) {
            FilePageCacheLockFree.$$$reportNull$$$0(8);
        }
        return byteBuffer;
    }

    @NotNull
    ByteBuffer allocatePageBuffer(int bufferSize) {
        this.checkNotClosed();
        int attempt = 0;
        while (true) {
            ByteBuffer allocatedBuffer;
            if ((allocatedBuffer = this.memoryManager.tryAllocate(bufferSize, false)) != null) {
                ByteBuffer byteBuffer = allocatedBuffer;
                if (byteBuffer == null) {
                    FilePageCacheLockFree.$$$reportNull$$$0(9);
                }
                return byteBuffer;
            }
            ByteBuffer reclaimedBuffer = this.tryReclaimPageOfSize(bufferSize, 10);
            if (reclaimedBuffer != null) {
                this.statistics.pageReclaimedByHandover(bufferSize, reclaimedBuffer.isDirect());
                ByteBuffer byteBuffer = reclaimedBuffer;
                if (byteBuffer == null) {
                    FilePageCacheLockFree.$$$reportNull$$$0(10);
                }
                return byteBuffer;
            }
            ByteBuffer aboveCapacityBuffer = this.memoryManager.tryAllocate(bufferSize, true);
            if (aboveCapacityBuffer != null) {
                ByteBuffer byteBuffer = aboveCapacityBuffer;
                if (byteBuffer == null) {
                    FilePageCacheLockFree.$$$reportNull$$$0(11);
                }
                return byteBuffer;
            }
            this.statistics.pageAllocationWaited();
            this.wakeupHousekeeper();
            this.pagesToProbablyReclaim.waitForRefill(1);
            ++attempt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeupHousekeeper() {
        Object object = this.housekeeperSleepLock;
        synchronized (object) {
            this.housekeeperSleepLock.notify();
        }
    }

    @Nullable
    private ByteBuffer tryReclaimPageOfSize(int bufferSize, int maxPagesToTry) {
        int dirtyPagesSkipped = 0;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int pagesTried = 0; pagesTried < maxPagesToTry && !this.memoryManager.hasFreeNativeCapacity(bufferSize); ++pagesTried) {
            PageImpl candidateToReclaim = this.pagesToProbablyReclaim.poll();
            if (candidateToReclaim == null) {
                return null;
            }
            if (candidateToReclaim.usageCount() > 0) continue;
            if (candidateToReclaim.isDirty() && dirtyPagesSkipped <= rnd.nextInt(maxPagesToTry)) {
                ++dirtyPagesSkipped;
                this.pagesToProbablyReclaim.pushBack(candidateToReclaim);
                continue;
            }
            boolean succeed = candidateToReclaim.tryMoveTowardsPreTombstone(false);
            if (!succeed) continue;
            ByteBuffer reclaimedBuffer = FilePageCacheLockFree.entombPageAndGetPageBuffer(candidateToReclaim);
            if (bufferSize <= reclaimedBuffer.capacity() && reclaimedBuffer.capacity() <= 2 * bufferSize) {
                reclaimedBuffer.clear().limit(bufferSize);
                return reclaimedBuffer;
            }
            this.reclaimPageBuffer(candidateToReclaim.pageSize(), reclaimedBuffer);
        }
        return null;
    }

    private void checkNotClosed() throws IllegalStateException {
        if (this.state == 3) {
            throw new IllegalStateException("Cache is already closed");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "page";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pagesTable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageToReclaim";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageBuffer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageToUnmap";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/FilePageCacheLockFree";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/FilePageCacheLockFree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "entombPageAndGetPageBuffer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "allocatePageBuffer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerStorage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "enqueueStoragePagesClosing";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustPageUsefulness";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToReclaimAll";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unmapPageAndReclaimBuffer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reclaimPageBuffer";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "entombPageAndGetPageBuffer";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CyclicIterator<T>
    implements Iterator<T> {
        private Collection<T> currentItems;
        @NotNull
        private ArrayDeque<T> processedItems = new ArrayDeque();
        @NotNull
        private ArrayDeque<T> unprocessedItems = new ArrayDeque();

        private CyclicIterator() {
        }

        public void update(@NotNull Collection<T> items) {
            if (items == null) {
                CyclicIterator.$$$reportNull$$$0(0);
            }
            if (this.currentItems != null && this.currentItems.containsAll(items) && this.currentItems.size() == items.size()) {
                return;
            }
            this.currentItems = CollectionFactory.createSmallMemoryFootprintSet(items);
            this.processedItems = new ArrayDeque<T>(ContainerUtil.intersection(this.processedItems, this.currentItems));
            this.unprocessedItems = new ArrayDeque<T>(ContainerUtil.subtract(this.currentItems, this.processedItems));
        }

        @Override
        public boolean hasNext() {
            if (this.currentItems == null) {
                throw new IllegalStateException(".update() must be called first");
            }
            return !this.unprocessedItems.isEmpty() || !this.processedItems.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Nothing to offer: unprocessed=" + this.unprocessedItems + ", processed=" + this.processedItems + ", current=" + this.currentItems);
            }
            if (this.unprocessedItems.isEmpty()) {
                this.unprocessedItems = this.processedItems;
                this.processedItems = new ArrayDeque();
            }
            T item = this.unprocessedItems.poll();
            this.processedItems.add(item);
            return item;
        }

        public int size() {
            return this.currentItems.size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/io/FilePageCacheLockFree$CyclicIterator", "update"));
        }
    }

    private static class PagesToReclaim {
        private volatile ConcurrentLinkedQueue<PageImpl> pagesToProbablyReclaimQueue = new ConcurrentLinkedQueue();
        private final AtomicInteger pagesInQueue = new AtomicInteger(0);
        private final Object refillSignalLock = new Object();
        private long lastRefillAtNs = 0L;

        private PagesToReclaim() {
        }

        public int size() {
            return this.pagesToProbablyReclaimQueue.size();
        }

        public boolean isOlderThen(long nowNs, long thresholdNs) {
            return nowNs - thresholdNs > this.lastRefillAtNs;
        }

        public void refill(@NotNull PagesForReclaimCollector pagesCollector) {
            if (pagesCollector == null) {
                PagesToReclaim.$$$reportNull$$$0(0);
            }
            ConcurrentLinkedQueue<PageImpl> pagesForReclaim = new ConcurrentLinkedQueue<PageImpl>();
            List<PageImpl> forReclaimDirty = pagesCollector.pagesForReclaimDirty();
            List<PageImpl> forReclaimNonDirty = pagesCollector.pagesForReclaimNonDirty();
            pagesForReclaim.addAll(forReclaimDirty);
            pagesForReclaim.addAll(forReclaimNonDirty);
            this.pagesToProbablyReclaimQueue = pagesForReclaim;
            this.pagesInQueue.addAndGet(forReclaimDirty.size() + forReclaimNonDirty.size());
            this.lastRefillAtNs = System.nanoTime();
            this.notifyAboutRefill();
        }

        @Nullable
        public PageImpl poll() {
            PageImpl page = this.pagesToProbablyReclaimQueue.poll();
            if (page != null) {
                this.pagesInQueue.decrementAndGet();
            }
            return page;
        }

        public void pushBack(@NotNull PageImpl page) {
            if (page == null) {
                PagesToReclaim.$$$reportNull$$$0(1);
            }
            this.pagesToProbablyReclaimQueue.offer(page);
            this.pagesInQueue.incrementAndGet();
        }

        public Iterator<PageImpl> iterator() {
            final Iterator<PageImpl> it = this.pagesToProbablyReclaimQueue.iterator();
            return new Iterator<PageImpl>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public PageImpl next() {
                    return (PageImpl)it.next();
                }

                @Override
                public void remove() {
                    it.remove();
                    pagesInQueue.decrementAndGet();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAboutRefill() {
            Object object = this.refillSignalLock;
            synchronized (object) {
                this.refillSignalLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForRefill(int maxWaitMs) {
            Object object = this.refillSignalLock;
            synchronized (object) {
                try {
                    this.refillSignalLock.wait(maxWaitMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public String toString() {
            return "PagesToReclaim[" + this.pagesInQueue + " in queue]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pagesCollector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "page";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/io/FilePageCacheLockFree$PagesToReclaim";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refill";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pushBack";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PagesForReclaimCollector {
        private static final Comparator<PageImpl> BY_USEFULNESS = Comparator.comparing(page -> page.localTokensOfUsefulness());
        private final FrugalQuantileEstimator lowUsefulnessThresholdEstimator;
        private final int minPercentOfPagesToPrepareForReclaim;
        private final int maxPercentOfPagesToPrepareForReclaim;
        @NotNull
        private List<PageImpl> pagesForReclaimNonDirty = Collections.emptyList();
        @NotNull
        private List<PageImpl> pagesForReclaimDirty = Collections.emptyList();
        private int maxPagesToCollect;

        public PagesForReclaimCollector(int minPercentOfPagesToPrepareForReclaim, int maxPercentOfPagesToPrepareForReclaim) {
            if (minPercentOfPagesToPrepareForReclaim > maxPercentOfPagesToPrepareForReclaim) {
                throw new IllegalArgumentException("minPercent(=" + minPercentOfPagesToPrepareForReclaim + ") must be <= maxPercent(=" + maxPercentOfPagesToPrepareForReclaim + ")");
            }
            this.minPercentOfPagesToPrepareForReclaim = minPercentOfPagesToPrepareForReclaim;
            this.maxPercentOfPagesToPrepareForReclaim = maxPercentOfPagesToPrepareForReclaim;
            this.lowUsefulnessThresholdEstimator = new FrugalQuantileEstimator(minPercentOfPagesToPrepareForReclaim, 0.5, 0.0);
        }

        public void startCollectingTurn(int pagesToCollect, int totalPagesCount) {
            if (pagesToCollect <= 0) {
                throw new IllegalArgumentException("pagesToCollect(=" + pagesToCollect + ") must be > 0");
            }
            if (totalPagesCount < 0) {
                throw new IllegalArgumentException("totalPagesCount(=" + totalPagesCount + ") must be >= 0");
            }
            this.maxPagesToCollect = Math.max(pagesToCollect, totalPagesCount * this.lowUsefulnessThresholdEstimator.percentileToEstimate() / 100 + 1);
            int listsSizeEstimation = Math.max(pagesToCollect / 2, 32);
            this.pagesForReclaimDirty = new ArrayList<PageImpl>(listsSizeEstimation);
            this.pagesForReclaimNonDirty = new ArrayList<PageImpl>(listsSizeEstimation);
        }

        public void finishCollectingTurn() {
            this.pagesForReclaimDirty.sort(BY_USEFULNESS);
            this.pagesForReclaimNonDirty.sort(BY_USEFULNESS);
        }

        public List<PageImpl> pagesForReclaimNonDirty() {
            return this.pagesForReclaimNonDirty;
        }

        public List<PageImpl> pagesForReclaimDirty() {
            return this.pagesForReclaimDirty;
        }

        public int totalPagesPreparedToReclaim() {
            return this.pagesForReclaimDirty.size() + this.pagesForReclaimNonDirty.size();
        }

        public void collectMoreAggressively() {
            int currentPercentage = this.lowUsefulnessThresholdEstimator.percentileToEstimate();
            this.lowUsefulnessThresholdEstimator.updateTargetPercentile(MathUtil.clamp(currentPercentage + 1, this.minPercentOfPagesToPrepareForReclaim, this.maxPercentOfPagesToPrepareForReclaim));
        }

        public void collectLessAggressively() {
            int currentPercentage = this.lowUsefulnessThresholdEstimator.percentileToEstimate();
            this.lowUsefulnessThresholdEstimator.updateTargetPercentile(MathUtil.clamp(currentPercentage - 1, this.minPercentOfPagesToPrepareForReclaim, this.maxPercentOfPagesToPrepareForReclaim));
        }

        public int ensureEnoughCleanPagesToReclaim(double fractionOfCleanPagesToAim) {
            int totalPagesToReclaim = this.pagesForReclaimDirty.size() + this.pagesForReclaimNonDirty.size();
            int dirtyPagesTargetCount = (int)((1.0 - fractionOfCleanPagesToAim) * (double)totalPagesToReclaim);
            int pagesToFlush = this.pagesForReclaimDirty.size() - dirtyPagesTargetCount;
            int actuallyFlushed = 0;
            for (int i2 = 0; i2 < pagesToFlush; ++i2) {
                PageImpl page = this.pagesForReclaimDirty.get(i2);
                if (page.isTombstone()) continue;
                try {
                    if (!page.tryFlush()) continue;
                    ++actuallyFlushed;
                    continue;
                }
                catch (IOException e2) {
                    LOG.warn("Can't flush page " + page, e2);
                }
            }
            return actuallyFlushed;
        }

        public boolean hasCollectedEnough() {
            return this.totalPagesPreparedToReclaim() >= this.maxPagesToCollect;
        }

        public boolean takePageIfGoodForReclaim(@NotNull PageImpl page) {
            if (page == null) {
                PagesForReclaimCollector.$$$reportNull$$$0(0);
            }
            int tokensOfUsefulness = page.tokensOfUsefulness();
            double lowUsefulnessThreshold = this.lowUsefulnessThresholdEstimator.updateEstimation(tokensOfUsefulness);
            if (!this.hasCollectedEnough() && this.isGoodForReclaim(page, lowUsefulnessThreshold)) {
                this.addCandidateForReclaim(page);
                return true;
            }
            return false;
        }

        public boolean isGoodForReclaim(@NotNull PageImpl page) {
            if (page == null) {
                PagesForReclaimCollector.$$$reportNull$$$0(1);
            }
            return this.isGoodForReclaim(page, this.lowUsefulnessThresholdEstimator.currentEstimation());
        }

        public boolean isGoodForReclaim(@NotNull PageImpl page, double lowUsefulnessThreshold) {
            if (page == null) {
                PagesForReclaimCollector.$$$reportNull$$$0(2);
            }
            int tokensOfUsefulness = page.tokensOfUsefulness();
            return page.isUsable() && page.usageCount() == 0 && (double)tokensOfUsefulness <= lowUsefulnessThreshold;
        }

        private void addCandidateForReclaim(@NotNull PageImpl page) {
            if (page == null) {
                PagesForReclaimCollector.$$$reportNull$$$0(3);
            }
            if (page.isDirty()) {
                this.pagesForReclaimDirty.add(page);
            } else {
                this.pagesForReclaimNonDirty.add(page);
            }
        }

        public String toString() {
            return "PagesForReclaimCollector[" + this.pagesForReclaimDirty.size() + " dirty/" + this.pagesForReclaimNonDirty.size() + " non-dirty, low usefulness <= " + this.lowUsefulnessThresholdEstimator.currentEstimation() + " (" + this.lowUsefulnessThresholdEstimator.percentileToEstimate() + "%)]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "page";
            objectArray2[1] = "com/intellij/util/io/FilePageCacheLockFree$PagesForReclaimCollector";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "takePageIfGoodForReclaim";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isGoodForReclaim";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCandidateForReclaim";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RateController {
        private long totalPagesAllocatedTurnBefore = 0L;
        private long totalPagesWaitedTurnBefore = 0L;
        private final ConfinedIntValue safetyMarginFactor = new ConfinedIntValue(12, 12, 36);

        private RateController() {
        }

        public int predictPagesDemandForNextTurn() {
            long totalPagesAllocatedNow = FilePageCacheLockFree.this.statistics.totalPagesAllocated();
            int totalPagesWaitedNow = FilePageCacheLockFree.this.statistics.totalPageAllocationsWaited();
            int pagesAllocatedInTurn = Math.toIntExact(totalPagesAllocatedNow - this.totalPagesAllocatedTurnBefore);
            int pagesWaitedInTurn = Math.toIntExact((long)totalPagesWaitedNow - this.totalPagesWaitedTurnBefore);
            this.totalPagesAllocatedTurnBefore = totalPagesAllocatedNow;
            this.totalPagesWaitedTurnBefore = totalPagesWaitedNow;
            if (pagesWaitedInTurn > 0) {
                this.safetyMarginFactor.update(this.safetyMarginFactor.value() * 2);
            } else {
                this.safetyMarginFactor.dec();
            }
            return Math.max(pagesAllocatedInTurn * this.safetyMarginFactor.value() / 10 + 1, 1);
        }
    }

    protected static class PostCloseStorageCleanupCommand
    extends Command {
        private final PagedFileStorageWithRWLockedPageContent storageToClose;
        private final CompletableFuture<?> onFinish;

        protected PostCloseStorageCleanupCommand(@NotNull PagedFileStorageWithRWLockedPageContent storageToClose, @NotNull CompletableFuture<Object> onFinish) {
            if (storageToClose == null) {
                PostCloseStorageCleanupCommand.$$$reportNull$$$0(0);
            }
            if (onFinish == null) {
                PostCloseStorageCleanupCommand.$$$reportNull$$$0(1);
            }
            this.storageToClose = storageToClose;
            this.onFinish = onFinish;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "storageToClose";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "onFinish";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/io/FilePageCacheLockFree$PostCloseStorageCleanupCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static abstract class Command {
        protected Command() {
        }
    }
}

