/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.dev;

import org.jetbrains.annotations.NotNull;

public final class AlignmentUtils {
    private AlignmentUtils() {
        throw new AssertionError((Object)"Not for instantiation");
    }

    public static int roundUpToInt32(int value) {
        if (AlignmentUtils.is32bAligned(value)) {
            return value;
        }
        return (value >> 2) + 1 << 2;
    }

    public static long roundUpToInt32(long value) {
        if (AlignmentUtils.is32bAligned(value)) {
            return value;
        }
        return (value >> 2) + 1L << 2;
    }

    public static boolean is32bAligned(int value) {
        return (value & 3) == 0;
    }

    public static boolean is32bAligned(long value) {
        return (value & 3L) == 0L;
    }

    /*
     * WARNING - void declaration
     */
    public static void assert32bAligned(long value, @NotNull String string2) {
        if (string2 == null) {
            AlignmentUtils.$$$reportNull$$$0(0);
        }
        if (!AlignmentUtils.is32bAligned(value)) {
            void name2;
            throw new AssertionError((Object)("Bug: " + (String)name2 + "(=" + value + ") is not 32b-aligned"));
        }
    }

    public static void assert32bAligned(int value, @NotNull String name2) {
        if (name2 == null) {
            AlignmentUtils.$$$reportNull$$$0(1);
        }
        if (!AlignmentUtils.is32bAligned(value)) {
            throw new AssertionError((Object)("Bug: " + name2 + "(=" + value + ") is not 32b-aligned"));
        }
    }

    public static int roundUpToInt64(int value) {
        if (AlignmentUtils.is64bAligned(value)) {
            return value;
        }
        return (value >> 3) + 1 << 3;
    }

    public static int roundDownToInt64(int value) {
        return value & 0xFFFFFFF8;
    }

    public static long roundUpToInt64(long value) {
        if (AlignmentUtils.is64bAligned(value)) {
            return value;
        }
        return (value >> 3) + 1L << 3;
    }

    public static boolean is64bAligned(int value) {
        return (value & 7) == 0;
    }

    public static boolean is64bAligned(long value) {
        return (value & 7L) == 0L;
    }

    /*
     * WARNING - void declaration
     */
    public static void assert64bAligned(long value, @NotNull String string2) {
        if (string2 == null) {
            AlignmentUtils.$$$reportNull$$$0(2);
        }
        if (!AlignmentUtils.is64bAligned(value)) {
            void name2;
            throw new AssertionError((Object)("Bug: " + (String)name2 + "(=" + value + ") is not 64b-aligned"));
        }
    }

    public static void assert64bAligned(int value, @NotNull String name2) {
        if (name2 == null) {
            AlignmentUtils.$$$reportNull$$$0(3);
        }
        if (!AlignmentUtils.is64bAligned(value)) {
            throw new AssertionError((Object)("Bug: " + name2 + "(=" + value + ") is not 64b-aligned"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "name";
        objectArray2[1] = "com/intellij/util/io/dev/AlignmentUtils";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assert32bAligned";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "assert64bAligned";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

