/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage.lf;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.RefCountingContentStorage;
import com.intellij.util.io.storage.lf.AbstractStorageLF;
import com.intellij.util.io.storage.lf.RefCountingRecordsTableLF;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class RefCountingContentStorageImplLF
extends AbstractStorageLF
implements RefCountingContentStorage {
    private final ConcurrentMap<Integer, Future<?>> pendingWriteRequests;
    private int pendingWriteRequestsSize;
    private final ExecutorService writeRequestExecutor;
    private final boolean useContentHashes;
    private static final int MAX_PENDING_WRITE_SIZE = 0x1400000;
    private final IntObjectMap<RecordData> recordsLogForDebug;

    public RefCountingContentStorageImplLF(@NotNull Path path, @Nullable CapacityAllocationPolicy capacityAllocationPolicy, @NotNull ExecutorService writeRequestExecutor, boolean useContentHashes) throws IOException {
        if (path == null) {
            RefCountingContentStorageImplLF.$$$reportNull$$$0(0);
        }
        if (writeRequestExecutor == null) {
            RefCountingContentStorageImplLF.$$$reportNull$$$0(1);
        }
        super(path, capacityAllocationPolicy);
        this.pendingWriteRequests = new ConcurrentHashMap();
        this.recordsLogForDebug = ContainerUtil.createConcurrentIntObjectMap();
        this.writeRequestExecutor = writeRequestExecutor;
        this.useContentHashes = useContentHashes;
    }

    @Override
    protected void doDeleteRecord(int record) throws IOException {
        if (this.useContentHashes) {
            throw new UnsupportedEncodingException("Records can't be released completely with enabled content hashes support");
        }
        super.doDeleteRecord(record);
    }

    @Override
    public DataInputStream readStream(int record) throws IOException {
        BufferExposingByteArrayOutputStream stream = this.internalReadStream(record);
        return new DataInputStream(stream.toInputStream());
    }

    @Override
    protected byte[] readBytes(int record) throws IOException {
        return this.internalReadStream(record).toByteArray();
    }

    private BufferExposingByteArrayOutputStream internalReadStream(int record) throws IOException {
        this.waitForPendingWriteForRecord(record);
        byte[] compressedBytes = super.readBytes(record);
        if (IndexDebugProperties.IS_UNIT_TEST_MODE) {
            this.doRecordSanityCheck(record, compressedBytes);
        }
        int uncompressedSizeEstimation = Math.max(512, compressedBytes.length * 3);
        try (CustomInflaterInputStream in = new CustomInflaterInputStream(compressedBytes);){
            BufferExposingByteArrayOutputStream outputStream = new BufferExposingByteArrayOutputStream(uncompressedSizeEstimation);
            StreamUtil.copy(in, outputStream);
            BufferExposingByteArrayOutputStream bufferExposingByteArrayOutputStream = outputStream;
            return bufferExposingByteArrayOutputStream;
        }
    }

    private void doRecordSanityCheck(int record, byte[] result2) {
        block5: {
            int currentHash;
            RecordData savedData;
            block4: {
                savedData = this.recordsLogForDebug.get(record);
                if (savedData == null) {
                    return;
                }
                currentHash = 0;
                if (savedData.compressedSize != result2.length) break block4;
                currentHash = new ByteArraySequence(result2).hashCode();
                if (savedData.compressedHash == currentHash) break block5;
            }
            String msg = "expected compressed len = " + savedData.compressedSize + ", but actual len = " + result2.length + ", \n expected content hash = " + savedData.compressedHash + ", but actual hash = " + currentHash;
            throw new AssertionError((Object)msg);
        }
    }

    private void waitForPendingWriteForRecord(int record) throws InterruptedIOException {
        Future future2 = (Future)this.pendingWriteRequests.get(record);
        if (future2 != null) {
            try {
                future2.get();
            }
            catch (InterruptedException ie) {
                InterruptedIOException wrapperException = new InterruptedIOException();
                wrapperException.addSuppressed(ie);
                throw wrapperException;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    @Override
    protected void appendBytes(int record, ByteArraySequence bytes2) {
        throw new IncorrectOperationException("Appending is not supported");
    }

    @Override
    public void writeBytes(int record, @NotNull ByteArraySequence bytes2, boolean fixedSize) throws IOException {
        if (bytes2 == null) {
            RefCountingContentStorageImplLF.$$$reportNull$$$0(2);
        }
        this.waitForPendingWriteForRecord(record);
        this.withWriteLock(() -> {
            this.pendingWriteRequestsSize += bytes2.getLength();
            if (this.pendingWriteRequestsSize > 0x1400000) {
                this.zipAndWrite(bytes2, record, fixedSize);
            } else {
                this.pendingWriteRequests.put(record, this.writeRequestExecutor.submit(() -> {
                    this.zipAndWrite(bytes2, record, fixedSize);
                    return null;
                }));
            }
        });
    }

    private void zipAndWrite(ByteArraySequence bytes2, int record, boolean fixedSize) throws IOException {
        BufferExposingByteArrayOutputStream s2 = new BufferExposingByteArrayOutputStream();
        try (DeflaterOutputStream out = new DeflaterOutputStream(s2);){
            out.write(bytes2.getInternalBuffer(), bytes2.getOffset(), bytes2.getLength());
        }
        ByteArraySequence compressedBytes = s2.toByteArraySequence();
        this.withWriteLock(() -> {
            super.writeBytes(record, compressedBytes, fixedSize);
            if (IndexDebugProperties.IS_UNIT_TEST_MODE) {
                this.recordsLogForDebug.put(record, new RecordData(compressedBytes.getLength(), compressedBytes.hashCode()));
            }
            this.pendingWriteRequestsSize -= bytes2.getLength();
            this.pendingWriteRequests.remove(record);
        });
    }

    @Override
    protected RefCountingRecordsTableLF createRecordsTable(@NotNull StorageLockContext storageLockContext, @NotNull Path recordsFile) throws IOException {
        if (storageLockContext == null) {
            RefCountingContentStorageImplLF.$$$reportNull$$$0(3);
        }
        if (recordsFile == null) {
            RefCountingContentStorageImplLF.$$$reportNull$$$0(4);
        }
        return new RefCountingRecordsTableLF(recordsFile, storageLockContext);
    }

    @Override
    public int acquireNewRecord() throws IOException {
        return this.withWriteLock(() -> {
            int record = this.recordsTable.createNewRecord();
            ((RefCountingRecordsTableLF)this.recordsTable).incRefCount(record);
            return record;
        });
    }

    @Override
    public int getRecordsCount() throws IOException {
        return this.recordsTable.getRecordsCount();
    }

    @Override
    public void acquireRecord(int record) throws IOException {
        this.waitForPendingWriteForRecord(record);
        if (!this.useContentHashes) {
            this.withWriteLock(() -> ((RefCountingRecordsTableLF)this.recordsTable).incRefCount(record));
        }
    }

    @Override
    public void releaseRecord(int record) throws IOException {
        if (!this.useContentHashes) {
            this.waitForPendingWriteForRecord(record);
            this.withWriteLock(() -> {
                if (((RefCountingRecordsTableLF)this.recordsTable).decRefCount(record)) {
                    this.doDeleteRecord(record);
                }
            });
        }
    }

    @Override
    public int getRefCount(int record) throws IOException {
        this.waitForPendingWriteForRecord(record);
        return this.withReadLock(() -> ((RefCountingRecordsTableLF)this.recordsTable).getRefCount(record));
    }

    @Override
    public void force() throws IOException {
        this.flushPendingWrites();
        super.force();
    }

    @Override
    public boolean isDirty() {
        return !this.pendingWriteRequests.isEmpty() || super.isDirty();
    }

    @Override
    public void dispose() {
        this.flushPendingWrites();
        super.dispose();
    }

    @Override
    public void checkSanity(int record) throws IOException {
        this.flushPendingWrites();
        super.checkSanity(record);
    }

    private void flushPendingWrites() {
        for (Map.Entry entry : this.pendingWriteRequests.entrySet()) {
            try {
                ((Future)entry.getValue()).get();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeRequestExecutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageLockContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordsFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/storage/lf/RefCountingContentStorageImplLF";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "writeBytes";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createRecordsTable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CustomInflaterInputStream
    extends InflaterInputStream {
        CustomInflaterInputStream(byte[] compressedData) {
            super(new UnsyncByteArrayInputStream(compressedData), new Inflater(), 1);
            this.buf = compressedData;
            this.len = -1;
        }

        @Override
        protected void fill() throws IOException {
            if (this.len >= 0) {
                throw new EOFException();
            }
            this.len = this.buf.length;
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.inf.end();
        }
    }

    private static final class RecordData {
        private final int compressedSize;
        private final int compressedHash;

        private RecordData(int size, int hash) {
            this.compressedSize = size;
            this.compressedHash = hash;
        }
    }
}

