/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

public final class ZipShort
implements Cloneable {
    private static final int BYTE_MASK = 255;
    private static final int BYTE_1_MASK = 65280;
    private static final int BYTE_1_SHIFT = 8;
    private final int value;

    public ZipShort(int value) {
        this.value = value;
    }

    public ZipShort(byte[] bytes2) {
        this(bytes2, 0);
    }

    public ZipShort(byte[] bytes2, int offset) {
        this.value = ZipShort.getValue(bytes2, offset);
    }

    public byte[] getBytes() {
        byte[] result2 = new byte[]{(byte)(this.value & 0xFF), (byte)((this.value & 0xFF00) >> 8)};
        return result2;
    }

    public int getValue() {
        return this.value;
    }

    public static byte[] getBytes(int value) {
        byte[] result2 = new byte[]{(byte)(value & 0xFF), (byte)((value & 0xFF00) >> 8)};
        return result2;
    }

    public static int getValue(byte[] bytes2, int offset) {
        int value = bytes2[offset + 1] << 8 & 0xFF00;
        return value += bytes2[offset] & 0xFF;
    }

    public static int getValue(byte[] bytes2) {
        return ZipShort.getValue(bytes2, 0);
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof ZipShort)) {
            return false;
        }
        return this.value == ((ZipShort)o2).getValue();
    }

    public int hashCode() {
        return this.value;
    }
}

