/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.Access;
import java.nio.ByteOrder;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class CharSequenceAccess {
    static final Access<CharSequence> INSTANCE = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? LittleEndianCharSequenceAccess.INSTANCE : BigEndianCharSequenceAccess.INSTANCE;

    private static final class LittleEndianCharSequenceAccess
    extends BaseCharSequenceAccess {
        static final BaseCharSequenceAccess INSTANCE = new LittleEndianCharSequenceAccess();

        private LittleEndianCharSequenceAccess() {
        }

        @Override
        public long i64(CharSequence input2, int offset) {
            return LittleEndianCharSequenceAccess.getLong(input2, offset, 0, 1, 2, 3, 4, 0);
        }

        @Override
        public long u32(CharSequence input2, int offset) {
            return LittleEndianCharSequenceAccess.getUnsignedInt(input2, offset, 0, 1, 2, 0);
        }

        @Override
        public int i8(CharSequence input2, int offset) {
            return LittleEndianCharSequenceAccess.getByte(input2, offset, (offset & 1) << 3);
        }
    }

    private static abstract class BaseCharSequenceAccess
    implements Access<CharSequence> {
        private static int ix(long offset) {
            return (int)(offset >> 1);
        }

        protected static long getLong(CharSequence input2, long offset, int char0Off, int char1Off, int char2Off, int char3Off, int char4Off, int delta) {
            int base = BaseCharSequenceAccess.ix(offset);
            if (0 == ((int)offset & 1)) {
                long char0 = input2.charAt(base + char0Off);
                long char1 = input2.charAt(base + char1Off);
                long char2 = input2.charAt(base + char2Off);
                long char3 = input2.charAt(base + char3Off);
                return char0 | char1 << 16 | char2 << 32 | char3 << 48;
            }
            long char0 = input2.charAt(base + char0Off + delta) >>> 8;
            long char1 = input2.charAt(base + char1Off + delta);
            long char2 = input2.charAt(base + char2Off + delta);
            long char3 = input2.charAt(base + char3Off + delta);
            long char4 = input2.charAt(base + char4Off);
            return char0 | char1 << 8 | char2 << 24 | char3 << 40 | char4 << 56;
        }

        protected static long getUnsignedInt(CharSequence input2, int offset, int char0Off, int char1Off, int char2Off, int delta) {
            int base = BaseCharSequenceAccess.ix(offset);
            if (0 == (offset & 1)) {
                long char0 = input2.charAt(base + char0Off);
                long char1 = input2.charAt(base + char1Off);
                return char0 | char1 << 16;
            }
            long char0 = input2.charAt(base + char0Off + delta) >>> 8;
            long char1 = input2.charAt(base + char1Off + delta);
            long char2 = input2.charAt(base + char2Off) & 0xFF;
            return char0 | char1 << 8 | char2 << 24;
        }

        protected static int getByte(CharSequence input2, int offset, int shift) {
            return input2.charAt(BaseCharSequenceAccess.ix(offset)) >> shift;
        }

        private BaseCharSequenceAccess() {
        }

        @Override
        public int i32(CharSequence input2, int offset) {
            return (int)this.u32(input2, offset);
        }
    }

    private static final class BigEndianCharSequenceAccess
    extends BaseCharSequenceAccess {
        static final BaseCharSequenceAccess INSTANCE = new BigEndianCharSequenceAccess();

        private BigEndianCharSequenceAccess() {
        }

        @Override
        public long i64(CharSequence input2, int offset) {
            return BigEndianCharSequenceAccess.getLong(input2, offset, 3, 2, 1, 0, 0, 1);
        }

        @Override
        public long u32(CharSequence input2, int offset) {
            return BigEndianCharSequenceAccess.getUnsignedInt(input2, offset, 1, 0, 0, 1);
        }

        @Override
        public int i8(CharSequence input2, int offset) {
            return BigEndianCharSequenceAccess.getByte(input2, offset, (offset & 1 ^ 1) << 3);
        }
    }
}

