/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.CharSequenceAccess;
import com.intellij.util.lang.Loader;
import com.intellij.util.lang.StrippedLongSet;
import com.intellij.util.lang.StrippedLongToObjectMap;
import com.intellij.util.lang.Xxh3Impl;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClasspathCache {
    public static final String CLASS_EXTENSION = ".class";
    private static final IntFunction<Loader[][]> ARRAY_FACTORY = size -> new Loader[size][];
    private StrippedLongToObjectMap<Loader[]> classPackageCache;
    private StrippedLongToObjectMap<Loader[]> resourcePackageCache;
    private static final LongFunction<Loader[]> NULL = value -> null;
    private volatile LongFunction<Loader[]> classPackageCacheGetter = NULL;
    private volatile LongFunction<Loader[]> resourcePackageCacheGetter = NULL;

    void clearCache() {
        this.classPackageCacheGetter = NULL;
        this.resourcePackageCacheGetter = NULL;
        this.classPackageCache = null;
        this.resourcePackageCache = null;
    }

    void applyLoaderData(@NotNull IndexRegistrar registrar, @NotNull Loader loader2) {
        if (registrar == null) {
            ClasspathCache.$$$reportNull$$$0(0);
        }
        if (loader2 == null) {
            ClasspathCache.$$$reportNull$$$0(1);
        }
        if (registrar.classPackageCount() != 0) {
            StrippedLongToObjectMap<Loader[]> newClassMap = this.classPackageCache == null ? new StrippedLongToObjectMap<Loader[]>(ARRAY_FACTORY, registrar.classPackageCount()) : new StrippedLongToObjectMap<Loader[]>(this.classPackageCache);
            ClasspathCache.addPackages(registrar.classPackages(), newClassMap, loader2, registrar.getKeyFilter(true));
            this.classPackageCache = newClassMap;
            this.classPackageCacheGetter = newClassMap;
        }
        if (registrar.resourcePackageCount() != 0) {
            StrippedLongToObjectMap<Loader[]> newResourceMap = this.resourcePackageCache == null ? new StrippedLongToObjectMap<Loader[]>(ARRAY_FACTORY, registrar.resourcePackageCount()) : new StrippedLongToObjectMap<Loader[]>(this.resourcePackageCache);
            ClasspathCache.addPackages(registrar.resourcePackages(), newResourceMap, loader2, registrar.getKeyFilter(false));
            this.resourcePackageCache = newResourceMap;
            this.resourcePackageCacheGetter = newResourceMap;
        }
    }

    Loader @Nullable [] getLoadersByName(@NotNull String path) {
        if (path == null) {
            ClasspathCache.$$$reportNull$$$0(2);
        }
        return (path.endsWith(CLASS_EXTENSION) ? this.classPackageCacheGetter : this.resourcePackageCacheGetter).apply(ClasspathCache.getPackageNameHash(path, path.lastIndexOf(47)));
    }

    Loader @Nullable [] getLoadersByResourcePackageDir(@NotNull String resourcePath) {
        if (resourcePath == null) {
            ClasspathCache.$$$reportNull$$$0(3);
        }
        return this.resourcePackageCacheGetter.apply(ClasspathCache.getPackageNameHash(resourcePath, resourcePath.length()));
    }

    Loader @Nullable [] getClassLoadersByPackageNameHash(long packageNameHash) {
        return this.classPackageCacheGetter.apply(packageNameHash);
    }

    public static long getPackageNameHash(@NotNull String resourcePath, int endIndex) {
        if (resourcePath == null) {
            ClasspathCache.$$$reportNull$$$0(4);
        }
        return endIndex <= 0 ? 0L : Xxh3Impl.hash(resourcePath, CharSequenceAccess.INSTANCE, 0, endIndex * 2, 0L);
    }

    private static void addPackages(long[] hashes, StrippedLongToObjectMap<Loader[]> map2, Loader loader2, @Nullable LongPredicate hashFilter) {
        Loader[] singleArray = null;
        for (long hash : hashes) {
            if (hashFilter != null && !hashFilter.test(hash)) continue;
            int index2 = map2.index(hash);
            if (index2 < 0) {
                if (singleArray == null) {
                    singleArray = new Loader[]{loader2};
                }
                map2.addByIndex(index2, hash, singleArray);
                continue;
            }
            Loader[] loaders = map2.getByIndex(index2);
            Loader[] newList = new Loader[loaders.length + 1];
            System.arraycopy(loaders, 0, newList, 0, loaders.length);
            newList[loaders.length] = loader2;
            map2.replaceByIndex(index2, hash, newList);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourcePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/ClasspathCache";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "applyLoaderData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLoadersByName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLoadersByResourcePackageDir";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageNameHash";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface IndexRegistrar {
        default public Predicate<String> getNameFilter() {
            return null;
        }

        public int classPackageCount();

        public int resourcePackageCount();

        public long[] classPackages();

        public long[] resourcePackages();

        @Nullable
        default public LongPredicate getKeyFilter(boolean forClasses) {
            return null;
        }
    }

    static final class LoaderDataBuilder
    implements IndexRegistrar {
        final StrippedLongSet classPackageHashes = new StrippedLongSet();
        final StrippedLongSet resourcePackageHashes = new StrippedLongSet();

        LoaderDataBuilder() {
        }

        @Override
        public int classPackageCount() {
            return this.classPackageHashes.size();
        }

        @Override
        public int resourcePackageCount() {
            return this.resourcePackageHashes.size();
        }

        @Override
        public long[] classPackages() {
            return this.classPackageHashes.keys;
        }

        @Override
        public long[] resourcePackages() {
            return this.resourcePackageHashes.keys;
        }

        @Override
        public LongPredicate getKeyFilter(final boolean forClasses) {
            return new LongPredicate(){
                boolean addZero;
                {
                    this.addZero = forClasses ? classPackageHashes.hasNull() : resourcePackageHashes.hasNull();
                }

                @Override
                public boolean test(long it) {
                    if (it == 0L) {
                        if (!this.addZero) {
                            return false;
                        }
                        this.addZero = false;
                    }
                    return true;
                }
            };
        }

        void addResourcePackage(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(0);
            }
            this.resourcePackageHashes.add(ClasspathCache.getPackageNameHash(path, path.length()));
        }

        void addPackageFromName(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(1);
            }
            StrippedLongSet set = path.endsWith(ClasspathCache.CLASS_EXTENSION) ? this.classPackageHashes : this.resourcePackageHashes;
            set.add(ClasspathCache.getPackageNameHash(path, path.lastIndexOf(47)));
        }

        void addClassPackage(@NotNull String path) {
            if (path == null) {
                LoaderDataBuilder.$$$reportNull$$$0(2);
            }
            this.classPackageHashes.add(ClasspathCache.getPackageNameHash(path, path.length()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "path";
            objectArray2[1] = "com/intellij/util/lang/ClasspathCache$LoaderDataBuilder";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addResourcePackage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addPackageFromName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addClassPackage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

