/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Hash {
    public static final float FAST_LOAD_FACTOR = 0.5f;
    public static final int DEFAULT_INITIAL_SIZE = 16;

    public static int arraySize(int expected, float f2) {
        long s2 = Math.max(2L, Hash.nextPowerOfTwo((long)Math.ceil((float)expected / f2)));
        if (s2 > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f2 + ")");
        }
        return (int)s2;
    }

    private static long nextPowerOfTwo(long x2) {
        return 1L << 64 - Long.numberOfLeadingZeros(x2 - 1L);
    }

    public static int maxFill(int n2, float f2) {
        return Math.min((int)Math.ceil((float)n2 * f2), n2 - 1);
    }
}

