/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Murmur3_32Hash {
    public static final Murmur3_32Hash MURMUR3_32 = new Murmur3_32Hash(0);
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;

    public Murmur3_32Hash(int seed) {
        this.seed = seed;
    }

    public int hashInt(int input2) {
        int k1 = Murmur3_32Hash.mixK1(input2);
        int h1 = Murmur3_32Hash.mixH1(this.seed, k1);
        return Murmur3_32Hash.fMix(h1, 4);
    }

    public static int hashInt(int input2, int seed) {
        int k1 = Murmur3_32Hash.mixK1(input2);
        int h1 = Murmur3_32Hash.mixH1(seed, k1);
        return Murmur3_32Hash.fMix(h1, 4);
    }

    public int hashLong(long input2) {
        int low = (int)input2;
        int high = (int)(input2 >>> 32);
        int k1 = Murmur3_32Hash.mixK1(low);
        int h1 = Murmur3_32Hash.mixH1(this.seed, k1);
        k1 = Murmur3_32Hash.mixK1(high);
        h1 = Murmur3_32Hash.mixH1(h1, k1);
        return Murmur3_32Hash.fMix(h1, 8);
    }

    public int hashUnencodedChars(CharSequence input2) {
        int h1 = this.seed;
        for (int i2 = 1; i2 < input2.length(); i2 += 2) {
            int k1 = input2.charAt(i2 - 1) | input2.charAt(i2) << 16;
            k1 = Murmur3_32Hash.mixK1(k1);
            h1 = Murmur3_32Hash.mixH1(h1, k1);
        }
        if ((input2.length() & 1) == 1) {
            int k1 = input2.charAt(input2.length() - 1);
            k1 = Murmur3_32Hash.mixK1(k1);
            h1 ^= k1;
        }
        return Murmur3_32Hash.fMix(h1, 2 * input2.length());
    }

    public int hashString(CharSequence input2) {
        return this.hashString(input2, 0, input2.length());
    }

    public int hashString(CharSequence input2, int start, int end) {
        int k1;
        int h1 = this.seed;
        int i2 = start;
        int len = 0;
        while (i2 + 4 <= end) {
            char c0 = input2.charAt(i2);
            char c1 = input2.charAt(i2 + 1);
            char c2 = input2.charAt(i2 + 2);
            char c3 = input2.charAt(i2 + 3);
            if (c0 >= '\u0080' || c1 >= '\u0080' || c2 >= '\u0080' || c3 >= '\u0080') break;
            k1 = c0 | c1 << 8 | c2 << 16 | c3 << 24;
            k1 = Murmur3_32Hash.mixK1(k1);
            h1 = Murmur3_32Hash.mixH1(h1, k1);
            i2 += 4;
            len += 4;
        }
        long buffer = 0L;
        int shift = 0;
        while (i2 < end) {
            char c2 = input2.charAt(i2);
            if (c2 < '\u0080') {
                buffer |= (long)c2 << shift;
                shift += 8;
                ++len;
            } else if (c2 < '\u0800') {
                buffer |= Murmur3_32Hash.charToTwoUtf8Bytes(c2) << shift;
                shift += 16;
                len += 2;
            } else if (c2 < '\ud800' || c2 > '\udfff') {
                buffer |= Murmur3_32Hash.charToThreeUtf8Bytes(c2) << shift;
                shift += 24;
                len += 3;
            } else {
                int codePoint = Character.codePointAt(input2, i2);
                if (codePoint == c2) {
                    byte[] bytes2 = input2.toString().getBytes(StandardCharsets.UTF_8);
                    return this.hashBytes(bytes2, 0, bytes2.length);
                }
                ++i2;
                buffer |= Murmur3_32Hash.codePointToFourUtf8Bytes(codePoint) << shift;
                len += 4;
            }
            if (shift >= 32) {
                k1 = Murmur3_32Hash.mixK1((int)buffer);
                h1 = Murmur3_32Hash.mixH1(h1, k1);
                buffer >>>= 32;
                shift -= 32;
            }
            ++i2;
        }
        int k12 = Murmur3_32Hash.mixK1((int)buffer);
        return Murmur3_32Hash.fMix(h1 ^= k12, len);
    }

    public int hashBytes(byte[] input2, int off, int len) {
        int k1;
        Murmur3_32Hash.checkPositionIndexes(off, off + len, input2.length);
        int h1 = this.seed;
        int i2 = 0;
        while (i2 + 4 <= len) {
            k1 = Murmur3_32Hash.mixK1(Murmur3_32Hash.getIntLittleEndian(input2, off + i2));
            h1 = Murmur3_32Hash.mixH1(h1, k1);
            i2 += 4;
        }
        k1 = 0;
        int shift = 0;
        while (i2 < len) {
            k1 ^= Murmur3_32Hash.toInt(input2[off + i2]) << shift;
            ++i2;
            shift += 8;
        }
        return Murmur3_32Hash.fMix(h1 ^= Murmur3_32Hash.mixK1(k1), len);
    }

    private static int getIntLittleEndian(byte[] input2, int offset) {
        return Murmur3_32Hash.fromBytes(input2[offset + 3], input2[offset + 2], input2[offset + 1], input2[offset]);
    }

    private static int fromBytes(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fMix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    private static long codePointToFourUtf8Bytes(int codePoint) {
        return (0xF0L | (long)(codePoint >>> 18)) & 0xFFL | (0x80L | (long)(0x3F & codePoint >>> 12)) << 8 | (0x80L | (long)(0x3F & codePoint >>> 6)) << 16 | (0x80L | (long)(0x3F & codePoint)) << 24;
    }

    private static long charToThreeUtf8Bytes(char c2) {
        return (0x1E0 | c2 >>> 12) & 0xFF | (0x80 | 0x3F & c2 >>> 6) << 8 | (0x80 | 0x3F & c2) << 16;
    }

    private static long charToTwoUtf8Bytes(char c2) {
        return (0x3C0 | c2 >>> 6) & 0xFF | (0x80 | 0x3F & c2) << 8;
    }

    private static int toInt(byte value) {
        return value & 0xFF;
    }

    private static void checkPositionIndexes(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException(Murmur3_32Hash.badPositionIndexes(start, end, size));
        }
    }

    private static String badPositionIndex(int index2, int size, @Nullable String desc) {
        if (index2 < 0) {
            return desc + " (" + index2 + ") must not be negative";
        }
        if (size < 0) {
            throw new IllegalArgumentException("negative size: " + size);
        }
        return desc + " (" + index2 + ") must not be greater than size (" + size + ")";
    }

    private static String badPositionIndexes(int start, int end, int size) {
        if (start < 0 || start > size) {
            return Murmur3_32Hash.badPositionIndex(start, size, "start index");
        }
        if (end < 0 || end > size) {
            return Murmur3_32Hash.badPositionIndex(end, size, "end index");
        }
        return "end index (" + end + ") must not be less than start index (" + start + ")";
    }

    public static final class Murmur3_32Hasher {
        private int h1;
        private long buffer;
        private int shift;
        private int length;
        private boolean isDone;

        public Murmur3_32Hasher(int seed) {
            this.h1 = seed;
            this.length = 0;
            this.isDone = false;
        }

        private void update(int nBytes, long update) {
            this.buffer |= (update & 0xFFFFFFFFL) << this.shift;
            this.shift += nBytes * 8;
            this.length += nBytes;
            if (this.shift >= 32) {
                this.h1 = Murmur3_32Hash.mixH1(this.h1, Murmur3_32Hash.mixK1((int)this.buffer));
                this.buffer >>>= 32;
                this.shift -= 32;
            }
        }

        public void putByte(byte b2) {
            this.update(1, b2 & 0xFF);
        }

        public void putBytes(byte[] bytes2, int off, int len) {
            Murmur3_32Hash.checkPositionIndexes(off, off + len, bytes2.length);
            int i2 = 0;
            while (i2 + 4 <= len) {
                this.update(4, Murmur3_32Hash.getIntLittleEndian(bytes2, off + i2));
                i2 += 4;
            }
            while (i2 < len) {
                this.putByte(bytes2[off + i2]);
                ++i2;
            }
        }

        public void putBytes(ByteBuffer buffer) {
            ByteOrder bo2 = buffer.order();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            while (buffer.remaining() >= 4) {
                this.putInt(buffer.getInt());
            }
            while (buffer.hasRemaining()) {
                this.putByte(buffer.get());
            }
            buffer.order(bo2);
        }

        public void putInt(int i2) {
            this.update(4, i2);
        }

        public void putLong(long l2) {
            this.update(4, (int)l2);
            this.update(4, l2 >>> 32);
        }

        public void putChar(char c2) {
            this.update(2, c2);
        }

        public void putString(CharSequence input2) {
            int utf16Length = input2.length();
            int i2 = 0;
            while (i2 + 4 <= utf16Length) {
                char c0 = input2.charAt(i2);
                char c1 = input2.charAt(i2 + 1);
                char c2 = input2.charAt(i2 + 2);
                char c3 = input2.charAt(i2 + 3);
                if (c0 >= '\u0080' || c1 >= '\u0080' || c2 >= '\u0080' || c3 >= '\u0080') break;
                this.update(4, c0 | c1 << 8 | c2 << 16 | c3 << 24);
                i2 += 4;
            }
            while (i2 < utf16Length) {
                char c2 = input2.charAt(i2);
                if (c2 < '\u0080') {
                    this.update(1, c2);
                } else if (c2 < '\u0800') {
                    this.update(2, Murmur3_32Hash.charToTwoUtf8Bytes(c2));
                } else if (c2 < '\ud800' || c2 > '\udfff') {
                    this.update(3, Murmur3_32Hash.charToThreeUtf8Bytes(c2));
                } else {
                    int codePoint = Character.codePointAt(input2, i2);
                    if (codePoint == c2) {
                        byte[] bytes2 = input2.subSequence(i2, utf16Length).toString().getBytes(StandardCharsets.UTF_8);
                        this.putBytes(bytes2, 0, bytes2.length);
                        return;
                    }
                    ++i2;
                    this.update(4, Murmur3_32Hash.codePointToFourUtf8Bytes(codePoint));
                }
                ++i2;
            }
        }

        public int hash() {
            assert (!this.isDone);
            this.isDone = true;
            this.h1 ^= Murmur3_32Hash.mixK1((int)this.buffer);
            return Murmur3_32Hash.fMix(this.h1, this.length);
        }
    }
}

