/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import java.nio.ByteBuffer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Xor16 {
    private static final int BITS_PER_FINGERPRINT = 16;
    private static final int HASHES = 3;
    private static final int OFFSET = 32;
    private static final int FACTOR_TIMES_100 = 123;
    private final int blockLength;
    private final long seed;
    private final short[] fingerprints;

    private Xor16(short[] fingerprints, int blockLength, long seed) {
        this.seed = seed;
        this.fingerprints = fingerprints;
        this.blockLength = blockLength;
    }

    public Xor16(ByteBuffer buffer) {
        this.seed = buffer.getLong();
        this.fingerprints = new short[buffer.getInt()];
        this.blockLength = this.fingerprints.length / 3;
        buffer.asShortBuffer().get(this.fingerprints);
        buffer.position(buffer.position() + this.fingerprints.length * 2);
    }

    public int sizeInBytes() {
        return 12 + this.fingerprints.length * 2;
    }

    public void write(ByteBuffer buffer) {
        buffer.putLong(this.seed);
        buffer.putInt(this.fingerprints.length);
        buffer.asShortBuffer().put(this.fingerprints);
        buffer.position(buffer.position() + this.fingerprints.length * 2);
    }

    private static int getArrayLength(int size) {
        return (int)(32L + 123L * (long)size / 100L);
    }

    private static long mix(long x2) {
        long h2 = x2 * -7046029254386353131L;
        h2 ^= h2 >>> 32;
        return h2 ^ h2 >>> 16;
    }

    public static Xor16 construct(long[] keys2, int offset, int length) {
        int h2;
        int hi;
        int reverseOrderPos;
        int arrayLength = Xor16.getArrayLength(length);
        int blockLength = arrayLength / 3;
        long[] reverseOrder = new long[length];
        byte[] reverseH = new byte[length];
        long seed = 1354212L;
        do {
            seed = Xor16.mix(seed);
            byte[] t2count = new byte[arrayLength];
            long[] t2 = new long[arrayLength];
            for (int i2 = offset; i2 < length; ++i2) {
                long k2 = keys2[i2];
                for (int hi2 = 0; hi2 < 3; ++hi2) {
                    int h3;
                    int n2 = h3 = Xor16.getHash(blockLength, k2, seed, hi2);
                    t2[n2] = t2[n2] ^ k2;
                    if (t2count[h3] > 120) {
                        throw new IllegalArgumentException();
                    }
                    int n3 = h3;
                    t2count[n3] = (byte)(t2count[n3] + 1);
                }
            }
            int[] alone = new int[arrayLength];
            int alonePos = 0;
            reverseOrderPos = 0;
            int nextAloneCheck = 0;
            while (nextAloneCheck < arrayLength) {
                while (nextAloneCheck < arrayLength) {
                    if (t2count[nextAloneCheck] == 1) {
                        alone[alonePos++] = nextAloneCheck;
                    }
                    ++nextAloneCheck;
                }
                while (alonePos > 0) {
                    int i3;
                    if (t2count[i3 = alone[--alonePos]] == 0) continue;
                    long k3 = t2[i3];
                    int found = -1;
                    for (hi = 0; hi < 3; ++hi) {
                        int n4 = h2 = Xor16.getHash(blockLength, k3, seed, hi);
                        t2count[n4] = (byte)(t2count[n4] - 1);
                        byte newCount = t2count[n4];
                        if (newCount == 0) {
                            found = (byte)hi;
                            continue;
                        }
                        if (newCount == 1) {
                            alone[alonePos++] = h2;
                        }
                        int n5 = h2;
                        t2[n5] = t2[n5] ^ k3;
                    }
                    reverseOrder[reverseOrderPos] = k3;
                    reverseH[reverseOrderPos] = found;
                    ++reverseOrderPos;
                }
            }
        } while (reverseOrderPos != length);
        short[] fingerprints = new short[arrayLength];
        for (int i4 = reverseOrderPos - 1; i4 >= 0; --i4) {
            long k4 = reverseOrder[i4];
            int found = reverseH[i4];
            int change = -1;
            long hash = Xor16.hash64(k4, seed);
            int xor = Xor16.fingerprint(hash);
            for (hi = 0; hi < 3; ++hi) {
                h2 = Xor16.getHash(blockLength, k4, seed, hi);
                if (found == hi) {
                    change = h2;
                    continue;
                }
                xor ^= fingerprints[h2];
            }
            fingerprints[change] = (short)xor;
        }
        return new Xor16(fingerprints, blockLength, seed);
    }

    private static int getHash(int blockLength, long key, long seed, int index2) {
        long r2 = Long.rotateLeft(Xor16.hash64(key, seed), 21 * index2);
        r2 = Xor16.reduce((int)r2, blockLength);
        return (int)(r2 += (long)index2 * (long)blockLength);
    }

    public boolean mightContain(long key) {
        int h2;
        int h1;
        long hash = Xor16.hash64(key, this.seed);
        int f2 = Xor16.fingerprint(hash);
        int r0 = (int)hash;
        int r1 = (int)Long.rotateLeft(hash, 21);
        int r2 = (int)Long.rotateLeft(hash, 42);
        int h0 = Xor16.reduce(r0, this.blockLength);
        return ((f2 ^= this.fingerprints[h0] ^ this.fingerprints[h1 = Xor16.reduce(r1, this.blockLength) + this.blockLength] ^ this.fingerprints[h2 = Xor16.reduce(r2, this.blockLength) + 2 * this.blockLength]) & 0xFFFF) == 0;
    }

    private static int fingerprint(long hash) {
        return (int)(hash & 0xFFFFL);
    }

    private static long hash64(long x2, long seed) {
        x2 += seed;
        x2 = (x2 ^ x2 >>> 33) * -49064778989728563L;
        x2 = (x2 ^ x2 >>> 33) * -4265267296055464877L;
        x2 ^= x2 >>> 33;
        return x2;
    }

    private static int reduce(int hash, int n2) {
        return (int)(((long)hash & 0xFFFFFFFFL) * (long)n2 >>> 32);
    }
}

